~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 2.2                               :LAS Program name and version
CREA.        2006/03/23 15:25                          :LAS Creation date {YYYY/MM/DD hh:mm}
SOURCE.     SPCS_PLAY_023.DLIS                         :DLIS File Name
FILE-ID.     SPCS  .023                                :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      209.3976        :START DEPTH     
STOP .M      874.9284        :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        DEER LAKE OIL & GAS INC.                 :COMPANY
WELL .        DEER LAKE OIL & GAS ET AL WESTERN ADV      :WELL
FLD  .        EXPLORATORY                              :FIELD
LOC  .                                                 :LOCATION
CNTY .        NEWFOUNDLAND                             :COUNTY
STAT .                                                 :STATE
CTRY .                                                 :COUNTRY
API  .        2000-120-01-01                           :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        03-AUG-2000                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG                                              :LATITUDE
LONG .DEG                                              :LONGITUDE
GDAT .                                                 :GeoDetic Datum
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          1                        :RUN NUMBER
PDAT .        GROUND LEVEL               :Permanent Datum
EPD  .M          90.000000               :Elevation of Permanent Datum above Mean Sea Level
EPD  .M          90.000000               :Elevation of tool zero above Mean Sea Level
LMF  .          DRILL FLOOR              :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           2.499996               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
BS   .MM                                               :Bit Size {F13.4}
CALI_SPCS.MM                                           :SPCS Caliper {F13.4}
DPHI_SLDT.V/V                                          :Density Porosity {F13.4}
GR_STGC.GAPI                                           :Gamma Ray {F13.4}
NPHI .V/V                                              :Thermal Neutron Porosity (Ratio Method) {F13.4}
PEF_SLDT.                                              :Photo Electric Effect {F13.4}
QRHO_SLDT.                                             :SLDT Density Quality Factor {F13.4}
RHOB_SLDT.K/M3                                         :Bulk Density {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        BS        CALI_SPCS    DPHI_SLDT     GR_STGC        NPHI       PEF_SLDT    QRHO_SLDT    RHOB_SLDT       TENS
#
~A  
  209.3976      96.0000     103.1553       0.0937     123.8318       0.2512      25.0000      -0.0981    2495.4536    1090.0000
  209.5500      96.0000     102.8844       0.0937     113.6714       0.2469      25.0000      -0.0981    2495.4536    1098.0000
  209.7024      96.0000     102.7262       0.1261     106.2875       0.2407       0.0000      -0.1065    2441.9307    1097.0000
  209.8548      96.0000     103.0359       0.1761     106.5015       0.2345      25.0000      -0.1114    2359.4561    1092.0000
  210.0072      96.0000     103.0417       0.1928     106.6712       0.2336      25.0000      -0.1157    2331.8762    1074.0000
  210.1596      96.0000     103.0532       0.1811     101.1582       0.2264      25.0000      -0.1152    2351.2617    1096.0000
  210.3120      96.0000     102.8259       0.1403     104.8239       0.2239      25.0000      -0.1140    2418.4265    1109.0000
  210.4644      96.0000     103.1291       0.1194     106.5613       0.2169       0.0000      -0.1135    2453.0105    1091.0000
  210.6168      96.0000     102.8606       0.1158     100.7113       0.2245       0.0000      -0.1049    2458.9478    1095.0000
  210.7692      96.0000     102.9775       0.1280     100.0960       0.2298       0.0000      -0.1013    2438.8813    1105.0000
  210.9216      96.0000     103.0154       0.1260      96.0336       0.2372      25.0000      -0.1057    2442.0713    1106.0000
  211.0740      96.0000     102.9605       0.1227     101.1228       0.2279       0.0000      -0.1090    2447.6018    1097.0000
  211.2264      96.0000     102.7879       0.1094      93.1236       0.2314      25.0000      -0.1003    2469.4849    1096.0000
  211.3788      96.0000     102.9366       0.1039      97.7420       0.2266      25.0000      -0.0941    2478.5867    1116.0000
  211.5312      96.0000     103.2052       0.0897     104.2079       0.2252      25.0000      -0.0919    2501.9851    1114.0000
  211.6836      96.0000     103.2428       0.0881     110.0804       0.2216       0.0000      -0.0935    2504.6748    1100.0000
  211.8360      96.0000     103.2573       0.0887     104.5384       0.2264       0.0000      -0.0920    2503.6272    1102.0000
  211.9884      96.0000     103.1030       0.1051     103.4233       0.2248       0.0000      -0.0905    2476.5752    1098.0000
  212.1408      96.0000     103.2049       0.1131     112.5461       0.2338       0.0000      -0.0907    2463.3965    1109.0000
  212.2932      96.0000     103.5573       0.1099     114.3699       0.2408       0.0000      -0.0971    2468.7134    1109.0000
  212.4456      96.0000     103.1874       0.1127     111.9352       0.2490      25.0000      -0.0902    2464.0557    1105.0000
  212.5980      96.0000     103.2224       0.1124     101.5808       0.2355       0.0000      -0.0886    2464.5657    1100.0000
  212.7504      96.0000     103.5573       0.1144     105.3977       0.2270       0.0000      -0.0853    2461.2483    1100.0000
  212.9028      96.0000     103.2224       0.1031     103.5504       0.2270       0.0000      -0.0873    2479.9143    1111.0000
  213.0552      96.0000     103.4701       0.1016     100.4477       0.2252       0.0000      -0.0896    2482.3650    1104.0000
  213.2076      96.0000     102.7674       0.1208      97.3989       0.2288       0.0000      -0.0939    2450.7207    1095.0000
  213.3600      96.0000     102.9775       0.1219      95.5515       0.2231       0.0000      -0.0947    2448.9131    1109.0000
  213.5124      96.0000     103.2428       0.1227      99.2434       0.2341       0.0000      -0.0955    2447.5935    1114.0000
  213.6648      96.0000     103.0533       0.1173      98.8068       0.2311       0.0000      -0.1015    2456.3755    1093.0000
  213.8172      96.0000     102.5605       0.1074      99.9001       0.2343       0.0000      -0.1037    2472.7954    1107.0000
  213.9696      96.0000     102.7328       0.1059      98.6951       0.2354       0.0000      -0.1046    2475.2437    1106.0000
  214.1220      96.0000     102.8259       0.1122     106.3924       0.2230       0.0000      -0.1078    2464.8052    1095.0000
  214.2744      96.0000     102.9894       0.1253     116.3027       0.2232       0.0000      -0.1076    2443.3203    1096.0000
  214.4268      96.0000     102.8843       0.1350     120.6132       0.2201       0.0000      -0.1098    2427.3137    1100.0000
  214.5792      96.0000     102.9020       0.1583     112.2768       0.2359       0.0000      -0.1260    2388.8074    1088.0000
  214.7316      96.0000     102.8432       0.2033      97.2705       0.2343      25.0000      -0.1369    2314.4819    1105.0000
  214.8840      96.0000     102.6743       0.2509      83.0893       0.2442       0.0000      -0.1389    2236.0955    1105.0000
  215.0364      96.0000     102.6743       0.2661      82.4968       0.2567      25.0000      -0.1423    2210.9934    1118.0000
  215.1888      96.0000     102.7502       0.2321      89.6722       0.2608       0.0000      -0.1375    2266.9880    1092.0000
  215.3412      96.0000     102.9017       0.1684     101.6710       0.2511       0.0000      -0.1285    2372.0688    1092.0000
  215.4936      96.0000     102.9602       0.1268     111.5236       0.2330       0.0000      -0.1171    2440.8184    1114.0000
  215.6460      96.0000     102.6915       0.0977     112.5496       0.2336       0.0000      -0.1089    2488.8630    1092.0000
  215.7984      96.0000     102.8757       0.0864     116.2416       0.2350       0.0000      -0.1070    2507.3777    1103.0000
  215.9508      96.0000     102.7848       0.0847     125.7862       0.2362      25.0000      -0.1034    2510.2571    1093.0000
  216.1032      96.0000     103.0417       0.0954     128.3321       0.2417       0.0000      -0.0934    2492.6682    1096.0000
  216.2556      96.0000     102.6743       0.1025     133.4824       0.2473       0.0000      -0.0869    2480.8960    1118.0000
  216.4080      96.0000     103.0677       0.1047     117.4466       0.2507       0.0000      -0.0842    2477.3120    1100.0000
  216.5604      96.0000     103.0943       0.1092     116.2439       0.2501       0.0000      -0.0866    2469.8535    1083.0000
  216.7128      96.0000     103.2225       0.1143     108.9684       0.2454       0.0000      -0.0845    2461.3340    1107.0000
  216.8652      96.0000     103.4438       0.1144     111.6910       0.2455       0.0000      -0.0877    2461.2146    1105.0000
  217.0176      96.0000     103.2633       0.0984     103.6858       0.2565       0.0000      -0.0921    2487.6191    1093.0000
  217.1700      96.0000     103.1291       0.0676      99.6578       0.2624       0.0000      -0.1010    2538.4917    1095.0000
  217.3224      96.0000     102.5985       0.0630      94.8054       0.2662       0.0000      -0.0965    2546.0740    1091.0000
  217.4748      96.0000     101.9156       0.0758     100.3213       0.2639       0.0000      -0.0938    2524.9270    1110.0000
  217.6272      96.0000     101.6499       0.0979     105.4685       0.2600       0.0000      -0.0800    2488.5352    1109.0000
  217.7796      96.0000     101.7977       0.0893     111.9342       0.2583      25.0000      -0.0690    2502.7183    1113.0000
  217.9320      96.0000     101.4221       0.0814     115.3185       0.2359      25.0000      -0.0684    2515.6318    1076.0000
  218.0844      96.0000     101.1562       0.0394     111.5563       0.2189      16.1347      -0.0221    2584.9177    1102.0000
  218.2368      96.0000     100.7168       0.0543     112.7879       0.2040       5.8666       0.0000    2560.3831    1132.0000
  218.3892      96.0000     103.7247       0.0756     116.4798       0.2017       4.1296       0.0000    2525.3096    1110.0000
  218.5416      96.0000     105.6093       0.0548     123.1254       0.1934       3.5081       0.0000    2559.5161    1098.0000
  218.6940      96.0000     100.8273       0.0387     130.8742       0.1793       3.8887       0.0000    2586.1113    1109.0000
  218.8464      96.0000     100.7335       0.0503     131.8293       0.1634       4.0260       0.0000    2566.9556    1111.0000
  218.9988      96.0000     100.2439       0.0549     136.1052       0.1648       3.8071       0.0000    2559.3618    1100.0000
  219.1512      96.0000     100.5101       0.0582     138.2089       0.1693       3.6366       0.0000    2553.9580    1100.0000
  219.3036      96.0000     100.2275       0.0911     131.6657       0.1835       3.2408       0.0000    2499.6897    1092.0000
  219.4560      96.0000     100.0537       0.1439     112.5907       0.1999       3.1398       0.0000    2412.6121    1106.0000
  219.6084      96.0000     100.4885       0.1911      92.2698       0.2133       2.9724       0.0000    2334.7554    1125.0000
  219.7608      96.0000     101.2915       0.2126      81.2443       0.2202       3.2129       0.0000    2299.1824    1113.0000
  219.9132      96.0000     100.3068       0.1900      84.2675       0.2089       3.7544       0.0000    2336.5537    1076.0000
  220.0656      96.0000     100.3366       0.1392      91.9648       0.1999       4.2764       0.0000    2420.2400    1128.0000
  220.2180      96.0000     100.6241       0.0891     101.5023       0.1866       4.8103       0.0000    2503.0605    1113.0000
  220.3704      96.0000     100.9117       0.0423     106.5045       0.1849       4.2989       0.0000    2580.1372    1124.0000
  220.5228      96.0000     101.2322       0.0232     108.8553       0.1835       4.6188       0.0000    2611.6885    1140.0000
  220.6752      96.0000     101.3968       0.0124     113.7779       0.1872       4.6894       0.0000    2629.6057    1107.0000
  220.8276      96.0000     101.1395       0.0095     122.7067       0.1893       5.4599       0.0000    2634.3450    1104.0000
  220.9800      96.0000     101.5360       0.0013     126.4818       0.1937       5.4993       0.0000    2647.8726    1114.0000
  221.1324      96.0000     101.3673       0.0098     130.2296       0.2051       5.4252       0.0000    2633.8220    1103.0000
  221.2848      96.0000     101.1942       0.0208     136.6575       0.2079       5.0013       0.0000    2615.6277    1135.0000
  221.4372      96.0000     101.5698       0.0291     146.5421       0.2027       4.7493       0.0000    2601.9600    1119.0000
  221.5896      96.0000     101.4263       0.0331     154.5239       0.1945       4.1854       0.0000    2595.3889    1103.0000
  221.7420      96.0000     101.5106       0.0446     146.7840       0.1900       3.7200       0.0000    2576.4553    1098.0000
  221.8944      96.0000     101.7219       0.0431     144.0130       0.1968       3.3728       0.0000    2578.9109    1112.0000
  222.0468      96.0000     100.9662       0.0495     144.2821       0.2018       3.2955       0.0000    2568.3374    1118.0000
  222.1992      96.0000     101.5022       0.0485     150.5204       0.2074       3.2888       0.0000    2570.0491    1124.0000
  222.3516      96.0000     101.1562       0.0539     153.5596       0.2031       3.4457       0.0000    2561.0674    1102.0000
  222.5040      96.0000     101.2831       0.0529     149.4129       0.1968       3.3633       0.0000    2562.7173    1112.0000
  222.6564      96.0000     101.4431       0.0570     152.4918       0.1973       3.3672       0.0000    2555.9817    1113.0000
  222.8088      96.0000     101.3335       0.0590     154.6454       0.2056       3.3656       0.0000    2552.7205    1109.0000
  222.9612      96.0000     101.1394       0.0674     154.8284       0.2097       3.3820       0.0000    2538.8184    1110.0000
  223.1136      96.0000     101.0802       0.0716     159.8638       0.2118       3.2333       0.0000    2531.8621    1117.0000
  223.2660      96.0000     100.9662       0.0729     156.2104       0.2086       3.0581       0.0000    2529.6731    1120.0000
  223.4184      96.0000     101.2490       0.0694     155.5947       0.2173       3.1202       0.0000    2535.4634    1112.0000
  223.5708      96.0000     100.7631       0.0583     149.9049       0.2168       3.2833       0.0000    2553.8621    1105.0000
  223.7232      96.0000     100.9282       0.0559     151.4995       0.2235       3.3198       0.0000    2557.7183    1119.0000
  223.8756      96.0000     100.9450       0.0559     158.2327       0.2153       3.4467       0.0000    2557.7732    1099.0000
  224.0280      96.0000     100.4210       0.0581     161.6581       0.2129       3.4874       0.0000    2554.2058    1091.0000
  224.1804      96.0000     100.3960       0.0572     160.2900       0.2106       3.5734       0.0000    2555.6736    1117.0000
  224.3328      96.0000     100.0291       0.0562     159.3670       0.2150       3.5930       0.0000    2557.2463    1102.0000
  224.4852      96.0000     100.2605       0.0535     155.6723       0.2133       3.5082       0.0000    2561.7776    1095.0000
  224.6376      96.0000     100.3713       0.0492     148.9463       0.2064       3.5012       0.0000    2568.8499    1097.0000
  224.7900      96.0000     100.1084       0.0532     146.5229       0.2097       3.3066       0.0000    2562.1636    1111.0000
  224.9424      96.0000     100.3530       0.0534     140.3313       0.2156       3.1648       0.0000    2561.8877    1112.0000
  225.0948      96.0000     100.0783       0.0493     141.2887       0.2184       3.1584       0.0000    2568.6025    1099.0000
  225.2472      96.0000     100.1843       0.0436     134.9146       0.2129       3.2562       0.0000    2578.1360    1095.0000
  225.3996      96.0000     100.0783       0.0431     137.0682       0.2116       3.3682       0.0000    2578.8796    1128.0000
  225.5520      96.0000     100.0918       0.0472     139.8028       0.2134       3.3850       0.0000    2572.1702    1111.0000
  225.7044      96.0000     100.3364       0.0496     147.1006       0.2067       3.2662       0.0000    2568.1548    1110.0000
  225.8568      96.0000     100.1678       0.0526     157.1452       0.2085       3.2355       0.0000    2563.1741    1109.0000
  226.0092      96.0000     100.5052       0.0502     166.3750       0.2015       3.2182       0.0000    2567.1812    1113.0000
  226.1616      96.0000     100.3068       0.0465     164.8356       0.2007       3.2982       0.0000    2573.2361    1119.0000
  226.3140      96.0000     100.4126       0.0428     166.8877       0.1993       3.4835       0.0000    2579.4478    1118.0000
  226.4664      96.0000     100.2603       0.0451     160.1191       0.2011       3.2942       0.0000    2575.5859    1112.0000
  226.6188      96.0000     100.3069       0.0452     161.3507       0.2097       3.3662       0.0000    2575.4465    1116.0000
  226.7712      96.0000     100.4126       0.0427     153.5612       0.2110       3.3301       0.0000    2579.5063    1110.0000
  226.9236      96.0000     100.1678       0.0426     154.8180       0.2159       3.5540       0.0000    2579.7563    1105.0000
  227.0760      96.0000     100.3200       0.0458     153.2786       0.2089       3.6079       0.0000    2574.4468    1113.0000
  227.2284      96.0000     100.2441       0.0438     144.6641       0.2002       3.6118       0.0000    2577.8083    1105.0000
  227.3808      96.0000     100.1927       0.0433     133.5930       0.1918       3.7850       0.0000    2578.4973    1107.0000
  227.5332      96.0000      99.9397       0.0459     132.2468       0.1962       3.6385       0.0000    2574.2788    1117.0000
  227.6856      96.0000      99.9642       0.0456     147.0145       0.2040       3.6463       0.0000    2574.7935    1134.0000
  227.8380      96.0000     100.3035       0.0469     160.5618       0.2083       3.3332       0.0000    2572.5876    1124.0000
  227.9904      96.0000     100.1515       0.0500     159.4096       0.1996       3.4162       0.0000    2567.4968    1110.0000
  228.1428      96.0000     100.0537       0.0537     154.2055       0.1959       3.3026       0.0000    2561.3274    1121.0000
  228.2952      96.0000     100.0485       0.0562     151.7031       0.1914       3.2817       0.0000    2557.2944    1124.0000
  228.4476      96.0000      99.8963       0.0550     153.2779       0.1960       3.0846       0.0000    2559.3279    1113.0000
  228.6000      96.0000      99.9642       0.0498     143.0989       0.1906       3.0800       0.0000    2567.8950    1100.0000
  228.7524      96.0000      99.8471       0.0453     140.3889       0.1957       3.2060       0.0000    2575.2258    1113.0000
  228.9048      96.0000     100.3068       0.0428     137.0021       0.1991       3.4777       0.0000    2579.3083    1113.0000
  229.0572      96.0000     100.0321       0.0471     137.9251       0.2017       3.4875       0.0000    2572.2185    1125.0000
  229.2096      96.0000     100.2173       0.0558     137.9033       0.1993       3.5963       0.0000    2557.8999    1102.0000
  229.3620      96.0000     100.4721       0.0597     139.7153       0.1971       3.3376       0.0000    2551.4600    1116.0000
  229.5144      96.0000     100.1676       0.0534     143.1570       0.1925       3.2388       0.0000    2561.9224    1126.0000
  229.6668      96.0000      99.9396       0.0463     143.9447       0.1879       3.0860       0.0000    2573.6028    1137.0000
  229.8192      96.0000      99.9725       0.0489     144.7549       0.1842       3.2561       0.0000    2569.2761    1126.0000
  229.9716      96.0000      99.9151       0.0477     150.5823       0.1903       3.6153       0.0000    2571.2720    1125.0000
  230.1240      96.0000      99.9724       0.0439     155.9263       0.1998       3.8945       0.0000    2577.6174    1139.0000
  230.2764      96.0000     100.1842       0.0393     160.0777       0.2044       3.8442       0.0000    2585.1460    1141.0000
  230.4288      96.0000     100.0784       0.0464     158.2303       0.2064       3.6621       0.0000    2573.4602    1141.0000
  230.5812      96.0000     100.1842       0.0474     150.5232       0.2144       3.5926       0.0000    2571.8362    1132.0000
  230.7336      96.0000      99.9888       0.0472     150.4760       0.2185       3.5852       0.0000    2572.1436    1127.0000
  230.8860      96.0000      99.7113       0.0475     149.8228       0.2195       3.6793       0.0000    2571.6814    1095.0000
  231.0384      96.0000     100.1843       0.0465     151.3983       0.2149       3.5431       0.0000    2573.3518    1130.0000
  231.1908      96.0000     100.2819       0.0448     154.7907       0.2181       3.6203       0.0000    2576.1003    1133.0000
  231.3432      96.0000     100.0917       0.0376     147.7017       0.2117       3.4884       0.0000    2587.9851    1116.0000
  231.4956      96.0000     100.0782       0.0321     141.8517       0.2030       3.6901       0.0000    2597.0769    1128.0000
  231.6480      96.0000      99.8799       0.0313     133.8526       0.1914       3.5801       0.0000    2598.4221    1135.0000
  231.8004      96.0000     100.0157       0.0331     136.3606       0.1913       3.7152       0.0000    2595.4646    1119.0000
  231.9528      96.0000      99.9396       0.0367     136.0202       0.1897       3.5094       0.0000    2589.4099    1123.0000
  232.1052      96.0000      99.8471       0.0354     133.9005       0.1884       3.6201       0.0000    2591.6147    1132.0000
  232.2576      96.0000      99.8009       0.0405     142.3370       0.1945       3.5345       0.0000    2583.1382    1131.0000
  232.4100      96.0000      99.9561       0.0405     149.4132       0.1994       3.6858       0.0000    2583.2231    1121.0000
  232.5624      96.0000      99.9559       0.0431     160.4973       0.2069       3.6389       0.0000    2578.8054    1133.0000
  232.7148      96.0000     100.1678       0.0363     158.7439       0.2048       3.8925       0.0000    2590.0977    1130.0000
  232.8672      96.0000      99.5590       0.0350     163.0922       0.2111       3.8107       0.0000    2592.3159    1114.0000
  233.0196      96.0000     100.0917       0.0414     155.0871       0.2156       3.8677       0.0000    2581.6152    1126.0000
  233.1720      96.0000     100.1678       0.0628     148.0623       0.2123       3.7391       0.0000    2546.4348    1128.0000
  233.3244      96.0000      99.8800       0.0922     140.4559       0.2161       3.7263       0.0000    2497.8623    1118.0000
  233.4768      96.0000     100.0532       0.1060     141.0350       0.2133       3.6708       0.0000    2475.0891    1132.0000
  233.6292      96.0000     100.3960       0.0920     144.1476       0.2154       3.4356       0.0000    2498.1418    1142.0000
  233.7816      96.0000     100.0784       0.0627     143.7138       0.1979       3.5386       0.0000    2546.5215    1125.0000
  233.9340      96.0000     100.0157       0.0534     145.7561       0.1887       3.4597       0.0000    2561.8657    1126.0000
  234.0864      96.0000      99.8798       0.0526     143.6009       0.1846       3.4191       0.0000    2563.1353    1144.0000
  234.2388      96.0000      99.9398       0.0586     147.6005       0.1943       3.1490       0.0000    2553.3547    1139.0000
  234.3912      96.0000      99.7876       0.0594     139.1291       0.1961       3.1392       0.0000    2551.9885    1119.0000
  234.5436      96.0000      99.8500       0.0533     135.0951       0.1896       3.2325       0.0000    2562.1135    1119.0000
  234.6960      96.0000      99.9397       0.0438     130.8453       0.1838       3.3492       0.0000    2577.6890    1145.0000
  234.8484      96.0000      99.8635       0.0406     139.1584       0.1849       3.4165       0.0000    2582.9734    1138.0000
  235.0008      96.0000     100.1678       0.0485     139.4660       0.1907       3.3216       0.0000    2569.9714    1095.0000
  235.1532      96.0000     100.0753       0.0559     137.9040       0.1910       3.4518       0.0000    2557.6980    1130.0000
  235.3056      96.0000     100.1843       0.0495     125.0341       0.1921       3.5686       0.0000    2568.3188    1134.0000
  235.4580      96.0000      99.8499       0.0411     127.2209       0.1994       3.6858       0.0000    2582.1733    1127.0000
  235.6104      96.0000     100.1412       0.0395     134.5711       0.1996       3.4321       0.0000    2584.8132    1113.0000
  235.7628      96.0000     100.0784       0.0385     153.5989       0.2022       3.4484       0.0000    2586.4829    1127.0000
  235.9152      96.0000      99.8201       0.0425     152.0594       0.2152       3.4414       0.0000    2579.9321    1145.0000
  236.0676      96.0000     100.5053       0.0397     157.5973       0.2187       3.6214       0.0000    2584.5242    1144.0000
  236.2200      96.0000     100.0537       0.0394     149.9000       0.2283       3.4846       0.0000    2584.9404    1137.0000
  236.3724      96.0000      99.9560       0.0412     162.4636       0.2182       3.5755       0.0000    2582.0542    1131.0000
  236.5248      96.0000      99.9888       0.0479     160.6596       0.2188       3.7128       0.0000    2570.9214    1146.0000
  236.6772      96.0000     100.3200       0.0450     161.8533       0.2160       3.7032       0.0000    2575.7583    1134.0000
  236.8296      96.0000     100.4719       0.0422     160.0660       0.2168       3.4814       0.0000    2580.3318    1126.0000
  236.9820      96.0000     100.4457       0.0438     154.7937       0.2139       3.3173       0.0000    2577.6775    1137.0000
  237.1344      96.0000      99.9397       0.0470     166.2423       0.2120       3.3407       0.0000    2572.4897    1139.0000
  237.2868      96.0000     100.3068       0.0565     168.7055       0.2110       3.5080       0.0000    2556.7898    1145.0000
  237.4392      96.0000     100.2603       0.0656     166.8595       0.2192       3.5506       0.0000    2541.8286    1138.0000
  237.5916      96.0000     100.1843       0.0730     154.5469       0.2320       3.6954       0.0000    2529.5959    1134.0000
  237.7440      96.0000     100.2819       0.0700     147.7363       0.2319       3.5640       0.0000    2534.4800    1125.0000
  237.8964      96.0000      99.6841       0.0651     149.6204       0.2274       3.7158       0.0000    2542.5166    1134.0000
  238.0488      96.0000      99.6868       0.0565     148.6749       0.2080       3.5348       0.0000    2556.7705    1131.0000
  238.2012      96.0000      99.7711       0.0439     152.0592       0.2048       3.5910       0.0000    2577.4893    1128.0000
  238.3536      96.0000      99.9397       0.0362     147.0873       0.1985       3.4048       0.0000    2590.2275    1128.0000
  238.5060      96.0000      99.7113       0.0327     148.8967       0.1912       3.5357       0.0000    2596.1257    1140.0000
  238.6584      96.0000     100.0322       0.0313     153.5546       0.1900       3.6123       0.0000    2598.3176    1146.0000
  238.8108      96.0000      99.7358       0.0326     154.2160       0.1852       3.5387       0.0000    2596.2480    1135.0000
  238.9632      96.0000     100.2605       0.0358     152.6777       0.1875       3.5283       0.0000    2591.0112    1124.0000
  239.1156      96.0000     100.1843       0.0419     146.7123       0.1842       3.4313       0.0000    2580.9331    1133.0000
  239.2680      96.0000      99.7113       0.0474     147.2928       0.1917       3.5004       0.0000    2571.8511    1126.0000
  239.4204      96.0000      99.7875       0.0552     145.7900       0.1907       3.2477       0.0000    2558.9709    1132.0000
  239.5728      96.0000      99.9643       0.0528     139.4061       0.1918       3.2241       0.0000    2562.9387    1131.0000
  239.7252      96.0000     100.0158       0.0507     148.9860       0.1930       3.2726       0.0000    2566.2725    1130.0000
  239.8776      96.0000     100.2439       0.0564     163.8177       0.2058       3.4078       0.0000    2556.9631    1133.0000
  240.0300      96.0000      99.6460       0.0623     174.5859       0.2092       3.5266       0.0000    2547.2712    1135.0000
  240.1824      96.0000      99.9994       0.0648     170.8912       0.2059       3.4106       0.0000    2543.1519    1135.0000
  240.3348      96.0000      99.9149       0.0731     157.8699       0.1963       3.6858       0.0000    2529.4504    1131.0000
  240.4872      96.0000      99.8039       0.0689     154.5118       0.1875       3.7131       0.0000    2536.3855    1128.0000
  240.6396      96.0000      99.7439       0.0565     144.3589       0.1778       3.9980       0.0000    2556.8347    1139.0000
  240.7920      96.0000      99.6215       0.0442     129.6768       0.1753       3.9563       0.0000    2577.0632    1148.0000
  240.9444      96.0000      99.7876       0.0309     108.4453       0.1676       3.8937       0.0000    2599.0146    1151.0000
  241.0968      96.0000      99.5970       0.0312     106.8674       0.1613       3.8110       0.0000    2598.4526    1142.0000
  241.2492      96.0000      99.4828       0.0317     118.1652       0.1583       3.5223       0.0000    2597.7129    1131.0000
  241.4016      96.0000      99.8038       0.0339     126.7862       0.1618       3.5819       0.0000    2594.0789    1134.0000
  241.5540      96.0000      99.5725       0.0390     128.9957       0.1697       3.5833       0.0000    2585.5796    1139.0000
  241.7064      96.0000      99.4667       0.0465     127.1498       0.1743       3.5146       0.0000    2573.2917    1120.0000
  241.8588      96.0000      99.4828       0.0437     129.6129       0.1793       3.3240       0.0000    2577.8704    1131.0000
  242.0112      96.0000      99.7275       0.0378     132.0183       0.1865       3.3366       0.0000    2587.5835    1165.0000
  242.1636      96.0000      99.8799       0.0337     134.2065       0.1928       3.4286       0.0000    2594.4294    1146.0000
  242.3160      96.0000      99.8008       0.0328     143.4048       0.2029       3.7170       0.0000    2595.8953    1111.0000
  242.4684      96.0000     100.0321       0.0412     148.1817       0.2047       3.6262       0.0000    2581.9402    1144.0000
  242.6208      96.0000      99.8498       0.0588     143.5633       0.2053       3.6044       0.0000    2553.0039    1154.0000
  242.7732      96.0000      99.6949       0.0704     128.4879       0.1996       3.3718       0.0000    2533.8271    1151.0000
  242.9256      96.0000     100.0158       0.0820     108.0429       0.1970       3.2182       0.0000    2514.7786    1142.0000
  243.0780      96.0000     100.1678       0.0809     107.3964       0.1856       3.2652       0.0000    2516.5051    1133.0000
  243.2304      96.0000      99.4668       0.0717     120.0472       0.1739       3.4032       0.0000    2531.7698    1149.0000
  243.3828      96.0000      99.1401       0.0583     144.2545       0.1655       3.3800       0.0000    2553.7917    1149.0000
  243.5352      96.0000      99.1181       0.0547     144.5621       0.1607       3.2162       0.0000    2559.8235    1141.0000
  243.6876      96.0000      99.1782       0.0499     142.4069       0.1613       3.0746       0.0000    2567.6816    1134.0000
  243.8400      96.0000      99.2785       0.0339     145.2512       0.1632       3.3770       0.0000    2594.0195    1145.0000
  243.9924      96.0000      99.4991       0.0288     161.1414       0.1774       3.5244       0.0000    2602.5134    1145.0000
  244.1448      96.0000      99.2543       0.0244     165.7212       0.1931       3.5724       0.0000    2609.7888    1123.0000
  244.2972      96.0000      99.2785       0.0333     152.2169       0.2033       3.3802       0.0000    2594.9873    1147.0000
  244.4496      96.0000      99.5592       0.0340     143.4391       0.2077       3.3595       0.0000    2593.9321    1156.0000
  244.6020      96.0000      99.6217       0.0376     139.9022       0.2099       3.4022       0.0000    2587.9988    1145.0000
  244.7544      96.0000      99.4230       0.0349     144.2127       0.2104       3.4228       0.0000    2592.3811    1138.0000
  244.9068      96.0000      99.6515       0.0338     145.7148       0.2065       3.6424       0.0000    2594.3093    1145.0000
  245.0592      96.0000      99.8499       0.0379     151.4455       0.2078       3.7116       0.0000    2587.5330    1147.0000
  245.2116      96.0000     100.0322       0.0418     154.3748       0.2207       3.6572       0.0000    2581.0208    1144.0000
  245.3640      96.0000      99.8011       0.0422     163.2970       0.2283       3.4876       0.0000    2580.3777    1146.0000
  245.5164      96.0000     100.0321       0.0425     174.0732       0.2300       3.5378       0.0000    2579.8198    1142.0000
  245.6688      96.0000      99.7276       0.0392     182.4913       0.2351       3.9478       0.0000    2585.3037    1133.0000
  245.8212      96.0000     100.0539       0.0380     178.5328       0.2366       4.2259       0.0000    2587.3674    1165.0000
  245.9736      96.0000     100.1082       0.0415     156.5935       0.2435       4.2591       0.0000    2581.5386    1159.0000
  246.1260      96.0000     100.4209       0.0436     147.9790       0.2219       4.1835       0.0000    2577.9949    1134.0000
  246.2784      96.0000     100.7002       0.0497     142.1290       0.2197       3.7976       0.0000    2567.9961    1137.0000
  246.4308      96.0000     100.1514       0.0480     142.4838       0.2177       3.5295       0.0000    2570.7717    1145.0000
  246.5832      96.0000     100.4457       0.0517     139.4430       0.2227       3.2572       0.0000    2564.6218    1145.0000
  246.7356      96.0000     100.2441       0.0538     140.3293       0.2187       3.3562       0.0000    2561.2263    1139.0000
  246.8880      96.0000     100.2819       0.0561     147.1568       0.2117       3.5003       0.0000    2557.5137    1140.0000
  247.0404      96.0000      99.7873       0.0488     152.3513       0.2231       3.5544       0.0000    2569.5410    1156.0000
  247.1928      96.0000      99.8635       0.0470     164.7043       0.2283       3.6111       0.0000    2572.4873    1154.0000
  247.3452      96.0000     100.0537       0.0475     171.7216       0.2395       3.7344       0.0000    2571.6282    1144.0000
  247.4976      96.0000     100.2604       0.0485     182.7609       0.2423       3.8990       0.0000    2569.8994    1146.0000
  247.6500      96.0000      99.5970       0.0515     177.2189       0.2471       3.7371       0.0000    2565.0852    1130.0000
  247.8024      96.0000     100.1084       0.0595     180.9108       0.2426       3.6458       0.0000    2551.8950    1147.0000
  247.9548      96.0000      99.9993       0.0573     176.4646       0.2358       3.5395       0.0000    2555.4949    1144.0000
  248.1072      96.0000      99.4828       0.0502     169.9989       0.2395       3.6718       0.0000    2567.0920    1144.0000
  248.2596      96.0000     100.1082       0.0480     157.3848       0.2465       3.7879       0.0000    2570.8098    1158.0000
  248.4120      96.0000      99.9151       0.0450     148.3682       0.2452       3.6653       0.0000    2575.7119    1153.0000
  248.5644      96.0000      99.9994       0.0465     143.6700       0.2372       3.5646       0.0000    2573.3262    1148.0000
  248.7168      96.0000      99.7874       0.0553     155.3611       0.2260       3.5019       0.0000    2558.8364    1135.0000
  248.8692      96.0000      99.7117       0.0591     157.5164       0.2243       3.5786       0.0000    2552.5383    1134.0000
  249.0216      96.0000      99.5590       0.0620     161.2539       0.2206       3.4864       0.0000    2547.7075    1151.0000
  249.1740      96.0000      99.3467       0.0691     153.6012       0.2177       3.5993       0.0000    2535.9763    1146.0000
  249.3264      96.0000      99.6215       0.0692     152.9464       0.2084       3.6761       0.0000    2535.7937    1132.0000
  249.4788      96.0000      99.2382       0.0697     157.2938       0.2070       3.8034       0.0000    2535.0417    1165.0000
  249.6312      96.0000      99.4829       0.0712     157.1695       0.2009       3.6845       0.0000    2532.4758    1156.0000
  249.7836      96.0000      99.4827       0.0737     160.2874       0.2045       3.6541       0.0000    2528.3899    1126.0000
  249.9360      96.0000      99.4828       0.0735     151.1763       0.2008       3.7007       0.0000    2528.7693    1155.0000
  250.0884      96.0000      99.5071       0.0738     143.8781       0.1969       3.6651       0.0000    2528.1873    1154.0000
  250.2408      96.0000      99.5590       0.0650     130.6387       0.1926       3.6124       0.0000    2542.6992    1128.0000
  250.3932      96.0000      99.2544       0.0551     136.3253       0.2005       3.5428       0.0000    2559.0911    1144.0000
  250.5456      96.0000      99.7874       0.0528     138.2059       0.2157       3.5620       0.0000    2562.8701    1154.0000
  250.6980      96.0000      99.6189       0.0432     144.0200       0.2223       3.9420       0.0000    2578.6509    1166.0000
  250.8504      96.0000      99.7113       0.0374     148.5939       0.2194       3.9948       0.0000    2588.3340    1137.0000
  251.0028      96.0000      99.6079       0.0387     161.2175       0.2213       3.9094       0.0000    2586.0784    1156.0000
  251.1552      96.0000      99.2544       0.0427     166.7554       0.2207       3.5280       0.0000    2579.6108    1163.0000
  251.3076      96.0000      99.4067       0.0418     167.4533       0.2110       3.4191       0.0000    2581.0496    1135.0000
  251.4600      96.0000      99.3467       0.0416     152.0459       0.1947       3.3793       0.0000    2581.3574    1148.0000
  251.6124      96.0000      99.4829       0.0442     140.3859       0.1854       3.4659       0.0000    2577.0010    1169.0000
  251.7648      96.0000      99.5590       0.0438     121.6045       0.1840       3.4748       0.0000    2577.7034    1147.0000
  251.9172      96.0000      99.0259       0.0359     118.2005       0.1809       3.6636       0.0000    2590.7478    1173.0000
  252.0696      96.0000      99.8799       0.0253     124.5174       0.1869       3.7866       0.0000    2608.2783    1169.0000
  252.2220      96.0000      99.6515       0.0299     136.2173       0.2032       3.8508       0.0000    2600.7004    1135.0000
  252.3744      96.0000      99.3686       0.0467     131.2947       0.2157       3.5475       0.0000    2572.9683    1145.0000
  252.5268      96.0000      99.5427       0.0647     114.7939       0.2292       3.2421       0.0000    2543.1665    1165.0000
  252.6792      96.0000     100.1514       0.0724      98.2624       0.2190       3.1888       0.0000    2530.5562    1154.0000
  252.8316      96.0000      99.8253       0.0732      98.5966       0.2139       3.3133       0.0000    2529.2356    1145.0000
  252.9840      96.0000      99.7114       0.0542     112.7490       0.2079       3.5989       0.0000    2560.5254    1149.0000
  253.1364      96.0000     100.3068       0.0422     132.3594       0.2028       3.7926       0.0000    2580.3640    1175.0000
  253.2888      96.0000      99.9395       0.0342     147.1006       0.2033       3.8676       0.0000    2593.6160    1156.0000
  253.4412      96.0000      99.7278       0.0346     151.5012       0.1983       3.6408       0.0000    2592.9800    1155.0000
  253.5936      96.0000      99.3443       0.0416     149.6538       0.2047       3.6387       0.0000    2581.3579    1161.0000
  253.7460      96.0000      99.5155       0.0408     151.8074       0.1958       3.5297       0.0000    2582.6406    1134.0000
  253.8984      96.0000      99.5970       0.0404     150.5199       0.1966       3.6286       0.0000    2583.2800    1174.0000
  254.0508      96.0000      99.7276       0.0400     139.0993       0.1953       3.5040       0.0000    2584.0723    1153.0000
  254.2032      96.0000      99.8037       0.0366     123.4361       0.2044       3.5978       0.0000    2589.5349    1149.0000
  254.3556      96.0000      99.8746       0.0432     115.8311       0.1978       3.7318       0.0000    2578.7898    1177.0000
  254.5080      96.0000      99.8798       0.0448     129.9836       0.1969       3.7720       0.0000    2576.1477    1184.0000
  254.6604      96.0000      99.5753       0.0466     141.6835       0.1949       3.6871       0.0000    2573.0457    1173.0000
  254.8128      96.0000      99.8254       0.0406     142.7910       0.1928       3.4439       0.0000    2582.9429    1147.0000
  254.9652      96.0000      99.4990       0.0479     129.2830       0.1845       3.3488       0.0000    2570.9314    1187.0000
  255.1176      96.0000      99.6215       0.0494     116.1424       0.1739       3.2752       0.0000    2568.4890    1170.0000
  255.2700      96.0000      99.4828       0.0508     114.0188       0.1661       3.3409       0.0000    2566.1155    1145.0000
  255.4224      96.0000      99.2382       0.0404     118.2969       0.1620       3.4123       0.0000    2583.2888    1159.0000
  255.5748      96.0000      99.1886       0.0385     115.4272       0.1652       3.5193       0.0000    2586.5420    1188.0000
  255.7272      96.0000      99.4666       0.0359     113.7071       0.1704       3.9132       0.0000    2590.7939    1170.0000
  255.8796      96.0000      99.2302       0.0397     112.4765       0.1775       4.3951       0.0000    2584.5142    1155.0000
  256.0320      96.0000      99.4392       0.0348     124.1764       0.1845       4.3874       0.0000    2592.5791    1176.0000
  256.1844      96.0000      99.5426       0.0401     136.3269       0.1914       3.8146       0.0000    2583.8135    1168.0000
  256.3368      96.0000      99.3444       0.0410     135.1850       0.1901       3.4795       0.0000    2582.4307    1154.0000
  256.4892      96.0000      99.3467       0.0406     139.8034       0.1806       3.4975       0.0000    2583.0117    1163.0000
  256.6416      96.0000      99.5590       0.0392     131.8042       0.1731       3.6240       0.0000    2585.2910    1182.0000
  256.7940      96.0000      99.5071       0.0394     129.8986       0.1682       3.6099       0.0000    2584.9417    1170.0000
  256.9464      96.0000      99.4665       0.0433     118.4787       0.1646       3.5583       0.0000    2578.5061    1176.0000
  257.0988      96.0000      99.8256       0.0488     109.8811       0.1604       3.4609       0.0000    2569.4834    1156.0000
  257.2512      96.0000      99.3467       0.0522     114.4669       0.1641       3.5078       0.0000    2563.9443    1165.0000
  257.4036      96.0000      99.7276       0.0504     119.1132       0.1691       3.5509       0.0000    2566.8115    1180.0000
  257.5560      96.0000      99.7112       0.0481     133.5564       0.1776       3.7952       0.0000    2570.6973    1170.0000
  257.7084      96.0000      99.4830       0.0359     136.0520       0.1803       3.7693       0.0000    2590.7947    1179.0000
  257.8608      96.0000      99.3306       0.0329     130.4325       0.1844       3.8541       0.0000    2595.7961    1188.0000
  258.0132      96.0000      99.5970       0.0245     128.8942       0.1775       3.7027       0.0000    2609.5054    1190.0000
  258.1656      96.0000      99.4667       0.0302     125.1995       0.1765       3.7155       0.0000    2600.1721    1187.0000
  258.3180      96.0000      99.3686       0.0346     132.6336       0.1776       3.4827       0.0000    2592.8579    1175.0000
  258.4704      96.0000      99.4828       0.0352     131.3573       0.1845       3.4934       0.0000    2591.9900    1179.0000
  258.6228      96.0000      99.4830       0.0316     137.8231       0.1865       3.5869       0.0000    2597.9231    1177.0000
  258.7752      96.0000      99.7112       0.0337     139.3614       0.1886       3.7464       0.0000    2594.4480    1179.0000
  258.9276      96.0000      99.4828       0.0377     142.5201       0.1865       3.7622       0.0000    2587.7959    1181.0000
  259.0800      96.0000      99.4828       0.0487     151.0981       0.1854       3.6937       0.0000    2569.7085    1181.0000
  259.2324      96.0000      99.4069       0.0437     151.4400       0.1890       3.6994       0.0000    2577.9053    1177.0000
  259.3848      96.0000      99.9725       0.0363     145.2031       0.1885       3.6911       0.0000    2590.1213    1187.0000
  259.5372      96.0000      99.4831       0.0345     128.5894       0.1900       3.6574       0.0000    2593.0620    1176.0000
  259.6896      96.0000      99.6079       0.0460     127.0169       0.1878       3.6143       0.0000    2574.0623    1179.0000
  259.8420      96.0000      99.5728       0.0515     125.2486       0.1957       3.5430       0.0000    2565.0974    1186.0000
  259.9944      96.0000      99.6515       0.0546     122.2591       0.1920       3.3749       0.0000    2559.9824    1167.0000
  260.1468      96.0000      99.4066       0.0496     125.0632       0.1898       3.4189       0.0000    2568.1138    1173.0000
  260.2992      96.0000      99.3686       0.0434     131.8012       0.1859       3.3278       0.0000    2578.4460    1166.0000
  260.4516      96.0000      99.6351       0.0437     140.6362       0.1931       3.4430       0.0000    2577.9309    1174.0000
  260.6040      96.0000      99.7112       0.0503     142.1757       0.1968       3.3741       0.0000    2567.0247    1191.0000
  260.7564      96.0000      99.5752       0.0534     138.9160       0.1994       3.4678       0.0000    2561.8171    1173.0000
  260.9088      96.0000      99.5590       0.0564     142.6080       0.1957       3.4359       0.0000    2556.9768    1174.0000
  261.0612      96.0000      99.5972       0.0525     146.3027       0.1915       3.4747       0.0000    2563.4104    1194.0000
  261.2136      96.0000      99.5590       0.0517     153.4850       0.1879       3.6086       0.0000    2564.7458    1182.0000
  261.3660      96.0000      99.5970       0.0478     150.8969       0.1885       3.6490       0.0000    2571.0508    1166.0000
  261.5184      96.0000      99.8201       0.0473     141.9572       0.1842       3.5763       0.0000    2571.9900    1181.0000
  261.6708      96.0000      99.6516       0.0461     127.5741       0.1869       3.3922       0.0000    2574.0017    1179.0000
  261.8232      96.0000      99.8254       0.0430     122.1947       0.1776       3.3004       0.0000    2579.0647    1177.0000
  261.9756      96.0000      99.4993       0.0428     128.3264       0.1775       3.2590       0.0000    2579.3308    1177.0000
  262.1280      96.0000      99.8499       0.0454     136.2112       0.1749       3.4513       0.0000    2575.0417    1176.0000
  262.2804      96.0000      99.4230       0.0435     138.0585       0.1811       3.5295       0.0000    2578.3005    1179.0000
  262.4328      96.0000      99.4392       0.0468     143.2888       0.1873       3.6799       0.0000    2572.7954    1170.0000
  262.5852      96.0000      99.8009       0.0450     157.5555       0.1933       3.6553       0.0000    2575.7126    1184.0000
  262.7376      96.0000      99.5753       0.0536     163.0976       0.1993       3.7898       0.0000    2561.5684    1173.0000
  262.8900      96.0000      99.7115       0.0515     156.5239       0.2053       3.6242       0.0000    2564.9890    1154.0000
  263.0424      96.0000      99.4991       0.0582     148.2171       0.2042       3.5332       0.0000    2553.9717    1205.0000
  263.1948      96.0000      99.8039       0.0482     152.2197       0.2014       3.3144       0.0000    2570.5225    1193.0000
  263.3472      96.0000      99.7112       0.0430     163.1006       0.1980       3.3847       0.0000    2579.1160    1174.0000
  263.4996      96.0000      99.8472       0.0329     160.2189       0.1937       3.3934       0.0000    2595.6787    1182.0000
  263.6520      96.0000     100.2605       0.0380     153.1373       0.2014       3.5575       0.0000    2587.3479    1168.0000
  263.8044      96.0000     100.1678       0.0358     146.3688       0.2033       3.5915       0.0000    2591.0039    1170.0000
  263.9568      96.0000     100.2438       0.0399     146.2097       0.2098       3.8061       0.0000    2584.2185    1162.0000
  264.1092      96.0000     100.5102       0.0410     154.1740       0.2179       3.8204       0.0000    2582.2766    1165.0000
  264.2616      96.0000     100.4126       0.0418     152.7978       0.2172       3.7496       0.0000    2581.0332    1170.0000
  264.4140      96.0000     100.1678       0.0405     150.3346       0.2125       3.5524       0.0000    2583.1348    1167.0000
  264.5664      96.0000     100.4207       0.0373     147.2580       0.2022       3.4771       0.0000    2588.5042    1190.0000
  264.7188      96.0000     100.4557       0.0310     155.1391       0.2093       3.6582       0.0000    2598.8059    1169.0000
  264.8712      96.0000     100.5909       0.0279     163.4120       0.2149       3.7289       0.0000    2603.9358    1166.0000
  265.0236      96.0000     100.1924       0.0301     164.7031       0.2257       3.7984       0.0000    2600.3999    1194.0000
  265.1760      96.0000     100.3203       0.0269     161.9321       0.2244       3.7403       0.0000    2605.5356    1176.0000
  265.3284      96.0000     100.5350       0.0286     159.1631       0.2258       3.7951       0.0000    2602.7793    1160.0000
  265.4808      96.0000     100.2935       0.0257     157.6026       0.2202       3.8327       0.0000    2607.5244    1188.0000
  265.6332      96.0000     100.3960       0.0235     152.9460       0.2167       3.9024       0.0000    2611.2561    1190.0000
  265.7856      96.0000     100.6407       0.0194     153.1423       0.2117       3.9032       0.0000    2618.0190    1180.0000
  265.9380      96.0000     100.3200       0.0194     145.4125       0.2033       3.9820       0.0000    2618.0566    1167.0000
  266.0904      96.0000     100.2819       0.0304     137.4456       0.2069       3.9365       0.0000    2599.7671    1177.0000
  266.2428      96.0000     100.3961       0.0380     128.6347       0.2094       3.8401       0.0000    2587.3284    1181.0000
  266.3952      96.0000     100.3960       0.0369     137.5961       0.2117       3.8061       0.0000    2589.0547    1194.0000
  266.5476      96.0000     100.3366       0.0303     147.1013       0.2126       3.7803       0.0000    2600.0378    1177.0000
  266.7000      96.0000     100.1082       0.0332     158.6484       0.2145       3.8784       0.0000    2595.1504    1182.0000
  266.8524      96.0000      99.7356       0.0347     163.5746       0.2184       3.8643       0.0000    2592.7354    1190.0000
  267.0048      96.0000      99.7872       0.0338     161.1133       0.2111       3.8298       0.0000    2594.2483    1190.0000
  267.1572      96.0000      99.9992       0.0360     153.5890       0.2047       3.6343       0.0000    2590.5613    1181.0000
  267.3096      96.0000      99.7603       0.0452     145.5838       0.2007       3.5941       0.0000    2575.4985    1181.0000
  267.4620      96.0000      99.6949       0.0407     144.0455       0.2020       3.5110       0.0000    2582.8909    1172.0000
  267.6144      96.0000     100.2819       0.0389     149.2912       0.2068       3.5011       0.0000    2585.8738    1187.0000
  267.7668      96.0000      99.9561       0.0372     150.9465       0.2090       3.7273       0.0000    2588.6626    1182.0000
  267.9192      96.0000     100.1082       0.0377     162.3750       0.2052       3.9137       0.0000    2587.7292    1181.0000
  268.0716      96.0000      99.6868       0.0339     164.4901       0.2037       3.9727       0.0000    2593.9958    1198.0000
  268.2240      96.0000      99.9561       0.0315     165.9137       0.1996       3.5318       0.0000    2598.0537    1187.0000
  268.3764      96.0000      99.9401       0.0382     156.4932       0.1941       3.1846       0.0000    2587.0422    1180.0000
  268.5288      96.0000      99.9562       0.0410     149.1093       0.1905       3.0902       0.0000    2582.2996    1208.0000
  268.6812      96.0000      99.8309       0.0392     138.9489       0.1871       3.3275       0.0000    2585.3906    1184.0000
  268.8336      96.0000      99.9396       0.0313     139.4022       0.1943       3.6809       0.0000    2598.4182    1166.0000
  268.9860      96.0000     100.0917       0.0229     150.2130       0.2011       3.9090       0.0000    2612.2693    1184.0000
  269.1384      96.0000      99.8254       0.0209     155.1040       0.2133       3.7978       0.0000    2615.5056    1197.0000
  269.2908      96.0000      99.8634       0.0185     153.6028       0.2166       3.9103       0.0000    2619.5437    1169.0000
  269.4432      96.0000      99.8799       0.0197     145.8932       0.2127       3.9149       0.0000    2617.4375    1194.0000
  269.5956      96.0000     100.2819       0.0248     143.7396       0.2026       3.9474       0.0000    2609.1499    1195.0000
  269.7480      96.0000      99.7112       0.0304     137.8896       0.1952       3.7536       0.0000    2599.8286    1163.0000
  269.9004      96.0000     100.1082       0.0353     131.4041       0.1906       3.7001       0.0000    2591.8040    1197.0000
  270.0528      96.0000     100.2821       0.0273     129.5905       0.1919       3.6124       0.0000    2604.8813    1163.0000
  270.2052      96.0000     100.0157       0.0246     137.5143       0.1894       3.5757       0.0000    2609.4360    1170.0000
  270.3576      96.0000      99.7356       0.0193     141.8216       0.1915       3.4354       0.0000    2618.1602    1190.0000
  270.5100      96.0000      99.7710       0.0254     142.7453       0.1926       3.4605       0.0000    2608.1257    1186.0000
  270.6624      96.0000     100.2007       0.0348     144.9415       0.1957       3.4231       0.0000    2592.5933    1179.0000
  270.8148      96.0000     100.0537       0.0380     145.0676       0.1954       3.6294       0.0000    2587.2241    1182.0000
  270.9672      96.0000      99.9992       0.0454     154.6123       0.1883       3.6819       0.0000    2575.1682    1183.0000
  271.1196      96.0000     100.3067       0.0365     153.0740       0.1894       3.6955       0.0000    2589.8210    1175.0000
  271.2720      96.0000     100.0321       0.0432     159.1010       0.1899       3.5979       0.0000    2578.7925    1183.0000
  271.4244      96.0000     100.0157       0.0395     158.1774       0.1964       3.4276       0.0000    2584.7627    1182.0000
  271.5768      96.0000      99.9396       0.0475     163.0999       0.1970       3.4229       0.0000    2571.7039    1188.0000
  271.7292      96.0000      99.9395       0.0511     145.1023       0.2056       3.4065       0.0000    2565.6885    1194.0000
  271.8816      96.0000     100.1431       0.0517     121.7025       0.2143       3.6136       0.0000    2564.7002    1191.0000
  272.0340      96.0000      99.5428       0.0516      94.0130       0.2078       3.7457       0.0000    2564.7888    1174.0000
  272.1864      96.0000      99.8201       0.0519      88.3429       0.1975       3.8205       0.0000    2564.3015    1188.0000
  272.3388      96.0000      99.4586       0.0516      96.3202       0.1820       3.7208       0.0000    2564.8770    1182.0000
  272.4912      96.0000     100.1082       0.0400     104.4065       0.1772       3.7596       0.0000    2583.9463    1182.0000
  272.6436      96.0000      99.8471       0.0355     117.3380       0.1762       3.6518       0.0000    2591.3564    1177.0000
  272.7960      96.0000      99.5972       0.0420     134.5670       0.1784       3.6621       0.0000    2580.7161    1179.0000
  272.9484      96.0000      99.8797       0.0387     148.9789       0.1851       3.6496       0.0000    2586.1421    1204.0000
  273.1008      96.0000      99.8502       0.0399     152.2819       0.1844       3.7889       0.0000    2584.1230    1191.0000
  273.2532      96.0000      99.9396       0.0300     142.7781       0.1881       3.8011       0.0000    2600.4224    1188.0000
  273.4056      96.0000     100.2605       0.0259     138.7755       0.1886       3.7130       0.0000    2607.2773    1194.0000
  273.5580      96.0000     100.3958       0.0236     137.5943       0.1860       3.5798       0.0000    2611.1384    1189.0000
  273.7104      96.0000      99.9724       0.0319     132.9759       0.1854       3.6498       0.0000    2597.3977    1184.0000
  273.8628      96.0000     100.4854       0.0338     128.3250       0.1941       3.4829       0.0000    2594.2158    1194.0000
  274.0152      96.0000     100.2935       0.0349     126.2032       0.2014       3.5735       0.0000    2592.4177    1181.0000
  274.1676      96.0000     100.4721       0.0249     129.6110       0.2012       3.5980       0.0000    2608.9229    1200.0000
  274.3200      96.0000     100.6490       0.0196     128.1041       0.1989       3.5335       0.0000    2617.7339    1204.0000
  274.4724      96.0000     100.4889       0.0213     135.2074       0.2012       3.4433       0.0000    2614.8362    1166.0000
  274.6248      96.0000     100.3067       0.0228     137.6275       0.2023       3.3039       0.0000    2612.3557    1189.0000
  274.7772      96.0000     100.5480       0.0270     141.9265       0.2027       3.4847       0.0000    2605.4250    1204.0000
  274.9296      96.0000     100.2439       0.0313     140.3292       0.1980       3.5800       0.0000    2598.3130    1177.0000
  275.0820      96.0000     100.3068       0.0382     149.2801       0.1990       3.5340       0.0000    2586.9351    1166.0000
  275.2344      96.0000     100.4886       0.0407     154.4873       0.1997       3.3874       0.0000    2582.9177    1203.0000
  275.3868      96.0000     100.6573       0.0435     150.2128       0.2048       3.2538       0.0000    2578.2422    1180.0000
  275.5392      96.0000     100.2819       0.0456     139.5623       0.2088       3.2803       0.0000    2574.7373    1175.0000
  275.6916      96.0000     100.3960       0.0424     135.5627       0.2069       3.5012       0.0000    2579.9985    1202.0000
  275.8440      96.0000     100.5102       0.0420     139.2574       0.2072       3.5106       0.0000    2580.6863    1165.0000
  275.9964      96.0000     100.6573       0.0417     147.4053       0.2064       3.6120       0.0000    2581.2566    1179.0000
  276.1488      96.0000     100.3366       0.0409     149.2882       0.2107       3.4109       0.0000    2582.4773    1198.0000
  276.3012      96.0000     100.1431       0.0351     152.1493       0.2046       3.4126       0.0000    2592.0054    1156.0000
  276.4536      96.0000     100.3960       0.0302     154.6105       0.1976       3.3532       0.0000    2600.1113    1170.0000
  276.6060      96.0000     100.3960       0.0292     156.1500       0.1950       3.5746       0.0000    2601.8794    1198.0000
  276.7584      96.0000     100.6240       0.0367     153.2534       0.2069       3.6450       0.0000    2589.4695    1170.0000
  276.9108      96.0000     100.5482       0.0414     150.5237       0.2137       3.4403       0.0000    2581.6611    1174.0000
  277.0632      96.0000     100.0290       0.0472     138.4868       0.2134       3.3410       0.0000    2572.1875    1184.0000
  277.2156      96.0000     100.3960       0.0466     140.0154       0.2047       3.2771       0.0000    2573.1287    1187.0000
  277.3680      96.0000     100.2008       0.0413     140.2838       0.1998       3.5640       0.0000    2581.8572    1177.0000
  277.5204      96.0000     100.1679       0.0382     154.1680       0.2021       3.5162       0.0000    2586.9216    1191.0000
  277.6728      96.0000     100.2770       0.0359     151.1011       0.2065       3.6102       0.0000    2590.7468    1181.0000
  277.8252      96.0000     100.1432       0.0348     139.1911       0.2095       3.4240       0.0000    2592.5359    1182.0000
  277.9776      96.0000     100.0917       0.0361     129.6464       0.2140       3.4327       0.0000    2590.5081    1187.0000
  278.1300      96.0000     100.4127       0.0353     133.9537       0.2144       3.4000       0.0000    2591.7988    1183.0000
  278.2824      96.0000      99.9396       0.0313     143.4401       0.2164       3.4145       0.0000    2598.3525    1169.0000
  278.4348      96.0000     100.0321       0.0274     149.2436       0.2175       3.4830       0.0000    2604.8311    1191.0000
  278.5872      96.0000     100.3713       0.0258     158.1658       0.2146       3.5904       0.0000    2607.4990    1183.0000
  278.7396      96.0000     100.3198       0.0266     156.9342       0.2157       3.5581       0.0000    2606.0466    1179.0000
  278.8920      96.0000     100.2010       0.0322     157.8669       0.2007       3.5206       0.0000    2596.8867    1186.0000
  279.0444      96.0000     100.0537       0.0434     150.5218       0.1968       3.3359       0.0000    2578.4253    1204.0000
  279.1968      96.0000      99.9993       0.0415     146.3339       0.1897       3.2131       0.0000    2581.4849    1189.0000
  279.3492      96.0000     100.1926       0.0403     143.2923       0.1897       3.1859       0.0000    2583.4653    1179.0000
  279.5016      96.0000      99.9562       0.0309     130.3318       0.1853       3.1595       0.0000    2599.0867    1176.0000
  279.6540      96.0000      99.8800       0.0224     128.3619       0.1831       3.3836       0.0000    2613.0085    1196.0000
  279.8064      96.0000      99.5970       0.0229     124.3272       0.1842       3.4213       0.0000    2612.1414    1186.0000
  279.9588      96.0000     100.0320       0.0277     125.9199       0.1904       3.7168       0.0000    2604.3701    1186.0000
  280.1112      96.0000     100.2821       0.0268     131.7698       0.1950       3.5558       0.0000    2605.7285    1189.0000
  280.2636      96.0000      99.8799       0.0301     133.0005       0.2008       3.6967       0.0000    2600.3350    1181.0000
  280.4160      96.0000     100.0155       0.0270     144.0605       0.2014       3.9053       0.0000    2605.4172    1181.0000
  280.5684      96.0000     100.0537       0.0241     141.2438       0.1954       4.3120       0.0000    2610.3020    1186.0000
  280.7208      96.0000     100.2440       0.0227     143.6897       0.1935       4.2503       0.0000    2612.5103    1191.0000
  280.8732      96.0000     100.1924       0.0316     137.0760       0.1917       3.9193       0.0000    2597.8123    1186.0000
  281.0256      96.0000      99.8470       0.0365     142.9328       0.1982       3.7302       0.0000    2589.7617    1191.0000
  281.1780      96.0000      99.9396       0.0425     143.5988       0.1983       3.7363       0.0000    2579.9290    1188.0000
  281.3304      96.0000      99.7113       0.0367     145.2514       0.1953       3.5815       0.0000    2589.5132    1188.0000
  281.4828      96.0000     100.1081       0.0364     137.0004       0.1911       3.5782       0.0000    2589.9163    1203.0000
  281.6352      96.0000      99.8634       0.0294     141.3109       0.1934       3.6447       0.0000    2601.5242    1197.0000
  281.7876      96.0000      99.4828       0.0239     143.4646       0.1971       3.7519       0.0000    2610.5396    1186.0000
  281.9400      96.0000      99.9233       0.0198     154.2174       0.2025       3.6341       0.0000    2617.3105    1180.0000
  282.0924      96.0000      99.9149       0.0285     149.5640       0.1998       3.4490       0.0000    2602.9414    1186.0000
  282.2448      96.0000      99.9562       0.0353     149.1779       0.1991       3.4522       0.0000    2591.8318    1188.0000
  282.3972      96.0000      99.8201       0.0439     136.8308       0.1919       3.6271       0.0000    2577.4995    1188.0000
  282.5496      96.0000     100.0291       0.0480     140.2527       0.1907       3.6461       0.0000    2570.7668    1181.0000
  282.7020      96.0000      99.9724       0.0557     133.2549       0.1931       3.6375       0.0000    2558.0435    1183.0000
  282.8544      96.0000     100.2571       0.0635     131.0869       0.1982       3.5448       0.0000    2545.2471    1193.0000
  283.0068      96.0000      99.8797       0.0694     112.6134       0.2015       3.4209       0.0000    2535.5361    1203.0000
  283.1592      96.0000      99.7710       0.0758     106.1525       0.2058       3.4246       0.0000    2524.8594    1181.0000
  283.3116      96.0000     100.0289       0.0804     100.9625       0.2041       3.5902       0.0000    2517.3264    1184.0000
  283.4640      96.0000     100.1245       0.0781     107.7073       0.1936       3.6436       0.0000    2521.0557    1196.0000
  283.6164      96.0000      99.5970       0.0695     107.4255       0.1803       3.4548       0.0000    2535.3223    1189.0000
  283.7688      96.0000      99.9562       0.0514     103.3810       0.1655       3.2000       0.0000    2565.1436    1197.0000
  283.9212      96.0000      99.8635       0.0383      97.2278       0.1547       3.1932       0.0000    2586.7754    1202.0000
  284.0736      96.0000      99.8009       0.0334      86.1437       0.1461       3.2179       0.0000    2594.8674    1189.0000
  284.2260      96.0000      99.8037       0.0385      75.7022       0.1512       3.1474       0.0000    2586.4209    1196.0000
  284.3784      96.0000      99.5590       0.0425      64.9448       0.1521       3.3052       0.0000    2579.9517    1198.0000
  284.5308      96.0000      99.5726       0.0436      70.7729       0.1586       3.4103       0.0000    2578.0181    1195.0000
  284.6832      96.0000      99.8201       0.0445      71.0958       0.1620       3.6425       0.0000    2576.6201    1198.0000
  284.8356      96.0000      99.5728       0.0418      84.9297       0.1690       3.6683       0.0000    2580.9785    1195.0000
  284.9880      96.0000      99.5590       0.0460      96.0358       0.1734       3.6101       0.0000    2574.1736    1214.0000
  285.1404      96.0000      99.5590       0.0531     108.2065       0.1910       3.5009       0.0000    2562.4490    1201.0000
  285.2928      96.0000      99.5727       0.0562     100.5150       0.2066       3.5241       0.0000    2557.3284    1193.0000
  285.4452      96.0000      99.6950       0.0537      90.9703       0.2116       3.6627       0.0000    2561.4175    1205.0000
  285.5976      96.0000      99.7356       0.0531      82.7840       0.2068       3.5201       0.0000    2562.3599    1197.0000
  285.7500      96.0000      99.7112       0.0529      78.4943       0.2045       3.2391       0.0000    2562.7603    1179.0000
  285.9024      96.0000      99.5155       0.0500      82.7784       0.2002       3.2432       0.0000    2567.5691    1215.0000
  286.0548      96.0000      99.4584       0.0377      95.0690       0.1962       3.3356       0.0000    2587.8413    1188.0000
  286.2072      96.0000      99.5753       0.0395      95.6848       0.1961       3.2484       0.0000    2584.7930    1186.0000
  286.3596      96.0000      99.4827       0.0471      86.4549       0.1945       2.9964       0.0000    2572.2473    1224.0000
  286.5120      96.0000      99.1944       0.0512      73.5668       0.1879       3.0962       0.0000    2565.5493    1183.0000
  286.6644      96.0000      99.4665       0.0415      76.2285       0.1788       3.2883       0.0000    2581.4448    1191.0000
  286.8168      96.0000      99.2544       0.0385      81.1511       0.1776       3.4835       0.0000    2586.5454    1226.0000
  286.9692      96.0000      99.4828       0.0468      82.3827       0.1808       3.4821       0.0000    2572.7871    1183.0000
  287.1216      96.0000      99.3467       0.0562      74.1650       0.1859       3.5625       0.0000    2557.2065    1196.0000
  287.2740      96.0000      99.2301       0.0594      74.4960       0.1855       3.6177       0.0000    2551.9353    1200.0000
  287.4264      96.0000      99.6513       0.0512      78.1693       0.1834       3.5389       0.0000    2565.5454    1197.0000
  287.5788      96.0000      99.5074       0.0509      90.1491       0.1878       3.4579       0.0000    2565.9875    1182.0000
  287.7312      96.0000      99.4229       0.0555      82.4342       0.1876       3.3606       0.0000    2558.4363    1193.0000
  287.8836      96.0000      99.8471       0.0634      79.9926       0.1940       3.3324       0.0000    2545.4624    1189.0000
  288.0360      96.0000      99.3443       0.0665      74.8002       0.1931       3.1801       0.0000    2540.2178    1191.0000
  288.1884      96.0000      99.4828       0.0637      85.8760       0.1971       3.3662       0.0000    2544.9729    1194.0000
  288.3408      96.0000      99.4990       0.0523     104.8514       0.2028       3.4683       0.0000    2563.6921    1181.0000
  288.4932      96.0000      99.3929       0.0449     118.6772       0.2016       3.6498       0.0000    2575.9075    1174.0000
  288.6456      96.0000      99.4990       0.0430     127.6319       0.1990       3.5912       0.0000    2579.0110    1190.0000
  288.7980      96.0000      99.4584       0.0461     125.8660       0.1970       3.4984       0.0000    2573.9160    1204.0000
  288.9504      96.0000      99.1943       0.0443     123.4321       0.1900       3.4423       0.0000    2576.9368    1180.0000
  289.1028      96.0000      99.3144       0.0527     111.4008       0.1925       3.4270       0.0000    2563.0864    1198.0000
  289.2552      96.0000      99.7113       0.0601      95.7239       0.1860       3.5851       0.0000    2550.8538    1190.0000
  289.4076      96.0000      99.6677       0.0714      86.7951       0.1891       3.7263       0.0000    2532.1370    1175.0000
  289.5600      96.0000      99.5970       0.0745      74.1810       0.1898       3.5567       0.0000    2527.1196    1212.0000
  289.7124      96.0000      99.3904       0.0743      66.1827       0.1811       3.4079       0.0000    2527.3794    1204.0000
  289.8648      96.0000      99.2866       0.0535      69.2385       0.1664       3.3270       0.0000    2561.6816    1174.0000
  290.0172      96.0000      98.9116       0.0356      79.8846       0.1509       3.4413       0.0000    2591.2002    1202.0000
  290.1696      96.0000      99.6787       0.0260      94.6635       0.1442       3.5098       0.0000    2607.0681    1212.0000
  290.3220      96.0000      99.4667       0.0322      95.8941       0.1464       3.6080       0.0000    2596.8982    1173.0000
  290.4744      96.0000      99.3686       0.0388      99.7330       0.1495       3.4511       0.0000    2586.0417    1198.0000
  290.6268      96.0000      99.4229       0.0327      94.7846       0.1501       3.3884       0.0000    2596.0798    1207.0000
  290.7792      96.0000      99.5072       0.0352      96.3054       0.1471       3.4736       0.0000    2591.8779    1183.0000
  290.9316      96.0000      99.2706       0.0400      91.6871       0.1428       3.6009       0.0000    2583.9639    1183.0000
  291.0840      96.0000      98.9116       0.0378      85.2262       0.1419       3.5484       0.0000    2587.5913    1215.0000
  291.2364      96.0000      98.9658       0.0393      80.0134       0.1475       3.4599       0.0000    2585.1001    1186.0000
  291.3888      96.0000      99.0258       0.0395      86.6071       0.1513       3.5115       0.0000    2584.7598    1205.0000
  291.5412      96.0000      99.0500       0.0416     104.4822       0.1550       3.7629       0.0000    2581.3816    1211.0000
  291.6936      96.0000      98.4925       0.0413     114.3273       0.1619       3.7016       0.0000    2581.9243    1169.0000
  291.8460      96.0000      98.7370       0.0436     117.2782       0.1701       3.6002       0.0000    2578.0854    1189.0000
  291.9984      96.0000      99.0259       0.0490     108.0177       0.1712       3.4305       0.0000    2569.1782    1189.0000
  292.1508      96.0000      99.0581       0.0485     112.3568       0.1711       3.3923       0.0000    2569.8972    1198.0000
  292.3032      96.0000      99.2544       0.0422     123.7116       0.1778       3.6687       0.0000    2580.3333    1181.0000
  292.4556      96.0000      99.4067       0.0371     138.8788       0.1896       3.8216       0.0000    2588.7400    1180.0000
  292.6080      96.0000      99.4068       0.0436     135.7999       0.2005       3.8226       0.0000    2578.0769    1202.0000
  292.7604      96.0000      99.3686       0.0430     125.0317       0.2112       3.4930       0.0000    2579.0425    1182.0000
  292.9128      96.0000      99.4066       0.0441     122.8198       0.2138       3.4414       0.0000    2577.1973    1196.0000
  293.0652      96.0000      99.7276       0.0397     132.0201       0.2183       3.5280       0.0000    2584.4487    1207.0000
  293.2176      96.0000      99.6216       0.0436     136.6909       0.2116       3.6295       0.0000    2578.0903    1180.0000
  293.3700      96.0000      99.5753       0.0435     132.9962       0.2096       3.5581       0.0000    2578.2903    1194.0000
  293.5224      96.0000      99.8253       0.0488     120.6898       0.1974       3.4515       0.0000    2569.4419    1208.0000
  293.6748      96.0000      99.3904       0.0533     116.3559       0.1891       3.4702       0.0000    2562.1333    1184.0000
  293.8272      96.0000      99.5427       0.0539     112.9968       0.1814       3.4977       0.0000    2561.0400    1210.0000
  293.9796      96.0000      99.7358       0.0461     110.8688       0.1805       3.4101       0.0000    2573.9561    1205.0000
  294.1320      96.0000      99.5915       0.0475     107.4552       0.1747       3.3889       0.0000    2571.6082    1186.0000
  294.2844      96.0000      99.3686       0.0552      99.1144       0.1710       3.4340       0.0000    2558.8718    1204.0000
  294.4368      96.0000      99.4070       0.0540      93.2432       0.1778       3.6459       0.0000    2560.9780    1201.0000
  294.5892      96.0000      99.2544       0.0481      94.1937       0.1762       3.5610       0.0000    2570.5886    1177.0000
  294.7416      96.0000      99.6869       0.0356     106.6700       0.1758       3.5884       0.0000    2591.3015    1198.0000
  294.8940      96.0000      99.3305       0.0255     124.2067       0.1684       3.5936       0.0000    2607.8906    1186.0000
  295.0464      96.0000      99.4586       0.0244     136.8302       0.1757       3.6724       0.0000    2609.7585    1193.0000
  295.1988      96.0000      99.5753       0.0268     129.5623       0.1761       3.7632       0.0000    2605.7993    1200.0000
  295.3512      96.0000      99.1620       0.0248     119.1283       0.1705       3.6168       0.0000    2609.0781    1175.0000
  295.5036      96.0000      99.4828       0.0230      97.5689       0.1652       3.5391       0.0000    2611.9839    1207.0000
  295.6560      96.0000      99.3468       0.0295     100.9532       0.1682       3.3825       0.0000    2601.2637    1203.0000
  295.8084      96.0000      99.7275       0.0380     104.3400       0.1771       3.3791       0.0000    2587.3713    1188.0000
  295.9608      96.0000      99.2787       0.0427     112.3254       0.1862       3.4317       0.0000    2579.6074    1200.0000
  296.1132      96.0000      99.7275       0.0417     104.0407       0.1898       3.4076       0.0000    2581.1707    1205.0000
  296.2656      96.0000      99.5970       0.0401      98.7360       0.1965       3.4829       0.0000    2583.7747    1202.0000
  296.4180      96.0000      99.9560       0.0415      99.3786       0.2012       3.4260       0.0000    2581.4536    1197.0000
  296.5704      96.0000      99.8039       0.0417      99.3786       0.2041       3.3504       0.0000    2581.1697    1181.0000
  296.7228      96.0000      99.5970       0.0391     105.5771       0.2106       3.3777       0.0000    2585.4099    1205.0000
  296.8752      96.0000      99.7710       0.0323     113.8568       0.2123       3.5748       0.0000    2596.6543    1218.0000
  297.0276      96.0000      99.7112       0.0393     130.1294       0.2216       3.9812       0.0000    2585.2026    1183.0000
  297.1800      96.0000      99.7874       0.0468     137.2407       0.2251       3.9731       0.0000    2572.8235    1198.0000
  297.3324      96.0000      99.6950       0.0503     140.6249       0.2314       3.8296       0.0000    2566.9595    1200.0000
  297.4848      96.0000      99.5972       0.0488     140.3627       0.2337       3.7707       0.0000    2569.5190    1184.0000
  297.6372      96.0000      99.9395       0.0455     134.1744       0.2313       3.8024       0.0000    2574.9392    1210.0000
  297.7896      96.0000      99.5726       0.0454     136.1137       0.2353       3.9849       0.0000    2575.1240    1205.0000
  297.9420      96.0000      99.8637       0.0413     144.7347       0.2422       3.8445       0.0000    2581.9192    1189.0000
  298.0944      96.0000      99.6515       0.0489     156.7335       0.2483       3.7793       0.0000    2569.3362    1205.0000
  298.2468      96.0000      99.4829       0.0503     163.7591       0.2424       3.6432       0.0000    2567.0254    1207.0000
  298.3992      96.0000      99.9560       0.0567     158.4882       0.2265       3.5927       0.0000    2556.5090    1191.0000
  298.5516      96.0000      99.6351       0.0615     149.3143       0.2143       3.1262       0.0000    2548.5671    1207.0000
  298.7040      96.0000      98.7731       0.0540     128.0697       0.1880       2.9034       0.0000    2560.9082    1215.0000
  298.8564      96.0000      98.8736       0.0499     111.7637       0.1594       2.7578       0.0000    2567.6804    1197.0000
  299.0088      96.0000      98.9359       0.0453     105.5825       0.1352       2.9619       0.0000    2575.2664    1212.0000
  299.1612      96.0000      98.5081       0.0529      93.8646       0.1258       3.0056       0.0000    2562.7688    1225.0000
  299.3136      96.0000      98.3557       0.0526      87.2458       0.1261       3.0969       0.0000    2563.1436    1207.0000
  299.4660      96.0000      98.4542       0.0464      75.2380       0.1160       3.3378       0.0000    2573.4009    1207.0000
  299.6184      96.0000      98.2478       0.0480      84.7755       0.1157       3.4843       0.0000    2570.8152    1221.0000
  299.7708      96.0000      98.4302       0.0476      99.3935       0.1217       3.3972       0.0000    2571.4512    1201.0000
  299.9232      96.0000      98.1715       0.0453     109.8618       0.1286       3.3239       0.0000    2575.3044    1198.0000
  300.0756      96.0000      98.5242       0.0426     105.5765       0.1357       3.1980       0.0000    2579.6570    1215.0000
  300.2280      96.0000      98.6165       0.0517      97.7715       0.1391       3.2172       0.0000    2564.6436    1211.0000
  300.3804      96.0000      98.5084       0.0570      98.0793       0.1393       3.1141       0.0000    2555.9827    1194.0000
  300.5328      96.0000      98.8575       0.0594      98.3651       0.1355       3.2180       0.0000    2552.0449    1217.0000
  300.6852      96.0000      99.0499       0.0560      86.8034       0.1293       3.1601       0.0000    2557.6812    1215.0000
  300.8376      96.0000      98.7370       0.0543      72.9316       0.1218       3.2815       0.0000    2560.3286    1196.0000
  300.9900      96.0000      99.0499       0.0501      70.4155       0.1152       3.4637       0.0000    2567.3472    1205.0000
  301.1424      96.0000      98.9056       0.0415      85.8101       0.1114       3.6622       0.0000    2581.5696    1200.0000
  301.2948      96.0000      98.8734       0.0353     100.8855       0.1166       3.5684       0.0000    2591.7671    1224.0000
  301.4472      96.0000      98.6589       0.0227     115.1237       0.1220       3.2069       0.0000    2612.4900    1204.0000
  301.5996      96.0000      98.7210       0.0233     112.6349       0.1215       3.0467       0.0000    2611.5762    1209.0000
  301.7520      96.0000      99.0258       0.0202     107.2155       0.1231       3.0154       0.0000    2616.6382    1229.0000
  301.9044      96.0000      98.9120       0.0241     102.3278       0.1224       3.3067       0.0000    2610.1563    1196.0000
  302.0568      96.0000      98.8132       0.0258     102.7211       0.1255       3.3236       0.0000    2607.5024    1202.0000
  302.2092      96.0000      99.3686       0.0375     101.3949       0.1293       3.3603       0.0000    2588.0771    1219.0000
  302.3616      96.0000      99.0859       0.0463      94.5605       0.1396       3.2994       0.0000    2573.6404    1211.0000
  302.5140      96.0000      99.1620       0.0454      92.3454       0.1481       3.5030       0.0000    2575.0457    1200.0000
  302.6664      96.0000      98.9356       0.0367      98.1179       0.1502       3.3369       0.0000    2589.4548    1239.0000
  302.8188      96.0000      98.8135       0.0255     113.5009       0.1481       3.2154       0.0000    2607.8835    1202.0000
  302.9712      96.0000      99.0259       0.0147     121.8140       0.1488       3.2313       0.0000    2625.7986    1211.0000
  303.1236      96.0000      99.1344       0.0076     132.0171       0.1471       3.4346       0.0000    2637.4541    1219.0000
  303.2760      96.0000      99.2105       0.0088     126.1715       0.1563       3.5378       0.0000    2635.4375    1223.0000
  303.4284      96.0000      98.9117       0.0164     120.0137       0.1575       3.5266       0.0000    2622.9158    1219.0000
  303.5808      96.0000      99.0259       0.0223     118.7031       0.1633       3.6099       0.0000    2613.1992    1208.0000
  303.7332      96.0000      99.0259       0.0301     121.7797       0.1734       3.5329       0.0000    2600.3914    1221.0000
  303.8856      96.0000      99.3307       0.0323     129.7849       0.1852       3.3221       0.0000    2596.6279    1209.0000
  304.0380      96.0000      99.7873       0.0332     128.9419       0.1848       3.3601       0.0000    2595.2578    1214.0000
  304.1904      96.0000      99.1642       0.0359     136.6708       0.1725       3.5044       0.0000    2590.6831    1224.0000
  304.3428      96.0000      99.1946       0.0343     140.3309       0.1585       3.5313       0.0000    2593.4463    1189.0000
  304.4952      96.0000      98.9658       0.0355     132.6235       0.1436       3.3952       0.0000    2591.5051    1224.0000
  304.6476      96.0000      98.4542       0.0429     108.6079       0.1251       3.1513       0.0000    2579.2246    1205.0000
  304.8000      96.0000      98.4922       0.0441      87.9946       0.1139       3.2266       0.0000    2577.2749    1197.0000
  304.9524      96.0000      98.3160       0.0446      65.5618       0.1116       3.1692       0.0000    2576.4377    1219.0000
  305.1048      96.0000      98.6891       0.0498      56.9279       0.1109       3.1952       0.0000    2567.8708    1214.0000
  305.2572      96.0000      98.8294       0.0496      48.1509       0.1112       3.1988       0.0000    2568.1943    1211.0000
  305.4096      96.0000      98.6829       0.0449      51.5377       0.1178       3.2659       0.0000    2575.8940    1232.0000
  305.5620      96.0000      98.7973       0.0417      56.7679       0.1273       3.4001       0.0000    2581.2024    1203.0000
  305.7144      96.0000      98.9658       0.0389      81.2666       0.1416       3.7118       0.0000    2585.8503    1205.0000
  305.8668      96.0000      99.8009       0.0320     105.5587       0.1590       3.9798       0.0000    2597.2036    1225.0000
  306.0192      96.0000      99.5590       0.0311     132.6918       0.1879       4.4534       0.0000    2598.6138    1207.0000
  306.1716      96.0000      99.2787       0.0283     132.6918       0.2101       4.2965       0.0000    2603.2893    1232.0000
  306.3240      96.0000      99.7112       0.0249     136.9991       0.2155       3.9856       0.0000    2608.8906    1204.0000
  306.4764      96.0000      99.7875       0.0162     123.4031       0.2096       3.4776       0.0000    2623.3381    1204.0000
  306.6288      96.0000      99.7112       0.0173     121.5557       0.1934       3.2944       0.0000    2621.4050    1242.0000
  306.7812      96.0000      99.6189       0.0200     117.8956       0.1912       3.4634       0.0000    2617.0420    1212.0000
  306.9336      96.0000     100.0536       0.0192     129.4000       0.1813       3.6634       0.0000    2618.2903    1216.0000
  307.0860      96.0000     100.1081       0.0203     137.4052       0.1846       3.9231       0.0000    2616.5486    1215.0000
  307.2384      96.0000     100.0322       0.0215     147.8338       0.1874       3.7786       0.0000    2614.4622    1207.0000
  307.3908      96.0000     100.1678       0.0224     152.3668       0.1963       3.6849       0.0000    2613.0581    1216.0000
  307.5432      96.0000     100.3365       0.0234     148.3876       0.1973       3.5398       0.0000    2611.4397    1223.0000
  307.6956      96.0000     100.1844       0.0314     150.8489       0.1975       3.6536       0.0000    2598.1863    1214.0000
  307.8480      96.0000     100.0782       0.0427     150.5410       0.1984       3.6080       0.0000    2579.5012    1218.0000
  308.0004      96.0000     100.1082       0.0451     151.4081       0.2008       3.6247       0.0000    2575.6277    1219.0000
  308.1528      96.0000      99.7110       0.0377     140.9813       0.2030       3.4486       0.0000    2587.7253    1221.0000
  308.3052      96.0000     100.1081       0.0381     136.3276       0.2033       3.3275       0.0000    2587.1821    1204.0000
  308.4576      96.0000      99.8038       0.0353     140.5908       0.2019       3.1697       0.0000    2591.7820    1207.0000
  308.6100      96.0000     100.0537       0.0382     148.8639       0.2032       3.3080       0.0000    2586.9495    1221.0000
  308.7624      96.0000     100.0752       0.0315     149.5150       0.2041       3.4513       0.0000    2598.0811    1208.0000
  308.9148      96.0000     100.1678       0.0285     149.2877       0.2068       3.5884       0.0000    2603.0344    1215.0000
  309.0672      96.0000      99.9559       0.0257     149.2877       0.2038       3.5548       0.0000    2607.6299    1211.0000
  309.2196      96.0000      99.9993       0.0257     148.9798       0.2032       3.5894       0.0000    2607.6257    1197.0000
  309.3720      96.0000     100.0537       0.0265     151.2171       0.1947       3.6099       0.0000    2606.2947    1209.0000
  309.5244      96.0000      99.7874       0.0314     148.4860       0.1886       3.4327       0.0000    2598.1516    1214.0000
  309.6768      96.0000     100.2571       0.0249     147.5275       0.1778       3.3335       0.0000    2608.9468    1195.0000
  309.8292      96.0000     100.0322       0.0212     132.6666       0.1794       3.2132       0.0000    2615.0732    1203.0000
  309.9816      96.0000      99.7547       0.0188     129.7127       0.1746       3.2146       0.0000    2619.0146    1212.0000
  310.1340      96.0000      99.9149       0.0209     125.4054       0.1755       3.2903       0.0000    2615.5261    1214.0000
  310.2864      96.0000     100.3035       0.0218     139.5684       0.1753       3.4369       0.0000    2614.0002    1216.0000
  310.4388      96.0000      99.7874       0.0239     138.4850       0.1920       3.5995       0.0000    2610.6072    1215.0000
  310.5912      96.0000     100.3068       0.0261     148.3691       0.1964       3.5873       0.0000    2606.9697    1217.0000
  310.7436      96.0000     100.0322       0.0282     148.0241       0.2021       3.3960       0.0000    2603.4299    1209.0000
  310.8960      96.0000     100.1678       0.0314     155.4483       0.2037       3.2075       0.0000    2598.2241    1208.0000
  311.0484      96.0000     100.0917       0.0299     153.0070       0.2024       3.1288       0.0000    2600.7283    1243.0000
  311.2008      96.0000      99.6949       0.0314     139.4699       0.1993       3.2893       0.0000    2598.2222    1210.0000
  311.3532      96.0000      99.5970       0.0383     137.6225       0.1885       3.3164       0.0000    2586.8213    1224.0000
  311.5056      96.0000     100.0157       0.0406     140.0249       0.1862       3.3842       0.0000    2583.0112    1228.0000
  311.6580      96.0000      99.7278       0.0461     146.7806       0.1832       3.3144       0.0000    2573.9329    1224.0000
  311.8104      96.0000      99.5970       0.0392     132.5156       0.1753       3.3100       0.0000    2585.3816    1209.0000
  311.9628      96.0000      99.9559       0.0338     117.4586       0.1712       3.3128       0.0000    2594.1782    1215.0000
  312.1152      96.0000      99.6215       0.0290     118.3944       0.1651       3.3090       0.0000    2602.1206    1200.0000
  312.2676      96.0000     100.1083       0.0291     120.9596       0.1659       3.2238       0.0000    2601.9849    1222.0000
  312.4200      96.0000     100.0590       0.0328     129.5556       0.1643       3.0927       0.0000    2595.8313    1224.0000
  312.5724      96.0000      99.9641       0.0284     130.5121       0.1636       3.0471       0.0000    2603.0591    1216.0000
  312.7248      96.0000     100.2769       0.0295     132.6355       0.1591       3.1150       0.0000    2601.3921    1228.0000
  312.8772      96.0000     100.1431       0.0315     128.9749       0.1589       3.3785       0.0000    2598.0569    1231.0000
  313.0296      96.0000     100.5052       0.0299     125.3726       0.1594       3.5639       0.0000    2600.6011    1225.0000
  313.1820      96.0000     100.4554       0.0307     115.2198       0.1665       3.5655       0.0000    2599.2830    1225.0000
  313.3344      96.0000     100.5993       0.0357     115.5276       0.1720       3.4965       0.0000    2591.1616    1233.0000
  313.4868      96.0000     100.2603       0.0440     118.7889       0.1844       3.3632       0.0000    2577.4009    1230.0000
  313.6392      96.0000     100.2768       0.0418     133.3407       0.1919       3.4913       0.0000    2580.9985    1232.0000
  313.7916      96.0000      99.9396       0.0449     135.8038       0.1945       3.4513       0.0000    2575.8362    1224.0000
  313.9440      96.0000     100.4721       0.0429     140.1111       0.1879       3.4405       0.0000    2579.2607    1238.0000
  314.0964      96.0000     100.4854       0.0433     137.8992       0.1779       3.2805       0.0000    2578.5313    1236.0000
  314.2488      96.0000     100.1247       0.0405     131.4048       0.1704       3.1755       0.0000    2583.2400    1223.0000
  314.4012      96.0000     100.0917       0.0414     122.8203       0.1668       3.1756       0.0000    2581.6836    1226.0000
  314.5536      96.0000      99.8009       0.0325     121.2701       0.1738       3.3488       0.0000    2596.3540    1217.0000
  314.7060      96.0000     100.2173       0.0276     134.4995       0.1838       3.3935       0.0000    2604.5107    1221.0000
  314.8584      96.0000     100.1926       0.0302     136.0078       0.1880       3.4738       0.0000    2600.1228    1238.0000
  315.0108      96.0000     100.2603       0.0328     135.7107       0.1887       3.4681       0.0000    2595.9163    1193.0000
  315.1632      96.0000     100.2772       0.0390     126.8204       0.1788       3.4320       0.0000    2585.6121    1232.0000
  315.3156      96.0000      99.9396       0.0424     129.5893       0.1728       3.2647       0.0000    2580.0706    1240.0000
  315.4680      96.0000     100.2009       0.0449     131.7446       0.1696       3.1120       0.0000    2575.9751    1205.0000
  315.6204      96.0000      99.9398       0.0358     135.4046       0.1675       3.0631       0.0000    2590.9431    1211.0000
  315.7728      96.0000     100.4209       0.0264     137.2737       0.1642       3.1699       0.0000    2606.4128    1242.0000
  315.9252      96.0000     100.2009       0.0252     141.8549       0.1649       3.3937       0.0000    2608.4246    1210.0000
  316.0776      96.0000     100.1031       0.0267     143.7369       0.1771       3.6774       0.0000    2606.0046    1237.0000
  316.2300      96.0000     100.0917       0.0233     142.8248       0.1909       3.7869       0.0000    2611.5273    1219.0000
  316.3824      96.0000      99.7275       0.0305     140.4503       0.1981       3.7856       0.0000    2599.6406    1222.0000
  316.5348      96.0000      99.4829       0.0355     143.2213       0.2083       3.4528       0.0000    2591.3562    1238.0000
  316.6872      96.0000      99.7710       0.0346     153.9555       0.2125       3.4717       0.0000    2592.8931    1222.0000
  316.8396      96.0000      99.7112       0.0286     164.3723       0.2172       3.5197       0.0000    2602.7412    1218.0000
  316.9920      96.0000      99.4829       0.0232     178.8953       0.2088       3.8494       0.0000    2611.7334    1232.0000
  317.1444      96.0000      99.7277       0.0187     177.6647       0.2131       3.7282       0.0000    2619.1921    1232.0000
  317.2968      96.0000      99.5970       0.0275     162.8859       0.2026       3.6003       0.0000    2604.6514    1229.0000
  317.4492      96.0000      99.3306       0.0367     133.5571       0.1857       3.3678       0.0000    2589.3845    1231.0000
  317.6016      96.0000      99.2105       0.0392     115.4325       0.1673       3.3291       0.0000    2585.2981    1225.0000
  317.7540      96.0000      98.9120       0.0471     105.5553       0.1569       3.2958       0.0000    2572.3562    1237.0000
  317.9064      96.0000      98.9818       0.0520     104.9665       0.1569       3.3307       0.0000    2564.2034    1207.0000
  318.0588      96.0000      99.2787       0.0468      96.0168       0.1487       3.2097       0.0000    2572.6985    1228.0000
  318.2112      96.0000      99.1023       0.0384      88.7484       0.1365       3.0548       0.0000    2586.6113    1223.0000
  318.3636      96.0000      99.1943       0.0289      89.3371       0.1298       3.0427       0.0000    2602.3315    1211.0000
  318.5160      96.0000      99.2301       0.0257      88.7421       0.1282       3.1888       0.0000    2607.5579    1222.0000
  318.6684      96.0000      99.6351       0.0241      98.1906       0.1413       3.3169       0.0000    2610.2920    1218.0000
  318.8208      96.0000      99.9395       0.0306     104.9107       0.1587       3.3831       0.0000    2599.4473    1212.0000
  318.9732      96.0000     100.3961       0.0324     121.5369       0.1860       3.7498       0.0000    2596.6108    1231.0000
  319.1256      96.0000     100.1412       0.0357     137.5472       0.2071       3.9098       0.0000    2591.1736    1229.0000
  319.2780      96.0000      99.6460       0.0367     150.5174       0.2174       4.0049       0.0000    2589.4370    1225.0000
  319.4304      96.0000     100.0917       0.0348     155.7051       0.2172       3.6173       0.0000    2592.5493    1225.0000
  319.5828      96.0000     100.1082       0.0390     152.5902       0.2195       3.6119       0.0000    2585.7229    1223.0000
  319.7352      96.0000     100.1432       0.0378     144.0110       0.2226       3.4948       0.0000    2587.6768    1218.0000
  319.8876      96.0000      99.5264       0.0391     141.5595       0.2144       3.6134       0.0000    2585.4897    1232.0000
  320.0400      96.0000      99.6213       0.0393     136.6692       0.2153       3.8329       0.0000    2585.0928    1215.0000
  320.1924      96.0000      99.3305       0.0385     136.3262       0.2149       3.8859       0.0000    2586.3948    1214.0000
  320.3448      96.0000      99.3306       0.0414     137.5927       0.2127       3.8026       0.0000    2581.6501    1221.0000
  320.4972      96.0000      99.1643       0.0406     135.0991       0.1868       3.4048       0.0000    2582.9963    1202.0000
  320.6496      96.0000      99.4067       0.0439     121.1682       0.1568       3.3995       0.0000    2577.6133    1209.0000
  320.8020      96.0000      99.4230       0.0360      98.0763       0.1380       3.4029       0.0000    2590.6262    1222.0000
  320.9544      96.0000      99.3686       0.0324      89.1541       0.1332       3.4795       0.0000    2596.5806    1218.0000
  321.1068      96.0000      99.3145       0.0289      96.6543       0.1439       3.5010       0.0000    2602.3669    1207.0000
  321.2592      96.0000      99.3686       0.0318     119.9053       0.1632       3.4239       0.0000    2597.5261    1238.0000
  321.4116      96.0000      99.4667       0.0318     131.5964       0.1799       3.5429       0.0000    2597.5291    1236.0000
  321.5640      96.0000      99.5915       0.0281     144.4880       0.1848       3.5006       0.0000    2603.6453    1207.0000
  321.7164      96.0000      99.5727       0.0314     142.1736       0.1781       3.5897       0.0000    2598.2012    1219.0000
  321.8688      96.0000      99.7874       0.0280     142.5141       0.1680       3.6034       0.0000    2603.8523    1207.0000
  322.0212      96.0000      99.3929       0.0346     129.2713       0.1615       3.6977       0.0000    2592.9399    1226.0000
  322.1736      96.0000      99.5914       0.0278     111.1057       0.1568       3.9354       0.0000    2604.1514    1203.0000
  322.3260      96.0000      99.4667       0.0224     101.8431       0.1498       3.8723       0.0000    2613.0686    1233.0000
  322.4784      96.0000      99.4828       0.0251      99.1154       0.1488       4.1496       0.0000    2608.5356    1224.0000
  322.6308      96.0000      99.4668       0.0292     106.4787       0.1607       3.8815       0.0000    2601.8962    1222.0000
  322.7832      96.0000      99.2382       0.0397     114.5097       0.1763       3.8536       0.0000    2584.4189    1236.0000
  322.9356      96.0000      99.2544       0.0376     124.0193       0.1865       3.5628       0.0000    2587.9202    1216.0000
  323.0880      96.0000      99.4990       0.0314     133.3738       0.1889       3.7078       0.0000    2598.2551    1245.0000
  323.2404      96.0000      99.3683       0.0337     138.6079       0.1916       3.7366       0.0000    2594.3752    1224.0000
  323.3928      96.0000      99.4828       0.0438     136.7620       0.1925       3.8177       0.0000    2577.6621    1238.0000
  323.5452      96.0000      99.5590       0.0490     136.0546       0.1886       3.6611       0.0000    2569.1843    1222.0000
  323.6976      96.0000      99.3929       0.0505     126.2952       0.1773       3.4989       0.0000    2566.6355    1224.0000
  323.8500      96.0000      99.2382       0.0536     122.6032       0.1711       3.2081       0.0000    2561.5134    1245.0000
  324.0024      96.0000      99.3905       0.0506     118.6006       0.1657       3.0888       0.0000    2566.4993    1235.0000
  324.1548      96.0000      99.1643       0.0489     125.2477       0.1713       2.9557       0.0000    2569.2756    1208.0000
  324.3072      96.0000      99.2544       0.0511     131.4364       0.1752       3.0818       0.0000    2565.6672    1240.0000
  324.4596      96.0000      99.8009       0.0551     128.5916       0.1805       2.9925       0.0000    2559.0142    1246.0000
  324.6120      96.0000      99.1944       0.0558     130.4539       0.1855       3.1231       0.0000    2557.9275    1215.0000
  324.7644      96.0000      99.6679       0.0545     130.1975       0.1887       3.2003       0.0000    2560.0166    1228.0000
  324.9168      96.0000      99.4829       0.0458     142.5871       0.1884       3.4135       0.0000    2574.4487    1232.0000
  325.0692      96.0000      99.2544       0.0437     137.9558       0.1877       3.6682       0.0000    2577.8215    1224.0000
  325.2216      96.0000      99.2544       0.0497     121.5860       0.1838       3.7646       0.0000    2567.9890    1242.0000
  325.3740      96.0000      99.1620       0.0533      93.8598       0.1723       3.8331       0.0000    2561.9937    1223.0000
  325.5264      96.0000      99.2707       0.0491      75.7255       0.1615       3.6372       0.0000    2568.9736    1232.0000
  325.6788      96.0000      99.0259       0.0502      67.1674       0.1490       3.6024       0.0000    2567.1052    1231.0000
  325.8312      96.0000      99.0098       0.0502      73.3206       0.1435       3.6222       0.0000    2567.1062    1233.0000
  325.9836      96.0000      98.9657       0.0479      85.6363       0.1332       3.7244       0.0000    2571.0251    1239.0000
  326.1360      96.0000      98.6829       0.0356      90.1717       0.1233       3.8350       0.0000    2591.2642    1205.0000
  326.2884      96.0000      99.1182       0.0254      92.0396       0.1178       3.8516       0.0000    2608.1460    1239.0000
  326.4408      96.0000      99.0500       0.0206      83.7196       0.1141       3.8161       0.0000    2615.9595    1221.0000
  326.5932      96.0000      99.0260       0.0338      80.6430       0.1191       3.4839       0.0000    2594.2808    1232.0000
  326.7456      96.0000      98.4320       0.0439      76.9483       0.1292       3.2998       0.0000    2577.5042    1247.0000
  326.8980      96.0000      99.0500       0.0561      78.7804       0.1451       3.1800       0.0000    2557.4521    1238.0000
  327.0504      96.0000      99.0098       0.0610      85.8797       0.1527       3.2401       0.0000    2549.2734    1231.0000
  327.2028      96.0000      98.5926       0.0614      97.8593       0.1573       3.3417       0.0000    2548.6174    1257.0000
  327.3552      96.0000      98.8735       0.0609     109.0239       0.1575       3.4950       0.0000    2549.4360    1223.0000
  327.5076      96.0000      98.9938       0.0580     122.8790       0.1571       3.6542       0.0000    2554.3506    1233.0000
  327.6600      96.0000      98.9359       0.0512     123.8020       0.1545       3.7418       0.0000    2565.5293    1247.0000
  327.8124      96.0000      98.6608       0.0473     125.2516       0.1498       3.6303       0.0000    2571.8794    1222.0000
  327.9648      96.0000      99.0420       0.0477     119.7095       0.1467       3.5310       0.0000    2571.2820    1236.0000
  328.1172      96.0000      99.2544       0.0437     120.0463       0.1443       3.4032       0.0000    2577.8398    1264.0000
  328.2696      96.0000      98.9820       0.0428     113.2777       0.1465       3.3922       0.0000    2579.4294    1228.0000
  328.4220      96.0000      98.9657       0.0362     112.1393       0.1556       3.4784       0.0000    2590.2595    1260.0000
  328.5744      96.0000      99.2788       0.0332     110.5719       0.1619       3.5952       0.0000    2595.1714    1235.0000
  328.7268      96.0000      99.5427       0.0320     123.5299       0.1719       3.7369       0.0000    2597.1670    1244.0000
  328.8792      96.0000      99.9642       0.0267     126.7927       0.1825       3.9930       0.0000    2605.9785    1231.0000
  329.0316      96.0000      99.7710       0.0270     141.2102       0.1947       3.8191       0.0000    2605.4517    1231.0000
  329.1840      96.0000      99.2706       0.0230     138.4391       0.1961       3.5240       0.0000    2612.0273    1240.0000
  329.3364      96.0000      99.6216       0.0226     142.1311       0.1906       3.2070       0.0000    2612.7188    1244.0000
  329.4888      96.0000      99.4667       0.0256     131.1283       0.1896       3.0868       0.0000    2607.8201    1240.0000
  329.6412      96.0000      99.9150       0.0283     132.6324       0.1844       3.1779       0.0000    2603.3701    1268.0000
  329.7936      96.0000      99.3631       0.0363     128.0719       0.1777       3.1960       0.0000    2590.1428    1223.0000
  329.9460      96.0000      99.4828       0.0420     140.6954       0.1631       3.3950       0.0000    2580.6284    1243.0000
  330.0984      96.0000      99.5970       0.0418     137.8267       0.1609       3.5525       0.0000    2580.9675    1250.0000
  330.2508      96.0000      99.2544       0.0337     136.1166       0.1578       3.6624       0.0000    2594.4658    1219.0000
  330.4032      96.0000      99.5428       0.0201     117.9247       0.1481       3.7928       0.0000    2616.8604    1232.0000
  330.5556      96.0000      99.4828       0.0173     107.5894       0.1337       3.6495       0.0000    2621.5334    1244.0000
  330.7080      96.0000      99.4990       0.0111      96.9387       0.1222       3.8815       0.0000    2631.6172    1200.0000
  330.8604      96.0000      99.2544       0.0071      86.8325       0.1180       3.9632       0.0000    2638.2517    1261.0000
  331.0128      96.0000      99.4067       0.0050      78.8273       0.1101       3.9882       0.0000    2641.7891    1236.0000
  331.1652      96.0000      99.2706       0.0094      79.4427       0.1057       3.8134       0.0000    2634.5396    1230.0000
  331.3176      96.0000      99.3930       0.0101      82.1857       0.1070       3.6961       0.0000    2633.3557    1237.0000
  331.4700      96.0000      99.1782       0.0052      80.6280       0.1116       3.6971       0.0000    2641.4700    1242.0000
  331.6224      96.0000      99.0420       0.0067      88.9533       0.1198       3.7678       0.0000    2638.8625    1242.0000
  331.7748      96.0000      99.4828       0.0197      94.1628       0.1304       3.7224       0.0000    2617.5071    1242.0000
  331.9272      96.0000      99.2867       0.0313     106.8046       0.1450       3.6157       0.0000    2598.3755    1253.0000
  332.0796      96.0000      99.5725       0.0467     113.8624       0.1552       3.3385       0.0000    2573.0061    1246.0000
  332.2320      96.0000      99.4554       0.0569     125.2791       0.1668       3.1739       0.0000    2556.0479    1253.0000
  332.3844      96.0000      99.3904       0.0605     133.2505       0.1703       3.3311       0.0000    2550.1819    1247.0000
  332.5368      96.0000      99.4828       0.0619     129.5889       0.1671       3.3331       0.0000    2547.8328    1238.0000
  332.6892      96.0000      99.4070       0.0643     125.2683       0.1560       3.5014       0.0000    2543.8787    1232.0000
  332.8416      96.0000      99.2786       0.0663     124.9607       0.1550       3.2355       0.0000    2540.6577    1240.0000
  332.9940      96.0000      99.2868       0.0651     135.4290       0.1628       3.1591       0.0000    2542.5464    1256.0000
  333.1464      96.0000      99.5917       0.0656     149.5614       0.1747       3.1063       0.0000    2541.7488    1254.0000
  333.2988      96.0000      99.3686       0.0620     151.8068       0.1868       3.2482       0.0000    2547.6892    1242.0000
  333.4512      96.0000      99.7112       0.0532     147.8042       0.1930       3.4263       0.0000    2562.2493    1260.0000
  333.6036      96.0000      99.7112       0.0460     144.4200       0.1938       3.5633       0.0000    2574.0286    1250.0000
  333.7560      96.0000      99.7110       0.0460     144.3633       0.1958       3.5852       0.0000    2574.0247    1242.0000
  333.9084      96.0000      99.7112       0.0475     146.7895       0.1907       3.4489       0.0000    2571.5566    1259.0000
  334.0608      96.0000      99.3683       0.0472     145.2881       0.1883       3.2514       0.0000    2572.0945    1245.0000
  334.2132      96.0000      99.6515       0.0471     141.5468       0.1804       3.1858       0.0000    2572.2175    1239.0000
  334.3656      96.0000      99.3143       0.0475     136.6574       0.1813       3.3406       0.0000    2571.5876    1253.0000
  334.5180      96.0000      99.9396       0.0537     133.8515       0.1888       3.3782       0.0000    2561.3838    1258.0000
  334.6704      96.0000      99.6188       0.0603     140.6718       0.1927       3.3391       0.0000    2550.5747    1244.0000
  334.8228      96.0000      99.8008       0.0593     141.2876       0.2000       3.1455       0.0000    2552.1650    1257.0000
  334.9752      96.0000      99.5589       0.0543     141.2876       0.1972       3.1860       0.0000    2560.4641    1250.0000
  335.1276      96.0000      99.7112       0.0398     137.2393       0.1967       3.5097       0.0000    2584.2590    1243.0000
  335.2800      96.0000      99.6215       0.0334     137.8209       0.2042       3.6293       0.0000    2594.8125    1246.0000
  335.4324      96.0000      99.9560       0.0327     131.3901       0.2019       3.6755       0.0000    2596.0112    1259.0000
  335.5848      96.0000      99.6189       0.0365     130.7860       0.1953       3.4353       0.0000    2589.7017    1252.0000
  335.7372      96.0000      99.3688       0.0339     129.3723       0.1820       3.3251       0.0000    2594.0376    1254.0000
  335.8896      96.0000      99.6514       0.0337     130.6039       0.1671       3.1824       0.0000    2594.4526    1221.0000
  336.0420      96.0000      99.6351       0.0276     123.8353       0.1571       3.1197       0.0000    2604.3938    1254.0000
  336.1944      96.0000      99.2544       0.0241     112.0438       0.1412       3.2581       0.0000    2610.2942    1247.0000
  336.3468      96.0000      99.4392       0.0244     116.9355       0.1408       3.2774       0.0000    2609.7788    1239.0000
  336.4992      96.0000      99.7112       0.0214     120.3512       0.1485       3.3873       0.0000    2614.6860    1250.0000
  336.6516      96.0000      99.3468       0.0203     122.5374       0.1586       3.2590       0.0000    2616.5176    1254.0000
  336.8040      96.0000      99.7278       0.0224     109.9485       0.1688       3.4353       0.0000    2613.0151    1260.0000
  336.9564      96.0000      99.7356       0.0262     104.9945       0.1727       3.5212       0.0000    2606.6990    1246.0000
  337.1088      96.0000      99.4067       0.0294     114.2002       0.1727       3.5507       0.0000    2601.5249    1245.0000
  337.2612      96.0000      99.4829       0.0344     128.6712       0.1770       3.4061       0.0000    2593.1821    1250.0000
  337.4136      96.0000      99.9725       0.0483     139.7470       0.1795       3.2948       0.0000    2570.2588    1249.0000
  337.5660      96.0000      99.8471       0.0612     139.7470       0.1814       3.3064       0.0000    2548.9895    1271.0000
  337.7184      96.0000      99.3930       0.0671     136.3267       0.1791       3.1780       0.0000    2539.2888    1239.0000
  337.8708      96.0000      99.4993       0.0752     132.1097       0.1709       3.0672       0.0000    2525.9629    1251.0000
  338.0232      96.0000      99.8038       0.0787     131.1539       0.1712       2.9563       0.0000    2520.2197    1252.0000
  338.1756      96.0000      99.9149       0.0825     126.8769       0.1723       3.0585       0.0000    2513.8379    1250.0000
  338.3280      96.0000      99.7278       0.0797     128.0173       0.1803       3.0985       0.0000    2518.4277    1254.0000
  338.4804      96.0000      99.8258       0.0818     124.9263       0.1858       3.0775       0.0000    2515.0291    1261.0000
  338.6328      96.0000      99.7275       0.0718     129.2368       0.1895       3.0817       0.0000    2531.5642    1246.0000
  338.7852      96.0000      99.9396       0.0631     118.4687       0.1979       3.1474       0.0000    2545.8840    1261.0000
  338.9376      96.0000      99.5317       0.0532     123.4391       0.2073       3.3648       0.0000    2562.1462    1263.0000
  339.0900      96.0000      99.4229       0.0481     124.3286       0.2162       3.2941       0.0000    2570.6526    1256.0000
  339.2424      96.0000      99.5970       0.0375     139.4286       0.2124       3.3457       0.0000    2588.1682    1250.0000
  339.3948      96.0000      99.7874       0.0358     138.1970       0.2075       3.3200       0.0000    2590.8884    1249.0000
  339.5472      96.0000      99.6351       0.0413     145.2733       0.2021       3.2852       0.0000    2581.7759    1247.0000
  339.6996      96.0000      99.5970       0.0516     136.9725       0.1990       3.1923       0.0000    2564.8376    1252.0000
  339.8520      96.0000      99.6676       0.0666     131.7097       0.1882       3.0091       0.0000    2540.1221    1261.0000
  340.0044      96.0000      99.8636       0.0718     119.4335       0.1832       2.9051       0.0000    2531.5872    1244.0000
  340.1568      96.0000      99.7358       0.0751     123.7100       0.1838       2.8471       0.0000    2526.1226    1245.0000
  340.3092      96.0000      99.4067       0.0679     127.6281       0.1860       3.0510       0.0000    2537.9714    1251.0000
  340.4616      96.0000      99.8254       0.0663     143.0227       0.1792       3.1352       0.0000    2540.5964    1215.0000
  340.6140      96.0000      99.6515       0.0734     144.8687       0.1662       3.0944       0.0000    2528.9661    1249.0000
  340.7664      96.0000      99.3306       0.0724     143.1345       0.1547       3.0309       0.0000    2530.5137    1229.0000
  340.9188      96.0000      98.9117       0.0643     119.4028       0.1410       3.1034       0.0000    2543.9578    1235.0000
  341.0712      96.0000      98.9818       0.0460      99.1172       0.1302       3.2086       0.0000    2574.0251    1250.0000
  341.2236      96.0000      98.2032       0.0382      87.4889       0.1203       3.1233       0.0000    2586.9807    1244.0000
  341.3760      96.0000      98.7070       0.0350      82.5866       0.1139       3.1644       0.0000    2592.2480    1256.0000
  341.5284      96.0000      98.4639       0.0362      87.4891       0.1085       3.1138       0.0000    2590.3044    1231.0000
  341.6808      96.0000      98.8875       0.0350      96.6543       0.1064       3.1675       0.0000    2592.2908    1258.0000
  341.8332      96.0000      98.5242       0.0346     103.0949       0.1055       3.1640       0.0000    2592.9417    1263.0000
  341.9856      96.0000      98.5688       0.0308     105.9495       0.1044       3.2802       0.0000    2599.2346    1236.0000
  342.1380      96.0000      98.7068       0.0292     103.1785       0.1021       3.4121       0.0000    2601.8484    1254.0000
  342.2904      96.0000      98.4161       0.0201      99.1789       0.0991       3.6434       0.0000    2616.8396    1260.0000
  342.4428      96.0000      98.5448       0.0176      93.8849       0.0937       3.7102       0.0000    2620.8953    1261.0000
  342.5952      96.0000      98.4161       0.0127      87.3977       0.0872       3.8331       0.0000    2629.1008    1252.0000
  342.7476      96.0000      98.7532       0.0120      88.3436       0.0853       3.5888       0.0000    2630.1414    1268.0000
  342.9000      96.0000      98.9357       0.0158      94.6636       0.0862       3.6282       0.0000    2623.9675    1253.0000
  343.0524      96.0000      98.7210       0.0152     101.1244       0.0912       3.4869       0.0000    2624.8684    1244.0000
  343.2048      96.0000      98.6006       0.0200     103.8955       0.0942       3.6173       0.0000    2617.0630    1251.0000
  343.3572      96.0000      98.5689       0.0142      99.7072       0.0997       3.6319       0.0000    2626.5439    1253.0000
  343.5096      96.0000      99.0418       0.0079      92.9599       0.1037       3.6047       0.0000    2636.9148    1266.0000
  343.6620      96.0000      99.1401       0.0026      96.9345       0.1088       3.6016       0.0000    2645.6865    1257.0000
  343.8144      96.0000      99.0260       0.0067     101.5765       0.1174       3.6523       0.0000    2639.0220    1253.0000
  343.9668      96.0000      99.1344       0.0085     111.8661       0.1264       3.8449       0.0000    2635.9529    1257.0000
  344.1192      96.0000      99.2788       0.0125     110.9703       0.1346       3.8682       0.0000    2629.3799    1258.0000
  344.2716      96.0000      99.4231       0.0162     116.4812       0.1408       3.8833       0.0000    2623.2495    1254.0000
  344.4240      96.0000      99.1944       0.0169     123.4336       0.1505       3.8530       0.0000    2622.1907    1257.0000
  344.5764      96.0000      99.9642       0.0070     132.2485       0.1607       3.7911       0.0000    2638.4993    1245.0000
  344.7288      96.0000      99.2545       0.0043     134.4021       0.1638       3.6485       0.0000    2642.8232    1251.0000
  344.8812      96.0000      99.6460       0.0029     130.3995       0.1606       3.7431       0.0000    2645.1721    1258.0000
  345.0336      96.0000      99.7710       0.0150     122.7880       0.1567       3.8044       0.0000    2625.3000    1242.0000
  345.1860      96.0000      99.6514       0.0140     122.5129       0.1566       3.6468       0.0000    2626.9487    1261.0000
  345.3384      96.0000      99.7113       0.0273     125.5583       0.1605       3.5578       0.0000    2604.9185    1261.0000
  345.4908      96.0000      99.7275       0.0265     131.4598       0.1667       3.5005       0.0000    2606.3464    1265.0000
  345.6432      96.0000     100.0154       0.0244     129.9203       0.1733       3.6771       0.0000    2609.7656    1239.0000
  345.7956      96.0000     100.0537       0.0235     122.8441       0.1835       3.5906       0.0000    2611.2542    1273.0000
  345.9480      96.0000     100.3364       0.0247     117.5866       0.1854       3.4269       0.0000    2609.2578    1251.0000
  346.1004      96.0000     100.1678       0.0285     120.6318       0.1879       3.2618       0.0000    2602.9619    1263.0000
  346.2528      96.0000      99.8471       0.0369     123.4310       0.1843       3.3473       0.0000    2589.0852    1263.0000
  346.4052      96.0000     100.3200       0.0333     126.9784       0.1931       3.2866       0.0000    2595.1147    1240.0000
  346.5576      96.0000      99.9149       0.0390     122.6712       0.1973       3.4502       0.0000    2585.7034    1249.0000
  346.7100      96.0000     100.2442       0.0287     126.3659       0.1998       3.3825       0.0000    2602.5991    1243.0000
  346.8624      96.0000      99.8008       0.0301     130.7890       0.1975       3.5547       0.0000    2600.4021    1238.0000
  347.0148      96.0000     100.1844       0.0250     135.6660       0.1935       3.3114       0.0000    2608.7271    1263.0000
  347.1672      96.0000     100.1082       0.0340     128.8923       0.1830       3.3268       0.0000    2593.9182    1251.0000
  347.3196      96.0000      99.7603       0.0332     122.7391       0.1693       3.4682       0.0000    2595.1763    1254.0000
  347.4720      96.0000      99.7710       0.0303     116.6315       0.1599       3.7219       0.0000    2599.9336    1267.0000
  347.6244      96.0000      99.8634       0.0290     120.0183       0.1548       3.6640       0.0000    2602.1414    1267.0000
  347.7768      96.0000      99.8746       0.0304     121.5566       0.1591       3.4629       0.0000    2599.7773    1263.0000
  347.9292      96.0000      99.8202       0.0334     128.6903       0.1629       3.3879       0.0000    2594.9380    1259.0000
  348.0816      96.0000      99.9642       0.0334     130.5376       0.1709       3.2960       0.0000    2594.8337    1249.0000
  348.2340      96.0000      99.6679       0.0411     128.3840       0.1716       3.4161       0.0000    2582.2383    1254.0000
  348.3864      96.0000      99.6949       0.0406     123.4352       0.1696       3.3309       0.0000    2583.0500    1258.0000
  348.5388      96.0000      99.4173       0.0431     131.0948       0.1728       3.4302       0.0000    2578.8892    1254.0000
  348.6912      96.0000      99.4667       0.0391     132.9717       0.1784       3.3057       0.0000    2585.5237    1260.0000
  348.8436      96.0000      99.2544       0.0437     134.8425       0.1837       3.2062       0.0000    2577.9312    1256.0000
  348.9960      96.0000      99.5916       0.0399     131.4582       0.1780       3.1593       0.0000    2584.1831    1265.0000
  349.1484      96.0000      99.5155       0.0422     139.1555       0.1722       3.1189       0.0000    2580.3799    1256.0000
  349.3008      96.0000      98.9360       0.0431     140.6379       0.1705       3.3090       0.0000    2578.8523    1264.0000
  349.4532      96.0000      98.8894       0.0506     135.1309       0.1674       3.1884       0.0000    2566.5867    1257.0000
  349.6056      96.0000      98.7209       0.0579     132.9406       0.1665       3.1763       0.0000    2554.3975    1250.0000
  349.7580      96.0000      98.7069       0.0661     132.9743       0.1621       3.1463       0.0000    2540.9270    1274.0000
  349.9104      96.0000      99.1343       0.0626     133.4428       0.1623       3.2125       0.0000    2546.6985    1249.0000
  350.0628      96.0000      99.0259       0.0607     132.2121       0.1539       3.2096       0.0000    2549.9128    1261.0000
  350.2152      96.0000      99.1181       0.0521     130.0248       0.1485       3.2607       0.0000    2563.9963    1266.0000
  350.3676      96.0000      99.0420       0.0432     125.2458       0.1496       3.3950       0.0000    2578.7307    1249.0000
  350.5200      96.0000      98.6829       0.0346     121.7800       0.1455       3.6010       0.0000    2592.8396    1268.0000
  350.6724      96.0000      99.2545       0.0331     125.7796       0.1519       3.4814       0.0000    2595.3735    1254.0000
  350.8248      96.0000      99.1181       0.0418     134.4006       0.1615       3.3500       0.0000    2580.9856    1246.0000
  350.9772      96.0000      98.9116       0.0462     136.6357       0.1754       3.1184       0.0000    2573.7808    1264.0000
  351.1296      96.0000      99.2106       0.0493     135.7471       0.1783       3.2167       0.0000    2568.6506    1257.0000
  351.2820      96.0000      99.4827       0.0451     133.6152       0.1720       3.2202       0.0000    2575.6482    1278.0000
  351.4344      96.0000      99.4229       0.0366     130.2310       0.1668       3.4398       0.0000    2589.5652    1264.0000
  351.5868      96.0000      99.8470       0.0327     120.6863       0.1640       3.4803       0.0000    2596.1099    1260.0000
  351.7392      96.0000      99.8251       0.0358     121.8611       0.1673       3.4421       0.0000    2590.9275    1258.0000
  351.8916      96.0000      99.5589       0.0401     123.1234       0.1692       3.3494       0.0000    2583.8379    1264.0000
  352.0440      96.0000     100.2173       0.0340     132.3260       0.1731       3.1939       0.0000    2593.8501    1259.0000
  352.1964      96.0000      99.7277       0.0238     136.9778       0.1742       3.3119       0.0000    2610.7859    1256.0000
  352.3488      96.0000      99.4667       0.0263     143.3630       0.1843       3.2724       0.0000    2606.6340    1281.0000
  352.5012      96.0000      99.7110       0.0276     143.6706       0.1877       3.3386       0.0000    2604.4280    1242.0000
  352.6536      96.0000      99.8365       0.0256     136.8970       0.1864       3.3661       0.0000    2607.7466    1267.0000
  352.8060      96.0000      99.4067       0.0218     133.8645       0.1820       3.4072       0.0000    2614.0754    1274.0000
  352.9584      96.0000      99.9151       0.0228     132.8272       0.1836       3.3420       0.0000    2612.3809    1251.0000
  353.1108      96.0000      99.7439       0.0312     131.2877       0.1794       3.2186       0.0000    2598.4468    1266.0000
  353.2632      96.0000      99.6514       0.0303     132.2107       0.1793       3.3418       0.0000    2599.9512    1264.0000
  353.4156      96.0000      99.7112       0.0309     135.4377       0.1745       3.4903       0.0000    2599.0056    1246.0000
  353.5680      96.0000     100.2273       0.0261     135.7146       0.1830       3.6819       0.0000    2606.9812    1249.0000
  353.7204      96.0000      99.5727       0.0327     136.3653       0.1822       3.6481       0.0000    2596.0977    1266.0000
  353.8728      96.0000      99.4067       0.0350     125.9246       0.1811       3.4567       0.0000    2592.3005    1253.0000
  354.0252      96.0000      99.6513       0.0396     127.1871       0.1705       3.3549       0.0000    2584.6887    1261.0000
  354.1776      96.0000      99.3444       0.0375     126.2288       0.1572       3.2322       0.0000    2588.0898    1263.0000
  354.3300      96.0000      99.8962       0.0373     135.4379       0.1455       3.2077       0.0000    2588.4690    1256.0000
  354.4824      96.0000      99.5071       0.0373     138.7903       0.1442       3.0510       0.0000    2588.3813    1265.0000
  354.6348      96.0000      99.4990       0.0392     140.0565       0.1525       3.1010       0.0000    2585.4006    1264.0000
  354.7872      96.0000      99.5426       0.0297     137.7191       0.1654       3.3095       0.0000    2600.9768    1273.0000
  354.9396      96.0000      99.4828       0.0264     144.4877       0.1750       3.9499       0.0000    2606.5173    1252.0000
  355.0920      96.0000      99.5588       0.0153     147.2587       0.1855       4.0676       0.0000    2624.6833    1256.0000
  355.2444      96.0000      99.6514       0.0196     147.7150       0.1898       3.8733       0.0000    2617.5918    1256.0000
  355.3968      96.0000      99.7356       0.0193     138.5411       0.1851       3.3721       0.0000    2618.2246    1245.0000
  355.5492      96.0000      99.4229       0.0255     128.9964       0.1775       3.1711       0.0000    2607.9934    1260.0000
  355.7016      96.0000      99.9396       0.0311     132.0731       0.1684       3.1881       0.0000    2598.6978    1261.0000
  355.8540      96.0000      99.3144       0.0324     132.3576       0.1615       3.2578       0.0000    2596.4937    1250.0000
  356.0064      96.0000      99.0582       0.0333     134.1731       0.1535       3.3068       0.0000    2595.0073    1251.0000
  356.1588      96.0000      99.3686       0.0351     126.8197       0.1596       3.2736       0.0000    2592.0232    1263.0000
  356.3112      96.0000      99.1184       0.0389     120.7209       0.1647       3.0972       0.0000    2585.8350    1245.0000
  356.4636      96.0000      99.0500       0.0359     116.4136       0.1732       3.0187       0.0000    2590.7454    1271.0000
  356.6160      96.0000      99.1943       0.0368     122.2287       0.1668       3.0871       0.0000    2589.2793    1250.0000
  356.7684      96.0000      99.1781       0.0414     133.2538       0.1715       3.2674       0.0000    2581.6565    1258.0000
  356.9208      96.0000      99.0501       0.0448     141.8683       0.1673       3.2711       0.0000    2576.0508    1250.0000
  357.0732      96.0000      99.2383       0.0416     140.6716       0.1643       3.2508       0.0000    2581.3313    1243.0000
  357.2256      96.0000      99.2704       0.0428     131.3566       0.1577       3.0722       0.0000    2579.4602    1264.0000
  357.3780      96.0000      99.0259       0.0404     134.4332       0.1539       3.2577       0.0000    2583.2725    1233.0000
  357.5304      96.0000      99.1182       0.0406     133.8174       0.1523       3.2329       0.0000    2583.0918    1263.0000
  357.6828      96.0000      99.1644       0.0419     140.0193       0.1518       3.3922       0.0000    2580.8582    1243.0000
  357.8352      96.0000      98.8453       0.0427     132.0515       0.1500       3.3113       0.0000    2579.4697    1244.0000
  357.9876      96.0000      98.8895       0.0489     134.6055       0.1496       3.4146       0.0000    2569.3809    1265.0000
  358.1400      96.0000      99.0259       0.0538     129.6829       0.1478       3.4716       0.0000    2561.2517    1237.0000
  358.2924      96.0000      99.1019       0.0599     121.9856       0.1474       3.3317       0.0000    2551.1997    1252.0000
  358.4448      96.0000      98.4319       0.0643     119.0905       0.1450       3.2769       0.0000    2543.8567    1250.0000
  358.5972      96.0000      98.4781       0.0689     116.3500       0.1425       3.2203       0.0000    2536.3308    1250.0000
  358.7496      96.0000      98.5402       0.0656     122.7852       0.1416       3.4421       0.0000    2541.7815    1261.0000
  358.9020      96.0000      98.7973       0.0610     122.2602       0.1426       3.6422       0.0000    2549.3286    1254.0000
  359.0544      96.0000      98.4321       0.0550     128.1101       0.1450       3.7445       0.0000    2559.2991    1250.0000
  359.2068      96.0000      98.7371       0.0536     121.3416       0.1464       3.5246       0.0000    2561.6335    1261.0000
  359.3592      96.0000      98.4303       0.0577     111.4315       0.1472       3.2343       0.0000    2554.7708    1244.0000
  359.5116      96.0000      98.2637       0.0602     102.1689       0.1441       3.2124       0.0000    2550.6689    1249.0000
  359.6640      96.0000      98.7069       0.0655     103.7338       0.1427       3.1627       0.0000    2541.8787    1271.0000
  359.8164      96.0000      98.4925       0.0638     107.4003       0.1397       3.1356       0.0000    2544.7087    1236.0000
  359.9688      96.0000      98.6768       0.0696     109.8893       0.1412       2.9699       0.0000    2535.1323    1274.0000
  360.1212      96.0000      98.2493       0.0674     110.7053       0.1378       2.9991       0.0000    2538.7998    1260.0000
  360.2736      96.0000      98.2953       0.0657     103.6520       0.1363       3.1022       0.0000    2541.5474    1257.0000
  360.4260      96.0000      98.2794       0.0661     100.5477       0.1291       3.1139       0.0000    2540.9341    1268.0000
  360.5784      96.0000      98.6829       0.0627     104.6820       0.1302       3.1646       0.0000    2546.4658    1247.0000
  360.7308      96.0000      98.4319       0.0588     100.9873       0.1251       2.9870       0.0000    2553.0151    1271.0000
  360.8832      96.0000      98.3559       0.0517      97.6031       0.1206       3.0460       0.0000    2564.7175    1266.0000
  361.0356      96.0000      98.5686       0.0495      84.6475       0.1124       3.0408       0.0000    2568.2986    1266.0000
  361.1880      96.0000      98.4323       0.0468      85.8581       0.1134       3.1171       0.0000    2572.8574    1259.0000
  361.3404      96.0000      98.5686       0.0465      83.4178       0.1136       3.1578       0.0000    2573.3394    1256.0000
  361.4928      96.0000      98.4161       0.0494      87.7045       0.1143       3.2735       0.0000    2568.4480    1271.0000
  361.6452      96.0000      98.4480       0.0484      98.8096       0.1183       3.5150       0.0000    2570.1135    1263.0000
  361.7976      96.0000      98.3638       0.0525     109.8644       0.1270       3.5558       0.0000    2563.4475    1275.0000
  361.9500      96.0000      98.8736       0.0591     119.4328       0.1324       3.4795       0.0000    2552.5498    1257.0000
  362.1024      96.0000      98.8454       0.0644     124.5339       0.1349       3.3524       0.0000    2543.7793    1254.0000
  362.2548      96.0000      98.7210       0.0587     118.6884       0.1444       3.3067       0.0000    2553.1694    1260.0000
  362.4072      96.0000      98.7370       0.0478     119.3041       0.1506       3.3851       0.0000    2571.1440    1268.0000
  362.5596      96.0000      99.1642       0.0288     113.0646       0.1588       3.4666       0.0000    2602.4932    1259.0000
  362.7120      96.0000      99.5752       0.0204     126.6017       0.1662       3.5787       0.0000    2616.3093    1268.0000
  362.8644      96.0000      99.7276       0.0177     132.7596       0.1892       3.5822       0.0000    2620.7168    1254.0000
  363.0168      96.0000      99.9396       0.0245     142.3563       0.2073       3.5609       0.0000    2609.5850    1271.0000
  363.1692      96.0000     100.3364       0.0230     144.8545       0.2179       3.6736       0.0000    2612.1226    1251.0000
  363.3216      96.0000     100.3067       0.0205     139.5883       0.2193       3.7647       0.0000    2616.1929    1272.0000
  363.4740      96.0000     100.8521       0.0168     136.6720       0.2223       3.6903       0.0000    2622.3135    1265.0000
  363.6264      96.0000     101.0210       0.0166     135.5935       0.2231       3.5032       0.0000    2622.5493    1260.0000
  363.7788      96.0000     101.1942       0.0176     137.9020       0.2194       3.4050       0.0000    2620.9736    1267.0000
  363.9312      96.0000     101.3418       0.0218     142.4834       0.2205       3.5543       0.0000    2614.0090    1259.0000
  364.0836      96.0000     101.3081       0.0236     143.2541       0.2240       3.5757       0.0000    2611.0322    1263.0000
  364.2360      96.0000     100.9282       0.0181     156.3286       0.2289       3.6312       0.0000    2620.0930    1259.0000
  364.3884      96.0000     101.1562       0.0148     163.7125       0.2316       3.5548       0.0000    2625.6155    1256.0000
  364.5408      96.0000     100.5352       0.0180     159.4020       0.2277       3.5614       0.0000    2620.3770    1249.0000
  364.6932      96.0000     100.3034       0.0222     147.4378       0.2241       3.6166       0.0000    2613.3562    1245.0000
  364.8456      96.0000     100.5053       0.0256     144.9765       0.2087       3.3834       0.0000    2607.7783    1250.0000
  364.9980      96.0000     100.0781       0.0323     156.6764       0.2016       3.2985       0.0000    2596.7212    1249.0000
  365.1504      96.0000      99.9562       0.0337     150.1809       0.1861       3.1812       0.0000    2594.4170    1254.0000
  365.3028      96.0000      99.9641       0.0361     141.2927       0.1765       3.3732       0.0000    2590.3894    1238.0000
  365.4552      96.0000      99.9559       0.0418     124.6367       0.1686       3.3404       0.0000    2581.0840    1264.0000
  365.6076      96.0000      99.2981       0.0496     130.2086       0.1685       3.2517       0.0000    2568.1902    1245.0000
  365.7600      96.0000      99.5970       0.0614     127.7133       0.1634       3.1777       0.0000    2548.6870    1240.0000
  365.9124      96.0000      99.2105       0.0684     130.5141       0.1534       3.2704       0.0000    2537.1335    1270.0000
  366.0648      96.0000      98.8212       0.0720     127.0959       0.1456       3.4001       0.0000    2531.1196    1242.0000
  366.2172      96.0000      98.3557       0.0663     116.9676       0.1379       3.3213       0.0000    2540.6633    1257.0000
  366.3696      96.0000      98.2953       0.0648     100.0144       0.1264       3.1824       0.0000    2543.0981    1247.0000
  366.5220      96.0000      98.3637       0.0543      92.3485       0.1151       3.0349       0.0000    2560.3892    1249.0000
  366.6744      96.0000      98.1873       0.0427      95.2425       0.1063       3.2749       0.0000    2579.6069    1256.0000
  366.8268      96.0000      98.3401       0.0245     100.8301       0.1014       3.6198       0.0000    2609.5066    1254.0000
  366.9792      96.0000      98.3638       0.0140     104.9824       0.0986       3.7589       0.0000    2626.8301    1266.0000
  367.1316      96.0000      98.7051       0.0083     106.0635       0.1039       3.6473       0.0000    2636.3325    1256.0000
  367.2840      96.0000      98.8213       0.0138     107.8844       0.1114       3.6160       0.0000    2627.2539    1275.0000
  367.4364      96.0000      98.5402       0.0231     104.6295       0.1199       3.8253       0.0000    2611.8704    1254.0000
  367.5888      96.0000      98.7372       0.0404     103.7333       0.1269       3.7706       0.0000    2583.3589    1285.0000
  367.7412      96.0000      98.7734       0.0476     102.7856       0.1365       3.5038       0.0000    2571.3801    1260.0000
  367.8936      96.0000      98.8894       0.0515      99.1172       0.1439       3.3052       0.0000    2564.9858    1253.0000
  368.0460      96.0000      98.5846       0.0503     103.7054       0.1489       3.3538       0.0000    2567.0322    1282.0000
  368.1984      96.0000      98.9357       0.0496     108.3478       0.1461       3.3809       0.0000    2568.2249    1243.0000
  368.3508      96.0000      98.4924       0.0462     108.0166       0.1402       3.3940       0.0000    2573.8245    1282.0000
  368.5032      96.0000      98.9116       0.0420     108.0468       0.1354       3.2978       0.0000    2580.7402    1272.0000
  368.6556      96.0000      99.0097       0.0438     108.6347       0.1354       3.2100       0.0000    2577.8101    1243.0000
  368.8080      96.0000      99.0580       0.0405     119.4342       0.1381       3.2904       0.0000    2583.1328    1281.0000
  368.9604      96.0000      98.5689       0.0377     115.0967       0.1361       3.2358       0.0000    2587.8540    1246.0000
  369.1128      96.0000      98.5244       0.0397     111.7378       0.1343       3.2720       0.0000    2584.5437    1267.0000
  369.2652      96.0000      98.3636       0.0436      93.2468       0.1337       3.1858       0.0000    2578.0066    1274.0000
  369.4176      96.0000      98.7530       0.0432      86.5001       0.1349       3.2751       0.0000    2578.7878    1252.0000
  369.5700      96.0000      98.7532       0.0348      93.1984       0.1402       3.4079       0.0000    2592.6533    1258.0000
  369.7224      96.0000      98.7070       0.0267     113.8117       0.1513       3.4420       0.0000    2605.9275    1268.0000
  369.8748      96.0000      98.9057       0.0261     129.8221       0.1683       3.5072       0.0000    2606.9746    1264.0000
  370.0272      96.0000      99.4067       0.0255     131.6658       0.1730       3.3515       0.0000    2607.9631    1271.0000
  370.1796      96.0000      99.1160       0.0265     129.3557       0.1662       3.3506       0.0000    2606.3372    1261.0000
  370.3320      96.0000      99.4067       0.0275     127.4758       0.1498       3.2286       0.0000    2604.6819    1277.0000
  370.4844      96.0000      98.9598       0.0314     122.6285       0.1417       3.2634       0.0000    2598.2527    1277.0000
  370.6368      96.0000      98.7976       0.0346     108.6326       0.1380       3.2110       0.0000    2592.8616    1251.0000
  370.7892      96.0000      99.0419       0.0362     102.8152       0.1394       3.2532       0.0000    2590.2720    1264.0000
  370.9416      96.0000      99.0259       0.0370     109.8632       0.1496       3.2926       0.0000    2588.9243    1257.0000
  371.0940      96.0000      99.3305       0.0374     137.2864       0.1647       3.4116       0.0000    2588.2747    1260.0000
  371.2464      96.0000      99.1401       0.0412     154.4873       0.1813       3.4038       0.0000    2581.9912    1266.0000
  371.3988      96.0000      99.2544       0.0419     169.6074       0.1882       3.3868       0.0000    2580.9031    1273.0000
  371.5512      96.0000      99.1181       0.0417     166.4895       0.1843       3.4007       0.0000    2581.1172    1270.0000
  371.7036      96.0000      99.5072       0.0338     160.3727       0.1827       3.3318       0.0000    2594.1531    1258.0000
  371.8560      96.0000      99.3144       0.0296     145.2526       0.1711       3.3260       0.0000    2601.1787    1268.0000
  372.0084      96.0000      99.4229       0.0261     128.3575       0.1618       3.1483       0.0000    2606.9092    1256.0000
  372.1608      96.0000      99.5970       0.0253     124.9707       0.1505       3.2505       0.0000    2608.2122    1271.0000
  372.3132      96.0000      99.4666       0.0213     125.5860       0.1442       3.2963       0.0000    2614.8967    1275.0000
  372.4656      96.0000      99.1782       0.0205     132.6675       0.1480       3.4282       0.0000    2616.1245    1268.0000
  372.6180      96.0000      99.2301       0.0251     135.4026       0.1502       3.3463       0.0000    2608.5771    1274.0000
  372.7704      96.0000      99.2982       0.0227     124.0191       0.1589       3.3362       0.0000    2612.4929    1261.0000
  372.9228      96.0000      99.3686       0.0219     117.3927       0.1603       3.0560       0.0000    2613.9475    1263.0000
  373.0752      96.0000      99.4828       0.0151     108.4705       0.1618       3.0703       0.0000    2625.0967    1280.0000
  373.2276      96.0000      99.2544       0.0123     115.6698       0.1643       2.9936       0.0000    2629.6780    1244.0000
  373.3800      96.0000      99.2544       0.0104     124.4182       0.1687       3.2120       0.0000    2632.8235    1257.0000
  373.5324      96.0000      99.5754       0.0135     130.9786       0.1694       3.2730       0.0000    2627.7542    1264.0000
  373.6848      96.0000      99.5970       0.0162     135.4704       0.1709       3.4376       0.0000    2623.2776    1266.0000
  373.8372      96.0000      99.1783       0.0233     136.7352       0.1740       3.4588       0.0000    2611.5867    1260.0000
  373.9896      96.0000      99.0419       0.0288     134.4821       0.1734       3.4867       0.0000    2602.5466    1268.0000
  374.1420      96.0000      99.3441       0.0280     133.2847       0.1680       3.3120       0.0000    2603.8643    1251.0000
  374.2944      96.0000      99.5916       0.0260     137.2502       0.1572       3.4025       0.0000    2607.1013    1257.0000
  374.4468      96.0000      99.4231       0.0314     135.7432       0.1512       3.5519       0.0000    2598.1379    1265.0000
  374.5992      96.0000      99.5074       0.0397     127.4032       0.1443       3.8704       0.0000    2584.4167    1249.0000
  374.7516      96.0000      99.2545       0.0426     108.3510       0.1424       3.8086       0.0000    2579.6409    1277.0000
  374.9040      96.0000      99.0420       0.0467     113.8575       0.1400       3.7221       0.0000    2572.9348    1253.0000
  375.0564      96.0000      99.3688       0.0421     115.4240       0.1518       3.5739       0.0000    2580.5474    1264.0000
  375.2088      96.0000      99.3467       0.0412     129.5536       0.1618       3.5438       0.0000    2581.9790    1253.0000
  375.3612      96.0000      99.4991       0.0318     122.5076       0.1750       3.5058       0.0000    2597.5012    1254.0000
  375.5136      96.0000      99.6869       0.0200     134.4782       0.1783       3.5720       0.0000    2617.0444    1274.0000
  375.6660      96.0000      99.1783       0.0181     140.9774       0.1835       3.4680       0.0000    2620.1372    1231.0000
  375.8184      96.0000      99.4229       0.0197     154.7919       0.1861       3.4068       0.0000    2617.4539    1249.0000
  375.9708      96.0000      99.9396       0.0268     155.1370       0.1829       3.1957       0.0000    2605.8384    1257.0000
  376.1232      96.0000      99.4990       0.0296     150.7914       0.1825       3.1939       0.0000    2601.2322    1256.0000
  376.2756      96.0000      99.7711       0.0281     138.8243       0.1802       3.1529       0.0000    2603.6443    1258.0000
  376.4280      96.0000      99.8254       0.0251     138.1716       0.1785       3.2959       0.0000    2608.5916    1246.0000
  376.5804      96.0000      99.4665       0.0290     141.4855       0.1780       3.2195       0.0000    2602.0737    1256.0000
  376.7328      96.0000      99.6515       0.0290     144.2566       0.1794       3.1227       0.0000    2602.0869    1266.0000
  376.8852      96.0000      99.9642       0.0250     151.9481       0.1768       3.1479       0.0000    2608.8091    1271.0000
  377.0376      96.0000      99.4067       0.0287     151.4402       0.1719       3.4653       0.0000    2602.6863    1268.0000
  377.1900      96.0000      99.5590       0.0226     149.8682       0.1761       3.4999       0.0000    2612.6968    1265.0000
  377.3424      96.0000      99.4828       0.0232     140.6741       0.1800       3.3834       0.0000    2611.6428    1249.0000
  377.4948      96.0000      99.6351       0.0213     142.7906       0.1803       3.1917       0.0000    2614.8552    1265.0000
  377.6472      96.0000      99.2544       0.0343     146.8257       0.1783       3.5367       0.0000    2593.3237    1270.0000
  377.7996      96.0000      99.6516       0.0315     146.4823       0.1934       3.6038       0.0000    2598.0725    1267.0000
  377.9520      96.0000      99.5071       0.0290     143.1343       0.2029       3.6093       0.0000    2602.1204    1266.0000
  378.1044      96.0000      99.8799       0.0297     143.7140       0.2044       3.4251       0.0000    2601.0771    1264.0000
  378.2568      96.0000      99.4829       0.0259     148.9837       0.1984       3.4025       0.0000    2607.2207    1257.0000
  378.4092      96.0000      99.2787       0.0277     153.2548       0.1898       3.4875       0.0000    2604.3228    1266.0000
  378.5616      96.0000      99.2706       0.0230     151.1355       0.1799       3.4614       0.0000    2612.0703    1260.0000
  378.7140      96.0000      99.5426       0.0193     144.0199       0.1685       3.4487       0.0000    2618.1030    1273.0000
  378.8664      96.0000      99.6216       0.0166     127.7411       0.1628       3.4444       0.0000    2622.5288    1254.0000
  379.0188      96.0000      99.6948       0.0116     124.3224       0.1538       3.5241       0.0000    2630.7808    1266.0000
  379.1712      96.0000      99.7874       0.0136     122.2013       0.1578       3.5442       0.0000    2627.6089    1251.0000
  379.3236      96.0000      99.6217       0.0172     137.3474       0.1625       3.5476       0.0000    2621.6245    1270.0000
  379.4760      96.0000      99.6514       0.0245     143.7985       0.1746       3.4815       0.0000    2609.5415    1270.0000
  379.6284      96.0000      99.4665       0.0225     146.5350       0.1788       3.6655       0.0000    2612.8230    1247.0000
  379.7808      96.0000      99.5074       0.0266     150.4517       0.1855       3.6466       0.0000    2606.0542    1285.0000
  379.9332      96.0000      99.9991       0.0243     151.7297       0.1862       3.6055       0.0000    2609.9744    1263.0000
  380.0856      96.0000      99.7440       0.0286     154.2275       0.1831       3.6513       0.0000    2602.7651    1271.0000
  380.2380      96.0000      99.3686       0.0298     146.5208       0.1807       3.6026       0.0000    2600.8550    1275.0000
  380.3904      96.0000      99.4828       0.0285     148.0603       0.1843       3.7105       0.0000    2603.0256    1243.0000
  380.5428      96.0000      99.5753       0.0229     147.7162       0.1908       3.7452       0.0000    2612.2190    1280.0000
  380.6952      96.0000      99.9150       0.0141     142.5178       0.1919       3.9231       0.0000    2626.7639    1246.0000
  380.8476      96.0000      99.7872       0.0124     138.1718       0.1932       3.9959       0.0000    2629.6096    1268.0000
  381.0000      96.0000      99.8799       0.0064     140.6711       0.1921       3.8598       0.0000    2639.3628    1279.0000
  381.1524      96.0000      99.4585       0.0079     142.4852       0.1932       3.5842       0.0000    2636.9536    1239.0000
  381.3048      96.0000      99.6950       0.0069     140.0576       0.1882       3.4789       0.0000    2638.6436    1285.0000
  381.4572      96.0000      99.7874       0.0033     129.5591       0.1782       3.4789       0.0000    2644.4824    1246.0000
  381.6096      96.0000      99.5726       0.0028     123.4345       0.1677       3.6596       0.0000    2645.4597    1257.0000
  381.7620      96.0000      99.5589       0.0039     117.2476       0.1631       3.7759       0.0000    2643.5430    1233.0000
  381.9144      96.0000      99.8036       0.0070     108.6568       0.1586       3.9738       0.0000    2638.3677    1285.0000
  382.0668      96.0000      99.7872       0.0012     104.9363       0.1601       3.9836       0.0000    2647.9663    1250.0000
  382.2192      96.0000      99.8502       0.0027      97.8838       0.1631       3.9759       0.0000    2645.5693    1270.0000
  382.3716      96.0000      99.6514       0.0047     108.6282       0.1628       3.5239       0.0000    2642.2751    1260.0000
  382.5240      96.0000      99.5264       0.0139     121.7308       0.1694       3.4284       0.0000    2627.1096    1247.0000
  382.6764      96.0000      99.7112       0.0201     134.4801       0.1714       3.3077       0.0000    2616.8909    1260.0000
  382.8288      96.0000      99.7439       0.0240     130.8172       0.1762       3.4341       0.0000    2610.3423    1245.0000
  382.9812      96.0000      99.5589       0.0173     122.0219       0.1696       3.3213       0.0000    2621.4250    1256.0000
  383.1336      96.0000      99.8258       0.0241     121.5883       0.1674       3.1484       0.0000    2610.2075    1263.0000
  383.2860      96.0000      99.8962       0.0306     123.6401       0.1692       3.1068       0.0000    2599.4788    1253.0000
  383.4384      96.0000     100.0158       0.0298     132.5622       0.1772       3.1982       0.0000    2600.8740    1295.0000
  383.5908      96.0000      99.6216       0.0291     137.4885       0.1915       3.3043       0.0000    2602.0654    1253.0000
  383.7432      96.0000      99.6677       0.0310     150.7907       0.1955       3.4817       0.0000    2598.8860    1286.0000
  383.8956      96.0000      99.7112       0.0284     149.2870       0.2019       3.6418       0.0000    2603.1255    1277.0000
  384.0480      96.0000      99.7356       0.0272     156.0189       0.2067       3.6242       0.0000    2605.0388    1271.0000
  384.2004      96.0000      99.7277       0.0296     152.6727       0.2167       3.4221       0.0000    2601.2236    1272.0000
  384.3528      96.0000      99.7547       0.0345     166.1752       0.2127       3.3491       0.0000    2593.0166    1260.0000
  384.5052      96.0000      99.7359       0.0336     148.1103       0.1993       3.3292       0.0000    2594.6125    1280.0000
  384.6576      96.0000      99.5753       0.0328     149.6248       0.1965       3.3501       0.0000    2595.8538    1264.0000
  384.8100      96.0000      99.6189       0.0262     132.1197       0.1962       3.3145       0.0000    2606.6963    1268.0000
  384.9624      96.0000      99.5753       0.0185     136.0322       0.1959       3.3359       0.0000    2619.5481    1270.0000
  385.1148      96.0000      99.7359       0.0130     133.5940       0.1939       3.3559       0.0000    2628.4856    1271.0000
  385.2672      96.0000      99.7114       0.0151     134.1777       0.1895       3.3403       0.0000    2625.0591    1256.0000
  385.4196      96.0000      99.6785       0.0160     140.3667       0.1849       3.2561       0.0000    2623.6516    1266.0000
  385.5720      96.0000      99.9398       0.0138     134.7914       0.1734       3.3787       0.0000    2627.2656    1256.0000
  385.7244      96.0000      99.8035       0.0075     133.2840       0.1636       3.4595       0.0000    2637.6282    1256.0000
  385.8768      96.0000      99.4067       0.0080     129.8640       0.1527       3.7607       0.0000    2636.7949    1284.0000
  386.0292      96.0000      99.3930      -0.0036     119.4289       0.1388       3.8116       0.0000    2655.9282    1284.0000
  386.1816      96.0000     100.0320      -0.0101     100.6306       0.1319       4.2574       0.0000    2666.7119    1280.0000
  386.3340      96.0000      99.6515      -0.0150      87.1166       0.1287       4.1805       0.0000    2674.7717    1268.0000
  386.4864      96.0000      99.8253      -0.0026      90.7832       0.1363       4.0696       0.0000    2654.2830    1277.0000
  386.6388      96.0000      99.5266       0.0047     114.5077       0.1507       3.6061       0.0000    2642.2949    1272.0000
  386.7912      96.0000      99.4392       0.0134     123.0991       0.1683       3.5063       0.0000    2627.8643    1277.0000
  386.9436      96.0000     100.0783       0.0103     135.1351       0.1756       3.4094       0.0000    2633.0684    1261.0000
  387.0960      96.0000      99.5752       0.0210     146.0240       0.1856       3.4733       0.0000    2615.3711    1272.0000
  387.2484      96.0000      99.7112       0.0255     148.8246       0.1903       3.4819       0.0000    2607.9468    1259.0000
  387.4008      96.0000      99.8009       0.0301     144.4801       0.1999       3.4118       0.0000    2600.3206    1271.0000
  387.5532      96.0000     100.1514       0.0244     126.4804       0.1969       3.3613       0.0000    2609.6853    1266.0000
  387.7056      96.0000      99.9396       0.0225     125.2488       0.1937       3.4344       0.0000    2612.9075    1273.0000
  387.8580      96.0000      99.9642       0.0146     127.7101       0.1917       3.5461       0.0000    2625.9336    1260.0000
  388.0104      96.0000      99.9562       0.0126     128.0473       0.1903       3.5677       0.0000    2629.1765    1263.0000
  388.1628      96.0000      99.6950       0.0149     128.9396       0.1822       3.3887       0.0000    2625.3796    1270.0000
  388.3152      96.0000      99.4828       0.0180     127.7438       0.1768       3.4300       0.0000    2620.2622    1266.0000
  388.4676      96.0000      99.3306       0.0203     131.7139       0.1750       3.4355       0.0000    2616.5471    1274.0000
  388.6200      96.0000      99.5425       0.0179     136.6716       0.1739       3.5766       0.0000    2620.4048    1266.0000
  388.7724      96.0000      99.5970       0.0219     129.5605       0.1727       3.4699       0.0000    2613.8625    1273.0000
  388.9248      96.0000      99.7275       0.0215     130.5167       0.1691       3.3205       0.0000    2614.5269    1264.0000
  389.0772      96.0000      99.5589       0.0352     128.6694       0.1729       3.3011       0.0000    2591.9443    1260.0000
  389.2296      96.0000      99.3030       0.0362     131.7460       0.1694       3.2351       0.0000    2590.2671    1270.0000
  389.3820      96.0000      99.6351       0.0370     124.3289       0.1677       3.1881       0.0000    2588.9666    1245.0000
  389.5344      96.0000      99.5427       0.0386     122.4903       0.1672       3.1422       0.0000    2586.3770    1260.0000
  389.6868      96.0000      99.5970       0.0375     122.0661       0.1633       3.2992       0.0000    2588.0474    1265.0000
  389.8392      96.0000      99.5590       0.0398     122.1014       0.1598       3.3181       0.0000    2584.3203    1268.0000
  389.9916      96.0000      99.4828       0.0365     119.2913       0.1599       3.3574       0.0000    2589.8174    1271.0000
  390.1440      96.0000      99.5070       0.0422     119.1316       0.1695       3.2874       0.0000    2580.4187    1272.0000
  390.2964      96.0000      99.6348       0.0424     127.0955       0.1790       3.3860       0.0000    2579.9631    1275.0000
  390.4488      96.0000      99.2221       0.0468     124.3547       0.1824       3.3331       0.0000    2572.8220    1274.0000
  390.6012      96.0000      99.4992       0.0452     121.2467       0.1786       3.3262       0.0000    2575.3911    1279.0000
  390.7536      96.0000      99.2787       0.0424     114.1989       0.1655       3.4105       0.0000    2580.0471    1275.0000
  390.9060      96.0000      99.3468       0.0340     111.7094       0.1550       3.6103       0.0000    2593.8311    1279.0000
  391.0584      96.0000      99.5592       0.0280     104.9649       0.1472       3.8011       0.0000    2603.8438    1263.0000
  391.2108      96.0000      99.6216       0.0290     108.3208       0.1471       3.7953       0.0000    2602.1890    1281.0000
  391.3632      96.0000      99.5590       0.0277     111.1181       0.1496       3.5192       0.0000    2604.2300    1270.0000
  391.5156      96.0000      99.5430       0.0331     121.5546       0.1530       3.3874       0.0000    2595.3035    1275.0000
  391.6680      96.0000      99.8254       0.0380     115.1198       0.1575       3.3556       0.0000    2587.2952    1284.0000
  391.8204      96.0000      99.4828       0.0458     110.8213       0.1627       3.5746       0.0000    2574.4919    1270.0000
  391.9728      96.0000      99.1620       0.0385     104.3604       0.1668       3.5294       0.0000    2586.4114    1278.0000
  392.1252      96.0000      99.7112       0.0355     113.5971       0.1653       3.6249       0.0000    2591.4341    1268.0000
  392.2776      96.0000      99.6950       0.0272     122.1745       0.1637       3.5440       0.0000    2605.1680    1275.0000
  392.4300      96.0000      99.6189       0.0259     130.8225       0.1596       3.6307       0.0000    2607.3037    1268.0000
  392.5824      96.0000      99.4828       0.0242     126.7899       0.1567       3.4220       0.0000    2610.1335    1271.0000
  392.7348      96.0000      99.3306       0.0250     120.6637       0.1509       3.4020       0.0000    2608.6699    1270.0000
  392.8872      96.0000      99.4830       0.0207     114.4770       0.1513       3.2393       0.0000    2615.8972    1272.0000
  393.0396      96.0000      99.6351       0.0194     112.3518       0.1565       3.3524       0.0000    2618.0505    1272.0000
  393.1920      96.0000      99.1159       0.0224     109.8635       0.1628       3.2861       0.0000    2613.0896    1267.0000
  393.3444      96.0000      99.4992       0.0323     115.7423       0.1661       3.3950       0.0000    2596.7046    1261.0000
  393.4968      96.0000      99.6026       0.0366     124.3284       0.1652       3.2643       0.0000    2589.5935    1260.0000
  393.6492      96.0000      99.3444       0.0364     138.8245       0.1630       3.2631       0.0000    2589.8596    1277.0000
  393.8016      96.0000      99.7874       0.0341     133.8687       0.1645       3.2270       0.0000    2593.6733    1261.0000
  393.9540      96.0000      99.6215       0.0297     123.7431       0.1590       3.2760       0.0000    2600.9712    1268.0000
  394.1064      96.0000      99.6351       0.0219     104.0168       0.1573       3.2433       0.0000    2613.8291    1270.0000
  394.2588      96.0000      99.4828       0.0213     102.5068       0.1537       3.3556       0.0000    2614.8638    1266.0000
  394.4112      96.0000      99.1621       0.0245     101.4264       0.1631       3.3983       0.0000    2609.5627    1270.0000
  394.5636      96.0000      98.9117       0.0287     116.5018       0.1684       3.3814       0.0000    2602.6716    1271.0000
  394.7160      96.0000      99.5154       0.0234     116.1939       0.1728       3.3205       0.0000    2611.3477    1271.0000
  394.8684      96.0000      99.1182       0.0223     123.0111       0.1685       3.3252       0.0000    2613.1558    1267.0000
  395.0208      96.0000      99.4828       0.0166     123.2748       0.1667       3.4347       0.0000    2622.6487    1264.0000
  395.1732      96.0000      99.4068       0.0092     126.9695       0.1585       3.5436       0.0000    2634.8147    1267.0000
  395.3256      96.0000      99.5590       0.0005     122.4361       0.1542       3.5899       0.0000    2649.1848    1265.0000
  395.4780      96.0000      99.4824      -0.0026     110.4813       0.1409       3.6642       0.0000    2654.2329    1267.0000
  395.6304      96.0000      99.4230      -0.0031     103.3998       0.1348       3.6922       0.0000    2655.0469    1271.0000
  395.7828      96.0000      98.9659       0.0028     100.3491       0.1298       3.6354       0.0000    2645.3098    1270.0000
  395.9352      96.0000      99.1401       0.0015      94.1958       0.1358       3.6622       0.0000    2647.5029    1280.0000
  396.0876      96.0000      99.6515       0.0031     102.2010       0.1423       3.5355       0.0000    2644.8127    1272.0000
  396.2400      96.0000      99.2540       0.0189     109.2514       0.1452       3.4256       0.0000    2618.7371    1273.0000
  396.3924      96.0000      99.3686       0.0359     127.4362       0.1496       3.2391       0.0000    2590.7087    1274.0000
  396.5448      96.0000      99.2706       0.0440     123.4049       0.1602       3.2108       0.0000    2577.4045    1280.0000
  396.6972      96.0000      99.1782       0.0435     119.4053       0.1699       3.1694       0.0000    2578.2952    1272.0000
  396.8496      96.0000      99.1401       0.0422     111.0923       0.1723       3.1202       0.0000    2580.2917    1272.0000
  397.0020      96.0000      99.1180       0.0376     112.3525       0.1705       3.1106       0.0000    2587.9585    1277.0000
  397.1544      96.0000      99.1182       0.0304     114.5061       0.1695       3.2490       0.0000    2599.7705    1254.0000
  397.3068      96.0000      99.4828       0.0351     119.4324       0.1753       3.3190       0.0000    2592.1055    1287.0000
  397.4592      96.0000      99.2546       0.0410     121.2488       0.1776       3.2679       0.0000    2582.4126    1274.0000
  397.6116      96.0000      99.5753       0.0501     123.1259       0.1794       3.2770       0.0000    2567.2769    1286.0000
  397.7640      96.0000      98.9115       0.0582     111.4045       0.1820       3.3615       0.0000    2553.9575    1270.0000
  397.9164      96.0000      99.4068       0.0599      99.1198       0.1840       3.4862       0.0000    2551.1130    1275.0000
  398.0688      96.0000      99.3306       0.0467      94.2040       0.1799       3.5065       0.0000    2573.0063    1277.0000
  398.2212      96.0000      99.2787       0.0265     107.7411       0.1720       3.4486       0.0000    2606.2126    1280.0000
  398.3736      96.0000      99.1620       0.0157     117.5936       0.1739       3.4909       0.0000    2624.0383    1282.0000
  398.5260      96.0000      99.6514       0.0049     117.8633       0.1844       3.5207       0.0000    2641.9209    1272.0000
  398.6784      96.0000      99.6217       0.0051     120.3581       0.1964       3.5501       0.0000    2641.5867    1289.0000
  398.8308      96.0000      99.5754       0.0097     124.3286       0.2049       3.4631       0.0000    2633.9421    1275.0000
  398.9832      96.0000      99.6187       0.0169     135.1325       0.2129       3.6432       0.0000    2622.1758    1274.0000
  399.1356      96.0000      99.9560       0.0138     143.4059       0.2099       3.7792       0.0000    2627.2913    1285.0000
  399.2880      96.0000      99.4827       0.0200     142.5143       0.2006       3.8318       0.0000    2616.9834    1270.0000
  399.4404      96.0000      99.4990       0.0239     129.2491       0.1839       3.6085       0.0000    2610.6052    1294.0000
  399.5928      96.0000      99.7278       0.0303     108.0443       0.1666       3.4893       0.0000    2599.9570    1282.0000
  399.7452      96.0000      99.4585       0.0285     104.3209       0.1564       3.5406       0.0000    2602.9863    1286.0000
  399.8976      96.0000      99.7439       0.0192     104.6547       0.1615       3.5695       0.0000    2618.3018    1280.0000
  400.0500      96.0000      99.4392       0.0149     116.6297       0.1784       3.6869       0.0000    2625.3870    1282.0000
  400.2024      96.0000      99.4584       0.0130     126.2029       0.1908       3.7943       0.0000    2628.5244    1275.0000
  400.3548      96.0000      99.5590       0.0130     144.9442       0.1946       3.7518       0.0000    2628.4846    1277.0000
  400.5072      96.0000      99.3904       0.0162     147.4401       0.1940       3.6652       0.0000    2623.2195    1272.0000
  400.6596      96.0000      99.2785       0.0245     142.4817       0.1862       3.4916       0.0000    2609.5986    1272.0000
  400.8120      96.0000      99.5154       0.0247     138.4677       0.1705       3.4986       0.0000    2609.1641    1256.0000
  400.9644      96.0000      99.1021       0.0247     128.9230       0.1531       3.3243       0.0000    2609.3010    1279.0000
  401.1168      96.0000      99.3929       0.0265     119.6757       0.1431       3.3231       0.0000    2606.2422    1285.0000
  401.2692      96.0000      99.1782       0.0252     111.0029       0.1477       3.3620       0.0000    2608.4597    1287.0000
  401.4216      96.0000      99.4066       0.0175     115.0638       0.1574       3.5559       0.0000    2621.1448    1284.0000
  401.5740      96.0000      99.5590       0.0119     120.1542       0.1650       3.7166       0.0000    2630.4067    1268.0000
  401.7264      96.0000      99.4828       0.0051     125.1382       0.1748       3.7318       0.0000    2641.5757    1303.0000
  401.8788      96.0000      99.5914       0.0031     117.3580       0.1720       3.7654       0.0000    2644.8594    1260.0000
  402.0312      96.0000      99.8799      -0.0013     111.3865       0.1689       3.6552       0.0000    2652.1541    1286.0000
  402.1836      96.0000      99.9644       0.0013     101.8603       0.1616       3.6223       0.0000    2647.8936    1261.0000
  402.3360      96.0000      99.8036       0.0092     105.8876       0.1607       3.7423       0.0000    2634.7395    1267.0000
  402.4884      96.0000     100.2275       0.0075     112.3240       0.1635       3.7249       0.0000    2637.6196    1315.0000
  402.6408      96.0000     100.3711       0.0082     117.2775       0.1668       3.9454       0.0000    2636.5024    1257.0000
  402.7932      96.0000     100.1082       0.0133     127.8911       0.1806       3.8967       0.0000    2628.0627    1307.0000
  402.9456      96.0000     100.5647       0.0167     127.8911       0.2013       3.7523       0.0000    2622.4805    1267.0000
  403.0980      96.0000     100.8522       0.0212     132.1218       0.2183       3.6544       0.0000    2614.9783    1277.0000
  403.2504      96.0000     100.9282       0.0184     128.8976       0.2288       3.5562       0.0000    2619.7190    1293.0000
  403.4028      96.0000     100.6835       0.0130     136.2662       0.2212       3.6885       0.0000    2628.6077    1265.0000
  403.5552      96.0000     101.1942       0.0083     149.2628       0.2157       3.4765       0.0000    2636.3555    1316.0000
  403.7076      96.0000     101.0040       0.0073     156.3058       0.2085       3.4097       0.0000    2637.9924    1274.0000
  403.8600      96.0000     100.9450       0.0100     150.8139       0.2117       3.3054       0.0000    2633.4260    1303.0000
  404.0124      96.0000     101.2195       0.0103     138.4908       0.2104       3.4284       0.0000    2633.0469    1302.0000
  404.1648      96.0000     101.1730       0.0100     136.0198       0.2116       3.4724       0.0000    2633.5183    1272.0000
  404.3172      96.0000     100.6241       0.0136     146.7572       0.2191       3.6677       0.0000    2627.5188    1275.0000
  404.4696      96.0000     101.3333       0.0116     164.6370       0.2268       3.7452       0.0000    2630.8250    1298.0000
  404.6220      96.0000     100.7596       0.0144     168.0310       0.2272       3.7411       0.0000    2626.2622    1270.0000
  404.7744      96.0000     100.9284       0.0092     163.7593       0.2286       3.6333       0.0000    2634.8906    1292.0000
  404.9268      96.0000     101.0042       0.0101     149.8665       0.2235       3.5336       0.0000    2633.2578    1286.0000
  405.0792      96.0000     100.9412       0.0094     140.6690       0.2267       3.6027       0.0000    2634.5054    1270.0000
  405.2316      96.0000     100.4127       0.0174     143.3322       0.2191       3.5640       0.0000    2621.2852    1287.0000
  405.3840      96.0000     100.2770       0.0151     146.1011       0.2160       3.5292       0.0000    2625.1555    1271.0000
  405.5364      96.0000     100.7631       0.0100     151.9046       0.2085       3.4273       0.0000    2633.5366    1288.0000
  405.6888      96.0000     100.6243       0.0067     148.6257       0.1992       3.2987       0.0000    2639.0146    1288.0000
  405.8412      96.0000     100.3962       0.0075     146.4720       0.1930       3.4003       0.0000    2637.5906    1268.0000
  405.9936      96.0000     100.3960       0.0095     145.1567       0.1903       3.4421       0.0000    2634.3865    1301.0000
  406.1460      96.0000     100.5052       0.0133     143.1240       0.1897       3.7833       0.0000    2628.0088    1271.0000
  406.2984      96.0000      99.8799       0.0175     146.8568       0.1907       3.7903       0.0000    2621.2034    1272.0000
  406.4508      96.0000     100.3067       0.0156     149.1049       0.1997       3.9093       0.0000    2624.3186    1296.0000
  406.6032      96.0000     100.0158       0.0137     149.5981       0.2027       3.8337       0.0000    2627.4075    1256.0000
  406.7556      96.0000     100.1083       0.0106     139.7121       0.2108       4.0446       0.0000    2632.5708    1282.0000
  406.9080      96.0000     100.0784       0.0108     136.6706       0.2183       4.0135       0.0000    2632.2017    1280.0000
  407.0604      96.0000      99.9723       0.0083     145.2511       0.2161       3.7651       0.0000    2636.2930    1281.0000
  407.2128      96.0000      99.8798       0.0179     152.0582       0.2237       3.4912       0.0000    2620.5432    1287.0000
  407.3652      96.0000      99.8634       0.0221     154.7921       0.2099       3.4619       0.0000    2613.5427    1279.0000
  407.5176      96.0000      99.8258       0.0223     152.9851       0.2034       3.6444       0.0000    2613.1582    1286.0000
  407.6700      96.0000      99.5754       0.0148     156.9462       0.1833       3.9185       0.0000    2625.5303    1277.0000
  407.8224      96.0000      99.5074       0.0190     154.8281       0.1771       3.9744       0.0000    2618.6985    1277.0000
  407.9748      96.0000      99.2705       0.0241     161.5576       0.1737       3.8148       0.0000    2610.2024    1281.0000
  408.1272      96.0000      99.3630       0.0192     154.5177       0.1727       3.5266       0.0000    2618.2905    1281.0000
  408.2796      96.0000      99.5074       0.0110     160.9430       0.1683       3.3812       0.0000    2631.8831    1271.0000
  408.4320      96.0000      99.6349       0.0079     150.2109       0.1670       3.3232       0.0000    2636.8967    1292.0000
  408.5844      96.0000      99.3631       0.0077     150.4823       0.1668       3.3714       0.0000    2637.2781    1292.0000
  408.7368      96.0000      99.4392       0.0097     139.7464       0.1690       3.4817       0.0000    2633.9250    1305.0000
  408.8892      96.0000      99.2544       0.0100     131.0959       0.1773       3.5832       0.0000    2633.4890    1282.0000
  409.0416      96.0000      99.5752       0.0089     128.0535       0.1765       3.4243       0.0000    2635.2893    1299.0000
  409.1940      96.0000      99.6948       0.0100     123.4063       0.1859       3.3484       0.0000    2633.4363    1285.0000
  409.3464      96.0000      99.4828       0.0088     124.9753       0.1876       3.4184       0.0000    2635.4741    1293.0000
  409.4988      96.0000      99.3905       0.0145     121.8645       0.1921       3.6872       0.0000    2626.0557    1295.0000
  409.6512      96.0000      99.6514       0.0090     120.0460       0.1895       3.8069       0.0000    2635.1978    1292.0000
  409.8036      96.0000      99.7360       0.0105     112.3238       0.1854       3.7045       0.0000    2632.7280    1280.0000
  409.9560      96.0000      99.4229      -0.0016     106.1978       0.1859       3.5705       0.0000    2652.6418    1295.0000
  410.1084      96.0000      99.9232       0.0033     116.0155       0.1819       3.6104       0.0000    2644.6128    1285.0000
  410.2608      96.0000      99.5074      -0.0000     125.2772       0.1831       3.6883       0.0000    2650.0254    1293.0000
  410.4132      96.0000      99.4667       0.0098     121.8656       0.1831       3.7673       0.0000    2633.7681    1291.0000
  410.5656      96.0000      99.5753       0.0062     119.8710       0.1888       3.6817       0.0000    2639.7610    1271.0000
  410.7180      96.0000      99.7360       0.0085     117.4078       0.1910       3.7357       0.0000    2635.9417    1320.0000
  410.8704      96.0000      99.9126       0.0069     123.2534       0.1953       3.5791       0.0000    2638.6565    1264.0000
  411.0228      96.0000      99.9723       0.0096     118.2014       0.1935       3.4847       0.0000    2634.1885    1303.0000
  411.1752      96.0000     100.1031       0.0154     121.8633       0.2000       3.4059       0.0000    2624.5957    1296.0000
  411.3276      96.0000      99.9993       0.0174     124.0477       0.1945       3.4067       0.0000    2621.3584    1267.0000
  411.4800      96.0000      99.9561       0.0134     133.8633       0.1917       3.4684       0.0000    2627.8318    1310.0000
  411.6324      96.0000      99.6869       0.0110     138.2066       0.1815       3.2498       0.0000    2631.7866    1251.0000
  411.7848      96.0000      99.5753       0.0157     141.2525       0.1851       3.1969       0.0000    2624.0925    1301.0000
  411.9372      96.0000      99.7874       0.0187     134.8237       0.1796       3.0900       0.0000    2619.1895    1288.0000
  412.0896      96.0000     100.2173       0.0244     129.2498       0.1784       3.2724       0.0000    2609.7637    1271.0000
  412.2420      96.0000      99.4067       0.0249     134.2090       0.1724       3.3733       0.0000    2608.9692    1306.0000
  412.3944      96.0000      99.4828       0.0238     137.5612       0.1826       3.4494       0.0000    2610.6682    1282.0000
  412.5468      96.0000      99.5970       0.0165     148.0614       0.1907       3.4287       0.0000    2622.8447    1295.0000
  412.6992      96.0000      99.5590       0.0164     140.9485       0.1983       3.5957       0.0000    2622.9014    1294.0000
  412.8516      96.0000      99.2544       0.0175     151.7594       0.1996       3.8398       0.0000    2621.0981    1288.0000
  413.0040      96.0000      99.5753       0.0185     149.2584       0.2017       3.8395       0.0000    2619.5569    1281.0000
  413.1564      96.0000      99.6215       0.0181     149.5976       0.2107       3.7420       0.0000    2620.0623    1281.0000
  413.3088      96.0000      99.6516       0.0182     133.8642       0.2158       3.7099       0.0000    2620.0117    1296.0000
  413.4612      96.0000      99.7874       0.0215     124.9732       0.2232       3.8891       0.0000    2614.4429    1281.0000
  413.6136      96.0000     100.2571       0.0201     132.3255       0.2262       3.8820       0.0000    2616.8157    1305.0000
  413.7660      96.0000     100.0919       0.0213     134.5116       0.2206       3.8002       0.0000    2614.7800    1281.0000
  413.9184      96.0000      99.4392       0.0190     149.5558       0.2262       3.7084       0.0000    2618.7263    1301.0000
  414.0708      96.0000      99.6460       0.0180     158.8493       0.2270       3.7619       0.0000    2620.3633    1292.0000
  414.2232      96.0000      99.6352       0.0153     162.8519       0.2352       3.7619       0.0000    2624.7769    1268.0000
  414.3756      96.0000      99.6676       0.0160     157.0063       0.2238       3.8347       0.0000    2623.6316    1310.0000
  414.5280      96.0000      99.6217       0.0183     148.3658       0.2106       3.7918       0.0000    2619.8516    1273.0000
  414.6804      96.0000      99.6514       0.0270     147.7150       0.1906       3.5442       0.0000    2605.4863    1301.0000
  414.8328      96.0000      99.0098       0.0410     130.2032       0.1737       3.2859       0.0000    2582.4131    1288.0000
  414.9852      96.0000      98.8454       0.0565     109.2447       0.1502       3.1727       0.0000    2556.7622    1279.0000
  415.1376      96.0000      98.1875       0.0649      88.6510       0.1334       3.2130       0.0000    2542.8401    1302.0000
  415.2900      96.0000      98.3557       0.0751      89.8567       0.1264       3.1540       0.0000    2526.1265    1272.0000
  415.4424      96.0000      98.8213       0.0850      94.8049       0.1377       3.0400       0.0000    2509.8257    1293.0000
  415.5948      96.0000      98.6449       0.0915      98.1695       0.1585       2.8522       0.0000    2499.0334    1295.0000
  415.7472      96.0000      98.6770       0.0872      97.2717       0.1715       2.9707       0.0000    2506.0667    1291.0000
  415.8996      96.0000      98.3637       0.0737      98.1691       0.1786       3.0889       0.0000    2528.3970    1302.0000
  416.0520      96.0000      98.2795       0.0568     111.1227       0.1713       3.5218       0.0000    2556.2800    1270.0000
  416.2044      96.0000      98.7208       0.0394     126.1729       0.1747       3.5022       0.0000    2584.9985    1291.0000
  416.3568      96.0000      98.7071       0.0351     123.7361       0.1718       3.3044       0.0000    2592.0281    1294.0000
  416.5092      96.0000      98.3401       0.0419     104.1621       0.1657       2.9348       0.0000    2580.9207    1277.0000
  416.6616      96.0000      98.3558       0.0566      70.9347       0.1462       2.8078       0.0000    2556.6846    1299.0000
  416.8140      96.0000      98.8215       0.0562      52.4612       0.1299       2.7884       0.0000    2557.2241    1284.0000
  416.9664      96.0000      98.5845       0.0559      40.3142       0.1274       2.9840       0.0000    2557.7383    1291.0000
  417.1188      96.0000      98.7211       0.0573      36.3232       0.1299       2.9498       0.0000    2555.4373    1310.0000
  417.2712      96.0000      99.3930       0.0621      41.2351       0.1371       3.0580       0.0000    2547.5667    1289.0000
  417.4236      96.0000      99.0859       0.0726      56.3299       0.1379       3.0459       0.0000    2530.1609    1314.0000
  417.5760      96.0000      98.9657       0.0781      71.7044       0.1423       3.1582       0.0000    2521.1047    1284.0000
  417.7284      96.0000      99.0259       0.0724      79.3960       0.1473       3.1170       0.0000    2530.4585    1305.0000
  417.8808      96.0000      98.3558       0.0728      85.5538       0.1517       3.1474       0.0000    2529.8887    1281.0000
  418.0332      96.0000      98.2795       0.0669      89.8611       0.1471       3.1523       0.0000    2539.6299    1289.0000
  418.1856      96.0000      98.6165       0.0701      93.2680       0.1398       3.2376       0.0000    2534.3953    1281.0000
  418.3380      96.0000      98.4922       0.0689      88.9575       0.1371       3.1154       0.0000    2536.3760    1287.0000
  418.4904      96.0000      98.6448       0.0661      94.8030       0.1442       3.2490       0.0000    2540.9912    1298.0000
  418.6428      96.0000      98.3399       0.0563      96.0951       0.1525       3.1843       0.0000    2557.1118    1301.0000
  418.7952      96.0000      99.1620       0.0393     106.5349       0.1574       3.2147       0.0000    2585.1484    1294.0000
  418.9476      96.0000      99.4828       0.0254     113.0283       0.1550       3.1057       0.0000    2608.0818    1303.0000
  419.1000      96.0000      99.3686       0.0224     128.9426       0.1511       3.0651       0.0000    2612.9880    1291.0000
  419.2524      96.0000      99.0257       0.0319     123.1212       0.1441       3.2526       0.0000    2597.3005    1309.0000
  419.4048      96.0000      98.3560       0.0389     109.8593       0.1305       3.4082       0.0000    2585.8726    1292.0000
  419.5572      96.0000      98.7973       0.0359      87.7266       0.1166       3.7155       0.0000    2590.8264    1310.0000
  419.7096      96.0000      98.6450       0.0349      82.4721       0.1131       3.6744       0.0000    2592.4443    1294.0000
  419.8620      96.0000      98.5845       0.0402      76.3369       0.1298       3.6658       0.0000    2583.7058    1306.0000
  420.0144      96.0000      98.4782       0.0354      79.1351       0.1459       3.6094       0.0000    2591.6089    1313.0000
  420.1668      96.0000      98.8735       0.0243      94.8259       0.1628       3.7995       0.0000    2609.8513    1298.0000
  420.3192      96.0000      98.8133       0.0131     118.8414       0.1852       3.8873       0.0000    2628.3875    1309.0000
  420.4716      96.0000      98.9117       0.0129     136.3299       0.2138       3.8006       0.0000    2628.7954    1292.0000
  420.6240      96.0000      99.0420       0.0177     139.7488       0.2183       3.4874       0.0000    2620.7219    1285.0000
  420.7764      96.0000      99.4391       0.0249     129.8676       0.2107       3.1886       0.0000    2608.8381    1289.0000
  420.9288      96.0000      99.2787       0.0333     120.9729       0.1900       3.1065       0.0000    2594.9807    1298.0000
  421.0812      96.0000      99.1943       0.0436     116.3234       0.1773       3.1727       0.0000    2578.0283    1310.0000
  421.2336      96.0000      98.8575       0.0471     112.0415       0.1605       3.2448       0.0000    2572.2598    1295.0000
  421.3860      96.0000      98.7973       0.0478     109.9461       0.1536       3.2190       0.0000    2571.1187    1313.0000
  421.5384      96.0000      98.6768       0.0439      95.8291       0.1533       3.1043       0.0000    2577.5535    1302.0000
  421.6908      96.0000      98.8454       0.0465      93.3424       0.1471       3.1152       0.0000    2573.3247    1303.0000
  421.8432      96.0000      98.2255       0.0439      95.0525       0.1406       3.1880       0.0000    2577.5457    1295.0000
  421.9956      96.0000      98.2636       0.0513     114.4348       0.1417       3.2701       0.0000    2565.3220    1302.0000
  422.1480      96.0000      98.4922       0.0513     117.8191       0.1502       3.2603       0.0000    2565.4316    1294.0000
  422.3004      96.0000      98.4782       0.0512     104.3493       0.1460       3.1878       0.0000    2565.4717    1299.0000
  422.4528      96.0000      99.1020       0.0468     100.9300       0.1379       3.2413       0.0000    2572.7910    1299.0000
  422.6052      96.0000      98.6829       0.0443     104.9586       0.1435       3.2143       0.0000    2576.8235    1299.0000
  422.7576      96.0000      99.1182       0.0370     118.1710       0.1624       3.3568       0.0000    2588.9358    1294.0000
  422.9100      96.0000      98.9979       0.0261     112.6615       0.1731       3.3824       0.0000    2606.9688    1302.0000
  423.0624      96.0000      99.1400       0.0161     104.0179       0.1777       3.5969       0.0000    2623.4338    1300.0000
  423.2148      96.0000      98.9820       0.0087     109.0635       0.1797       3.5772       0.0000    2635.6846    1305.0000
  423.3672      96.0000      98.7811       0.0090     115.2214       0.1817       3.5511       0.0000    2635.0732    1302.0000
  423.5196      96.0000      99.1401       0.0179     125.6818       0.1748       3.5400       0.0000    2620.4785    1320.0000
  423.6720      96.0000      99.3467       0.0165     120.3285       0.1649       3.5849       0.0000    2622.7278    1298.0000
  423.8244      96.0000      99.4990       0.0193     113.2470       0.1591       3.4972       0.0000    2618.1230    1306.0000
  423.9768      96.0000      98.6589       0.0240     110.8144       0.1484       3.4653       0.0000    2610.4492    1298.0000
  424.1292      96.0000      98.8895       0.0309     111.4297       0.1386       3.4414       0.0000    2598.9341    1301.0000
  424.2816      96.0000      99.3143       0.0377     109.3683       0.1329       3.3704       0.0000    2587.8206    1310.0000
  424.4340      96.0000      98.5924       0.0381      96.4180       0.1237       3.2691       0.0000    2587.1790    1282.0000
  424.5864      96.0000      98.2478       0.0427      84.1904       0.1091       2.9221       0.0000    2579.4744    1315.0000
  424.7388      96.0000      98.5844       0.0326      66.3913       0.0921       2.8832       0.0000    2596.2651    1278.0000
  424.8912      96.0000      98.5686       0.0294      63.6392       0.0852       2.9034       0.0000    2601.4690    1305.0000
  425.0436      96.0000      97.9899       0.0223      59.5607       0.0923       3.0591       0.0000    2613.1387    1272.0000
  425.1960      96.0000      97.9743       0.0222      63.4108       0.1007       3.1531       0.0000    2613.3774    1310.0000
  425.3484      96.0000      98.1111       0.0240      75.0850       0.1140       3.2876       0.0000    2610.4116    1292.0000
  425.5008      96.0000      98.6608       0.0308      94.0770       0.1330       3.4421       0.0000    2599.1648    1295.0000
  425.6532      96.0000      99.3467       0.0292     116.5531       0.1580       3.5869       0.0000    2601.7742    1301.0000
  425.8056      96.0000      99.0499       0.0269     124.5523       0.1793       3.5272       0.0000    2605.5889    1281.0000
  425.9580      96.0000      98.9657       0.0150     132.0541       0.2038       3.5543       0.0000    2625.2922    1315.0000
  426.1104      96.0000      99.5154       0.0076     136.6364       0.2145       3.4702       0.0000    2637.4612    1294.0000
  426.2628      96.0000      99.3686       0.0060     139.7470       0.2221       3.5407       0.0000    2640.1621    1321.0000
  426.4152      96.0000      99.2705       0.0043     140.0198       0.2162       3.4290       0.0000    2642.8828    1299.0000
  426.5676      96.0000      99.2543       0.0151     131.7427       0.2174       3.4028       0.0000    2625.0896    1298.0000
  426.7200      96.0000      98.8874       0.0252     127.8666       0.2116       3.1127       0.0000    2608.4390    1303.0000
  426.8724      96.0000      99.2105       0.0374     118.6368       0.2025       3.0814       0.0000    2588.2754    1298.0000
  427.0248      96.0000      98.5926       0.0540     112.4789       0.1842       2.9380       0.0000    2560.8647    1307.0000
  427.1772      96.0000      98.7371       0.0795      96.3231       0.1685       3.0379       0.0000    2518.8450    1303.0000
  427.3296      96.0000      98.2953       0.0889      98.5065       0.1532       3.0785       0.0000    2503.2412    1305.0000
  427.4820      96.0000      98.4542       0.0845     100.6350       0.1502       3.1924       0.0000    2510.5691    1296.0000
  427.6344      96.0000      98.1717       0.0722     103.4250       0.1438       3.1953       0.0000    2530.9146    1300.0000
  427.7868      96.0000      98.6928       0.0658      85.9195       0.1366       3.2367       0.0000    2541.4854    1291.0000
  427.9392      96.0000      98.7070       0.0642      79.7884       0.1283       3.0999       0.0000    2544.0813    1312.0000
  428.0916      96.0000      98.4765       0.0662      76.0755       0.1261       3.0780       0.0000    2540.7490    1305.0000
  428.2440      96.0000      98.2032       0.0725      82.1890       0.1224       3.1319       0.0000    2530.3669    1322.0000
  428.3964      96.0000      98.2492       0.0742      76.6289       0.1211       3.3136       0.0000    2527.5884    1312.0000
  428.5488      96.0000      98.5688       0.0750      75.9228       0.1197       3.2249       0.0000    2526.2307    1323.0000
  428.7012      96.0000      98.3718       0.0693      78.3923       0.1209       3.1588       0.0000    2535.7373    1298.0000
  428.8536      96.0000      98.4542       0.0567      83.7836       0.1216       3.1745       0.0000    2556.4998    1310.0000
  429.0060      96.0000      98.3717       0.0408      82.9685       0.1266       3.3545       0.0000    2582.6565    1312.0000
  429.1584      96.0000      98.3559       0.0288      81.7085       0.1280       3.5675       0.0000    2602.4297    1307.0000
  429.3108      96.0000      98.9356       0.0265      87.7271       0.1323       3.5789       0.0000    2606.2012    1309.0000
  429.4632      96.0000      98.8576       0.0328     107.0927       0.1379       3.6577       0.0000    2595.8557    1331.0000
  429.6156      96.0000      99.1344       0.0302     115.7358       0.1427       3.5357       0.0000    2600.2358    1312.0000
  429.7680      96.0000      99.2544       0.0252     109.3996       0.1439       3.5699       0.0000    2608.3386    1312.0000
  429.9204      96.0000      99.3469       0.0155      90.6323       0.1408       3.6043       0.0000    2624.3992    1296.0000
  430.0728      96.0000      99.1644       0.0079      84.4745       0.1433       3.6531       0.0000    2636.9973    1330.0000
  430.2252      96.0000      99.4070       0.0057      91.7071       0.1508       3.7317       0.0000    2640.5706    1280.0000
  430.3776      96.0000      99.4229       0.0073     105.5797       0.1659       3.6546       0.0000    2638.0203    1316.0000
  430.5300      96.0000      99.7359       0.0143     108.7867       0.1840       3.5806       0.0000    2626.3784    1313.0000
  430.6824      96.0000      99.5915       0.0125     114.9399       0.1968       3.3748       0.0000    2629.3025    1305.0000
  430.8348      96.0000      99.8039       0.0160     124.4846       0.1970       3.3542       0.0000    2623.5627    1312.0000
  430.9872      96.0000      99.9396       0.0170     136.9443       0.1988       3.4461       0.0000    2621.9941    1303.0000
  431.1396      96.0000      99.9561       0.0171     148.0603       0.2019       3.7845       0.0000    2621.8542    1324.0000
  431.2920      96.0000      99.9723       0.0183     154.9126       0.2144       3.8089       0.0000    2619.7322    1317.0000
  431.4444      96.0000     100.2819       0.0153     167.8798       0.2179       3.6410       0.0000    2624.7483    1302.0000
  431.5968      96.0000     100.1082       0.0215     169.9933       0.2219       3.4337       0.0000    2614.4429    1324.0000
  431.7492      96.0000     100.1085       0.0183     170.2225       0.2159       3.3166       0.0000    2619.8142    1287.0000
  431.9016      96.0000      99.8502       0.0189     163.7161       0.2135       3.3504       0.0000    2618.8872    1333.0000
  432.0540      96.0000      99.7876       0.0122     162.8342       0.2099       3.3534       0.0000    2629.8843    1284.0000
  432.2064      96.0000     101.1562       0.0125     159.2296       0.2084       3.3959       0.0000    2629.3438    1333.0000
  432.3588      96.0000     100.0784       0.0183     171.2284       0.2116       3.5450       0.0000    2619.8591    1294.0000
  432.5112      96.0000     100.2604       0.0187     173.3836       0.2174       3.5572       0.0000    2619.0867    1320.0000
  432.6636      96.0000     100.5349       0.0186     174.4866       0.2249       3.5974       0.0000    2619.2437    1329.0000
  432.8160      96.0000     100.2770       0.0110     164.6837       0.2303       3.5126       0.0000    2631.7905    1299.0000
  432.9684      96.0000     100.3366       0.0163     164.0257       0.2418       3.6202       0.0000    2623.1470    1345.0000
  433.1208      96.0000     100.3960       0.0236     174.8933       0.2545       3.5140       0.0000    2611.0244    1272.0000
  433.2732      96.0000     100.7001       0.0276     169.6591       0.2588       3.4062       0.0000    2604.4011    1320.0000
  433.4256      96.0000     100.3368       0.0188     167.8131       0.2667       3.2703       0.0000    2618.9927    1312.0000
  433.5780      96.0000     100.5599       0.0169     157.8946       0.2590       3.3542       0.0000    2622.1111    1305.0000
  433.7304      96.0000     100.2770       0.0091     160.9329       0.2515       3.4663       0.0000    2634.9622    1345.0000
  433.8828      96.0000      99.8963       0.0103     153.8923       0.2294       3.5667       0.0000    2633.0757    1302.0000
  434.0352      96.0000     100.2571       0.0067     141.8673       0.2105       3.7891       0.0000    2639.0117    1313.0000
  434.1876      96.0000      99.7710       0.0125     125.8976       0.2000       3.8125       0.0000    2629.3425    1317.0000
  434.3400      96.0000      99.5728       0.0083     124.9965       0.1921       3.7905       0.0000    2636.2361    1298.0000
  434.4924      96.0000      99.4067       0.0127     134.8416       0.1926       3.5480       0.0000    2629.1018    1336.0000
  434.6448      96.0000      99.3467       0.0102     146.8494       0.1905       3.5922       0.0000    2633.1282    1305.0000
  434.7972      96.0000      99.5074       0.0131     142.7452       0.1770       3.5466       0.0000    2628.3279    1312.0000
  434.9496      96.0000      99.1943       0.0162     139.0533       0.1705       3.5106       0.0000    2623.2288    1323.0000
  435.1020      96.0000      99.2707       0.0192     139.3612       0.1635       3.4562       0.0000    2618.2559    1302.0000
  435.2544      96.0000      99.0918       0.0206     142.1773       0.1676       3.3964       0.0000    2616.0764    1323.0000
  435.4068      96.0000      99.4392       0.0140     140.1826       0.1669       3.5343       0.0000    2626.9019    1314.0000
  435.5592      96.0000      99.1183       0.0114     137.7195       0.1757       3.5403       0.0000    2631.1938    1313.0000
  435.7116      96.0000      99.1643      -0.0011     139.2578       0.1842       3.5032       0.0000    2651.8633    1320.0000
  435.8640      96.0000      99.0582       0.0028     143.1347       0.1913       3.4235       0.0000    2645.3901    1321.0000
  436.0164      96.0000      99.0259       0.0032     141.9208       0.1885       3.3042       0.0000    2644.6504    1319.0000
  436.1688      96.0000      99.3686       0.0057     136.7217       0.1861       3.2494       0.0000    2640.6099    1317.0000
  436.3212      96.0000      99.2105      -0.0031     129.6093       0.1850       3.2036       0.0000    2655.1094    1317.0000
  436.4736      96.0000      99.2544      -0.0019     125.5890       0.1776       3.2555       0.0000    2653.1758    1313.0000
  436.6260      96.0000      99.3629      -0.0001     130.8232       0.1699       3.3296       0.0000    2650.1321    1330.0000
  436.7784      96.0000      99.0420       0.0052     133.3382       0.1622       3.4776       0.0000    2641.3523    1313.0000
  436.9308      96.0000      98.9357       0.0035     135.8014       0.1613       3.5344       0.0000    2644.2847    1319.0000
  437.0832      96.0000      99.0699      -0.0011     136.0740       0.1582       3.5998       0.0000    2651.8652    1326.0000
  437.2356      96.0000      99.3629      -0.0020     135.0844       0.1553       3.4443       0.0000    2653.2197    1313.0000
  437.3880      96.0000      98.9357       0.0104     136.0080       0.1526       3.4566       0.0000    2632.7673    1317.0000
  437.5404      96.0000      98.9658       0.0171     140.3153       0.1566       3.4303       0.0000    2621.7434    1303.0000
  437.6928      96.0000      99.6515       0.0177     146.2101       0.1674       3.5666       0.0000    2620.8330    1312.0000
  437.8452      96.0000      99.3030       0.0142     146.5019       0.1878       3.5254       0.0000    2626.5569    1314.0000
  437.9976      96.0000      99.4667       0.0147     138.5352       0.2054       3.6613       0.0000    2625.6689    1307.0000
  438.1500      96.0000      99.5970       0.0160     144.3852       0.2119       3.5766       0.0000    2623.5500    1310.0000
  438.3024      96.0000      99.4230       0.0180     145.2894       0.2183       3.5748       0.0000    2620.3284    1321.0000
  438.4548      96.0000      99.6678       0.0119     155.5733       0.2196       3.4584       0.0000    2630.3350    1321.0000
  438.6072      96.0000      99.2787       0.0055     152.4558       0.2305       3.4822       0.0000    2640.9177    1326.0000
  438.7596      96.0000      99.4229       0.0029     150.3361       0.2253       3.4866       0.0000    2645.2188    1330.0000
  438.9120      96.0000      99.6513       0.0020     143.0964       0.2136       3.6353       0.0000    2646.6179    1323.0000
  439.0644      96.0000      99.6215       0.0020     132.0508       0.2029       3.6850       0.0000    2646.6826    1326.0000
  439.2168      96.0000      99.1020       0.0075     125.4385       0.1955       3.6881       0.0000    2637.5740    1320.0000
  439.3692      96.0000      99.5071       0.0062     118.6700       0.1879       3.6179       0.0000    2639.7571    1313.0000
  439.5216      96.0000      99.4391       0.0026     122.3647       0.1775       3.4656       0.0000    2645.6379    1337.0000
  439.6740      96.0000      99.3631       0.0051     139.0958       0.1691       3.4187       0.0000    2641.5972    1313.0000
  439.8264      96.0000      99.1642       0.0115     151.7361       0.1653       3.5251       0.0000    2631.0840    1323.0000
  439.9788      96.0000      98.9659       0.0124     159.1255       0.1557       3.6410       0.0000    2629.4695    1328.0000
  440.1312      96.0000      98.9176       0.0108     144.0501       0.1460       3.8103       0.0000    2632.1824    1310.0000
  440.2836      96.0000      99.0742       0.0067     128.6686       0.1353       3.7750       0.0000    2638.8745    1317.0000
  440.4360      96.0000      98.8294       0.0049     110.0569       0.1307       3.7507       0.0000    2641.9785    1309.0000
  440.5884      96.0000      99.2301       0.0009     104.8530       0.1284       3.7372       0.0000    2648.4875    1313.0000
  440.7408      96.0000      98.6006      -0.0033     107.6240       0.1344       3.6249       0.0000    2655.5032    1338.0000
  440.8932      96.0000      98.9818      -0.0050     120.6098       0.1441       3.7112       0.0000    2658.3218    1320.0000
  441.0456      96.0000      98.6831       0.0026     122.1493       0.1565       3.5819       0.0000    2645.7349    1343.0000
  441.1980      96.0000      98.9497       0.0080     128.2727       0.1594       3.5121       0.0000    2636.8818    1326.0000
  441.3504      96.0000      98.7529       0.0131     127.7408       0.1544       3.3972       0.0000    2628.4309    1320.0000
  441.5028      96.0000      98.4542       0.0105     135.0972       0.1489       3.4413       0.0000    2632.7222    1337.0000
  441.6552      96.0000      98.9818       0.0017     127.4343       0.1439       3.5219       0.0000    2647.1594    1309.0000
  441.8076      96.0000      98.8897      -0.0019     122.5321       0.1425       3.5654       0.0000    2653.1182    1317.0000
  441.9600      96.0000      98.7973       0.0037     119.1478       0.1381       3.4446       0.0000    2643.9265    1307.0000
  442.1124      96.0000      98.7971       0.0021     126.2293       0.1401       3.3093       0.0000    2646.5737    1327.0000
  442.2648      96.0000      99.0500       0.0016     121.7831       0.1429       3.2738       0.0000    2647.3274    1308.0000
  442.4172      96.0000      98.4765       0.0098     125.4751       0.1428       3.2693       0.0000    2633.7930    1335.0000
  442.5696      96.0000      99.2105       0.0073     118.3935       0.1441       3.3895       0.0000    2637.9749    1296.0000
  442.7220      96.0000      98.8875       0.0109     127.0927       0.1459       3.4155       0.0000    2632.0862    1320.0000
  442.8744      96.0000      98.9499       0.0063     126.5676       0.1482       3.4422       0.0000    2639.5684    1320.0000
  443.0268      96.0000      98.7973       0.0112     133.6152       0.1540       3.3731       0.0000    2631.5359    1312.0000
  443.1792      96.0000      98.7310       0.0073     133.6486       0.1580       3.2342       0.0000    2637.9834    1315.0000
  443.3316      96.0000      98.7371       0.0107     130.2285       0.1710       3.1798       0.0000    2632.3503    1320.0000
  443.4840      96.0000      98.7069       0.0080     125.3059       0.1793       3.2443       0.0000    2636.8542    1309.0000
  443.6364      96.0000      98.7973       0.0044     120.9954       0.1835       3.3110       0.0000    2642.7913    1324.0000
  443.7888      96.0000      98.9336      -0.0014     117.5568       0.1799       3.3662       0.0000    2652.3337    1312.0000
  443.9412      96.0000      98.7070      -0.0017     118.2028       0.1786       3.2797       0.0000    2652.7627    1323.0000
  444.0936      96.0000      98.8895      -0.0012     118.9109       0.1817       3.2982       0.0000    2652.0239    1312.0000
  444.2460      96.0000      98.9116       0.0045     126.6025       0.1760       3.3445       0.0000    2642.5620    1316.0000
  444.3984      96.0000      98.7974       0.0100     129.6814       0.1644       3.3386       0.0000    2633.4729    1312.0000
  444.5508      96.0000      98.9819       0.0138     128.9637       0.1436       3.3687       0.0000    2627.2969    1313.0000
  444.7032      96.0000      98.5927       0.0091     117.9131       0.1318       3.2695       0.0000    2634.9153    1313.0000
  444.8556      96.0000      98.6004       0.0009     100.0554       0.1230       3.3559       0.0000    2648.5857    1314.0000
  445.0080      96.0000      98.6607      -0.0039      84.3439       0.1244       3.4420       0.0000    2656.3560    1309.0000
  445.1604      96.0000      98.5927      -0.0023      76.3387       0.1279       3.5031       0.0000    2653.7285    1299.0000
  445.3128      96.0000      98.4161       0.0027      87.4166       0.1339       3.3932       0.0000    2645.5664    1316.0000
  445.4652      96.0000      99.0259       0.0085      96.0561       0.1397       3.4324       0.0000    2635.9180    1314.0000
  445.6176      96.0000      98.4764       0.0161     107.1127       0.1468       3.4941       0.0000    2623.3574    1302.0000
  445.7700      96.0000      98.5081       0.0222     106.1177       0.1519       3.4799       0.0000    2613.3518    1313.0000
  445.9224      96.0000      98.4781       0.0234     108.2730       0.1540       3.4564       0.0000    2611.4192    1306.0000
  446.0748      96.0000      98.2794       0.0241     108.5806       0.1546       3.3787       0.0000    2610.1865    1313.0000
  446.2272      96.0000      98.5927       0.0387     111.4291       0.1567       3.4894       0.0000    2586.1809    1328.0000
  446.3796      96.0000      98.6165       0.0515     108.9413       0.1569       3.4670       0.0000    2564.9854    1307.0000
  446.5320      96.0000      98.0952       0.0552     101.2717       0.1518       3.4179       0.0000    2558.9829    1321.0000
  446.6844      96.0000      97.9967       0.0508      88.1627       0.1463       3.2713       0.0000    2566.1064    1317.0000
  446.8368      96.0000      98.2030       0.0369      82.3171       0.1501       3.0902       0.0000    2589.1179    1320.0000
  446.9892      96.0000      98.2016       0.0160      84.5329       0.1513       3.1417       0.0000    2623.5872    1335.0000
  447.1416      96.0000      98.8294       0.0092      97.6126       0.1570       3.3128       0.0000    2634.8838    1319.0000
  447.2940      96.0000      99.1945       0.0108     114.2591       0.1807       3.6318       0.0000    2632.1770    1324.0000
  447.4464      96.0000      99.1403       0.0176     122.1742       0.1932       3.7354       0.0000    2621.0022    1333.0000
  447.5988      96.0000      99.2706       0.0244     120.0483       0.1874       3.7310       0.0000    2609.7468    1309.0000
  447.7512      96.0000      99.2544       0.0281     118.7377       0.1655       3.5501       0.0000    2603.6111    1333.0000
  447.9036      96.0000      99.3302       0.0317     116.5841       0.1610       3.4254       0.0000    2597.6672    1316.0000
  448.0560      96.0000      98.9980       0.0332     116.2762       0.1651       3.2030       0.0000    2595.2278    1328.0000
  448.2084      96.0000      98.5687       0.0349     109.7779       0.1628       3.0626       0.0000    2592.3845    1328.0000
  448.3608      96.0000      99.3957       0.0336     112.8375       0.1624       3.0584       0.0000    2594.5415    1324.0000
  448.5132      96.0000      99.5970       0.0269     119.6345       0.1741       3.2882       0.0000    2605.6279    1327.0000
  448.6656      96.0000      99.5426       0.0256     122.4880       0.1862       3.6364       0.0000    2607.7410    1331.0000
  448.8180      96.0000      99.5590       0.0255     125.9220       0.1934       3.5945       0.0000    2607.9250    1315.0000
  448.9704      96.0000      99.3686       0.0211     121.5589       0.1885       3.4074       0.0000    2615.1553    1310.0000
  449.1228      96.0000      99.7114       0.0197     120.4154       0.1817       3.2057       0.0000    2617.4536    1326.0000
  449.2752      96.0000      99.0501       0.0202     112.4102       0.1842       3.2364       0.0000    2616.5918    1301.0000
  449.4276      96.0000      99.1183       0.0219     107.4876       0.1878       3.1672       0.0000    2613.8213    1328.0000
  449.5800      96.0000      99.1781       0.0240     112.0154       0.1849       3.1378       0.0000    2610.3916    1317.0000
  449.7324      96.0000      99.3686       0.0299     115.2898       0.1833       3.1699       0.0000    2600.6741    1326.0000
  449.8848      96.0000      99.5590       0.0389     115.3155       0.1815       3.3107       0.0000    2585.8684    1334.0000
  450.0372      96.0000      99.2544       0.0399     109.4699       0.1793       3.2795       0.0000    2584.1846    1313.0000
  450.1896      96.0000      99.1183       0.0416     107.1191       0.1746       3.1602       0.0000    2581.4053    1317.0000
  450.3420      96.0000      98.8134       0.0485     110.9070       0.1816       3.0729       0.0000    2570.0549    1315.0000
  450.4944      96.0000      98.9116       0.0669     110.9070       0.1887       3.0713       0.0000    2539.5989    1323.0000
  450.6468      96.0000      98.3240       0.0793     103.8255       0.1890       3.1378       0.0000    2519.1316    1317.0000
  450.7992      96.0000      98.6829       0.0906     101.2427       0.1818       3.0328       0.0000    2500.4309    1326.0000
  450.9516      96.0000      98.3557       0.0995      94.6941       0.1839       2.9730       0.0000    2485.7727    1322.0000
  451.1040      96.0000      98.3716       0.1064      95.5949       0.1876       2.7399       0.0000    2474.4353    1320.0000
  451.2564      96.0000      98.5021       0.1125      85.4610       0.1868       2.7688       0.0000    2464.4370    1315.0000
  451.4088      96.0000      98.8133       0.1044      81.2414       0.1805       2.8658       0.0000    2477.6855    1312.0000
  451.5612      96.0000      98.2493       0.0896      87.7208       0.1718       3.1514       0.0000    2502.2073    1326.0000
  451.7136      96.0000      98.2478       0.0781      86.4892       0.1629       3.2848       0.0000    2521.0557    1317.0000
  451.8660      96.0000      98.7532       0.0723      86.4892       0.1574       3.3324       0.0000    2530.7051    1322.0000
  452.0184      96.0000      98.7069       0.0692      80.9564       0.1526       3.2239       0.0000    2535.8406    1334.0000
  452.1708      96.0000      98.4480       0.0685      81.5660       0.1541       3.1236       0.0000    2537.0371    1312.0000
  452.3232      96.0000      98.6829       0.0651      84.0273       0.1476       2.9854       0.0000    2542.5154    1333.0000
  452.4756      96.0000      98.5846       0.0512      79.4089       0.1436       2.9173       0.0000    2565.5972    1316.0000
  452.6280      96.0000      98.4319       0.0378      80.3196       0.1409       2.9289       0.0000    2587.6270    1329.0000
  452.7804      96.0000      98.4780       0.0186      79.3418       0.1455       3.0406       0.0000    2619.3777    1341.0000
  452.9328      96.0000      98.8896       0.0065      85.8075       0.1537       3.5163       0.0000    2639.3269    1327.0000
  453.0852      96.0000      98.7973       0.0128     100.2676       0.1660       3.7533       0.0000    2628.8286    1333.0000
  453.2376      96.0000      98.7973       0.0288     108.9637       0.1729       3.6413       0.0000    2602.5095    1319.0000
  453.3900      96.0000      98.8293       0.0450     111.9652       0.1777       3.2514       0.0000    2575.6758    1341.0000
  453.5424      96.0000      98.9359       0.0568     102.1200       0.1728       3.0669       0.0000    2556.2090    1327.0000
  453.6948      96.0000      98.5084       0.0645      99.3243       0.1687       3.0181       0.0000    2543.6304    1330.0000
  453.8472      96.0000      98.4783       0.0653      91.7045       0.1648       3.0725       0.0000    2542.3169    1324.0000
  453.9996      96.0000      98.8895       0.0630      92.3352       0.1617       3.1699       0.0000    2545.9907    1343.0000
  454.1520      96.0000      98.5243       0.0556      92.3352       0.1663       3.3302       0.0000    2558.3191    1331.0000
  454.3044      96.0000      98.7310       0.0451      95.4141       0.1662       3.4713       0.0000    2575.6270    1333.0000
  454.4568      96.0000      98.8293       0.0409      98.4753       0.1709       3.4551       0.0000    2582.5801    1330.0000
  454.6092      96.0000      98.6447       0.0339      95.9951       0.1690       3.4621       0.0000    2594.0801    1334.0000
  454.7616      96.0000      98.7071       0.0221      95.9951       0.1709       3.3127       0.0000    2613.4858    1313.0000
  454.9140      96.0000      99.2868       0.0137      98.1487       0.1700       3.3054       0.0000    2627.3584    1323.0000
  455.0664      96.0000      99.0259       0.0083     102.9369       0.1730       3.2486       0.0000    2636.2654    1322.0000
  455.2188      96.0000      98.6608       0.0018     106.6316       0.1741       3.2705       0.0000    2647.0095    1326.0000
  455.3712      96.0000      98.9818      -0.0066     103.5550       0.1704       3.2611       0.0000    2660.8577    1313.0000
  455.5236      96.0000      98.7069      -0.0140     100.3481       0.1636       3.2794       0.0000    2673.1143    1312.0000
  455.6760      96.0000      98.6006      -0.0129     100.0139       0.1601       3.4487       0.0000    2671.2407    1317.0000
  455.8284      96.0000      98.4542      -0.0096     102.5017       0.1636       3.4532       0.0000    2665.8489    1312.0000
  455.9808      96.0000      98.2796       0.0011     104.3236       0.1711       3.3189       0.0000    2648.2258    1338.0000
  456.1332      96.0000      98.7310       0.0028     104.4780       0.1726       3.1854       0.0000    2645.4519    1320.0000
  456.2856      96.0000      98.6005       0.0200     103.2208       0.1691       3.0727       0.0000    2617.0334    1327.0000
  456.4380      96.0000      98.5083       0.0280      96.3974       0.1658       3.0101       0.0000    2603.8179    1308.0000
  456.5904      96.0000      98.6161       0.0417      92.5747       0.1608       2.8542       0.0000    2581.1182    1327.0000
  456.7428      96.0000      98.4003       0.0399      85.1908       0.1618       2.9030       0.0000    2584.1570    1315.0000
  456.8952      96.0000      98.6608       0.0467      89.5765       0.1598       3.0930       0.0000    2572.9299    1322.0000
  457.0476      96.0000      98.2492       0.0447      92.6295       0.1652       3.0530       0.0000    2576.1919    1333.0000
  457.2000      96.0000      98.4319       0.0457      92.5403       0.1613       3.0665       0.0000    2574.6025    1313.0000
  457.3524      96.0000      98.4542       0.0453      86.9983       0.1595       2.9770       0.0000    2575.2549    1345.0000
  457.5048      96.0000      98.4479       0.0483      79.6144       0.1536       3.0135       0.0000    2570.2761    1320.0000
  457.6572      96.0000      98.8213       0.0427      76.0290       0.1505       2.9792       0.0000    2579.5288    1335.0000
  457.8096      96.0000      98.5083       0.0396      72.0369       0.1414       2.9341       0.0000    2584.6028    1335.0000
  457.9620      96.0000      98.4321       0.0270      61.5889       0.1390       2.9658       0.0000    2605.4377    1312.0000
  458.1144      96.0000      98.3637       0.0237      64.3405       0.1410       2.9735       0.0000    2610.9548    1347.0000
  458.2668      96.0000      98.6005       0.0162      72.3352       0.1437       3.2602       0.0000    2623.2161    1313.0000
  458.4192      96.0000      99.0582       0.0203      98.4739       0.1493       3.5641       0.0000    2616.5337    1352.0000
  458.5716      96.0000      99.2301       0.0223     117.7766       0.1609       3.5820       0.0000    2613.2754    1314.0000
  458.7240      96.0000      99.0097       0.0306     123.0108       0.1725       3.5853       0.0000    2599.4373    1335.0000
  458.8764      96.0000      98.7973       0.0392     126.7027       0.1677       3.4875       0.0000    2585.3032    1321.0000
  459.0288      96.0000      98.4925       0.0507     119.8624       0.1573       3.5234       0.0000    2566.4043    1320.0000
  459.1812      96.0000      98.3717       0.0420     119.5545       0.1477       3.2649       0.0000    2580.6404    1320.0000
  459.3336      96.0000      98.2492       0.0399     105.0944       0.1405       2.9884       0.0000    2584.2319    1330.0000
  459.4860      96.0000      98.4924       0.0356      98.5014       0.1297       2.9128       0.0000    2591.2202    1334.0000
  459.6384      96.0000      98.2731       0.0338      92.7568       0.1212       2.9366       0.0000    2594.2078    1340.0000
  459.7908      96.0000      98.3400       0.0282      92.4729       0.1179       3.0348       0.0000    2603.4707    1324.0000
  459.9432      96.0000      98.4781       0.0286      94.6028       0.1198       3.1424       0.0000    2602.8694    1333.0000
  460.0956      96.0000      98.4926       0.0301     101.2710       0.1320       3.0649       0.0000    2600.2708    1309.0000
  460.2480      96.0000      98.4924       0.0282      99.6556       0.1426       3.1124       0.0000    2603.4526    1320.0000
  460.4004      96.0000      98.3637       0.0261     105.8088       0.1537       3.2248       0.0000    2606.9883    1308.0000
  460.5528      96.0000      98.7050       0.0169     115.6614       0.1664       3.3284       0.0000    2622.0823    1342.0000
  460.7052      96.0000      99.0580       0.0155     122.7909       0.1839       3.5253       0.0000    2624.3811    1315.0000
  460.8576      96.0000      99.0499       0.0131     132.9814       0.1948       3.5297       0.0000    2628.4541    1331.0000
  461.0100      96.0000      99.2709       0.0161     127.4293       0.1981       3.6371       0.0000    2623.4968    1335.0000
  461.1624      96.0000      99.1398       0.0193     126.1987       0.1976       3.7669       0.0000    2618.0859    1331.0000
  461.3148      96.0000      99.0420       0.0201     116.6540       0.1961       3.7515       0.0000    2616.8718    1327.0000
  461.4672      96.0000      99.3305       0.0195     120.6336       0.1881       3.9260       0.0000    2617.8259    1330.0000
  461.6196      96.0000      98.6829       0.0201     127.7313       0.1835       3.6569       0.0000    2616.8164    1321.0000
  461.7720      96.0000      98.8737       0.0197     124.3445       0.1725       3.6688       0.0000    2617.4734    1351.0000
  461.9244      96.0000      98.7973       0.0129     111.4228       0.1675       3.5449       0.0000    2628.6619    1317.0000
  462.0768      96.0000      98.8894       0.0040     104.5824       0.1615       3.5247       0.0000    2643.4453    1336.0000
  462.2292      96.0000      99.0260       0.0075     105.5061       0.1647       3.5066       0.0000    2637.6262    1327.0000
  462.3816      96.0000      99.0259       0.0081     116.2743       0.1727       3.5652       0.0000    2636.6748    1315.0000
  462.5340      96.0000      98.8133       0.0036     116.6322       0.1717       3.7346       0.0000    2644.0999    1329.0000
  462.6864      96.0000      98.9116      -0.0047     113.6813       0.1644       3.9124       0.0000    2657.7170    1334.0000
  462.8388      96.0000      98.8735      -0.0026     108.1706       0.1508       3.7336       0.0000    2654.3508    1321.0000
  462.9912      96.0000      98.9496       0.0033     113.7085       0.1486       3.6928       0.0000    2644.4731    1329.0000
  463.1436      96.0000      98.4304       0.0105     119.1225       0.1505       3.5242       0.0000    2632.7239    1314.0000
  463.2960      96.0000      99.1343       0.0135     115.0957       0.1542       3.6144       0.0000    2627.6580    1331.0000
  463.4484      96.0000      98.8454       0.0134     110.2260       0.1639       3.6838       0.0000    2627.8206    1333.0000
  463.6008      96.0000      98.7529       0.0107     112.9970       0.1721       3.6801       0.0000    2632.3777    1338.0000
  463.7532      96.0000      99.0903       0.0140     125.6111       0.1774       3.5844       0.0000    2626.8337    1340.0000
  463.9056      96.0000      98.5686       0.0141     127.1256       0.1791       3.2791       0.0000    2626.7986    1352.0000
  464.0580      96.0000      98.8414       0.0235     128.8591       0.1758       3.2091       0.0000    2611.1431    1330.0000
  464.2104      96.0000      98.9598       0.0247     125.4748       0.1767       3.0953       0.0000    2609.2949    1336.0000
  464.3628      96.0000      98.8895       0.0283     133.4449       0.1692       3.3406       0.0000    2603.2888    1347.0000
  464.5152      96.0000      98.9499       0.0286     139.1009       0.1719       3.4303       0.0000    2602.8057    1340.0000
  464.6676      96.0000      99.0985       0.0245     144.7649       0.1712       3.4639       0.0000    2609.5090    1326.0000
  464.8200      96.0000      98.7370       0.0236     136.7657       0.1704       3.5029       0.0000    2611.0696    1347.0000
  464.9724      96.0000      98.6829       0.0230     134.3026       0.1730       3.4575       0.0000    2612.1221    1342.0000
  465.1248      96.0000      98.7692       0.0183     126.7926       0.1701       3.5332       0.0000    2619.7375    1340.0000
  465.2772      96.0000      98.9658       0.0142     136.3663       0.1645       3.4536       0.0000    2626.6218    1340.0000
  465.4296      96.0000      99.3930       0.0129     127.7012       0.1531       3.4784       0.0000    2628.6560    1347.0000
  465.5820      96.0000      99.2105       0.0073     132.6238       0.1514       3.6189       0.0000    2637.9846    1338.0000
  465.7344      96.0000      99.3686       0.0107     126.1581       0.1579       3.4746       0.0000    2632.3606    1342.0000
  465.8868      96.0000      99.3142       0.0132     130.7874       0.1640       3.5969       0.0000    2628.1406    1331.0000
  466.0392      96.0000      99.3306       0.0146     126.8765       0.1738       3.3871       0.0000    2625.9751    1356.0000
  466.1916      96.0000      99.6868       0.0161     119.7950       0.1908       3.4243       0.0000    2623.4050    1321.0000
  466.3440      96.0000      99.2106       0.0133     121.0256       0.2043       3.1551       0.0000    2627.9812    1354.0000
  466.4964      96.0000      99.6460       0.0144     128.0489       0.2146       3.3232       0.0000    2626.2441    1329.0000
  466.6488      96.0000      99.7874       0.0124     142.8082       0.2147       3.3528       0.0000    2629.5742    1350.0000
  466.8012      96.0000      99.4828       0.0126     141.6108       0.2232       3.4730       0.0000    2629.1643    1334.0000
  466.9536      96.0000      99.2544       0.0113     141.2673       0.2298       3.5320       0.0000    2631.3682    1334.0000
  467.1060      96.0000      99.4229       0.0188     138.9145       0.2252       3.7067       0.0000    2619.0425    1341.0000
  467.2584      96.0000      99.5970       0.0239     143.2250       0.2103       3.6989       0.0000    2610.5366    1352.0000
  467.4108      96.0000      99.4990       0.0251     139.2254       0.1890       3.5088       0.0000    2608.5281    1347.0000
  467.5632      96.0000      99.1020       0.0154     127.7426       0.1700       3.2465       0.0000    2624.5256    1331.0000
  467.7156      96.0000      98.7973       0.0131      99.0936       0.1440       3.2279       0.0000    2628.3955    1355.0000
  467.8680      96.0000      98.5844       0.0118      75.8924       0.1185       3.2087       0.0000    2630.4592    1328.0000
  468.0204      96.0000      98.7069       0.0065      59.5741       0.1044       3.2281       0.0000    2639.2036    1345.0000
  468.1728      96.0000      98.7369       0.0064      57.4205       0.1022       3.1336       0.0000    2639.4939    1333.0000
  468.3252      96.0000      98.8213       0.0082      54.4835       0.1004       3.0661       0.0000    2636.5361    1343.0000
  468.4776      96.0000      98.5846       0.0097      53.8972       0.0966       3.1114       0.0000    2633.9343    1337.0000
  468.6300      96.0000      98.4321       0.0078      51.4359       0.0929       3.1567       0.0000    2637.1404    1335.0000
  468.7824      96.0000      98.5020       0.0096      47.7412       0.0896       3.2850       0.0000    2634.2012    1330.0000
  468.9348      96.0000      97.9429       0.0098      42.4674       0.0863       3.3417       0.0000    2633.8291    1334.0000
  469.0872      96.0000      97.8978       0.0124      41.1070       0.0921       3.5118       0.0000    2629.5586    1340.0000
  469.2396      96.0000      97.6769       0.0080      47.2500       0.1044       3.4109       0.0000    2636.7727    1340.0000
  469.3920      96.0000      97.8375       0.0061      74.3547       0.1269       3.5705       0.0000    2639.8857    1344.0000
  469.5444      96.0000      98.2492       0.0038     103.0841       0.1631       3.6164       0.0000    2643.7029    1351.0000
  469.6968      96.0000      98.4639       0.0083     141.2341       0.2003       3.8769       0.0000    2636.2788    1344.0000
  469.8492      96.0000      98.4320       0.0096     149.8551       0.2194       3.6562       0.0000    2634.1763    1331.0000
  470.0016      96.0000      98.9357       0.0178     152.9445       0.2172       3.3650       0.0000    2620.6677    1323.0000
  470.1540      96.0000      98.9497       0.0191     136.9775       0.1989       3.0029       0.0000    2618.4841    1365.0000
  470.3064      96.0000      98.7734       0.0257     123.2845       0.1785       2.9040       0.0000    2607.5730    1326.0000
  470.4588      96.0000      99.1182       0.0292     108.5168       0.1550       2.9388       0.0000    2601.8381    1350.0000
  470.6112      96.0000      99.1182       0.0376     100.8195       0.1402       3.0357       0.0000    2587.9055    1336.0000
  470.7636      96.0000      98.7973       0.0381     100.3231       0.1364       3.1098       0.0000    2587.2031    1347.0000
  470.9160      96.0000      98.3399       0.0362      97.6367       0.1390       3.2100       0.0000    2590.3464    1349.0000
  471.0684      96.0000      98.5686       0.0248      91.7656       0.1354       3.2906       0.0000    2609.0891    1343.0000
  471.2208      96.0000      98.4924       0.0203      90.8682       0.1307       3.4549       0.0000    2616.5754    1328.0000
  471.3732      96.0000      98.6609       0.0108     100.0436       0.1260       3.5170       0.0000    2632.2383    1347.0000
  471.5256      96.0000      98.6829       0.0106     102.8364       0.1297       3.6498       0.0000    2632.5662    1320.0000
  471.6780      96.0000      98.6005       0.0120      96.6786       0.1266       3.8197       0.0000    2630.1260    1358.0000
  471.8304      96.0000      98.2256       0.0173      90.1895       0.1213       3.6640       0.0000    2621.4663    1327.0000
  471.9828      96.0000      98.5242       0.0169      93.6356       0.1237       3.4460       0.0000    2622.1890    1357.0000
  472.1352      96.0000      99.1021       0.0164     105.6434       0.1337       3.1939       0.0000    2622.9058    1316.0000
  472.2876      96.0000      99.1643       0.0112     112.4120       0.1503       3.1549       0.0000    2631.4917    1350.0000
  472.4400      96.0000      98.9217       0.0068     127.4389       0.1602       3.3944       0.0000    2638.7424    1324.0000
  472.5924      96.0000      99.2788       0.0035     130.7932       0.1795       3.5021       0.0000    2644.3064    1354.0000
  472.7448      96.0000      98.7813       0.0255     141.5172       0.1845       3.6118       0.0000    2607.9177    1323.0000
  472.8972      96.0000      99.0742       0.0463     142.4030       0.1813       3.5224       0.0000    2573.6279    1347.0000
  473.0496      96.0000      98.9116       0.0611     135.9698       0.1689       3.5338       0.0000    2549.2434    1328.0000
  473.2020      96.0000      98.8293       0.0606     121.2631       0.1531       3.5111       0.0000    2549.9790    1348.0000
  473.3544      96.0000      98.6165       0.0538     106.8030       0.1416       3.4929       0.0000    2561.1492    1348.0000
  473.5068      96.0000      98.9217       0.0451      98.7978       0.1377       3.4404       0.0000    2575.5552    1349.0000
  473.6592      96.0000      98.4923       0.0424     100.0116       0.1445       3.6095       0.0000    2579.9675    1352.0000
  473.8116      96.0000      98.7551       0.0331      98.2169       0.1580       3.7286       0.0000    2595.3713    1341.0000
  473.9640      96.0000      98.6004       0.0281     110.2247       0.1739       3.7578       0.0000    2603.7173    1354.0000
  474.1164      96.0000      98.9115       0.0145     125.3001       0.1932       3.8565       0.0000    2626.1260    1333.0000
  474.2688      96.0000      99.0259       0.0065     140.9769       0.2068       3.6282       0.0000    2639.2532    1338.0000
  474.4212      96.0000      99.1345       0.0069     150.9877       0.1997       3.6797       0.0000    2638.6628    1337.0000
  474.5736      96.0000      99.3930       0.0194     141.7579       0.1854       3.3794       0.0000    2617.9907    1361.0000
  474.7260      96.0000      99.3628       0.0235     134.6764       0.1719       3.5170       0.0000    2611.2908    1342.0000
  474.8784      96.0000      99.0016       0.0286     117.8663       0.1629       3.4012       0.0000    2602.8804    1337.0000
  475.0308      96.0000      99.0419       0.0364     110.5076       0.1565       3.2944       0.0000    2590.0063    1343.0000
  475.1832      96.0000      98.8135       0.0455     100.5169       0.1572       3.2146       0.0000    2574.9060    1341.0000
  475.3356      96.0000      98.3638       0.0525     102.6977       0.1677       3.0103       0.0000    2563.3899    1333.0000
  475.4880      96.0000      98.7532       0.0504     107.5952       0.1854       2.9416       0.0000    2566.8042    1347.0000
  475.6404      96.0000      98.3637       0.0526     106.1939       0.1875       2.9080       0.0000    2563.1563    1344.0000
  475.7928      96.0000      98.5846       0.0524     105.0903       0.1873       3.1661       0.0000    2563.6182    1347.0000
  475.9452      96.0000      98.5847       0.0540     100.4754       0.1876       3.1381       0.0000    2560.9739    1340.0000
  476.0976      96.0000      98.7310       0.0640     104.7859       0.1861       3.1556       0.0000    2544.3821    1348.0000
  476.2500      96.0000      98.3557       0.0762     104.6316       0.1834       2.9637       0.0000    2524.2158    1341.0000
  476.4024      96.0000      98.7814       0.0916     114.5670       0.1749       3.0730       0.0000    2498.8218    1349.0000
  476.5548      96.0000      98.9598       0.0980     110.8723       0.1768       2.9363       0.0000    2488.2961    1341.0000
  476.7072      96.0000      98.8293       0.1012     111.4876       0.1819       2.9456       0.0000    2483.0261    1350.0000
  476.8596      96.0000      98.4781       0.1035      95.4128       0.1807       3.0830       0.0000    2479.1514    1348.0000
  477.0120      96.0000      98.7691       0.0968      92.3339       0.1757       3.1239       0.0000    2490.2478    1340.0000
  477.1644      96.0000      98.8215       0.0892      85.8730       0.1617       3.1873       0.0000    2502.8027    1352.0000
  477.3168      96.0000      99.0580       0.0780      89.8588       0.1527       2.9969       0.0000    2521.2686    1345.0000
  477.4692      96.0000      98.3401       0.0667      87.9362       0.1464       3.0332       0.0000    2539.9810    1359.0000
  477.6216      96.0000      98.6165       0.0593      83.3398       0.1393       3.0422       0.0000    2552.1980    1354.0000
  477.7740      96.0000      98.5846       0.0594      81.4938       0.1351       3.1908       0.0000    2551.9229    1341.0000
  477.9264      96.0000      98.2954       0.0691      77.5664       0.1398       3.2989       0.0000    2535.9165    1357.0000
  478.0788      96.0000      98.2493       0.0790      75.5081       0.1473       3.3784       0.0000    2519.6897    1340.0000
  478.2312      96.0000      98.6767       0.0837      65.6630       0.1585       3.3999       0.0000    2511.8464    1363.0000
  478.3836      96.0000      98.5446       0.0732      67.8182       0.1624       3.4272       0.0000    2529.2144    1335.0000
  478.5360      96.0000      98.7973       0.0516      72.0116       0.1576       3.3273       0.0000    2564.8582    1362.0000
  478.6884      96.0000      98.4158       0.0349      88.9515       0.1557       3.1679       0.0000    2592.4639    1331.0000
  478.8408      96.0000      98.5923       0.0266      98.8040       0.1493       3.1082       0.0000    2606.1025    1362.0000
  478.9932      96.0000      98.5844       0.0241     104.9572       0.1494       3.2560       0.0000    2610.1777    1334.0000
  479.1456      96.0000      98.4783       0.0185     104.3507       0.1394       3.6683       0.0000    2619.5078    1365.0000
  479.2980      96.0000      98.3717       0.0152     102.0573       0.1302       3.8574       0.0000    2624.9629    1354.0000
  479.4504      96.0000      98.3558       0.0085     101.7741       0.1300       3.8482       0.0000    2635.9761    1372.0000
  479.6028      96.0000      98.5923       0.0085     101.1315       0.1274       3.6790       0.0000    2636.0264    1361.0000
  479.7552      96.0000      98.5846       0.0014      91.4171       0.1265       3.6781       0.0000    2647.7551    1359.0000
  479.9076      96.0000      98.5927       0.0073      91.9562       0.1235       3.7183       0.0000    2638.0020    1351.0000
  480.0600      96.0000      98.5243       0.0071      94.1098       0.1236       3.7392       0.0000    2638.2424    1343.0000
  480.2124      96.0000      98.4322       0.0120     101.4992       0.1242       3.6885       0.0000    2630.2019    1359.0000
  480.3648      96.0000      98.4302       0.0173     102.1663       0.1238       3.4420       0.0000    2621.4590    1343.0000
  480.5172      96.0000      98.7692       0.0255      93.7374       0.1259       3.3371       0.0000    2607.9202    1361.0000
  480.6696      96.0000      98.4302       0.0325      95.8927       0.1318       3.3016       0.0000    2596.4385    1340.0000
  480.8220      96.0000      98.3558       0.0374      94.9697       0.1379       3.3550       0.0000    2588.2949    1376.0000
  480.9744      96.0000      98.3717       0.0404      93.2665       0.1403       3.2216       0.0000    2583.3325    1336.0000
  481.1268      96.0000      98.5446       0.0329      96.5417       0.1397       3.1346       0.0000    2595.7896    1371.0000
  481.2792      96.0000      98.2033       0.0203      95.6188       0.1347       3.0874       0.0000    2616.5381    1344.0000
  481.4316      96.0000      98.6829       0.0069      93.7520       0.1249       3.1223       0.0000    2638.5684    1362.0000
  481.5840      96.0000      99.2106       0.0056      91.0159       0.1166       3.1938       0.0000    2640.7278    1336.0000
  481.7364      96.0000      98.7211       0.0036      86.1136       0.1130       3.4056       0.0000    2643.9988    1377.0000
  481.8888      96.0000      99.1400       0.0017      85.8060       0.1151       3.4016       0.0000    2647.2170    1331.0000
  482.0412      96.0000      99.1181       0.0023      82.4959       0.1199       3.5958       0.0000    2646.2280    1368.0000
  482.1936      96.0000      99.0016       0.0009      87.0905       0.1208       3.5172       0.0000    2648.5813    1347.0000
  482.3460      96.0000      98.2794       0.0101     100.8865       0.1286       3.5571       0.0000    2633.3699    1352.0000
  482.4984      96.0000      98.2033       0.0118     108.2759       0.1403       3.3394       0.0000    2630.5491    1349.0000
  482.6508      96.0000      97.8822       0.0124     107.0453       0.1483       3.2461       0.0000    2629.6025    1355.0000
  482.8032      96.0000      98.0507       0.0075     111.7419       0.1569       3.2826       0.0000    2637.6448    1330.0000
  482.9556      96.0000      98.6829       0.0078     114.1609       0.1631       3.2911       0.0000    2637.1770    1347.0000
  483.1080      96.0000      98.8132       0.0119     124.3137       0.1727       3.2957       0.0000    2630.3318    1350.0000
  483.2604      96.0000      98.8134       0.0148     115.0770       0.1748       3.3218       0.0000    2625.5842    1352.0000
  483.4128      96.0000      99.1643       0.0146     114.4760       0.1679       3.3689       0.0000    2625.8384    1358.0000
  483.5652      96.0000      99.3906       0.0219     117.3009       0.1658       3.4553       0.0000    2613.8337    1347.0000
  483.7176      96.0000      99.0500       0.0279     123.7357       0.1702       3.3877       0.0000    2603.9919    1375.0000
  483.8700      96.0000      99.2705       0.0263     129.9228       0.1723       3.2612       0.0000    2606.6575    1310.0000
  484.0224      96.0000      99.7277       0.0206     131.6329       0.1688       3.1886       0.0000    2615.9929    1358.0000
  484.1748      96.0000      99.3444       0.0184     135.3248       0.1742       3.2278       0.0000    2619.5874    1314.0000
  484.3272      96.0000      99.4990       0.0124     140.5590       0.1827       3.3796       0.0000    2629.5554    1348.0000
  484.4796      96.0000      99.4586       0.0116     145.5616       0.1933       3.5418       0.0000    2630.7913    1341.0000
  484.6320      96.0000      99.5154       0.0094     155.1399       0.1995       3.5821       0.0000    2634.4165    1366.0000
  484.7844      96.0000      99.7275       0.0106     153.5540       0.2057       3.5688       0.0000    2632.4685    1356.0000
  484.9368      96.0000      99.7112       0.0091     150.4774       0.2166       3.4792       0.0000    2634.9844    1352.0000
  485.0892      96.0000      99.9394       0.0086     153.2484       0.2148       3.5338       0.0000    2635.8792    1369.0000
  485.2416      96.0000      99.9888       0.0051     152.1825       0.2246       3.5431       0.0000    2641.6055    1350.0000
  485.3940      96.0000     100.0754       0.0018     154.0652       0.2212       3.5416       0.0000    2647.1030    1355.0000
  485.5464      96.0000      99.7439       0.0058     144.8284       0.2151       3.6715       0.0000    2640.4470    1354.0000
  485.6988      96.0000     100.0537       0.0048     141.2891       0.2017       3.6990       0.0000    2642.1155    1361.0000
  485.8512      96.0000      99.4830       0.0034     131.6662       0.1988       3.6245       0.0000    2644.4512    1363.0000
  486.0036      96.0000      99.5970       0.0075     128.5536       0.1890       3.4822       0.0000    2637.6558    1354.0000
  486.1560      96.0000      99.7440       0.0054     125.8158       0.1753       3.3598       0.0000    2641.1133    1356.0000
  486.3084      96.0000      99.6215       0.0005     136.6327       0.1651       3.5300       0.0000    2649.2192    1361.0000
  486.4608      96.0000      99.4393      -0.0003     131.3881       0.1650       3.4287       0.0000    2650.4131    1348.0000
  486.6132      96.0000      99.6515      -0.0026     136.9301       0.1700       3.6796       0.0000    2654.3726    1365.0000
  486.7656      96.0000      98.9116       0.0007     124.3160       0.1668       3.6642       0.0000    2648.9272    1340.0000
  486.9180      96.0000      98.9337      -0.0013     120.6654       0.1601       3.6148       0.0000    2652.0896    1350.0000
  487.0704      96.0000      98.6769       0.0028     109.5543       0.1414       3.5004       0.0000    2645.4583    1355.0000
  487.2228      96.0000      98.8454       0.0051      96.9869       0.1260       3.3897       0.0000    2641.6497    1349.0000
  487.3752      96.0000      98.6006       0.0103      83.1318       0.1090       3.4614       0.0000    2633.0308    1365.0000
  487.5276      96.0000      98.5924       0.0122      68.3640       0.0993       3.5736       0.0000    2629.7913    1354.0000
  487.6800      96.0000      98.4322       0.0139      60.3309       0.0874       3.5226       0.0000    2627.0637    1363.0000
  487.8324      96.0000      98.5846       0.0121      57.6414       0.0846       3.4481       0.0000    2629.9734    1357.0000
  487.9848      96.0000      98.4780       0.0122      57.9652       0.0900       3.3456       0.0000    2629.9263    1358.0000
  488.1372      96.0000      98.1271       0.0087      58.2601       0.0977       3.3788       0.0000    2635.6960    1349.0000
  488.2896      96.0000      98.5926       0.0022      61.2575       0.1061       3.4215       0.0000    2646.3479    1377.0000
  488.4420      96.0000      98.5525      -0.0008      69.8026       0.1171       3.4997       0.0000    2651.3479    1351.0000
  488.5944      96.0000      98.6768      -0.0013      97.7997       0.1391       3.7216       0.0000    2652.0940    1366.0000
  488.7468      96.0000      99.1646      -0.0014     114.7338       0.1642       4.0786       0.0000    2652.3430    1371.0000
  488.8992      96.0000      99.5154      -0.0020     126.3623       0.1808       4.1652       0.0000    2653.3499    1357.0000
  489.0516      96.0000      99.8500      -0.0032     124.2087       0.1896       4.1603       0.0000    2655.2080    1371.0000
  489.2040      96.0000      99.3305      -0.0033     124.5166       0.1938       4.0686       0.0000    2655.5042    1363.0000
  489.3564      96.0000      99.4828       0.0035     127.0938       0.2018       3.7719       0.0000    2644.2576    1366.0000
  489.5088      96.0000      99.7603       0.0122     128.3244       0.2045       3.5280       0.0000    2629.8928    1376.0000
  489.6612      96.0000      99.5754       0.0145     137.8978       0.1997       3.4917       0.0000    2626.1201    1357.0000
  489.8136      96.0000      99.3686       0.0129     141.2821       0.1917       3.5983       0.0000    2628.6931    1394.0000
  489.9660      96.0000      99.3905       0.0041     143.7434       0.1842       3.4738       0.0000    2643.2339    1345.0000
  490.1184      96.0000      99.1400       0.0015     129.6797       0.1715       3.3889       0.0000    2647.4666    1398.0000
  490.2708      96.0000      98.6609      -0.0018     120.1708       0.1626       3.3114       0.0000    2652.9370    1343.0000
  490.4232      96.0000      98.8134       0.0059     107.5567       0.1545       3.4777       0.0000    2640.2253    1383.0000
  490.5756      96.0000      98.5020       0.0065     112.9707       0.1583       3.3454       0.0000    2639.2917    1358.0000
  490.7280      96.0000      98.7532       0.0101     122.3324       0.1618       3.4274       0.0000    2633.2527    1391.0000
  490.8804      96.0000      99.3143       0.0065     135.8695       0.1652       3.3773       0.0000    2639.3103    1350.0000
  491.0328      96.0000      99.3929       0.0054     137.4090       0.1708       3.4513       0.0000    2641.1719    1389.0000
  491.1852      96.0000      99.4991       0.0039     125.5573       0.1637       3.4938       0.0000    2643.6353    1366.0000
  491.3376      96.0000      99.2542       0.0027     119.2539       0.1583       3.5645       0.0000    2645.5623    1365.0000
  491.4900      96.0000      99.1344       0.0035     122.6407       0.1511       3.5985       0.0000    2644.1748    1350.0000
  491.6424      96.0000      98.8134       0.0156     126.9430       0.1549       3.3948       0.0000    2624.2727    1345.0000
  491.7948      96.0000      98.8213       0.0191     133.9212       0.1655       3.3856       0.0000    2618.4558    1368.0000
  491.9472      96.0000      98.9818       0.0197     142.5286       0.1755       3.4066       0.0000    2617.4502    1344.0000
  492.0996      96.0000      99.0259       0.0186     155.0767       0.1827       3.6311       0.0000    2619.2827    1368.0000
  492.2520      96.0000      99.0259       0.0160     151.2450       0.1907       3.6768       0.0000    2623.6072    1331.0000
  492.4044      96.0000      99.3928       0.0099     139.5480       0.1962       3.6677       0.0000    2633.6055    1378.0000
  492.5568      96.0000      99.0259       0.0038     128.4614       0.1962       3.6077       0.0000    2643.7231    1334.0000
  492.7092      96.0000      99.4391       0.0029     127.8239       0.1880       3.5407       0.0000    2645.1731    1383.0000
  492.8616      96.0000      99.4173       0.0160     129.4083       0.1827       3.4970       0.0000    2623.5366    1354.0000
  493.0140      96.0000      99.6514       0.0177     136.7714       0.1827       3.4504       0.0000    2620.7734    1377.0000
  493.1664      96.0000      99.4067       0.0157     136.3830       0.1829       3.4702       0.0000    2624.0852    1359.0000
  493.3188      96.0000      99.2544       0.0055     132.7464       0.1836       3.5130       0.0000    2640.8542    1382.0000
  493.4712      96.0000      99.5265       0.0041     124.5624       0.1820       3.5895       0.0000    2643.2319    1357.0000
  493.6236      96.0000      99.1886       0.0001     120.6635       0.1791       3.7444       0.0000    2649.8721    1384.0000
  493.7760      96.0000      99.2106      -0.0013     123.7199       0.1738       3.8989       0.0000    2652.0701    1364.0000
  493.9284      96.0000      99.2704      -0.0035     119.0698       0.1702       3.8683       0.0000    2655.8533    1368.0000
  494.0808      96.0000      99.2788      -0.0006     123.5624       0.1742       3.6471       0.0000    2651.0505    1382.0000
  494.2332      96.0000      99.1945      -0.0012     125.0206       0.1778       3.5252       0.0000    2652.0291    1385.0000
  494.3856      96.0000      99.0501       0.0035     135.4109       0.1825       3.5513       0.0000    2644.2849    1352.0000
  494.5380      96.0000      99.1019       0.0150     137.4620       0.1852       3.6781       0.0000    2625.2073    1391.0000
  494.6904      96.0000      99.1886       0.0168     135.6151       0.1885       3.7757       0.0000    2622.3564    1372.0000
  494.8428      96.0000      99.2383       0.0151     127.8227       0.1901       3.7825       0.0000    2625.0110    1372.0000
  494.9952      96.0000      99.0257       0.0127     125.7937       0.1887       3.7838       0.0000    2629.0940    1377.0000
  495.1476      96.0000      99.2788       0.0124     122.3184       0.1816       3.7041       0.0000    2629.5222    1351.0000
  495.3000      96.0000      99.3629       0.0077     130.5268       0.1791       3.5452       0.0000    2637.2688    1379.0000
  495.4524      96.0000      98.9336       0.0068     125.3771       0.1767       3.5203       0.0000    2638.7534    1369.0000
  495.6048      96.0000      98.6829       0.0065     131.7253       0.1803       3.4792       0.0000    2639.3547    1377.0000
  495.7572      96.0000      98.9659       0.0111     131.5201       0.1804       3.5069       0.0000    2631.6338    1371.0000
  495.9096      96.0000      99.2788       0.0149     138.1063       0.1753       3.5027       0.0000    2625.3931    1383.0000
  496.0620      96.0000      99.2868       0.0197     137.0578       0.1725       3.4523       0.0000    2617.4541    1363.0000
  496.2144      96.0000      98.8294       0.0216     134.1532       0.1694       3.4314       0.0000    2614.3381    1385.0000
  496.3668      96.0000      98.7973       0.0162     131.4854       0.1692       3.2519       0.0000    2623.3215    1344.0000
  496.5192      96.0000      98.8132       0.0117     129.4344       0.1653       3.2616       0.0000    2630.7207    1383.0000
  496.6716      96.0000      99.2544       0.0040     127.1254       0.1613       3.2071       0.0000    2643.4712    1361.0000
  496.8240      96.0000      98.7532       0.0076     120.7639       0.1602       3.2972       0.0000    2637.4788    1376.0000
  496.9764      96.0000      98.8216       0.0040     117.6873       0.1633       3.1781       0.0000    2643.4561    1375.0000
  497.1288      96.0000      98.6611       0.0091     123.1060       0.1652       3.3106       0.0000    2634.9175    1384.0000
  497.2812      96.0000      98.8455       0.0101     125.3634       0.1688       3.2802       0.0000    2633.3984    1366.0000
  497.4336      96.0000      98.6833       0.0158     131.5380       0.1778       3.4576       0.0000    2623.9004    1391.0000
  497.5860      96.0000      98.8133       0.0133     132.5641       0.1858       3.4208       0.0000    2627.9878    1362.0000
  497.7384      96.0000      98.5527       0.0134     140.9777       0.1894       3.4980       0.0000    2627.8511    1385.0000
  497.8908      96.0000      98.5926       0.0139     142.0053       0.1849       3.3186       0.0000    2627.0632    1362.0000
  498.0432      96.0000      98.8132       0.0219     138.6996       0.1787       3.1973       0.0000    2613.7937    1371.0000
  498.1956      96.0000      98.7070       0.0287     124.3349       0.1731       3.2180       0.0000    2602.6082    1364.0000
  498.3480      96.0000      99.2867       0.0294     111.9602       0.1556       3.3097       0.0000    2601.4805    1384.0000
  498.5004      96.0000      99.3630       0.0369     107.0574       0.1485       3.3745       0.0000    2589.1880    1378.0000
  498.6528      96.0000      99.1886       0.0404     107.0574       0.1485       3.2605       0.0000    2583.3145    1389.0000
  498.8052      96.0000      98.7532       0.0364     106.2881       0.1625       3.3725       0.0000    2589.8699    1379.0000
  498.9576      96.0000      98.6590       0.0214     110.5976       0.1683       3.5452       0.0000    2614.6284    1384.0000
  499.1100      96.0000      99.0259       0.0161     131.1185       0.1703       3.7356       0.0000    2623.3904    1384.0000
  499.2624      96.0000      99.3792       0.0123     145.8799       0.1787       3.6192       0.0000    2629.6978    1366.0000
  499.4148      96.0000      99.0742       0.0249     143.5265       0.1825       3.4121       0.0000    2608.9202    1396.0000
  499.5672      96.0000      99.4229       0.0327     121.5691       0.1726       3.2317       0.0000    2596.0203    1366.0000
  499.7196      96.0000      99.1159       0.0452     107.8269       0.1556       3.3054       0.0000    2575.4170    1399.0000
  499.8720      96.0000      98.8293       0.0487      96.4312       0.1428       3.2725       0.0000    2569.7166    1364.0000
  500.0244      96.0000      98.4319       0.0534      91.9166       0.1383       3.3950       0.0000    2561.9553    1389.0000
  500.1768      96.0000      98.5926       0.0553      83.5891       0.1311       3.4177       0.0000    2558.8271    1364.0000
  500.3292      96.0000      98.5083       0.0503      75.1755       0.1259       3.4042       0.0000    2567.0322    1385.0000
  500.4816      96.0000      98.8454       0.0488      78.0484       0.1215       3.3129       0.0000    2569.4744    1347.0000
  500.6340      96.0000      98.7973       0.0459      81.0579       0.1231       3.0933       0.0000    2574.2568    1365.0000
  500.7864      96.0000      99.1620       0.0476      89.0462       0.1262       3.1064       0.0000    2571.4441    1359.0000
  500.9388      96.0000      98.6590       0.0434      89.2514       0.1254       3.0866       0.0000    2578.4131    1358.0000
  501.0912      96.0000      98.7532       0.0401      90.8723       0.1192       3.1009       0.0000    2583.8501    1371.0000
  501.2436      96.0000      98.1111       0.0467      85.5395       0.1102       3.0124       0.0000    2572.8875    1372.0000
  501.3960      96.0000      98.2033       0.0498      88.0021       0.1077       2.9393       0.0000    2567.7844    1370.0000
  501.5484      96.0000      98.2796       0.0422      81.8331       0.1071       2.9508       0.0000    2580.3982    1380.0000
  501.7008      96.0000      98.4783       0.0311      86.7703       0.1127       3.0699       0.0000    2598.7307    1386.0000
  501.8532      96.0000      98.7972       0.0248      81.6401       0.1231       3.1611       0.0000    2609.0715    1376.0000
  502.0056      96.0000      99.0501       0.0194      96.8591       0.1386       3.3617       0.0000    2618.0454    1385.0000
  502.1580      96.0000      98.9335       0.0187     106.8947       0.1547       3.4385       0.0000    2619.2141    1380.0000
  502.3104      96.0000      99.1782       0.0134     119.8164       0.1667       3.4581       0.0000    2627.8914    1372.0000
  502.4628      96.0000      98.7973       0.0140     123.7153       0.1652       3.2870       0.0000    2626.9302    1375.0000
  502.6152      96.0000      98.6449       0.0187     121.8694       0.1669       2.9429       0.0000    2619.2036    1379.0000
  502.7676      96.0000      98.7069       0.0254     123.1072       0.1761       2.8016       0.0000    2608.0698    1382.0000
  502.9200      96.0000      98.6004       0.0288     115.1040       0.1914       2.8029       0.0000    2602.4419    1390.0000
  503.0724      96.0000      99.3907       0.0350     125.5885       0.2074       3.2740       0.0000    2592.1846    1356.0000
  503.2248      96.0000      99.4828       0.0397     137.4640       0.2188       3.7717       0.0000    2584.5764    1411.0000
  503.3772      96.0000     100.3968       0.0527     152.7217       0.2350       3.7940       0.0000    2563.0500    1368.0000
  503.5296      96.0000     105.5382       0.0556     154.5436       0.2478       3.6305       0.0000    2558.1924    1405.0000
  503.6820      96.0000     108.6240       0.0327     148.0036       0.2570       3.5381       0.0000    2595.9685    1372.0000
  503.8344      96.0000     101.5615       0.0112     148.5808       0.2593       3.5881       0.0000    2631.5044    1391.0000
  503.9868      96.0000      99.4067      -0.0002     144.0684       0.2411       3.8628       0.0000    2650.2949    1377.0000
  504.1392      96.0000      99.1945       0.0052     142.2215       0.2201       3.6852       0.0000    2641.3755    1407.0000
  504.2916      96.0000      99.2544       0.0122     129.0543       0.2003       3.6289       0.0000    2629.8057    1364.0000
  504.4440      96.0000      98.9657       0.0297     117.1748       0.2015       3.2762       0.0000    2600.9302    1413.0000
  504.5964      96.0000      98.8875       0.0332     112.8451       0.2033       3.2898       0.0000    2595.2446    1369.0000
  504.7488      96.0000      98.8668       0.0284     121.3944       0.2009       3.3919       0.0000    2603.1428    1398.0000
  504.9012      96.0000      99.0742       0.0255     130.0132       0.1979       3.4647       0.0000    2607.9956    1356.0000
  505.0536      96.0000      98.9808       0.0352     129.1927       0.1897       3.3676       0.0000    2591.9219    1441.0000
  505.2060      96.0000      98.9356       0.0406     115.7184       0.1781       3.2102       0.0000    2582.9739    1378.0000
  505.3584      96.0000      98.6378       0.0463     105.8684       0.1558       3.0901       0.0000    2573.6738    1421.0000
  505.5108      96.0000      99.0829       0.0438      96.8590       0.1388       3.0810       0.0000    2577.6909    1373.0000
  505.6632      96.0000      99.4135       0.0426      93.9636       0.1270       3.0772       0.0000    2579.6584    1384.0000
  505.8156      96.0000      99.5642       0.0434      92.7323       0.1198       3.2368       0.0000    2578.4373    1400.0000
  505.9680      96.0000      98.9235       0.0514      98.2548       0.1172       3.3159       0.0000    2565.1680    1369.0000
  506.1204      96.0000      98.0085       0.0495     105.0039       0.1234       3.3817       0.0000    2568.3303    1404.0000
  506.2728      96.0000      98.0087       0.0390     108.4924       0.1335       3.3556       0.0000    2585.6978    1369.0000
  506.4252      96.0000      98.3637       0.0245     112.7997       0.1404       3.5077       0.0000    2609.5234    1413.0000
  506.5776      96.0000      98.1801       0.0118     114.2816       0.1464       3.6969       0.0000    2630.4565    1386.0000
  506.7300      96.0000      98.1467       0.0122     114.2816       0.1477       3.9474       0.0000    2629.8542    1368.0000
  506.8824      96.0000      98.4662       0.0204     104.0414       0.1443       3.8047       0.0000    2616.3921    1394.0000
  507.0348      96.0000      98.5234       0.0242      97.9260       0.1375       3.5892       0.0000    2610.0383    1407.0000
  507.1872      96.0000      98.4663       0.0283      94.2323       0.1397       3.4120       0.0000    2603.3564    1390.0000
  507.3396      96.0000      98.3780       0.0346      95.6687       0.1539       3.2943       0.0000    2592.8750    1368.0000
  507.4920      96.0000      98.9808       0.0323      97.2521       0.1647       3.4028       0.0000    2596.6787    1370.0000
  507.6444      96.0000      98.4996       0.0271     103.7990       0.1775       3.4287       0.0000    2605.2327    1378.0000
  507.7968      96.0000      98.7521       0.0266     110.1415       0.1871       3.6242       0.0000    2606.1121    1394.0000
  507.9492      96.0000      98.5806       0.0331     114.2630       0.1994       3.5022       0.0000    2595.3240    1390.0000
  508.1016      96.0000      98.8784       0.0402     112.6411       0.2002       3.3691       0.0000    2583.6187    1407.0000
  508.2540      96.0000      99.0378       0.0430     114.3019       0.2010       3.2409       0.0000    2579.0391    1387.0000
  508.4064      96.0000      98.9808       0.0372     111.4110       0.2009       3.1744       0.0000    2588.6345    1378.0000
  508.5588      96.0000      98.8093       0.0289     116.8811       0.2016       3.3644       0.0000    2602.3230    1386.0000
  508.7112      96.0000      98.9928       0.0248     116.0603       0.2024       3.3197       0.0000    2609.0784    1382.0000
  508.8636      96.0000      98.7975       0.0306     114.8297       0.2000       3.3301       0.0000    2599.5024    1410.0000
  509.0160      96.0000      98.9477       0.0475     108.3335       0.1916       3.1101       0.0000    2571.6802    1379.0000
  509.1684      96.0000      98.6830       0.0790     100.5147       0.1740       2.9603       0.0000    2519.6079    1364.0000
  509.3208      96.0000      98.3970       0.0959      90.0542       0.1618       2.8116       0.0000    2491.7354    1384.0000
  509.4732      96.0000      98.3066       0.0921      83.2823       0.1562       2.8382       0.0000    2498.0784    1390.0000
  509.6256      96.0000      98.3518       0.0794      79.6093       0.1507       3.0174       0.0000    2518.9563    1396.0000
  509.7780      96.0000      97.9393       0.0662      88.2402       0.1452       3.1467       0.0000    2540.6956    1380.0000
  509.9304      96.0000      98.0658       0.0609      96.6809       0.1473       3.1724       0.0000    2549.4448    1378.0000
  510.0828      96.0000      98.1395       0.0532     100.5799       0.1655       3.0755       0.0000    2562.2344    1396.0000
  510.2352      96.0000      98.2708       0.0426     100.1533       0.1740       3.0371       0.0000    2579.6494    1401.0000
  510.3876      96.0000      98.3518       0.0252     110.3867       0.1774       3.1927       0.0000    2608.4749    1373.0000
  510.5400      96.0000      98.9687       0.0213     122.4941       0.1850       3.3046       0.0000    2614.8967    1362.0000
  510.6924      96.0000      98.9478       0.0414     132.9760       0.2073       3.4699       0.0000    2581.7007    1384.0000
  510.8448      96.0000      98.9357       0.0680     127.9353       0.2222       3.3118       0.0000    2537.8118    1384.0000
  510.9972      96.0000      99.2096       0.0878     125.4728       0.2187       3.3329       0.0000    2505.1475    1401.0000
  511.1496      96.0000      98.6949       0.0876     126.4989       0.2084       3.3149       0.0000    2505.4426    1385.0000
  511.3020      96.0000      98.8544       0.0850     130.7300       0.1955       3.5250       0.0000    2509.6865    1396.0000
  511.4544      96.0000      99.1314       0.0831     123.3424       0.1877       3.6268       0.0000    2512.8628    1394.0000
  511.6068      96.0000      98.8093       0.0863     118.8081       0.1797       3.7146       0.0000    2507.5835    1373.0000
  511.7592      96.0000      98.6710       0.0841     105.6633       0.1778       3.5480       0.0000    2511.2117    1419.0000
  511.9116      96.0000      98.9355       0.0795     100.7383       0.1744       3.4734       0.0000    2518.8523    1412.0000
  512.0640      96.0000      98.8996       0.0723      97.6798       0.1696       3.3668       0.0000    2530.7437    1386.0000
  512.2164      96.0000      98.9236       0.0674     101.3555       0.1720       3.4757       0.0000    2538.8135    1389.0000
  512.3688      96.0000      98.8665       0.0733     103.9896       0.1756       3.3439       0.0000    2529.0945    1391.0000
  512.5212      96.0000      98.5228       0.0744     101.7323       0.1873       3.3183       0.0000    2527.3162    1414.0000
  512.6736      96.0000      98.3971       0.0772      96.6046       0.1874       3.1262       0.0000    2522.5620    1396.0000
  512.8260      96.0000      98.4330       0.0728      91.9184       0.1857       3.1378       0.0000    2529.9539    1379.0000
  512.9784      96.0000      98.3399       0.0626      90.6871       0.1765       3.1611       0.0000    2546.6846    1401.0000
  513.1308      96.0000      98.5235       0.0456      99.5267       0.1666       3.2576       0.0000    2574.7007    1413.0000
  513.2832      96.0000      98.5353       0.0366     107.2755       0.1628       3.4284       0.0000    2589.5901    1403.0000
  513.4356      96.0000      98.4663       0.0282     111.3797       0.1620       3.6481       0.0000    2603.4075    1392.0000
  513.5880      96.0000      98.5353       0.0240     107.9053       0.1658       3.7615       0.0000    2610.3625    1396.0000
  513.7404      96.0000      99.0050       0.0167     112.4692       0.1696       3.8202       0.0000    2622.4504    1413.0000
  513.8928      96.0000      98.9237       0.0177     116.5734       0.1841       3.5988       0.0000    2620.8708    1410.0000
  514.0452      96.0000      99.2422       0.0161     124.1299       0.1899       3.5887       0.0000    2623.4985    1391.0000
  514.1976      96.0000      99.4380       0.0139     124.9507       0.1830       3.5231       0.0000    2627.1238    1392.0000
  514.3500      96.0000      99.2666       0.0136     127.5868       0.1657       3.6859       0.0000    2627.5254    1393.0000
  514.5024      96.0000      99.0257       0.0059     123.2795       0.1523       3.5624       0.0000    2640.2649    1403.0000
  514.6548      96.0000      98.8215       0.0079     125.7421       0.1368       3.6821       0.0000    2636.9695    1405.0000
  514.8072      96.0000      98.6378       0.0101     114.4872       0.1177       3.7330       0.0000    2633.3958    1391.0000
  514.9596      96.0000      98.4781       0.0198     109.5820       0.1074       3.7117       0.0000    2617.2942    1414.0000
  515.1120      96.0000      98.2375       0.0264      96.2289       0.1086       3.5636       0.0000    2606.4482    1383.0000
  515.2644      96.0000      98.5924       0.0274      93.2452       0.1142       3.3256       0.0000    2604.7712    1370.0000
  515.4168      96.0000      98.5971       0.0199      89.7566       0.1249       3.4314       0.0000    2617.1641    1382.0000
  515.5692      96.0000      98.5234       0.0125      98.9864       0.1391       3.3258       0.0000    2629.3730    1398.0000
  515.7216      96.0000      98.5686       0.0121     112.6411       0.1645       3.4129       0.0000    2629.9700    1405.0000
  515.8740      96.0000      98.5353       0.0127     127.6214       0.1891       3.3564       0.0000    2629.0352    1400.0000
  516.0264      96.0000      98.5594       0.0106     134.8600       0.2071       3.5266       0.0000    2632.4854    1364.0000
  516.1788      96.0000      98.9687       0.0043     132.3975       0.2184       3.4573       0.0000    2642.9114    1376.0000
  516.3312      96.0000      99.4379       0.0019     132.1923       0.2225       3.4987       0.0000    2646.9265    1394.0000
  516.4836      96.0000      99.4379      -0.0010     137.9620       0.2335       3.4453       0.0000    2651.6560    1385.0000
  516.6360      96.0000      99.8947      -0.0082     150.0694       0.2432       3.6690       0.0000    2663.4756    1408.0000
  516.7884      96.0000      99.4380      -0.0119     156.6361       0.2468       3.6605       0.0000    2669.5801    1421.0000
  516.9408      96.0000      99.7561      -0.0052     156.3445       0.2377       3.6629       0.0000    2658.6184    1404.0000
  517.0932      96.0000      99.2665       0.0031     153.2484       0.2255       3.7104       0.0000    2644.8284    1389.0000
  517.2456      96.0000      98.9117       0.0093     141.5515       0.2089       3.6221       0.0000    2634.6082    1419.0000
  517.3980      96.0000      99.0380       0.0107     129.8604       0.1910       3.7024       0.0000    2632.3167    1413.0000
  517.5504      96.0000      98.7522       0.0134     123.9272       0.1697       3.5122       0.0000    2627.8220    1401.0000
  517.7028      96.0000      98.8213       0.0188     118.7969       0.1545       3.5423       0.0000    2618.9670    1401.0000
  517.8552      96.0000      98.7399       0.0164     119.2269       0.1438       3.2915       0.0000    2622.9470    1393.0000
  518.0076      96.0000      98.7070       0.0206     109.9752       0.1345       3.2692       0.0000    2615.9924    1396.0000
  518.1600      96.0000      98.3494       0.0170     108.5057       0.1300       3.2758       0.0000    2621.8682    1377.0000
  518.3124      96.0000      98.4330       0.0167     102.7429       0.1276       3.4624       0.0000    2622.5010    1372.0000
  518.4648      96.0000      98.3065       0.0141     105.9981       0.1255       3.3836       0.0000    2626.7690    1394.0000
  518.6172      96.0000      98.5472       0.0131     111.5718       0.1261       3.3425       0.0000    2628.4182    1396.0000
  518.7696      96.0000      98.7973       0.0095     111.3667       0.1322       3.2737       0.0000    2634.2654    1391.0000
  518.9220      96.0000      98.8094       0.0040     108.1288       0.1373       3.5897       0.0000    2643.3701    1394.0000
  519.0744      96.0000      98.4662       0.0011     105.0506       0.1421       3.8491       0.0000    2648.1338    1376.0000
  519.2268      96.0000      98.8664      -0.0019     112.7627       0.1511       4.1252       0.0000    2653.1975    1401.0000
  519.3792      96.0000      98.9237      -0.0049     114.4044       0.1702       4.2794       0.0000    2658.0159    1419.0000
  519.5316      96.0000      98.5926      -0.0002     118.3034       0.1885       4.4116       0.0000    2650.3271    1391.0000
  519.6840      96.0000      99.2544      -0.0021     122.0999       0.1991       4.4846       0.0000    2653.5183    1391.0000
  519.8364      96.0000      99.0258       0.0007     128.6452       0.1989       4.0447       0.0000    2648.7661    1398.0000
  519.9888      96.0000      99.1071       0.0047     132.7495       0.2012       3.7746       0.0000    2642.2202    1404.0000
  520.1412      96.0000      99.1523       0.0097     136.8537       0.1982       3.3131       0.0000    2633.9399    1366.0000
  520.2936      96.0000      99.2666       0.0149     133.4255       0.1942       3.2236       0.0000    2625.3799    1394.0000
  520.4460      96.0000      99.0501       0.0216     126.8587       0.1838       3.2511       0.0000    2614.4155    1400.0000
  520.5984      96.0000      99.1644       0.0207     115.7774       0.1802       3.4010       0.0000    2615.8599    1419.0000
  520.7508      96.0000      98.9357       0.0212     121.5471       0.1796       3.5418       0.0000    2614.9885    1406.0000
  520.9032      96.0000      99.1073       0.0121     135.2962       0.1871       3.4896       0.0000    2630.0828    1396.0000
  521.0556      96.0000      99.0622       0.0109     141.0421       0.1905       3.6949       0.0000    2632.0911    1417.0000
  521.2080      96.0000      99.6213       0.0091     146.4946       0.1998       3.6041       0.0000    2635.0542    1442.0000
  521.3604      96.0000      99.6395       0.0114     132.3351       0.1965       3.5598       0.0000    2631.2021    1425.0000
  521.5128      96.0000      99.5644       0.0039     129.5776       0.1983       3.4477       0.0000    2643.4856    1396.0000
  521.6652      96.0000      99.2422       0.0024     125.2934       0.1995       3.3519       0.0000    2645.9980    1407.0000
  521.8176      96.0000      99.6094       0.0015     133.5018       0.2102       3.4535       0.0000    2647.5979    1450.0000
  521.9700      96.0000      99.3359       0.0002     140.3636       0.2161       3.7618       0.0000    2649.6682    1417.0000
  522.1224      96.0000     102.4589       0.0016     143.8110       0.2242       3.9068       0.0000    2647.2793    1399.0000
  522.2748      96.0000      99.6539       0.0110     146.2208       0.2299       3.8923       0.0000    2631.8096    1362.0000
  522.4272      96.0000      99.3929       0.0076     143.2267       0.2234       3.4089       0.0000    2637.4695    1411.0000
  522.5796      96.0000      99.8826      -0.0045     143.6783       0.2102       3.4263       0.0000    2657.4441    1434.0000
  522.7320      96.0000      99.9069      -0.0006     139.1942       0.2048       3.4404       0.0000    2650.9443    1434.0000
  522.8844      96.0000     100.1355       0.0045     139.7259       0.2077       3.6309       0.0000    2642.6257    1389.0000
  523.0368      96.0000     100.1109       0.0056     140.2359       0.2100       3.5576       0.0000    2640.8018    1351.0000
  523.1892      96.0000     100.1802       0.0055     143.5413       0.2054       3.4975       0.0000    2640.8716    1387.0000
  523.3416      96.0000     100.3638       0.0059     147.2351       0.2048       3.3903       0.0000    2640.3130    1453.0000
  523.4940      96.0000     100.1478       0.0037     144.0336       0.2026       3.4865       0.0000    2643.9104    1468.0000
  523.6464      96.0000     100.1231       0.0052     136.4409       0.2052       3.2978       0.0000    2641.4985    1352.0000
  523.7988      96.0000     100.0413       0.0025     129.5216       0.2049       3.2384       0.0000    2645.8660    1375.0000
  523.9512      96.0000      99.8580       0.0072     128.0860       0.2067       3.2201       0.0000    2638.1941    1422.0000
  524.1036      96.0000      99.7928       0.0061     139.2412       0.2081       3.4251       0.0000    2639.9622    1457.0000
  524.2560      96.0000      99.7682       0.0086     150.2646       0.2143       3.5858       0.0000    2635.8203    1390.0000
  524.4084      96.0000      99.5644       0.0053     149.2614       0.2163       3.7005       0.0000    2641.3110    1379.0000
  524.5608      96.0000      99.6542       0.0080     146.7612       0.2162       3.5383       0.0000    2636.8181    1405.0000
  524.7132      96.0000      99.5072       0.0094     132.1913       0.2012       3.4642       0.0000    2634.4729    1441.0000
  524.8656      96.0000      99.2095       0.0086     127.0610       0.1873       3.4971       0.0000    2635.8809    1433.0000
  525.0180      96.0000      99.3238       0.0037     117.3606       0.1732       3.6988       0.0000    2643.8508    1368.0000
  525.1704      96.0000      99.4707      -0.0041     120.2336       0.1704       3.7844       0.0000    2656.8140    1373.0000
  525.3228      96.0000      99.3237      -0.0042     117.1554       0.1723       3.5872       0.0000    2656.9348    1396.0000
  525.4752      96.0000      99.2994       0.0043     120.3168       0.1654       3.6456       0.0000    2642.8591    1443.0000
  525.6276      96.0000      99.6990       0.0092     117.2386       0.1599       3.6412       0.0000    2634.7988    1378.0000
  525.7800      96.0000      99.5402       0.0118     117.2386       0.1515       3.6579       0.0000    2630.5591    1377.0000
  525.9324      96.0000      99.5071       0.0077     108.5560       0.1438       3.5606       0.0000    2637.2542    1420.0000
  526.0848      96.0000      99.9520       0.0051     105.3642       0.1329       3.5915       0.0000    2641.5684    1392.0000
  526.2372      96.0000      99.7805       0.0027      97.9766       0.1241       3.6684       0.0000    2645.6272    1398.0000
  526.3896      96.0000      99.6786      -0.0024      92.8464       0.1229       3.8719       0.0000    2654.0234    1426.0000
  526.5420      96.0000      99.0379      -0.0030      78.3796       0.1261       4.0673       0.0000    2654.9785    1426.0000
  526.6944      96.0000      99.2835      -0.0062      77.7640       0.1294       4.0231       0.0000    2660.2307    1411.0000
  526.8468      96.0000      99.1973       0.0042      82.5377       0.1339       3.8222       0.0000    2643.0073    1435.0000
  526.9992      96.0000      99.5521       0.0084     101.2223       0.1455       3.5560       0.0000    2636.1504    1403.0000
  527.1516      96.0000      99.4380       0.0128     116.8182       0.1586       3.5228       0.0000    2628.9482    1415.0000
  527.3040      96.0000      99.3808       0.0102     127.4353       0.1698       3.4447       0.0000    2633.1433    1405.0000
  527.4564      96.0000      99.5970       0.0105     135.6198       0.1746       3.3770       0.0000    2632.7375    1399.0000
  527.6088      96.0000      99.3116       0.0106     132.6635       0.1757       3.4378       0.0000    2632.5864    1425.0000
  527.7612      96.0000      99.1973       0.0062     132.4583       0.1766       3.4963       0.0000    2639.7456    1408.0000
  527.9136      96.0000      99.6542       0.0012     128.5613       0.1783       3.5542       0.0000    2647.9932    1398.0000
  528.0660      96.0000      99.6787       0.0011     131.9280       0.1762       3.2935       0.0000    2648.1118    1412.0000
  528.2184      96.0000      99.4951       0.0059     124.0329       0.1664       3.2766       0.0000    2640.2585    1414.0000
  528.3708      96.0000      99.6419       0.0036     111.3163       0.1584       3.4383       0.0000    2644.0305    1413.0000
  528.5232      96.0000      99.1522       0.0015     105.1600       0.1610       3.8312       0.0000    2647.4519    1380.0000
  528.6756      96.0000      99.3929      -0.0015     107.5143       0.1711       3.8433       0.0000    2652.4258    1407.0000
  528.8280      96.0000      99.2093      -0.0049     120.9572       0.1800       3.7885       0.0000    2658.1665    1432.0000
  528.9804      96.0000      99.4380      -0.0021     122.1885       0.1840       3.6222       0.0000    2653.4729    1438.0000
  529.1328      96.0000      99.2093      -0.0003     123.2146       0.1882       3.5443       0.0000    2650.4382    1407.0000
  529.2852      96.0000      99.1401       0.0069     123.9241       0.1911       3.4024       0.0000    2638.6357    1393.0000
  529.4376      96.0000      99.3458       0.0086     122.5962       0.1954       3.3584       0.0000    2635.8694    1407.0000
  529.5900      96.0000      99.1972       0.0141     127.5213       0.1904       3.2917       0.0000    2626.7957    1431.0000
  529.7424      96.0000      99.1072       0.0163     121.5732       0.1898       3.2189       0.0000    2623.1003    1433.0000
  529.8948      96.0000      99.2666       0.0223     124.5427       0.1835       3.1597       0.0000    2613.2473    1410.0000
  530.0472      96.0000      99.3930       0.0305     120.0281       0.1849       3.1784       0.0000    2599.6042    1403.0000
  530.1996      96.0000      99.3115       0.0382     117.3814       0.1807       3.2467       0.0000    2586.9941    1428.0000
  530.3520      96.0000      99.3116       0.0383     114.5084       0.1804       3.3704       0.0000    2586.7664    1418.0000
  530.5044      96.0000      99.3237       0.0366     114.0980       0.1788       3.4273       0.0000    2589.5767    1401.0000
  530.6568      96.0000      99.3479       0.0303     121.2140       0.1866       3.4937       0.0000    2599.9514    1387.0000
  530.8092      96.0000      99.5195       0.0329     119.3671       0.1916       3.3563       0.0000    2595.7322    1455.0000
  530.9616      96.0000      99.3360       0.0348     120.5984       0.1991       3.3145       0.0000    2592.5007    1424.0000
  531.1140      96.0000      99.3602       0.0360     113.0525       0.2033       3.4047       0.0000    2590.5488    1426.0000
  531.2664      96.0000      99.2093       0.0238     112.4368       0.2099       3.6433       0.0000    2610.6897    1412.0000
  531.4188      96.0000      99.0050       0.0150     120.1397       0.2174       3.7450       0.0000    2625.2151    1391.0000
  531.5712      96.0000      98.9928       0.0037     131.6257       0.2113       3.6725       0.0000    2643.8774    1433.0000
  531.7236      96.0000      99.1366       0.0040     133.8830       0.2018       3.5618       0.0000    2643.3230    1431.0000
  531.8760      96.0000      99.2787       0.0065     122.8982       0.1827       3.4740       0.0000    2639.3037    1396.0000
  532.0284      96.0000      99.1765       0.0203     109.9938       0.1639       3.3938       0.0000    2616.4480    1412.0000
  532.1808      96.0000      99.1970       0.0263     101.1698       0.1496       3.2251       0.0000    2606.5774    1431.0000
  532.3332      96.0000      98.6378       0.0299      89.6303       0.1376       3.2029       0.0000    2600.6274    1439.0000
  532.4856      96.0000      98.5805       0.0265      78.7964       0.1385       3.1579       0.0000    2606.1936    1398.0000
  532.6380      96.0000      98.7523       0.0341      78.9868       0.1411       3.1370       0.0000    2593.7671    1403.0000
  532.7904      96.0000      98.7068       0.0450      82.2696       0.1503       3.0733       0.0000    2575.6980    1445.0000
  532.9428      96.0000      98.8665       0.0647      89.5667       0.1589       3.0050       0.0000    2543.2092    1420.0000
  533.0952      96.0000      98.9238       0.0757      86.5034       0.1669       2.9067       0.0000    2525.0669    1399.0000
  533.2476      96.0000      98.9236       0.0796      88.8076       0.1677       2.8518       0.0000    2518.6797    1412.0000
  533.4000      96.0000      98.6951       0.0767      83.9995       0.1681       2.8345       0.0000    2523.4541    1442.0000
  533.5524      96.0000      99.0170       0.0737      82.9013       0.1645       2.9484       0.0000    2528.4492    1414.0000
  533.7048      96.0000      99.5522       0.0732      81.4648       0.1622       2.9362       0.0000    2529.3010    1438.0000
  533.8572      96.0000      99.3809       0.0767      81.4773       0.1567       2.8907       0.0000    2523.5266    1419.0000
  534.0096      96.0000      99.4830       0.0784      83.7928       0.1584       2.8758       0.0000    2520.7114    1400.0000
  534.1620      96.0000      98.9930       0.0772      82.5402       0.1640       2.9585       0.0000    2522.6287    1432.0000
  534.3144      96.0000      98.4663       0.0794      86.3581       0.1686       3.1376       0.0000    2518.9094    1426.0000
  534.4668      96.0000      98.3637       0.0832      82.6964       0.1688       3.0797       0.0000    2512.6804    1435.0000
  534.6192      96.0000      98.4409       0.0899      82.1020       0.1691       3.1071       0.0000    2501.6794    1414.0000
  534.7716      96.0000      98.2374       0.0953      82.6951       0.1670       2.9832       0.0000    2492.7764    1414.0000
  534.9240      96.0000      98.2040       0.0914      87.6021       0.1600       3.1621       0.0000    2499.2109    1427.0000
  535.0764      96.0000      98.2947       0.0843      85.1061       0.1550       3.3381       0.0000    2510.8652    1418.0000
  535.2288      96.0000      98.5807       0.0805      77.8089       0.1478       3.4635       0.0000    2517.1138    1413.0000
  535.3812      96.0000      98.4781       0.0811      72.6666       0.1400       3.2408       0.0000    2516.2212    1435.0000
  535.5336      96.0000      98.6379       0.0729      66.7135       0.1319       3.1538       0.0000    2529.7585    1417.0000
  535.6860      96.0000      98.5356       0.0642      62.3363       0.1237       3.1860       0.0000    2544.1514    1425.0000
  535.8384      96.0000      98.6045       0.0543      61.2253       0.1168       3.3266       0.0000    2560.3828    1428.0000
  535.9908      96.0000      98.4662       0.0458      66.2281       0.1111       3.2801       0.0000    2574.4355    1434.0000
  536.1432      96.0000      98.6949       0.0392      71.1410       0.1109       3.0293       0.0000    2585.3367    1431.0000
  536.2956      96.0000      98.4448       0.0315      74.7265       0.1139       3.0565       0.0000    2598.0520    1419.0000
  536.4480      96.0000      98.3756       0.0216      86.0624       0.1229       3.0069       0.0000    2614.3081    1399.0000
  536.6004      96.0000      98.5804       0.0115     102.2860       0.1392       3.3641       0.0000    2631.0657    1418.0000
  536.7528      96.0000      98.9114       0.0026     114.6817       0.1540       3.6614       0.0000    2645.7271    1440.0000
  536.9052      96.0000      99.3237      -0.0018     118.0593       0.1627       3.9295       0.0000    2652.9941    1434.0000
  537.0576      96.0000      99.3810      -0.0094     124.3897       0.1701       3.7736       0.0000    2665.4463    1426.0000
  537.2100      96.0000      99.7357      -0.0051     130.1412       0.1762       3.5616       0.0000    2658.4529    1410.0000
  537.3624      96.0000      99.6664      -0.0087     136.3168       0.1814       3.4487       0.0000    2664.4187    1419.0000
  537.5148      96.0000     100.0050      -0.0062     130.9099       0.1795       3.4751       0.0000    2660.2732    1438.0000
  537.6672      96.0000     100.1031      -0.0070     126.3128       0.1834       3.3808       0.0000    2661.5830    1422.0000
  537.8196      96.0000      99.9517      -0.0029     118.9065       0.1831       3.4641       0.0000    2654.7126    1419.0000
  537.9720      96.0000     100.2819      -0.0048     119.3107       0.1852       3.4722       0.0000    2657.8745    1436.0000
  538.1244      96.0000     100.1230      -0.0043     120.1253       0.1899       3.5194       0.0000    2657.1006    1425.0000
  538.2768      96.0000      99.8377      -0.0094     122.4018       0.1910       3.4905       0.0000    2665.4358    1432.0000
  538.4292      96.0000      99.8501      -0.0112     124.7680       0.1910       3.4819       0.0000    2668.5598    1436.0000
  538.5816      96.0000      99.7807      -0.0122     128.7428       0.1914       3.5499       0.0000    2670.1797    1450.0000
  538.7340      96.0000      99.8623      -0.0110     134.8987       0.1966       3.4589       0.0000    2668.0913    1424.0000
  538.8864      96.0000     100.1926      -0.0054     138.8596       0.1998       3.4147       0.0000    2658.8855    1428.0000
  539.0388      96.0000     100.0783      -0.0029     139.6502       0.1960       3.4886       0.0000    2654.8491    1432.0000
  539.1912      96.0000     100.1355      -0.0020     146.3958       0.2003       3.5904       0.0000    2653.3608    1443.0000
  539.3436      96.0000      99.7806      -0.0008     143.6662       0.2070       3.5648       0.0000    2651.3557    1421.0000
  539.4960      96.0000     100.1354       0.0033     140.5676       0.2142       3.3999       0.0000    2644.5068    1417.0000
  539.6484      96.0000     100.1355       0.0042     137.4979       0.2158       3.2602       0.0000    2643.1165    1426.0000
  539.8008      96.0000      99.9273       0.0036     134.8302       0.2104       3.4999       0.0000    2644.0332    1399.0000
  539.9532      96.0000     100.0213      -0.0008     138.0997       0.2123       3.7197       0.0000    2651.3628    1429.0000
  540.1056      96.0000     100.1678      -0.0031     140.3843       0.2062       3.9440       0.0000    2655.0344    1427.0000
  540.2580      96.0000      99.6990      -0.0039     137.5114       0.2073       3.9821       0.0000    2656.4646    1418.0000
  540.4104      96.0000     100.0408      -0.0104     130.6059       0.1931       3.8425       0.0000    2667.2329    1404.0000
  540.5628      96.0000      99.6338      -0.0216     114.9824       0.1819       3.8428       0.0000    2685.7188    1412.0000
  540.7152      96.0000      99.4501      -0.0181     108.6518       0.1628       3.8207       0.0000    2679.7913    1436.0000
  540.8676      96.0000      99.3686      -0.0171      98.2940       0.1515       3.9418       0.0000    2678.1768    1426.0000
  541.0200      96.0000      99.4949      -0.0116      88.5432       0.1422       4.0130       0.0000    2669.1846    1419.0000
  541.1724      96.0000      99.8174      -0.0137      87.4862       0.1416       3.8292       0.0000    2672.6130    1432.0000
  541.3248      96.0000      99.6909      -0.0081      90.9021       0.1430       3.6623       0.0000    2663.3010    1433.0000
  541.4772      96.0000      99.7234      -0.0005      95.9513       0.1479       3.7406       0.0000    2650.8645    1448.0000
  541.6296      96.0000      99.7806       0.0035      96.0309       0.1557       3.7439       0.0000    2644.1589    1421.0000
  541.7820      96.0000      99.9397       0.0004     100.2220       0.1626       3.8204       0.0000    2649.3096    1419.0000
  541.9344      96.0000      99.6541       0.0019     105.7383       0.1737       3.7478       0.0000    2646.8601    1461.0000
  542.0868      96.0000      99.7805       0.0026     107.1004       0.1812       3.8939       0.0000    2645.6797    1461.0000
  542.2392      96.0000      99.8378       0.0033     109.0637       0.1870       3.8121       0.0000    2644.5962    1394.0000
  542.3916      96.0000      99.9072       0.0073     114.6287       0.1858       3.5221       0.0000    2637.9456    1398.0000
  542.5440      96.0000      99.9967       0.0093     117.4977       0.1845       3.3980       0.0000    2634.6606    1406.0000
  542.6964      96.0000      99.9193       0.0114     127.2315       0.1853       3.4091       0.0000    2631.2356    1482.0000
  542.8488      96.0000      99.7667       0.0153     122.6458       0.1933       3.5274       0.0000    2624.7820    1490.0000
  543.0012      96.0000      99.5970       0.0161     130.6253       0.1900       3.5495       0.0000    2623.4380    1415.0000
  543.1536      96.0000      99.3686       0.0182     129.1833       0.1900       3.6494       0.0000    2619.8911    1429.0000
  543.3060      96.0000      99.7238       0.0195     134.5680       0.1804       3.5292       0.0000    2617.8462    1433.0000
  543.4584      96.0000      99.2665       0.0228     136.6113       0.1816       3.4284       0.0000    2612.3792    1424.0000
  543.6108      96.0000      99.6991       0.0258     130.2428       0.1745       3.0717       0.0000    2607.4358    1461.0000
  543.7632      96.0000      99.6216       0.0288     127.1864       0.1628       3.0830       0.0000    2602.5403    1427.0000
  543.9156      96.0000      99.4950       0.0253     127.9338       0.1568       3.0376       0.0000    2608.3152    1445.0000
  544.0680      96.0000      99.5643       0.0200     125.0734       0.1591       3.3670       0.0000    2616.9985    1435.0000
  544.2204      96.0000      99.6544       0.0212     119.8424       0.1695       3.3849       0.0000    2615.0854    1453.0000
  544.3728      96.0000      99.6216       0.0188     109.6865       0.1740       3.5132       0.0000    2618.9675    1454.0000
  544.5252      96.0000      99.4379       0.0208     108.1401       0.1743       3.4158       0.0000    2615.7300    1431.0000
  544.6776      96.0000      98.7521       0.0153     108.9094       0.1698       3.5760       0.0000    2624.7471    1427.0000
  544.8300      96.0000      98.9807       0.0109     106.0365       0.1734       3.7148       0.0000    2632.0276    1439.0000
  544.9824      96.0000      99.1523       0.0032     107.9431       0.1794       3.8088       0.0000    2644.6887    1424.0000
  545.1348      96.0000      98.9899       0.0005     108.0954       0.1925       3.6208       0.0000    2649.1008    1412.0000
  545.2872      96.0000      99.1522       0.0066     114.7775       0.2024       3.5322       0.0000    2639.1511    1407.0000
  545.4396      96.0000      99.0952       0.0126     122.8765       0.2153       3.5716       0.0000    2629.2666    1442.0000
  545.5920      96.0000      98.9929       0.0171     133.3189       0.2199       3.8189       0.0000    2621.7756    1433.0000
  545.7444      96.0000      99.0828       0.0144     137.9562       0.2179       3.8150       0.0000    2626.2646    1419.0000
  545.8968      96.0000      99.1765       0.0203     139.1418       0.2153       3.5969       0.0000    2616.5640    1436.0000
  546.0492      96.0000      99.3653       0.0226     134.7015       0.2018       3.3576       0.0000    2612.6658    1424.0000
  546.2016      96.0000      99.1972       0.0225     129.9488       0.1916       3.2890       0.0000    2612.8579    1420.0000
  546.3540      96.0000      99.1193       0.0143     124.5107       0.1857       3.4527       0.0000    2626.3503    1418.0000
  546.5064      96.0000      99.3929       0.0097     123.8441       0.1942       3.5497       0.0000    2633.9561    1449.0000
  546.6588      96.0000      99.5970       0.0041     129.9215       0.1955       3.6029       0.0000    2643.2837    1428.0000
  546.8112      96.0000      99.6420       0.0013     127.4395       0.1833       3.6923       0.0000    2647.8662    1396.0000
  546.9636      96.0000      99.4503      -0.0018     120.0285       0.1738       3.8864       0.0000    2653.0190    1431.0000
  547.1160      96.0000      99.4109       0.0027     109.8469       0.1606       3.9021       0.0000    2645.5913    1424.0000
  547.2684      96.0000      99.1525       0.0070     105.9822       0.1564       3.7837       0.0000    2638.4602    1434.0000
  547.4208      96.0000      98.8213       0.0065     110.1098       0.1562       3.5353       0.0000    2639.1992    1421.0000
  547.5732      96.0000      98.3518       0.0109     114.3487       0.1695       3.4868       0.0000    2632.0791    1426.0000
  547.7256      96.0000      98.5806       0.0160     116.8489       0.1793       3.3681       0.0000    2623.6570    1427.0000
  547.8780      96.0000      98.4900       0.0201     119.5167       0.1796       3.4369       0.0000    2616.8818    1439.0000
  548.0304      96.0000      98.5234       0.0173     119.4974       0.1705       3.3218       0.0000    2621.4082    1422.0000
  548.1828      96.0000      98.6336       0.0244     126.3195       0.1671       3.2622       0.0000    2609.7703    1446.0000
  548.3352      96.0000      98.4090       0.0307     115.2930       0.1610       3.1726       0.0000    2599.2927    1429.0000
  548.4876      96.0000      98.3637       0.0421     106.5587       0.1554       3.2813       0.0000    2580.4998    1446.0000
  548.6400      96.0000      98.5235       0.0471      90.3127       0.1470       3.4749       0.0000    2572.3496    1434.0000
  548.7924      96.0000      98.1112       0.0580      90.9040       0.1490       3.4786       0.0000    2554.3804    1439.0000
  548.9448      96.0000      97.9058       0.0605      92.3235       0.1551       3.3403       0.0000    2550.1499    1443.0000
  549.0972      96.0000      98.1802       0.0568      95.2229       0.1539       3.3215       0.0000    2556.3337    1446.0000
  549.2496      96.0000      98.2483       0.0440      92.9007       0.1477       3.4547       0.0000    2577.4446    1443.0000
  549.4020      96.0000      98.5234       0.0349      89.0187       0.1408       3.6974       0.0000    2592.4673    1454.0000
  549.5544      96.0000      98.5805       0.0377      87.8502       0.1403       3.6880       0.0000    2587.7678    1433.0000
  549.7068      96.0000      98.5926       0.0477      86.7089       0.1413       3.7170       0.0000    2571.2637    1406.0000
  549.8592      96.0000      98.4542       0.0516      86.0933       0.1400       3.4714       0.0000    2564.8354    1401.0000
  550.0116      96.0000      98.4781       0.0493      85.9009       0.1352       3.2936       0.0000    2568.7200    1477.0000
  550.1640      96.0000      98.4424       0.0374      84.6142       0.1281       3.1873       0.0000    2588.2205    1460.0000
  550.3164      96.0000      98.3494       0.0260      84.8871       0.1228       3.3231       0.0000    2607.0593    1412.0000
  550.4688      96.0000      98.6046       0.0151      81.0527       0.1214       3.4243       0.0000    2625.0830    1432.0000
  550.6212      96.0000      98.7521       0.0109      80.6296       0.1221       3.4602       0.0000    2632.0256    1450.0000
  550.7736      96.0000      98.5353       0.0184      80.9724       0.1319       3.4266       0.0000    2619.6790    1446.0000
  550.9260      96.0000      98.4209       0.0297      90.0158       0.1389       3.4821       0.0000    2600.9587    1443.0000
  551.0784      96.0000      98.3637       0.0395      95.9441       0.1513       3.3585       0.0000    2584.8923    1436.0000
  551.2308      96.0000      98.2941       0.0499      99.8431       0.1550       3.2891       0.0000    2567.5999    1435.0000
  551.3832      96.0000      98.3876       0.0572      95.9803       0.1613       3.1132       0.0000    2555.5781    1435.0000
  551.5356      96.0000      98.4089       0.0646      94.6480       0.1613       3.0197       0.0000    2543.3735    1441.0000
  551.6880      96.0000      98.3637       0.0671      86.6319       0.1616       3.0198       0.0000    2539.3442    1429.0000
  551.8404      96.0000      98.3757       0.0660      86.4396       0.1609       3.1028       0.0000    2541.0911    1425.0000
  551.9928      96.0000      98.5806       0.0592      81.6292       0.1636       3.2691       0.0000    2552.3357    1440.0000
  552.1452      96.0000      98.3636       0.0548      87.5932       0.1689       3.3569       0.0000    2559.5593    1441.0000
  552.2976      96.0000      98.6071       0.0511      93.3630       0.1669       3.3744       0.0000    2565.7236    1456.0000
  552.4500      96.0000      98.4901       0.0435     104.4661       0.1626       3.4019       0.0000    2578.1968    1456.0000
  552.6024      96.0000      98.3757       0.0365     114.5852       0.1571       3.3302       0.0000    2589.7322    1443.0000
  552.7548      96.0000      98.5234       0.0346     119.0856       0.1538       3.5026       0.0000    2592.9375    1435.0000
  552.9072      96.0000      98.4208       0.0382     112.2019       0.1436       3.4428       0.0000    2586.9395    1424.0000
  553.0596      96.0000      98.5235       0.0385     101.6388       0.1356       3.5201       0.0000    2586.4824    1446.0000
  553.2120      96.0000      98.1662       0.0312      95.2773       0.1291       3.3893       0.0000    2598.4983    1454.0000
  553.3644      96.0000      97.9395       0.0257     100.0854       0.1386       3.5436       0.0000    2607.6069    1447.0000
  553.5168      96.0000      98.2827       0.0150     109.1482       0.1503       3.4901       0.0000    2625.2839    1449.0000
  553.6692      96.0000      98.6498       0.0111     114.8558       0.1677       3.5910       0.0000    2631.7617    1435.0000
  553.8216      96.0000      98.8665       0.0043     120.0486       0.1804       3.5047       0.0000    2642.8804    1445.0000
  553.9740      96.0000      98.7975       0.0094     113.1023       0.1837       3.6576       0.0000    2634.4619    1432.0000
  554.1264      96.0000      98.9234       0.0053     111.2937       0.1867       3.5599       0.0000    2641.3203    1414.0000
  554.2788      96.0000      98.8263       0.0051     110.5244       0.1886       3.6748       0.0000    2641.5630    1410.0000
  554.4312      96.0000      99.0138       0.0058     117.6437       0.2017       3.5322       0.0000    2640.4592    1433.0000
  554.5836      96.0000      98.8787       0.0070     121.3164       0.2097       3.7080       0.0000    2638.4500    1422.0000
  554.7360      96.0000      99.0950       0.0079     127.6841       0.2203       3.6804       0.0000    2636.9495    1443.0000
  554.8884      96.0000      98.8784       0.0017     136.1053       0.2224       3.8158       0.0000    2647.1450    1450.0000
  555.0408      96.0000      98.6497       0.0020     141.9568       0.2224       3.7675       0.0000    2646.6365    1443.0000
  555.1932      96.0000      99.0501      -0.0022     135.4985       0.2113       3.7420       0.0000    2653.5854    1454.0000
  555.3456      96.0000      98.8429       0.0059     131.6740       0.2000       3.5864       0.0000    2640.1953    1426.0000
  555.4980      96.0000      98.8454       0.0128     122.8046       0.1834       3.4690       0.0000    2628.9436    1432.0000
  555.6504      96.0000      98.5927       0.0192     121.9837       0.1686       3.3154       0.0000    2618.2769    1441.0000
  555.8028      96.0000      98.6259       0.0214     117.5603       0.1533       3.4072       0.0000    2614.6746    1483.0000
  555.9552      96.0000      98.3399       0.0204     110.1337       0.1449       3.3896       0.0000    2616.3145    1439.0000
  556.1076      96.0000      98.3756       0.0275     105.2907       0.1372       3.4913       0.0000    2604.5823    1435.0000
  556.2600      96.0000      98.1394       0.0241      99.3286       0.1294       3.2738       0.0000    2610.1851    1447.0000
  556.4124      96.0000      98.2945       0.0246      98.4853       0.1266       3.3157       0.0000    2609.4832    1461.0000
  556.5648      96.0000      98.5806       0.0209      96.3511       0.1316       3.3359       0.0000    2615.5657    1447.0000
  556.7172      96.0000      99.0379       0.0148      97.5219       0.1393       3.7057       0.0000    2625.5132    1412.0000
  556.8696      96.0000      98.6497       0.0122     111.0660       0.1563       3.6923       0.0000    2629.9053    1441.0000
  557.0220      96.0000      98.4090       0.0081     122.6285       0.1648       3.7593       0.0000    2636.6482    1471.0000
  557.1744      96.0000      98.1921       0.0050     122.9692       0.1696       3.6316       0.0000    2641.8152    1440.0000
  557.3268      96.0000      98.5686       0.0034     116.9257       0.1608       3.6436       0.0000    2644.4583    1415.0000
  557.4792      96.0000      98.5927       0.0029     112.4825       0.1562       3.5080       0.0000    2645.1482    1418.0000
  557.6316      96.0000      98.4997       0.0073     110.4304       0.1494       3.5164       0.0000    2637.8784    1461.0000
  557.7840      96.0000      98.1467       0.0099     107.5622       0.1433       3.5474       0.0000    2633.7034    1449.0000
  557.9364      96.0000      98.3518       0.0108      94.4796       0.1374       3.6691       0.0000    2632.1086    1420.0000
  558.0888      96.0000      98.3183       0.0042      90.9958       0.1406       3.8434       0.0000    2643.1440    1419.0000
  558.2412      96.0000      98.4506       0.0036      86.3704       0.1452       4.0155       0.0000    2644.0696    1449.0000
  558.3936      96.0000      98.8785      -0.0042      90.8120       0.1512       4.2013       0.0000    2656.9500    1464.0000
  558.5460      96.0000      99.1072      -0.0023      92.5285       0.1558       4.2044       0.0000    2653.7256    1427.0000
  558.6984      96.0000      99.0380      -0.0010      91.1891       0.1579       3.9217       0.0000    2651.7209    1418.0000
  558.8508      96.0000      99.0049       0.0110     102.5407       0.1582       3.6218       0.0000    2631.8965    1463.0000
  559.0032      96.0000      98.7521       0.0177     110.0601       0.1613       3.3566       0.0000    2620.7239    1454.0000
  559.1556      96.0000      98.8544       0.0223     112.9311       0.1616       3.2944       0.0000    2613.2441    1432.0000
  559.3080      96.0000      98.7155       0.0191     111.3096       0.1607       3.2747       0.0000    2618.4446    1407.0000
  559.4604      96.0000      98.7522       0.0185     108.4060       0.1579       3.3476       0.0000    2619.4792    1443.0000
  559.6128      96.0000      98.7642       0.0243     112.8410       0.1619       3.5082       0.0000    2609.8787    1452.0000
  559.7652      96.0000      99.1525       0.0204     105.4052       0.1773       3.6842       0.0000    2616.3416    1475.0000
  559.9176      96.0000      99.2095       0.0115     105.4226       0.1866       3.6600       0.0000    2631.0071    1442.0000
  560.0700      96.0000      99.6093       0.0095     110.1424       0.2009       3.6224       0.0000    2634.3833    1436.0000
  560.2224      96.0000      99.7764       0.0122     133.2213       0.2152       3.6039       0.0000    2629.9119    1463.0000
  560.3748      96.0000      99.7235       0.0138     150.8764       0.2373       3.7341       0.0000    2627.2043    1449.0000
  560.5272      96.0000      99.7112       0.0140     156.9152       0.2435       3.7679       0.0000    2626.9724    1425.0000
  560.6796      96.0000      99.2301       0.0241     149.2753       0.2318       3.7291       0.0000    2610.1770    1462.0000
  560.8320      96.0000      99.8954       0.0230     142.3730       0.2147       3.5741       0.0000    2612.1301    1492.0000
  560.9844      96.0000      99.1643       0.0120     139.8939       0.2024       3.4769       0.0000    2630.1775    1461.0000
  561.1368      96.0000      99.0356       0.0089     136.7637       0.1902       3.3539       0.0000    2635.3953    1389.0000
  561.2892      96.0000      98.6046       0.0107     134.2634       0.1745       3.3865       0.0000    2632.3452    1436.0000
  561.4416      96.0000      98.5235       0.0081     132.7558       0.1646       3.3665       0.0000    2636.5742    1497.0000
  561.5940      96.0000      98.5925       0.0033     130.5506       0.1584       3.5091       0.0000    2644.5313    1482.0000
  561.7464      96.0000      98.3636       0.0020     121.3190       0.1532       3.5077       0.0000    2646.6670    1411.0000
  561.8988      96.0000      98.7068       0.0004     121.0950       0.1503       3.5846       0.0000    2649.3474    1405.0000
  562.0512      96.0000      99.0381       0.0081     121.3002       0.1531       3.5774       0.0000    2636.6328    1476.0000
  562.2036      96.0000      99.2738       0.0040     118.4153       0.1531       3.5555       0.0000    2643.4016    1494.0000
  562.3560      96.0000      99.3238       0.0028     106.6631       0.1517       3.6163       0.0000    2645.3149    1411.0000
  562.5084      96.0000      99.6664      -0.0045     103.3798       0.1533       3.5021       0.0000    2657.3501    1431.0000
  562.6608      96.0000      99.7481      -0.0088     107.6109       0.1582       3.4236       0.0000    2664.4941    1425.0000
  562.8132      96.0000      99.6785      -0.0055     116.0986       0.1626       3.4118       0.0000    2659.0752    1443.0000
  562.9656      96.0000      99.3748      -0.0018     113.7058       0.1665       3.5272       0.0000    2652.9543    1436.0000
  563.1180      96.0000      99.0138      -0.0019     116.7830       0.1799       3.7232       0.0000    2653.0801    1445.0000
  563.2704      96.0000      98.9359      -0.0082     113.0892       0.1889       3.7579       0.0000    2663.4971    1448.0000
  563.4228      96.0000      99.5071      -0.0056     114.2263       0.1935       3.8523       0.0000    2659.3047    1443.0000
  563.5752      96.0000      99.0377      -0.0021     124.4433       0.1861       3.5594       0.0000    2653.4470    1432.0000
  563.7276      96.0000      98.7401       0.0104     132.5352       0.1788       3.3878       0.0000    2632.8386    1453.0000
  563.8800      96.0000      98.8215       0.0178     135.9970       0.1716       3.2574       0.0000    2620.6650    1457.0000
  564.0324      96.0000      98.6698       0.0229     120.0853       0.1659       3.4647       0.0000    2612.2107    1424.0000
  564.1848      96.0000      98.6738       0.0203     110.9674       0.1548       3.5637       0.0000    2616.5356    1427.0000
  564.3372      96.0000      98.5354       0.0195     103.0821       0.1554       3.5084       0.0000    2617.7437    1443.0000
  564.4896      96.0000      98.8094       0.0178     111.4896       0.1612       3.4676       0.0000    2620.6646    1469.0000
  564.6420      96.0000      98.7069       0.0125     113.1313       0.1754       3.4412       0.0000    2629.4463    1457.0000
  564.7944      96.0000      98.5325       0.0135     124.0938       0.1846       3.4960       0.0000    2627.7444    1433.0000
  564.9468      96.0000      98.5805       0.0084     120.9963       0.1895       3.4280       0.0000    2636.1851    1415.0000
  565.0992      96.0000      98.7070       0.0108     128.5891       0.1883       3.3891       0.0000    2632.2234    1490.0000
  565.2516      96.0000      98.6499       0.0110     127.4351       0.1805       3.3090       0.0000    2631.9099    1473.0000
  565.4040      96.0000      98.8333       0.0172     131.1098       0.1720       3.2483       0.0000    2621.6770    1420.0000
  565.5564      96.0000      98.4542       0.0143     124.1327       0.1628       3.3120       0.0000    2626.4089    1438.0000
  565.7088      96.0000      98.5354       0.0112     115.0935       0.1502       3.4084       0.0000    2631.5042    1450.0000
  565.8612      96.0000      98.5878       0.0030     112.0148       0.1376       3.4570       0.0000    2645.0181    1436.0000
  566.0136      96.0000      98.6259      -0.0031     104.6121       0.1260       3.5483       0.0000    2655.1829    1443.0000
  566.1660      96.0000      98.7522       0.0002      94.8147       0.1181       3.8426       0.0000    2649.7122    1435.0000
  566.3184      96.0000      98.7642      -0.0023      73.2552       0.1114       4.3064       0.0000    2653.7678    1447.0000
  566.4708      96.0000      98.8785      -0.0038      65.2672       0.1104       4.4202       0.0000    2656.2180    1488.0000
  566.6232      96.0000      98.5354      -0.0062      70.0642       0.1121       4.3201       0.0000    2660.2954    1454.0000
  566.7756      96.0000      98.7251      -0.0050      78.1247       0.1204       4.1354       0.0000    2658.2012    1414.0000
  566.9280      96.0000      98.5806      -0.0062      83.0669       0.1275       3.9312       0.0000    2660.2776    1436.0000
  567.0804      96.0000      98.7521      -0.0015      88.4678       0.1406       3.6809       0.0000    2652.4182    1460.0000
  567.2328      96.0000      99.2423       0.0043      96.6585       0.1527       3.3960       0.0000    2642.9009    1457.0000
  567.3852      96.0000      98.9598       0.0052     112.8341       0.1597       3.3510       0.0000    2641.4944    1455.0000
  567.5376      96.0000      98.9080       0.0071     125.9623       0.1635       3.3953       0.0000    2638.2646    1453.0000
  567.6900      96.0000      98.6736       0.0038     126.8280       0.1610       3.6784       0.0000    2643.7683    1468.0000
  567.8424      96.0000      98.3517       0.0089     121.6148       0.1584       3.6434       0.0000    2635.3940    1439.0000
  567.9948      96.0000      98.6737       0.0112     114.6439       0.1531       3.6334       0.0000    2631.5742    1466.0000
  568.1472      96.0000      98.5354       0.0181     117.5288       0.1557       3.4878       0.0000    2620.1326    1475.0000
  568.2996      96.0000      98.5927       0.0144     125.4285       0.1673       3.4959       0.0000    2626.2517    1463.0000
  568.4520      96.0000      98.6948       0.0118     131.7565       0.1883       3.4413       0.0000    2630.5952    1462.0000
  568.6044      96.0000      98.9537       0.0083     139.7206       0.2107       3.4645       0.0000    2636.2451    1457.0000
  568.7568      96.0000      98.7640       0.0155     144.5382       0.2245       3.5159       0.0000    2624.3704    1462.0000
  568.9092      96.0000      99.3688       0.0198     148.5770       0.2315       3.6621       0.0000    2617.3674    1464.0000
  569.0616      96.0000      99.2216       0.0143     150.6291       0.2213       3.7189       0.0000    2626.3828    1412.0000
  569.2140      96.0000      99.3479       0.0098     149.0666       0.2164       3.8152       0.0000    2633.9072    1415.0000
  569.3664      96.0000      99.1073       0.0121     143.6187       0.2046       3.5174       0.0000    2629.9883    1456.0000
  569.5188      96.0000      99.2184       0.0121     136.8719       0.2021       3.4843       0.0000    2630.0603    1453.0000
  569.6712      96.0000      99.1973       0.0083     127.4668       0.1985       3.3445       0.0000    2636.3840    1449.0000
  569.8236      96.0000      99.1072       0.0067     126.0086       0.1963       3.4595       0.0000    2638.9866    1448.0000
  569.9760      96.0000      98.9357      -0.0009     128.7223       0.1916       3.3440       0.0000    2651.4863    1443.0000
  570.1284      96.0000      98.8544      -0.0001     131.0114       0.1866       3.3184       0.0000    2650.2290    1445.0000
  570.2808      96.0000      98.8665       0.0020     126.1081       0.1782       3.2619       0.0000    2646.6895    1422.0000
  570.4332      96.0000      98.9080       0.0070     123.0097       0.1734       3.3878       0.0000    2638.4561    1434.0000
  570.5856      96.0000      99.1401       0.0055     128.8020       0.1696       3.3384       0.0000    2640.9063    1473.0000
  570.7380      96.0000      99.1521       0.0053     127.7258       0.1691       3.4384       0.0000    2641.1958    1461.0000
  570.8904      96.0000      98.9808       0.0063     123.3654       0.1655       3.3539       0.0000    2639.5947    1440.0000
  571.0428      96.0000      99.1399      -0.0013     110.6495       0.1591       3.6107       0.0000    2652.1868    1418.0000
  571.1952      96.0000      98.8093      -0.0047     107.7808       0.1495       3.7803       0.0000    2657.7021    1443.0000
  571.3476      96.0000      98.9807      -0.0117     106.3262       0.1386       4.1795       0.0000    2669.3064    1452.0000
  571.5000      96.0000      99.1727      -0.0068      99.4159       0.1360       4.1544       0.0000    2661.2454    1442.0000
  571.6524      96.0000      98.9357      -0.0108      96.1301       0.1352       4.0399       0.0000    2667.8293    1436.0000
  571.8048      96.0000      98.8663      -0.0020      89.3764       0.1347       3.7857       0.0000    2653.3716    1450.0000
  571.9572      96.0000      98.9687      -0.0049      96.8637       0.1340       3.7141       0.0000    2658.0706    1445.0000
  572.1096      96.0000      98.8095      -0.0021      94.4494       0.1423       3.6346       0.0000    2653.5054    1420.0000
  572.2620      96.0000      99.0163      -0.0004     101.2485       0.1534       3.5498       0.0000    2650.5828    1433.0000
  572.4144      96.0000      98.9718       0.0062     103.3819       0.1641       3.3459       0.0000    2639.7922    1454.0000
  572.5668      96.0000      98.8094       0.0142     112.6163       0.1694       3.2754       0.0000    2626.6475    1471.0000
  572.7192      96.0000      98.7401       0.0234     113.7703       0.1779       3.2906       0.0000    2611.3376    1461.0000
  572.8716      96.0000      98.6378       0.0292     108.3673       0.1825       3.3709       0.0000    2601.8796    1428.0000
  573.0240      96.0000      98.7190       0.0408     106.5646       0.1840       3.3207       0.0000    2582.7480    1427.0000
  573.1764      96.0000      98.4901       0.0473     105.1783       0.1817       3.2136       0.0000    2571.9475    1469.0000
  573.3288      96.0000      98.4142       0.0528     106.3323       0.1786       3.2625       0.0000    2562.9165    1469.0000
  573.4812      96.0000      98.6497       0.0556     103.6227       0.1813       3.2190       0.0000    2558.2275    1442.0000
  573.6336      96.0000      98.6951       0.0575      95.0039       0.1859       3.1675       0.0000    2555.0808    1448.0000
  573.7860      96.0000      98.3638       0.0687      86.7459       0.1899       3.0635       0.0000    2536.6838    1463.0000
  573.9384      96.0000      98.5926       0.0754      84.8808       0.1916       3.0690       0.0000    2525.5188    1435.0000
  574.0908      96.0000      98.5612       0.0808      93.3642       0.1945       3.1074       0.0000    2516.6917    1433.0000
  574.2432      96.0000      98.7401       0.0838      98.5450       0.1974       3.1109       0.0000    2511.7393    1443.0000
  574.3956      96.0000      98.4780       0.0931      93.8410       0.1976       3.0267       0.0000    2496.4346    1459.0000
  574.5480      96.0000      98.5808       0.1015      86.1312       0.1928       2.9316       0.0000    2482.5630    1441.0000
  574.7004      96.0000      98.5593       0.1028      85.7304       0.1870       2.8873       0.0000    2480.3835    1449.0000
  574.8528      96.0000      98.3520       0.1045      85.3757       0.1762       2.9319       0.0000    2477.5764    1453.0000
  575.0052      96.0000      98.7707       0.0983      90.5842       0.1724       3.0230       0.0000    2487.7734    1448.0000
  575.1576      96.0000      98.4544       0.0885      92.9082       0.1649       3.2484       0.0000    2503.8987    1456.0000
  575.3100      96.0000      98.3755       0.0756      97.1539       0.1542       3.4036       0.0000    2525.3315    1442.0000
  575.4624      96.0000      98.5924       0.0669      90.5992       0.1414       3.3952       0.0000    2539.6309    1452.0000
  575.6148      96.0000      98.3637       0.0576      89.3012       0.1290       3.2354       0.0000    2554.8801    1457.0000
  575.7672      96.0000      98.5234       0.0468      93.1331       0.1216       3.1590       0.0000    2572.7893    1445.0000
  575.9196      96.0000      99.0355       0.0386      93.9111       0.1223       3.2388       0.0000    2586.3113    1455.0000
  576.0720      96.0000      99.6093       0.0311      90.7856       0.1326       3.2243       0.0000    2598.6750    1449.0000
  576.2244      96.0000      99.2422       0.0255      88.8778       0.1427       3.3968       0.0000    2607.9773    1435.0000
  576.3768      96.0000      98.9809       0.0219      93.5976       0.1529       3.5129       0.0000    2613.9231    1448.0000
  576.5292      96.0000      98.9239       0.0239     104.9447       0.1584       3.6280       0.0000    2610.6316    1463.0000
  576.6816      96.0000      99.1463       0.0231     105.2859       0.1633       3.5221       0.0000    2611.8660    1459.0000
  576.8340      96.0000      98.1921       0.0284     101.7114       0.1562       3.3567       0.0000    2603.1099    1449.0000
  576.9864      96.0000      98.2612       0.0328      95.3647       0.1469       3.2482       0.0000    2595.9080    1440.0000
  577.1388      96.0000      97.9967       0.0372      94.7490       0.1421       3.1512       0.0000    2588.5481    1457.0000
  577.2912      96.0000      98.1920       0.0430      99.9577       0.1424       3.0863       0.0000    2578.9719    1467.0000
  577.4436      96.0000      98.2255       0.0438     102.2656       0.1441       3.0740       0.0000    2577.7573    1433.0000
  577.5960      96.0000      99.0621       0.0504     102.9093       0.1450       3.0739       0.0000    2566.9219    1464.0000
  577.7484      96.0000      98.6987       0.0437     100.9852       0.1465       3.1393       0.0000    2577.9309    1455.0000
  577.9008      96.0000      98.8213       0.0377      96.1867       0.1474       3.1798       0.0000    2587.7285    1447.0000
  578.0532      96.0000      98.7401       0.0324     100.2255       0.1474       3.2132       0.0000    2596.5366    1446.0000
  578.2056      96.0000      98.8335       0.0348      97.3256       0.1520       3.0724       0.0000    2592.5327    1418.0000
  578.3580      96.0000      98.5353       0.0344      98.1464       0.1502       2.9975       0.0000    2593.3018    1454.0000
  578.5104      96.0000      98.8665       0.0389      91.6074       0.1505       3.0376       0.0000    2585.7720    1460.0000
  578.6628      96.0000      98.9176       0.0399      95.0025       0.1459       3.1397       0.0000    2584.1389    1434.0000
  578.8152      96.0000      98.8334       0.0461      95.1485       0.1538       3.2396       0.0000    2573.9031    1431.0000
  578.9676      96.0000      98.6497       0.0452      99.4500       0.1587       3.1084       0.0000    2575.3975    1431.0000
  579.1200      96.0000      98.2828       0.0433     102.2259       0.1640       3.2677       0.0000    2578.5256    1448.0000
  579.2724      96.0000      98.4329       0.0459     106.2498       0.1686       3.2773       0.0000    2574.2129    1439.0000
  579.4248      96.0000      98.3494       0.0575     100.4235       0.1684       3.3394       0.0000    2555.0601    1426.0000
  579.5772      96.0000      98.8213       0.0680      95.7853       0.1628       3.2234       0.0000    2537.7930    1457.0000
  579.7296      96.0000      98.4090       0.0764      87.3359       0.1516       3.2580       0.0000    2523.9895    1457.0000
  579.8820      96.0000      98.4780       0.0707      88.2838       0.1394       3.4292       0.0000    2533.4238    1439.0000
  580.0344      96.0000      98.4901       0.0551      85.6102       0.1288       3.3485       0.0000    2559.0669    1433.0000
  580.1868      96.0000      98.3185       0.0354      82.5202       0.1187       3.3114       0.0000    2591.5212    1453.0000
  580.3392      96.0000      98.7708       0.0273      83.7224       0.1171       3.2361       0.0000    2605.0125    1463.0000
  580.4916      96.0000      99.2215       0.0253      90.4406       0.1257       3.4358       0.0000    2608.2734    1449.0000
  580.6440      96.0000      99.2335       0.0160      96.1684       0.1400       3.5138       0.0000    2623.5737    1446.0000
  580.7964      96.0000      99.0951       0.0099      99.7743       0.1556       3.5895       0.0000    2633.6479    1443.0000
  580.9488      96.0000      99.5072       0.0023     103.4464       0.1642       3.6410       0.0000    2646.2407    1453.0000
  581.1012      96.0000      99.4257      -0.0011     108.7643       0.1694       3.7921       0.0000    2651.8088    1459.0000
  581.2536      96.0000      99.2836      -0.0083     109.9352       0.1728       3.8450       0.0000    2663.7385    1441.0000
  581.4060      96.0000      99.5644      -0.0170      99.9765       0.1679       3.9909       0.0000    2678.1155    1441.0000
  581.5584      96.0000      99.3931      -0.0143      96.4315       0.1613       3.9784       0.0000    2673.5374    1445.0000
  581.7108      96.0000      99.6093      -0.0102      99.4917       0.1537       3.6506       0.0000    2666.8740    1445.0000
  581.8632      96.0000      99.3929       0.0068     106.4689       0.1497       3.3081       0.0000    2638.8535    1455.0000
  582.0156      96.0000      98.8358       0.0170     108.0075       0.1412       3.1241       0.0000    2621.9502    1474.0000
  582.1680      96.0000      98.3517       0.0226     106.8714       0.1265       3.3238       0.0000    2612.7830    1461.0000
  582.3204      96.0000      98.6380       0.0173     110.7965       0.1223       3.4637       0.0000    2621.5081    1432.0000
  582.4728      96.0000      99.2665       0.0183     116.9694       0.1291       3.3402       0.0000    2619.8586    1433.0000
  582.6252      96.0000      98.5473       0.0228     118.6622       0.1426       3.2293       0.0000    2612.3079    1466.0000
  582.7776      96.0000      98.4901       0.0226     119.4503       0.1590       3.1692       0.0000    2612.7620    1428.0000
  582.9300      96.0000      98.7058       0.0092     126.9325       0.1763       3.3002       0.0000    2634.8376    1426.0000
  583.0824      96.0000      98.7763       0.0014     132.9363       0.1939       3.4386       0.0000    2647.7246    1482.0000
  583.2348      96.0000      98.6377      -0.0092     142.9183       0.2039       3.5882       0.0000    2665.1882    1470.0000
  583.3872      96.0000      98.5355      -0.0136     145.2493       0.2063       3.7609       0.0000    2672.4905    1425.0000
  583.5396      96.0000      98.3280      -0.0058     141.7660       0.2030       3.7755       0.0000    2659.6113    1442.0000
  583.6920      96.0000      98.7442       0.0034     134.8686       0.1881       3.7101       0.0000    2644.4106    1467.0000
  583.8444      96.0000      98.4662       0.0131     120.8059       0.1688       3.5414       0.0000    2628.4104    1476.0000
  583.9968      96.0000      98.6497       0.0193     113.6899       0.1514       3.5609       0.0000    2618.2310    1446.0000
  584.1492      96.0000      98.7519       0.0194     101.9466       0.1442       3.4848       0.0000    2617.9834    1443.0000
  584.3016      96.0000      99.6337       0.0146      98.9692       0.1436       3.4940       0.0000    2625.8296    1477.0000
  584.4540      96.0000      99.5522       0.0100     102.4310       0.1511       3.4464       0.0000    2633.5569    1483.0000
  584.6064      96.0000      99.7113       0.0050     113.3787       0.1655       3.6565       0.0000    2641.7827    1426.0000
  584.7588      96.0000      99.4829       0.0025     126.1017       0.1859       3.7382       0.0000    2645.9189    1421.0000
  584.9112      96.0000      99.4623      -0.0019     124.7729       0.2003       3.7871       0.0000    2653.1619    1463.0000
  585.0636      96.0000      99.2423      -0.0009     131.5043       0.2006       3.7647       0.0000    2651.4338    1457.0000
  585.2160      96.0000      99.3566       0.0044     131.5043       0.1943       3.6723       0.0000    2642.7632    1446.0000
  585.3684      96.0000      99.3566       0.0034     135.5256       0.1854       3.6303       0.0000    2644.3835    1448.0000
  585.5208      96.0000      98.9081       0.0056     124.7555       0.1762       3.4363       0.0000    2640.8096    1455.0000
  585.6732      96.0000      99.0380       0.0010     113.4870       0.1669       3.5153       0.0000    2648.3535    1447.0000
  585.8256      96.0000      98.8784      -0.0015     115.4366       0.1696       3.6761       0.0000    2652.5525    1467.0000
  585.9780      96.0000      98.9478      -0.0043     113.5133       0.1820       3.7855       0.0000    2657.1306    1448.0000
  586.1304      96.0000      98.8783      -0.0092     119.4782       0.1902       3.7843       0.0000    2665.2288    1433.0000
  586.2828      96.0000      99.1269      -0.0101     117.6106       0.1968       3.5837       0.0000    2666.6895    1466.0000
  586.4352      96.0000      99.0949      -0.0112     124.7470       0.1961       3.6446       0.0000    2668.4377    1442.0000
  586.5876      96.0000      99.1073      -0.0063     134.3447       0.2015       3.7557       0.0000    2660.4744    1417.0000
  586.7400      96.0000      99.0621      -0.0021     132.5185       0.2001       3.6838       0.0000    2653.5078    1453.0000
  586.8924      96.0000      99.0950       0.0053     122.4972       0.1896       3.5972       0.0000    2641.1863    1491.0000
  587.0448      96.0000      99.1645       0.0092     103.0864       0.1747       3.3972       0.0000    2634.7424    1442.0000
  587.1972      96.0000      98.9441       0.0081      93.8681       0.1651       3.4278       0.0000    2636.5596    1468.0000
  587.3496      96.0000      99.2459       0.0139      93.0450       0.1738       3.5242       0.0000    2626.9932    1456.0000
  587.5020      96.0000      99.1974       0.0119     102.6472       0.1902       3.6345       0.0000    2630.3801    1447.0000
  587.6544      96.0000      99.4501       0.0113     118.0546       0.2020       3.7917       0.0000    2631.3281    1443.0000
  587.8068      96.0000      99.4501       0.0031     128.2936       0.2100       3.9182       0.0000    2644.8406    1439.0000
  587.9592      96.0000      99.2458       0.0107     139.6645       0.2137       4.0687       0.0000    2632.3953    1443.0000
  588.1116      96.0000      99.3099       0.0075     133.2505       0.2116       3.8971       0.0000    2637.5935    1445.0000
  588.2640      96.0000      99.4950       0.0093     132.5091       0.1944       3.6758       0.0000    2634.6462    1471.0000
  588.4164      96.0000      99.8501       0.0071     116.5224       0.1657       3.5129       0.0000    2638.3271    1453.0000
  588.5688      96.0000      99.2094       0.0088     107.7180       0.1401       3.4088       0.0000    2635.4070    1463.0000
  588.7212      96.0000      99.0951       0.0089      97.5050       0.1291       3.4001       0.0000    2635.2625    1438.0000
  588.8736      96.0000      99.6199       0.0146      97.9062       0.1309       3.3399       0.0000    2625.8584    1448.0000
  589.0260      96.0000      99.6094       0.0207     104.8645       0.1414       3.3775       0.0000    2615.8176    1471.0000
  589.1784      96.0000      99.5400       0.0235     110.2672       0.1552       3.2441       0.0000    2611.2183    1487.0000
  589.3308      96.0000      99.5075       0.0228     112.5586       0.1661       3.3101       0.0000    2612.3513    1413.0000
  589.4832      96.0000      99.4501       0.0174     117.1627       0.1695       3.3062       0.0000    2621.3013    1427.0000
  589.6356      96.0000      99.8256       0.0038     121.0736       0.1733       3.6049       0.0000    2643.7739    1491.0000
  589.7880      96.0000     100.0147      -0.0011     116.8581       0.1799       3.6902       0.0000    2651.8809    1446.0000
  589.9404      96.0000      99.9520      -0.0045     104.7219       0.1803       4.0519       0.0000    2657.4377    1457.0000
  590.0928      96.0000     100.4086      -0.0067      93.4560       0.1772       3.9214       0.0000    2661.0938    1460.0000
  590.2452      96.0000     100.1803      -0.0031     102.4797       0.1682       3.9743       0.0000    2655.0566    1439.0000
  590.3976      96.0000      99.9966       0.0019     120.9655       0.1716       3.7009       0.0000    2646.8069    1460.0000
  590.5500      96.0000     100.0703      -0.0047     128.1479       0.1781       3.6402       0.0000    2657.7629    1464.0000
  590.7024      96.0000     100.1925      -0.0067     122.1858       0.1912       3.5162       0.0000    2660.9995    1440.0000
  590.8548      96.0000     100.3067      -0.0077     114.5342       0.1927       3.4939       0.0000    2662.6931    1445.0000
  591.0072      96.0000     100.2945      -0.0049     123.5361       0.1931       3.4309       0.0000    2658.1284    1449.0000
  591.1596      96.0000     100.2497      -0.0079     138.9463       0.1998       3.4199       0.0000    2663.0630    1466.0000
  591.3120      96.0000     100.3390      -0.0105     144.2673       0.2088       3.3689       0.0000    2667.3645    1453.0000
  591.4644      96.0000     100.1123      -0.0105     150.6140       0.2130       3.4377       0.0000    2667.3130    1448.0000
  591.6168      96.0000      99.5972      -0.0066     145.6424       0.1998       3.4038       0.0000    2660.8076    1468.0000
  591.7692      96.0000      99.6665       0.0009     141.9883       0.1900       3.4026       0.0000    2648.4365    1471.0000
  591.9216      96.0000      99.1193       0.0088     130.0833       0.1801       3.1745       0.0000    2635.5054    1466.0000
  592.0740      96.0000      98.9565       0.0158     124.7478       0.1706       3.1213       0.0000    2624.0122    1442.0000
  592.2264      96.0000      99.1193       0.0226     123.7862       0.1601       3.0735       0.0000    2612.7104    1439.0000
  592.3788      96.0000      98.6793       0.0233     115.0071       0.1467       3.0895       0.0000    2611.5032    1462.0000
  592.5312      96.0000      99.0830       0.0165     112.0196       0.1379       3.1248       0.0000    2622.7009    1474.0000
  592.6836      96.0000      99.6540       0.0132     107.4211       0.1349       3.0207       0.0000    2628.1704    1418.0000
  592.8360      96.0000      99.3359       0.0130     106.7572       0.1353       3.1076       0.0000    2628.4700    1453.0000
  592.9884      96.0000      99.3237       0.0133     105.0249       0.1462       3.0094       0.0000    2628.0830    1484.0000
  593.1408      96.0000      99.2475       0.0171     109.6234       0.1621       3.1642       0.0000    2621.8567    1434.0000
  593.2932      96.0000      99.3238       0.0085     119.0664       0.1795       3.2580       0.0000    2635.9309    1452.0000
  593.4456      96.0000      99.3565       0.0019     125.2012       0.1894       3.5264       0.0000    2646.8235    1463.0000
  593.5980      96.0000      99.5766       0.0037     125.6056       0.1886       3.4826       0.0000    2643.9348    1443.0000
  593.7504      96.0000      99.6092       0.0185     125.7788       0.1835       3.3236       0.0000    2619.4314    1450.0000
  593.9028      96.0000      99.5384       0.0284     124.6652       0.1797       3.0832       0.0000    2603.1982    1463.0000
  594.0552      96.0000      99.5645       0.0334     115.4140       0.1765       3.1055       0.0000    2594.8572    1480.0000
  594.2076      96.0000      99.6214       0.0376     111.3867       0.1773       3.1243       0.0000    2587.9407    1455.0000
  594.3600      96.0000      99.4950       0.0453     104.0589       0.1719       3.1993       0.0000    2575.2512    1434.0000
  594.5124      96.0000      99.3238       0.0531     110.2132       0.1696       3.1756       0.0000    2562.3174    1490.0000
  594.6648      96.0000      99.3236       0.0581     103.6465       0.1692       3.1055       0.0000    2554.1331    1475.0000
  594.8172      96.0000      99.3237       0.0559      98.0826       0.1656       3.0408       0.0000    2557.8035    1422.0000
  594.9696      96.0000      99.2739       0.0501      93.0822       0.1634       3.0383       0.0000    2567.3621    1431.0000
  595.1220      96.0000      99.4256       0.0519      96.7760       0.1659       2.9930       0.0000    2564.4426    1476.0000
  595.2744      96.0000      99.3930       0.0594     100.8013       0.1783       3.0487       0.0000    2552.0144    1440.0000
  595.4268      96.0000      99.6093       0.0742     102.2483       0.1887       3.0055       0.0000    2527.5142    1410.0000
  595.5792      96.0000      99.5938       0.0783      98.5707       0.1927       3.1732       0.0000    2520.8718    1460.0000
  595.7316      96.0000      99.6664       0.0884      94.7378       0.1954       3.1295       0.0000    2504.1375    1477.0000
  595.8840      96.0000      99.7236       0.0905      90.2136       0.1932       3.1757       0.0000    2500.7334    1429.0000
  596.0364      96.0000      99.5074       0.0944      90.4027       0.1937       3.1597       0.0000    2494.1638    1447.0000
  596.1888      96.0000      99.5644       0.0937      90.9660       0.1936       3.1518       0.0000    2495.3489    1476.0000
  596.3412      96.0000      99.5938       0.0879      90.2108       0.1949       3.1541       0.0000    2504.8994    1473.0000
  596.4936      96.0000      99.8376       0.0846      95.4068       0.1930       3.1872       0.0000    2510.3596    1459.0000
  596.6460      96.0000      99.8500       0.0887      96.1761       0.1979       3.1679       0.0000    2503.5991    1450.0000
  596.7984      96.0000      99.3688       0.0950     101.4556       0.1975       3.1739       0.0000    2493.2671    1470.0000
  596.9508      96.0000      99.4372       0.0944     100.3179       0.1950       3.2278       0.0000    2494.1868    1473.0000
  597.1032      96.0000      99.4828       0.0924     110.3368       0.1883       3.4635       0.0000    2497.4822    1470.0000
  597.2556      96.0000      99.2097       0.0919     118.1415       0.1907       3.5177       0.0000    2498.3762    1446.0000
  597.4080      96.0000      98.8544       0.0899     123.7027       0.1901       3.3260       0.0000    2501.6118    1468.0000
  597.5604      96.0000      99.2095       0.0961     113.6980       0.1822       3.0439       0.0000    2491.3816    1488.0000
  597.7128      96.0000      99.1659       0.0933     104.8501       0.1696       3.0143       0.0000    2496.0308    1477.0000
  597.8652      96.0000      98.9478       0.0826      98.1345       0.1616       3.1662       0.0000    2513.7759    1456.0000
  598.0176      96.0000      98.7070       0.0617      97.0633       0.1513       3.3922       0.0000    2548.1567    1450.0000
  598.1700      96.0000      98.8093       0.0536      95.7133       0.1403       3.3196       0.0000    2561.4927    1481.0000
  598.3224      96.0000      98.8543       0.0570      92.8127       0.1287       3.2021       0.0000    2555.9238    1489.0000
  598.4748      96.0000      98.7401       0.0619      92.1521       0.1271       3.3576       0.0000    2547.8489    1461.0000
  598.6272      96.0000      98.2579       0.0569      85.0207       0.1279       3.3298       0.0000    2556.1580    1470.0000
  598.7796      96.0000      97.6079       0.0406      86.3669       0.1279       3.2947       0.0000    2582.9634    1469.0000
  598.9320      96.0000      98.1230       0.0228      89.4456       0.1277       3.2576       0.0000    2612.4197    1477.0000
  599.0844      96.0000      98.1803       0.0141      98.3546       0.1384       3.4196       0.0000    2626.7288    1474.0000
  599.2368      96.0000      98.6045       0.0198     104.5090       0.1592       3.5686       0.0000    2617.2820    1450.0000
  599.3892      96.0000      98.8430       0.0140     110.7245       0.1787       3.4805       0.0000    2626.8210    1452.0000
  599.5416      96.0000      98.6497       0.0063     115.0858       0.1832       3.5429       0.0000    2639.6741    1484.0000
  599.6940      96.0000      98.3969       0.0065     117.4126       0.1777       3.5582       0.0000    2639.2183    1485.0000
  599.8464      96.0000      98.2826       0.0213     119.0345       0.1707       3.3082       0.0000    2614.8442    1450.0000
  599.9988      96.0000      98.2826       0.0401     112.1259       0.1619       3.0756       0.0000    2583.8552    1459.0000
  600.1512      96.0000      98.5781       0.0578      95.5671       0.1487       2.8760       0.0000    2554.7051    1498.0000
  600.3036      96.0000      99.2214       0.0632      83.2743       0.1353       2.8915       0.0000    2545.6736    1516.0000
  600.4560      96.0000      99.3237       0.0644      73.4507       0.1294       2.8886       0.0000    2543.7292    1478.0000
  600.6084      96.0000      99.3115       0.0735      76.3481       0.1342       2.9086       0.0000    2528.8037    1427.0000
  600.7608      96.0000      99.3116       0.0718      73.0957       0.1419       2.9342       0.0000    2531.5933    1470.0000
  600.9132      96.0000      98.6498       0.0643      80.7886       0.1498       3.0400       0.0000    2543.9658    1509.0000
  601.0656      96.0000      98.4962       0.0455      82.3620       0.1519       3.2407       0.0000    2574.9060    1454.0000
  601.2180      96.0000      98.7282       0.0396      91.9940       0.1496       3.3423       0.0000    2584.6084    1436.0000
  601.3704      96.0000      98.4543       0.0391      94.3019       0.1450       3.3327       0.0000    2585.4902    1468.0000
  601.5228      96.0000      98.4781       0.0553      99.6374       0.1428       3.3235       0.0000    2558.7251    1487.0000
  601.6752      96.0000      98.7190       0.0622      95.3904       0.1446       3.2100       0.0000    2547.3467    1470.0000
  601.8276      96.0000      98.4090       0.0652      91.7497       0.1456       3.1582       0.0000    2542.3804    1461.0000
  601.9800      96.0000      98.9177       0.0637      86.9439       0.1402       3.1507       0.0000    2544.9119    1487.0000
  602.1324      96.0000      98.6950       0.0690      86.5593       0.1348       3.0995       0.0000    2536.1904    1488.0000
  602.2848      96.0000      98.4210       0.0713      84.5668       0.1283       3.1282       0.0000    2532.2776    1484.0000
  602.4372      96.0000      98.8544       0.0700      79.9510       0.1239       3.1078       0.0000    2534.5444    1471.0000
  602.5896      96.0000      98.4544       0.0633      78.2030       0.1196       3.1952       0.0000    2545.5691    1471.0000
  602.7420      96.0000      98.6889       0.0503      83.8513       0.1169       3.2943       0.0000    2566.9636    1462.0000
  602.8944      96.0000      98.4448       0.0410      86.7362       0.1201       3.3130       0.0000    2582.4290    1470.0000
  603.0468      96.0000      98.8333       0.0356      90.0371       0.1231       3.3314       0.0000    2591.2207    1487.0000
  603.1992      96.0000      99.1850       0.0320      89.0604       0.1269       3.2750       0.0000    2597.1814    1476.0000
  603.3516      96.0000      99.4052       0.0216      87.5939       0.1319       3.2770       0.0000    2614.3750    1475.0000
  603.5040      96.0000      99.5971       0.0089      85.2717       0.1342       3.2955       0.0000    2635.3914    1484.0000
  603.6564      96.0000      99.3654       0.0017      89.6951       0.1405       3.5245       0.0000    2647.1892    1489.0000
  603.8088      96.0000      98.9688       0.0045     100.9817       0.1454       3.4812       0.0000    2642.6440    1483.0000
  603.9612      96.0000      98.6618       0.0066     109.6536       0.1507       3.4979       0.0000    2639.1877    1481.0000
  604.1136      96.0000      98.1348       0.0124     114.4617       0.1564       3.3371       0.0000    2629.5667    1485.0000
  604.2660      96.0000      98.7068       0.0182     111.9992       0.1611       3.3663       0.0000    2619.9880    1457.0000
  604.4184      96.0000      98.4411       0.0243     107.5584       0.1582       3.3186       0.0000    2609.8511    1484.0000
  604.5708      96.0000      98.0203       0.0277     102.1898       0.1512       3.3188       0.0000    2604.3611    1490.0000
  604.7232      96.0000      98.1229       0.0231     101.9675       0.1453       3.2796       0.0000    2611.9585    1461.0000
  604.8756      96.0000      98.4662       0.0192     102.1751       0.1437       3.2067       0.0000    2618.3096    1481.0000
  605.0280      96.0000      98.9235       0.0209     102.2418       0.1400       3.2623       0.0000    2615.4900    1487.0000
  605.1804      96.0000      99.3654       0.0131      98.1979       0.1339       3.3706       0.0000    2628.3359    1476.0000
  605.3328      96.0000      99.0710       0.0063      98.7595       0.1335       3.6459       0.0000    2639.6309    1480.0000
  605.4852      96.0000      99.3688      -0.0000      95.2294       0.1348       3.5777       0.0000    2650.0100    1483.0000
  605.6376      96.0000      99.4951      -0.0037      97.7155       0.1385       3.6073       0.0000    2656.1172    1480.0000
  605.7900      96.0000      99.1765      -0.0100      95.7922       0.1448       3.6814       0.0000    2666.5667    1467.0000
  605.9424      96.0000      99.1194      -0.0070     102.9116       0.1476       3.7596       0.0000    2661.5945    1475.0000
  606.0948      96.0000      99.4110       0.0020     108.5907       0.1501       3.7158       0.0000    2646.7244    1495.0000
  606.2472      96.0000      99.0952       0.0084     117.2453       0.1578       3.5089       0.0000    2636.0825    1484.0000
  606.3996      96.0000      99.0621       0.0086     110.1852       0.1646       3.4517       0.0000    2635.8669    1475.0000
  606.5520      96.0000      98.9929       0.0078     107.0062       0.1715       3.4702       0.0000    2637.1536    1462.0000
  606.7044      96.0000      98.9237       0.0091     104.1162       0.1781       3.4508       0.0000    2634.9131    1466.0000
  606.8568      96.0000      98.7515       0.0050     112.5233       0.1880       3.5400       0.0000    2641.7192    1491.0000
  607.0092      96.0000      99.0621       0.0036     118.3494       0.1929       3.5099       0.0000    2644.0566    1485.0000
  607.1616      96.0000      98.6379       0.0055     126.8382       0.1857       3.5892       0.0000    2640.9856    1433.0000
  607.3140      96.0000      98.5686       0.0156     130.9268       0.1783       3.2802       0.0000    2624.2651    1454.0000
  607.4664      96.0000      98.5114       0.0311     121.2689       0.1718       3.1574       0.0000    2598.7244    1504.0000
  607.6188      96.0000      98.5926       0.0466     104.8999       0.1645       3.0538       0.0000    2573.0759    1488.0000
  607.7712      96.0000      99.7569       0.0590      91.1906       0.1576       3.0885       0.0000    2552.6584    1460.0000
  607.9236      96.0000      99.4502       0.0697      89.6374       0.1537       3.1170       0.0000    2535.0686    1459.0000
  608.0760      96.0000      99.0139       0.0750      92.3299       0.1552       3.1651       0.0000    2526.3071    1511.0000
  608.2284      96.0000      99.3479       0.0765      86.5574       0.1618       3.2937       0.0000    2523.7439    1485.0000
  608.3808      96.0000      99.2545       0.0788      83.4245       0.1607       3.2252       0.0000    2520.0605    1481.0000
  608.5332      96.0000      99.1174       0.0863      78.4240       0.1584       3.1498       0.0000    2507.6274    1470.0000
  608.6856      96.0000      98.9116       0.0895      81.1007       0.1481       3.0796       0.0000    2502.2512    1489.0000
  608.8380      96.0000      98.3971       0.0787      77.6947       0.1419       3.0804       0.0000    2520.1355    1471.0000
  608.9904      96.0000      98.4090       0.0665      71.7424       0.1348       3.0990       0.0000    2540.2231    1473.0000
  609.1428      96.0000      98.1349       0.0543      68.6695       0.1296       3.1265       0.0000    2560.3735    1471.0000
  609.2952      96.0000      98.4600       0.0376      70.8443       0.1241       3.2113       0.0000    2587.9509    1509.0000
  609.4476      96.0000      98.5807       0.0290      73.7193       0.1165       3.1973       0.0000    2602.1499    1476.0000
  609.6000      96.0000      98.5924       0.0223      68.7891       0.1146       3.1429       0.0000    2613.1958    1480.0000
  609.7524      96.0000      98.0658       0.0175      71.6147       0.1185       3.1041       0.0000    2621.0979    1477.0000
  609.9048      96.0000      98.1229       0.0113      71.8183       0.1267       3.1933       0.0000    2631.3433    1484.0000
  610.0572      96.0000      97.9739       0.0081      82.1336       0.1344       3.2008       0.0000    2636.5549    1494.0000
  610.2096      96.0000      98.4781       0.0166      89.4586       0.1467       3.3008       0.0000    2622.6841    1504.0000
  610.3620      96.0000      98.6497       0.0267     103.7619       0.1612       3.3655       0.0000    2605.8735    1483.0000
  610.5144      96.0000      98.5446       0.0452     108.1684       0.1728       3.3403       0.0000    2575.4819    1480.0000
  610.6668      96.0000      98.3971       0.0536     110.1252       0.1833       3.2962       0.0000    2561.5593    1506.0000
  610.8192      96.0000      98.4448       0.0565     105.4268       0.1789       3.1968       0.0000    2556.7607    1491.0000
  610.9716      96.0000      98.5517       0.0579     103.2228       0.1766       3.1991       0.0000    2554.5220    1455.0000
  611.1240      96.0000      98.6497       0.0653      93.7619       0.1647       3.1719       0.0000    2542.3044    1477.0000
  611.2764      96.0000      98.3970       0.0793      90.8770       0.1617       3.1759       0.0000    2519.2214    1476.0000
  611.4288      96.0000      98.5354       0.0887      91.9441       0.1580       3.1915       0.0000    2503.6614    1490.0000
  611.5812      96.0000      98.8213       0.0822      89.5028       0.1461       3.2498       0.0000    2514.4448    1499.0000
  611.7336      96.0000      98.2217       0.0647      84.5144       0.1301       3.2608       0.0000    2543.2075    1476.0000
  611.8860      96.0000      98.1920       0.0491      75.4322       0.1066       3.4264       0.0000    2568.9836    1484.0000
  612.0384      96.0000      98.2615       0.0373      74.9873       0.0935       3.4369       0.0000    2588.4443    1476.0000
  612.1908      96.0000      97.8940       0.0312      69.9748       0.0860       3.4693       0.0000    2598.5076    1482.0000
  612.3432      96.0000      97.8032       0.0299      66.7482       0.0843       3.3602       0.0000    2600.6514    1500.0000
  612.4956      96.0000      98.2216       0.0304      63.4994       0.0855       3.2345       0.0000    2599.9009    1455.0000
  612.6480      96.0000      98.1349       0.0319      65.7206       0.0898       3.2454       0.0000    2597.4150    1490.0000
  612.8004      96.0000      98.4662       0.0349      66.0862       0.0942       3.1334       0.0000    2592.3521    1505.0000
  612.9528      96.0000      99.0051       0.0346      69.7198       0.0969       3.3072       0.0000    2592.8547    1487.0000
  613.1052      96.0000      99.4380       0.0385      70.3835       0.0980       3.4105       0.0000    2586.5198    1476.0000
  613.2576      96.0000      98.9567       0.0375      78.5919       0.1005       3.5991       0.0000    2588.2061    1494.0000
  613.4100      96.0000      99.2642       0.0362      77.4260       0.1028       3.6433       0.0000    2590.3101    1497.0000
  613.5624      96.0000      98.9356       0.0247      78.7723       0.1104       3.4506       0.0000    2609.2358    1485.0000
  613.7148      96.0000      98.5474       0.0148      77.3358       0.1221       3.6222       0.0000    2625.5037    1467.0000
  613.8672      96.0000      98.4996       0.0031      84.8514       0.1400       3.6671       0.0000    2644.9009    1460.0000
  614.0196      96.0000      98.8210      -0.0055      97.1601       0.1612       3.7305       0.0000    2659.0400    1474.0000
  614.1720      96.0000      99.1823      -0.0090     109.6780       0.1773       3.5787       0.0000    2664.7874    1490.0000
  614.3244      96.0000      99.3806      -0.0100     128.1261       0.1875       3.4856       0.0000    2666.5698    1497.0000
  614.4768      96.0000      99.4259      -0.0022     137.5719       0.1843       3.6068       0.0000    2653.5669    1450.0000
  614.6292      96.0000      99.1971       0.0059     133.6547       0.1802       3.4412       0.0000    2640.3047    1467.0000
  614.7816      96.0000      99.3359       0.0172     115.2065       0.1677       3.3843       0.0000    2621.6792    1523.0000
  614.9340      96.0000      99.1465       0.0281      99.7987       0.1593       3.3443       0.0000    2603.5911    1494.0000
  615.0864      96.0000      99.1642       0.0318      99.4465       0.1532       3.2447       0.0000    2597.5098    1466.0000
  615.2388      96.0000      98.5235       0.0394     105.4114       0.1607       3.2015       0.0000    2585.0620    1464.0000
  615.3912      96.0000      98.4996       0.0471     113.0524       0.1639       3.3146       0.0000    2572.2764    1460.0000
  615.5436      96.0000      98.6498       0.0557     115.5526       0.1667       3.4758       0.0000    2558.0168    1469.0000
  615.6960      96.0000      98.6889       0.0584     114.5732       0.1607       3.4774       0.0000    2553.6040    1490.0000
  615.8484      96.0000      98.6376       0.0619     103.2867       0.1588       3.1430       0.0000    2547.8137    1497.0000
  616.0008      96.0000      99.0951       0.0586      94.0689       0.1560       3.0988       0.0000    2553.3398    1477.0000
  616.1532      96.0000      98.8665       0.0558      92.7226       0.1537       3.0420       0.0000    2558.0117    1443.0000
  616.3056      96.0000      98.9357       0.0489      99.0607       0.1504       3.2427       0.0000    2569.3191    1492.0000
  616.4580      96.0000      98.8166       0.0418     104.3018       0.1445       3.1957       0.0000    2580.9963    1478.0000
  616.6104      96.0000      98.5688       0.0359      99.5081       0.1350       3.4131       0.0000    2590.7490    1484.0000
  616.7628      96.0000      98.4209       0.0303      95.6175       0.1238       3.4549       0.0000    2600.0696    1495.0000
  616.9152      96.0000      98.2494       0.0252      86.9129       0.1131       3.6820       0.0000    2608.4524    1435.0000
  617.0676      96.0000      99.4951       0.0226      81.1288       0.1099       3.6024       0.0000    2612.7500    1485.0000
  617.2200      96.0000      99.4929       0.0190      76.9418       0.1105       3.4942       0.0000    2618.5723    1481.0000
  617.3724      96.0000      99.3114       0.0219      74.0556       0.1160       3.3869       0.0000    2613.8635    1477.0000
  617.5248      96.0000      99.3238       0.0246      75.5255       0.1201       3.2482       0.0000    2609.3455    1462.0000
  617.6772      96.0000      99.4623       0.0299      75.7178       0.1255       3.2518       0.0000    2600.7437    1481.0000
  617.8296      96.0000      99.3688       0.0319      78.9889       0.1311       3.2737       0.0000    2597.3911    1498.0000
  617.9820      96.0000      99.6787       0.0283      78.9756       0.1365       3.4566       0.0000    2603.2634    1464.0000
  618.1344      96.0000      99.5546       0.0305      78.6031       0.1453       3.4201       0.0000    2599.6348    1483.0000
  618.2868      96.0000      99.2908       0.0326      82.0525       0.1487       3.3511       0.0000    2596.2324    1482.0000
  618.4392      96.0000      99.2544       0.0353      88.0169       0.1521       3.1670       0.0000    2591.7627    1484.0000
  618.5916      96.0000      98.9808       0.0349      93.7745       0.1504       3.2457       0.0000    2592.4851    1453.0000
  618.7440      96.0000      99.0709       0.0274      94.3657       0.1463       3.4999       0.0000    2604.7478    1469.0000
  618.8964      96.0000      99.1727       0.0218      93.5291       0.1461       3.7982       0.0000    2613.9919    1492.0000
  619.0488      96.0000      98.7522       0.0201      91.4273       0.1435       3.8109       0.0000    2616.8215    1481.0000
  619.2012      96.0000      98.5474       0.0225      92.1824       0.1459       3.5617       0.0000    2612.8032    1467.0000
  619.3536      96.0000      98.6498       0.0244      96.3682       0.1420       3.3982       0.0000    2609.7617    1487.0000
  619.5060      96.0000      98.3518       0.0196      98.0999       0.1371       3.3959       0.0000    2617.6213    1474.0000
  619.6584      96.0000      98.7611       0.0159      97.5229       0.1296       3.5096       0.0000    2623.7673    1483.0000
  619.8108      96.0000      98.9477       0.0100      95.4050       0.1270       3.8092       0.0000    2633.4663    1480.0000
  619.9632      96.0000      99.1074       0.0055      96.3521       0.1266       3.9959       0.0000    2640.9338    1484.0000
  620.1156      96.0000      99.1644       0.0038      99.6374       0.1359       3.9734       0.0000    2643.7388    1482.0000
  620.2680      96.0000      99.3556       0.0059     103.3312       0.1404       3.7076       0.0000    2640.2532    1471.0000
  620.4204      96.0000      99.3930       0.0118      98.1385       0.1434       3.5135       0.0000    2630.5913    1483.0000
  620.5728      96.0000      99.4950       0.0086      99.0842       0.1411       3.4906       0.0000    2635.8157    1497.0000
  620.7252      96.0000      98.6710       0.0045      92.9071       0.1436       3.6703       0.0000    2642.6423    1482.0000
  620.8776      96.0000      98.4782      -0.0044      92.2486       0.1442       3.9155       0.0000    2657.1799    1478.0000
  621.0300      96.0000      98.4866      -0.0101      86.0942       0.1456       3.9811       0.0000    2666.6011    1499.0000
  621.1824      96.0000      98.3876      -0.0123      86.8489       0.1469       3.8785       0.0000    2670.2676    1484.0000
  621.3348      96.0000      98.6951      -0.0030      92.3896       0.1442       3.6711       0.0000    2655.0037    1495.0000
  621.4872      96.0000      98.8093       0.0094      96.6207       0.1398       3.5214       0.0000    2634.4961    1511.0000
  621.6396      96.0000      98.9236       0.0191      94.7115       0.1370       3.2841       0.0000    2618.4187    1491.0000
  621.7920      96.0000      98.7708       0.0323      94.2529       0.1399       3.1614       0.0000    2596.7849    1473.0000
  621.9444      96.0000      98.3183       0.0409      92.1517       0.1472       3.1611       0.0000    2582.5532    1487.0000
  622.0968      96.0000      97.9513       0.0437      94.6379       0.1498       3.2109       0.0000    2577.9290    1476.0000
  622.2492      96.0000      98.1921       0.0447      95.3018       0.1578       3.1662       0.0000    2576.1780    1511.0000
  622.4016      96.0000      98.2039       0.0490      94.9027       0.1579       3.1130       0.0000    2569.0828    1488.0000
  622.5540      96.0000      98.2960       0.0572      97.6117       0.1560       3.3700       0.0000    2555.6755    1503.0000
  622.7064      96.0000      98.1231       0.0623      96.9804       0.1453       3.6387       0.0000    2547.2798    1478.0000
  622.8588      96.0000      98.0204       0.0673      98.7264       0.1360       3.9782       0.0000    2539.0049    1477.0000
  623.0112      96.0000      98.0658       0.0590      90.3971       0.1275       4.0218       0.0000    2552.6587    1488.0000
  623.1636      96.0000      98.3066       0.0458      88.3443       0.1236       3.9914       0.0000    2574.4219    1478.0000
  623.3160      96.0000      98.5420       0.0345      86.7721       0.1202       3.9978       0.0000    2593.1372    1492.0000
  623.4684      96.0000      98.4662       0.0391      88.1745       0.1193       3.8246       0.0000    2585.5623    1492.0000
  623.6208      96.0000      98.5686       0.0431      87.9711       0.1192       3.9900       0.0000    2578.9509    1473.0000
  623.7732      96.0000      98.4543       0.0399      88.5812       0.1129       3.8876       0.0000    2584.1545    1494.0000
  623.9256      96.0000      98.0203       0.0273      85.6831       0.1062       3.8614       0.0000    2604.8904    1517.0000
  624.0780      96.0000      98.4600       0.0147      83.6883       0.0978       3.7131       0.0000    2625.8149    1487.0000
  624.2304      96.0000      98.2611       0.0066      78.8656       0.0962       3.7101       0.0000    2639.1563    1519.0000
  624.3828      96.0000      98.0085       0.0083      81.3873       0.0935       3.8758       0.0000    2636.2654    1489.0000
  624.5352      96.0000      98.1228       0.0096      82.1439       0.0942       3.9848       0.0000    2634.1050    1491.0000
  624.6876      96.0000      97.9056       0.0062      83.6956       0.0956       4.1433       0.0000    2639.8040    1498.0000
  624.8400      96.0000      98.4901       0.0019      88.8668       0.0994       3.9977       0.0000    2646.8938    1499.0000
  624.9924      96.0000      99.1990      -0.0058      93.0979       0.1042       4.0498       0.0000    2659.5820    1491.0000
  625.1448      96.0000      98.8785      -0.0005      98.0314       0.1161       4.0696       0.0000    2650.8130    1504.0000
  625.2972      96.0000      98.7973       0.0012      92.4669       0.1261       3.9972       0.0000    2647.9841    1480.0000
  625.4496      96.0000      98.8784       0.0072      82.5004       0.1324       3.7888       0.0000    2638.0481    1482.0000
  625.6020      96.0000      99.3115       0.0097      80.4531       0.1279       3.7761       0.0000    2634.0393    1491.0000
  625.7544      96.0000      98.9443       0.0004      81.2095       0.1277       4.1420       0.0000    2649.3940    1487.0000
  625.9068      96.0000      98.4089      -0.0074      93.3279       0.1354       4.3451       0.0000    2662.1626    1492.0000
  626.0592      96.0000      97.6650      -0.0207      94.4675       0.1447       4.1886       0.0000    2684.0845    1494.0000
  626.2116      96.0000      98.2492      -0.0188     104.1014       0.1502       3.9349       0.0000    2681.0344    1504.0000
  626.3640      96.0000      97.9632      -0.0147     101.7572       0.1533       3.6764       0.0000    2674.2739    1495.0000
  626.5164      96.0000      98.3038      -0.0024     101.7722       0.1574       3.5565       0.0000    2654.0295    1475.0000
  626.6688      96.0000      98.5355       0.0010     103.4853       0.1617       3.3826       0.0000    2648.2920    1511.0000
  626.8212      96.0000      98.6497      -0.0013     117.1161       0.1681       3.4270       0.0000    2652.1985    1516.0000
  626.9736      96.0000      99.1765      -0.0035     133.2564       0.1714       3.5270       0.0000    2655.6946    1502.0000
  627.1260      96.0000      99.0501      -0.0035     136.9105       0.1757       3.5332       0.0000    2655.7473    1475.0000
  627.2784      96.0000      98.8069       0.0058     134.2623       0.1690       3.4660       0.0000    2640.3850    1513.0000
  627.4308      96.0000      98.9356       0.0075     127.6337       0.1618       3.4024       0.0000    2637.6128    1497.0000
  627.5832      96.0000      99.5194       0.0105     119.1714       0.1542       3.3031       0.0000    2632.7292    1500.0000
  627.7356      96.0000      99.6663       0.0070     115.6895       0.1516       3.4505       0.0000    2638.3801    1504.0000
  627.8880      96.0000      99.9071       0.0028     122.1483       0.1642       3.4802       0.0000    2645.4023    1509.0000
  628.0404      96.0000      99.9593      -0.0023     127.3535       0.1797       3.6576       0.0000    2653.8621    1495.0000
  628.1928      96.0000     100.0660      -0.0054     128.6998       0.1907       3.7632       0.0000    2658.8391    1475.0000
  628.3452      96.0000     100.3962      -0.0076     120.1889       0.1926       3.9511       0.0000    2662.4600    1491.0000
  628.4976      96.0000     100.4208      -0.0099     124.7922       0.1889       3.9979       0.0000    2666.4109    1480.0000
  628.6500      96.0000     100.5475      -0.0051     129.4080       0.1887       3.7256       0.0000    2658.3928    1474.0000
  628.8024      96.0000     100.6616      -0.0051     131.7616       0.1840       3.4937       0.0000    2658.4292    1506.0000
  628.9548      96.0000     100.7610      -0.0046     128.8767       0.1783       3.5330       0.0000    2657.6387    1500.0000
  629.1072      96.0000     100.2944      -0.0019     128.8980       0.1752       3.5398       0.0000    2653.1333    1470.0000
  629.2596      96.0000     100.3192       0.0009     124.4550       0.1749       3.7233       0.0000    2648.4910    1507.0000
  629.4120      96.0000     100.1355      -0.0031     120.2740       0.1764       3.9381       0.0000    2655.1953    1491.0000
  629.5644      96.0000     100.1355      -0.0040     109.0980       0.1806       4.2193       0.0000    2656.6133    1470.0000
  629.7168      96.0000     100.3146      -0.0066     113.6499       0.1791       4.0783       0.0000    2660.9231    1482.0000
  629.8692      96.0000     100.4655      -0.0069     116.2922       0.1829       3.8760       0.0000    2661.3254    1466.0000
  630.0216      96.0000     100.1356      -0.0088     124.9669       0.1800       3.5898       0.0000    2664.4517    1495.0000
  630.1740      96.0000     100.1479      -0.0030     118.4918       0.1719       3.5713       0.0000    2655.0017    1510.0000
  630.3264      96.0000     100.3637       0.0002     112.5661       0.1604       3.5608       0.0000    2649.6106    1481.0000
  630.4788      96.0000      99.9593      -0.0007     102.9297       0.1510       3.8912       0.0000    2651.1638    1469.0000
  630.6312      96.0000      99.7481      -0.0023     100.6374       0.1506       4.0710       0.0000    2653.7290    1503.0000
  630.7836      96.0000      99.6664      -0.0045      96.3699       0.1486       4.1628       0.0000    2657.3625    1474.0000
  630.9360      96.0000      99.8256      -0.0056      93.2637       0.1486       4.0653       0.0000    2659.2493    1473.0000
  631.0884      96.0000      99.4951      -0.0009      94.5944       0.1558       3.8626       0.0000    2651.5417    1504.0000
  631.2408      96.0000      99.5277       0.0049      98.2644       0.1635       3.7434       0.0000    2641.8582    1503.0000
  631.3932      96.0000      99.0548       0.0119     104.6401       0.1662       3.6987       0.0000    2630.3035    1446.0000
  631.5456      96.0000      99.3480       0.0159     107.3326       0.1626       3.7503       0.0000    2623.7097    1484.0000
  631.6980      96.0000      98.9809       0.0174     110.3927       0.1582       3.8865       0.0000    2621.3645    1516.0000
  631.8504      96.0000      99.0621       0.0215     110.0250       0.1501       3.8580       0.0000    2614.4475    1498.0000
  632.0028      96.0000      99.1193       0.0217     104.2879       0.1416       3.9918       0.0000    2614.2590    1468.0000
  632.1552      96.0000      99.0549       0.0236      94.4933       0.1356       3.9321       0.0000    2611.1169    1510.0000
  632.3076      96.0000      98.8906       0.0239      89.6683       0.1469       3.8313       0.0000    2610.5381    1485.0000
  632.4600      96.0000      98.8665       0.0173      96.0454       0.1680       3.6520       0.0000    2621.5371    1480.0000
  632.6124      96.0000      98.8092       0.0089     113.9190       0.1957       3.5649       0.0000    2635.2551    1498.0000
  632.7648      96.0000      98.9356      -0.0020     129.5193       0.2172       3.5880       0.0000    2653.2654    1499.0000
  632.9172      96.0000      99.2476      -0.0077     144.4575       0.2282       3.6903       0.0000    2662.7830    1477.0000
  633.0696      96.0000      98.8424      -0.0042     140.4378       0.2244       3.8519       0.0000    2656.9839    1498.0000
  633.2220      96.0000      98.8665       0.0060     131.8437       0.2129       3.7913       0.0000    2640.1697    1494.0000
  633.3744      96.0000      98.9688       0.0124     109.5484       0.1929       3.5096       0.0000    2629.5457    1489.0000
  633.5268      96.0000      98.9080       0.0179      98.5668       0.1765       3.2184       0.0000    2620.4810    1498.0000
  633.6792      96.0000      98.9358       0.0154      89.6373       0.1649       3.1061       0.0000    2624.6191    1499.0000
  633.8316      96.0000      99.4257       0.0142      94.4477       0.1645       3.2090       0.0000    2626.5718    1498.0000
  633.9840      96.0000      99.4949       0.0108      94.5980       0.1688       3.3204       0.0000    2632.1111    1495.0000
  634.1364      96.0000      99.7235       0.0088     104.4066       0.1719       3.4727       0.0000    2635.5403    1517.0000
  634.2888      96.0000      99.8746       0.0081     109.0059       0.1744       3.6003       0.0000    2636.5891    1500.0000
  634.4412      96.0000      99.8581       0.0087     116.3736       0.1689       3.6662       0.0000    2635.5869    1467.0000
  634.5936      96.0000      99.6664       0.0148     112.4356       0.1663       3.7638       0.0000    2625.6189    1504.0000
  634.7460      96.0000      99.9519       0.0130     110.3200       0.1594       3.7453       0.0000    2628.5154    1527.0000
  634.8984      96.0000      99.9071       0.0159     107.2253       0.1541       3.8398       0.0000    2623.8098    1478.0000
  635.0508      96.0000      99.4951       0.0136     101.8899       0.1497       3.7366       0.0000    2627.4900    1476.0000
  635.2032      96.0000      99.7309       0.0080      94.9806       0.1499       3.8135       0.0000    2636.8669    1516.0000
  635.3556      96.0000      99.8827       0.0016      89.5955       0.1521       3.7343       0.0000    2647.3469    1527.0000
  635.5080      96.0000     100.2620      -0.0025      92.3300       0.1534       3.8199       0.0000    2654.1709    1477.0000
  635.6604      96.0000     100.1355      -0.0062      99.5075       0.1486       3.8527       0.0000    2660.1887    1464.0000
  635.8128      96.0000     101.0486      -0.0034     105.6783       0.1480       4.0079       0.0000    2655.6270    1521.0000
  635.9652      96.0000     100.8523      -0.0021     104.5244       0.1440       4.1118       0.0000    2653.4663    1496.0000
  636.1176      96.0000     100.3763      -0.0059      92.7166       0.1481       4.1717       0.0000    2659.7722    1448.0000
  636.2700      96.0000     100.8772      -0.0116      88.8683       0.1495       4.3001       0.0000    2669.1167    1517.0000
  636.4224      96.0000     101.0802      -0.0116      93.0995       0.1570       4.1730       0.0000    2669.1069    1514.0000
  636.5748      96.0000     100.6366      -0.0055     109.6271       0.1730       3.8760       0.0000    2659.1052    1489.0000
  636.7272      96.0000     100.6797      -0.0001     124.8061       0.1951       3.6002       0.0000    2650.2009    1478.0000
  636.8796      96.0000     101.3650       0.0008     139.2539       0.2115       3.7272       0.0000    2648.7090    1537.0000
  637.0320      96.0000     101.0735      -0.0006     151.3613       0.2202       3.8852       0.0000    2650.9500    1505.0000
  637.1844      96.0000     101.2638      -0.0004     156.1694       0.2216       3.8395       0.0000    2650.6992    1456.0000
  637.3368      96.0000     101.3335      -0.0010     152.6841       0.2108       3.7249       0.0000    2651.6533    1505.0000
  637.4892      96.0000     101.2270       0.0017     142.3407       0.1981       3.7108       0.0000    2647.2175    1513.0000
  637.6416      96.0000     101.4031       0.0061     132.8193       0.1839       3.6223       0.0000    2639.9751    1488.0000
  637.7940      96.0000     101.5171       0.0133     124.1825       0.1777       3.6323       0.0000    2628.0627    1470.0000
  637.9464      96.0000     101.4473       0.0046     119.1351       0.1734       3.8168       0.0000    2642.3794    1532.0000
  638.0988      96.0000     101.4791      -0.0047     110.1934       0.1696       4.2721       0.0000    2657.7390    1531.0000
  638.2512      96.0000     100.9991      -0.0143     101.5210       0.1719       4.1379       0.0000    2673.6531    1449.0000
  638.4036      96.0000     100.2944      -0.0089     100.4112       0.1740       3.8105       0.0000    2664.7158    1467.0000
  638.5560      96.0000     100.3067      -0.0055     110.7967       0.1774       3.5551       0.0000    2659.0488    1520.0000
  638.7084      96.0000     100.2497      -0.0043     122.1438       0.1791       3.4557       0.0000    2657.0339    1497.0000
  638.8608      96.0000      99.7234       0.0031     127.1526       0.1747       3.3783       0.0000    2644.8169    1481.0000
  639.0132      96.0000      99.6493       0.0059     126.7880       0.1729       3.2781       0.0000    2640.3389    1491.0000
  639.1656      96.0000      99.7235       0.0137     124.8648       0.1716       3.3939       0.0000    2627.4438    1534.0000
  639.3180      96.0000      99.5970       0.0147     116.8616       0.1668       3.4168       0.0000    2625.7925    1524.0000
  639.4704      96.0000      99.2994       0.0149     109.1486       0.1614       3.5424       0.0000    2625.3601    1457.0000
  639.6228      96.0000      99.2664       0.0066     107.4351       0.1546       3.6240       0.0000    2639.0552    1495.0000
  639.7752      96.0000      99.0812      -0.0003     112.3400       0.1538       3.5375       0.0000    2650.4268    1556.0000
  639.9276      96.0000      98.9929       0.0069     117.7440       0.1529       3.4226       0.0000    2638.6255    1485.0000
  640.0800      96.0000      99.0710       0.0145     115.0341       0.1482       3.1779       0.0000    2626.0037    1475.0000
  640.2324      96.0000      99.2994       0.0203     104.8356       0.1474       3.2743       0.0000    2616.4563    1477.0000
  640.3848      96.0000      99.2665       0.0202      93.5684       0.1469       3.3549       0.0000    2616.7363    1510.0000
  640.5372      96.0000      99.5023       0.0188      88.7742       0.1555       3.5455       0.0000    2619.0347    1488.0000
  640.6896      96.0000      99.6786       0.0121      97.4288       0.1615       3.5906       0.0000    2630.0940    1500.0000
  640.8420      96.0000      99.7358       0.0095     104.8477       0.1798       3.5150       0.0000    2634.3628    1485.0000
  640.9944      96.0000      99.6095       0.0087     113.1038       0.1904       3.4811       0.0000    2635.6960    1490.0000
  641.1468      96.0000      99.7481       0.0107     115.2193       0.1989       3.3726       0.0000    2632.3228    1492.0000
  641.2992      96.0000      99.6493       0.0088     125.0380       0.1918       3.2910       0.0000    2635.4329    1503.0000
  641.4516      96.0000      99.7683       0.0057     137.5627       0.1889       3.3198       0.0000    2640.5994    1497.0000
  641.6040      96.0000     100.0336       0.0030     148.4771       0.1830       3.4130       0.0000    2645.0256    1497.0000
  641.7564      96.0000     100.2620       0.0093     145.2004       0.1730       3.5190       0.0000    2634.6670    1518.0000
  641.9088      96.0000      99.8499       0.0165     128.2523       0.1596       3.4726       0.0000    2622.7607    1485.0000
  642.0612      96.0000      99.7666       0.0296     101.5674       0.1392       3.2396       0.0000    2601.1863    1476.0000
  642.2136      96.0000      99.4378       0.0408      81.6553       0.1251       3.2106       0.0000    2582.7356    1485.0000
  642.3660      96.0000      99.4052       0.0506      75.8985       0.1144       3.1826       0.0000    2566.4326    1506.0000
  642.5184      96.0000      98.8785       0.0523      77.8218       0.1225       3.5404       0.0000    2563.7361    1492.0000
  642.6708      96.0000      98.9356       0.0530      83.4817       0.1308       3.4745       0.0000    2562.5667    1492.0000
  642.8232      96.0000      98.5974       0.0521      91.8910       0.1425       3.4730       0.0000    2564.1152    1494.0000
  642.9756      96.0000      98.1920       0.0518      99.6002       0.1502       3.2410       0.0000    2564.5801    1478.0000
  643.1280      96.0000      97.8486       0.0550     104.4083       0.1571       3.2053       0.0000    2559.2302    1476.0000
  643.2804      96.0000      97.8248       0.0589     102.1404       0.1538       3.2757       0.0000    2552.7561    1495.0000
  643.4328      96.0000      97.6196       0.0627     100.4087       0.1433       3.2594       0.0000    2546.5571    1494.0000
  643.5852      96.0000      97.9280       0.0554      94.8312       0.1316       3.3592       0.0000    2558.5151    1481.0000
  643.7376      96.0000      98.2731       0.0466      92.7897       0.1381       3.1186       0.0000    2573.1582    1488.0000
  643.8900      96.0000      98.6258       0.0348      89.8894       0.1490       3.1283       0.0000    2592.6499    1494.0000
  644.0424      96.0000      98.9927       0.0186     104.3337       0.1737       3.3885       0.0000    2619.2876    1492.0000
  644.1948      96.0000      98.9808       0.0006     121.7611       0.2028       3.7308       0.0000    2649.0632    1503.0000
  644.3472      96.0000      98.3591      -0.0074     146.9600       0.2412       4.0108       0.0000    2662.2695    1488.0000
  644.4996      96.0000      98.3758      -0.0125     161.3644       0.2589       3.8374       0.0000    2670.5845    1491.0000
  644.6520      96.0000      98.1466      -0.0102     165.4840       0.2582       3.8482       0.0000    2666.7813    1500.0000
  644.8044      96.0000      98.3970      -0.0046     163.3640       0.2404       3.7759       0.0000    2657.5771    1502.0000
  644.9568      96.0000      98.0658       0.0016     154.5397       0.2208       3.8973       0.0000    2647.4214    1506.0000
  645.1092      96.0000      98.1855       0.0027     147.7275       0.1940       3.8886       0.0000    2645.6226    1461.0000
  645.2616      96.0000      98.3185       0.0103     131.5896       0.1736       3.5658       0.0000    2632.9927    1512.0000
  645.4140      96.0000      98.5232       0.0102     118.7645       0.1572       3.1049       0.0000    2633.2307    1483.0000
  645.5664      96.0000      98.6498       0.0062     106.0767       0.1439       3.0422       0.0000    2639.8115    1455.0000
  645.7188      96.0000      98.4662      -0.0005     109.9249       0.1419       3.3366       0.0000    2650.9001    1468.0000
  645.8712      96.0000      97.8188      -0.0043     110.3530       0.1670       3.9166       0.0000    2657.1616    1470.0000
  646.0236      96.0000      97.8368      -0.0090     109.9628       0.1925       4.1219       0.0000    2664.8491    1454.0000
  646.1760      96.0000      97.6768      -0.0055     113.0858       0.1965       4.1405       0.0000    2659.0874    1438.0000
  646.3284      96.0000      97.6884      -0.0037     116.4211       0.1846       3.9497       0.0000    2656.1038    1511.0000
  646.4808      96.0000      97.4817       0.0028     122.4016       0.1780       3.9168       0.0000    2645.2993    1474.0000
  646.6332      96.0000      97.7459       0.0045     115.0283       0.1754       3.7581       0.0000    2642.5732    1452.0000
  646.7856      96.0000      97.9468       0.0129     113.2974       0.1679       3.5885       0.0000    2628.6584    1491.0000
  646.9380      96.0000      97.7340       0.0189     109.9694       0.1623       3.2952       0.0000    2618.8440    1483.0000
  647.0904      96.0000      97.7109       0.0229     109.9694       0.1584       3.2092       0.0000    2612.1897    1506.0000
  647.2428      96.0000      97.8369       0.0193     108.2552       0.1503       3.2251       0.0000    2618.2366    1475.0000
  647.3952      96.0000      97.5900       0.0220     110.9229       0.1416       3.2826       0.0000    2613.6602    1512.0000
  647.5476      96.0000      97.5050       0.0267     110.1536       0.1381       3.3087       0.0000    2605.9155    1466.0000
  647.7000      96.0000      98.4901       0.0258     105.5211       0.1401       3.3172       0.0000    2607.4094    1494.0000
  647.8524      96.0000      99.1073       0.0189     100.2166       0.1442       3.3265       0.0000    2618.7583    1562.0000
  648.0048      96.0000      99.5521       0.0147     103.8707       0.1502       3.5168       0.0000    2625.7415    1496.0000
  648.1572      96.0000      98.5422       0.0108     118.1239       0.1631       3.6607       0.0000    2632.1028    1454.0000
  648.3096      96.0000      98.3183      -0.0005     125.4602       0.1742       3.8793       0.0000    2650.8328    1518.0000
  648.4620      96.0000      98.2041      -0.0053     129.7118       0.1781       3.7880       0.0000    2658.7654    1494.0000
  648.6144      96.0000      98.0895      -0.0004     128.1520       0.1748       3.6933       0.0000    2650.6233    1485.0000
  648.7668      96.0000      98.1229       0.0147     127.3391       0.1626       3.6016       0.0000    2625.7336    1484.0000
  648.9192      96.0000      97.9834       0.0169     125.7290       0.1439       3.5278       0.0000    2622.1746    1492.0000
  649.0716      96.0000      98.3065       0.0091     112.4729       0.1243       3.5764       0.0000    2634.9182    1507.0000
  649.2240      96.0000      98.7882       0.0040     108.8188       0.1170       3.6525       0.0000    2643.4517    1464.0000
  649.3764      96.0000      98.8786       0.0030      99.5843       0.1228       3.6550       0.0000    2645.1011    1509.0000
  649.5288      96.0000      99.5072      -0.0021     113.4174       0.1357       3.6410       0.0000    2653.4409    1537.0000
  649.6812      96.0000      99.4469      -0.0025     126.9035       0.1623       3.7159       0.0000    2654.1250    1504.0000
  649.8336      96.0000      99.6909      -0.0019     136.7659       0.1841       3.8635       0.0000    2653.0938    1511.0000
  649.9860      96.0000      99.7929       0.0019     136.9582       0.2008       3.9232       0.0000    2646.8096    1507.0000
  650.1384      96.0000     100.1926       0.0052     131.4482       0.1945       3.8251       0.0000    2641.3438    1498.0000
  650.2908      96.0000     101.3335       0.0029     130.1213       0.1917       3.8994       0.0000    2645.2075    1538.0000
  650.4432      96.0000     101.3081       0.0005     121.6590       0.1808       4.1199       0.0000    2649.1912    1510.0000
  650.5956      96.0000     101.5171      -0.0013     114.0676       0.1789       4.0503       0.0000    2652.0771    1499.0000
  650.7480      96.0000     101.7450       0.0018     120.5124       0.1749       3.8352       0.0000    2646.9521    1498.0000
  650.9004      96.0000     101.8336      -0.0007     122.2433       0.1786       3.5648       0.0000    2651.1704    1535.0000
  651.0528      96.0000     101.8148      -0.0038     130.7268       0.1778       3.7147       0.0000    2656.2595    1524.0000
  651.2052      96.0000     102.2007      -0.0065     127.5321       0.1837       3.6824       0.0000    2660.7817    1481.0000
  651.3576      96.0000     101.7492      -0.0045     137.0349       0.1916       3.6172       0.0000    2657.3696    1502.0000
  651.5100      96.0000     101.7323      -0.0060     134.1288       0.1976       3.5391       0.0000    2659.8550    1562.0000
  651.6624      96.0000     101.5359      -0.0079     132.4180       0.1945       3.7285       0.0000    2663.0066    1492.0000
  651.8148      96.0000     101.2446      -0.0112     128.9294       0.1911       3.9721       0.0000    2668.5437    1460.0000
  651.9672      96.0000     100.9890      -0.0126     127.1985       0.1868       3.8361       0.0000    2670.7310    1552.0000
  652.1196      96.0000     100.7188      -0.0051     126.6014       0.1786       3.7249       0.0000    2658.4219    1516.0000
  652.2720      96.0000     100.3389       0.0014     131.1877       0.1682       3.4816       0.0000    2647.7007    1476.0000
  652.4244      96.0000     100.3636       0.0071     131.5724       0.1592       3.4834       0.0000    2638.2871    1520.0000
  652.5768      96.0000     100.2249       0.0057     126.7818       0.1545       3.4857       0.0000    2640.5286    1525.0000
  652.7292      96.0000     100.2495       0.0095     119.0662       0.1536       3.5017       0.0000    2634.3989    1517.0000
  652.8816      96.0000     100.2789       0.0074     111.9608       0.1534       3.4493       0.0000    2637.8069    1477.0000
  653.0340      96.0000     100.4209       0.0059     108.6737       0.1581       3.2595       0.0000    2640.2148    1519.0000
  653.1864      96.0000     100.5225       0.0073     107.5383       0.1623       3.3520       0.0000    2637.9658    1530.0000
  653.3388      96.0000     100.2744       0.0012     115.2207       0.1799       3.6162       0.0000    2648.0974    1483.0000
  653.4912      96.0000     100.2498      -0.0046     127.1448       0.1956       3.8196       0.0000    2657.5132    1502.0000
  653.6436      96.0000     100.4060      -0.0062     137.9763       0.2082       3.8724       0.0000    2660.2712    1553.0000
  653.7960      96.0000     100.9662      -0.0078     148.7464       0.2140       3.7556       0.0000    2662.9373    1498.0000
  653.9484      96.0000     100.6365      -0.0041     148.1908       0.2064       3.6095       0.0000    2656.8474    1477.0000
  654.1008      96.0000     100.5922       0.0030     150.0377       0.2012       3.4452       0.0000    2645.0024    1539.0000
  654.2532      96.0000     100.1928       0.0120     141.5754       0.1814       3.2591       0.0000    2630.2166    1526.0000
  654.4056      96.0000      99.8321       0.0139     138.0922       0.1752       3.3650       0.0000    2627.0137    1503.0000
  654.5580      96.0000      99.4829       0.0150     127.1456       0.1601       3.3345       0.0000    2625.2866    1523.0000
  654.7104      96.0000      99.8051       0.0171     125.0300       0.1553       3.3260       0.0000    2621.7666    1495.0000
  654.8628      96.0000      99.3930       0.0230     112.7352       0.1419       3.1743       0.0000    2611.9976    1523.0000
  655.0152      96.0000      99.2787       0.0210     105.0230       0.1430       3.3069       0.0000    2615.3088    1518.0000
  655.1676      96.0000      99.2641       0.0139     101.8681       0.1431       3.4633       0.0000    2627.0364    1559.0000
  655.3200      96.0000     100.2622       0.0087     110.7010       0.1511       3.8025       0.0000    2635.5935    1503.0000
  655.4724      96.0000     100.1230       0.0004     121.8767       0.1638       3.7501       0.0000    2649.2749    1483.0000
  655.6248      96.0000      99.9888      -0.0051     132.9169       0.1792       3.8294       0.0000    2658.3416    1539.0000
  655.7772      96.0000     100.0336      -0.0157     138.1747       0.1884       3.7084       0.0000    2675.8364    1495.0000
  655.9296      96.0000      99.6297      -0.0182     133.9227       0.1797       3.7131       0.0000    2679.9746    1490.0000
  656.0820      96.0000      99.1401      -0.0196     122.0162       0.1697       3.7026       0.0000    2682.3511    1491.0000
  656.2344      96.0000      99.1073      -0.0134     109.8348       0.1598       3.7884       0.0000    2672.0911    1485.0000
  656.3868      96.0000      98.7521      -0.0128     103.3063       0.1523       3.9502       0.0000    2671.1011    1494.0000
  656.5392      96.0000      98.8070       0.0011      95.0187       0.1445       3.8267       0.0000    2648.1594    1537.0000
  656.6916      96.0000      98.9477       0.0132      93.0407       0.1441       3.5192       0.0000    2628.1697    1526.0000
  656.8440      96.0000      98.6137       0.0290      90.3375       0.1486       3.3112       0.0000    2602.1313    1509.0000
  656.9964      96.0000      98.7882       0.0350      93.0451       0.1505       3.4042       0.0000    2592.2437    1538.0000
  657.1488      96.0000      98.6950       0.0353     103.4855       0.1520       3.5438       0.0000    2591.6792    1516.0000
  657.3012      96.0000      98.5420       0.0312     110.9861       0.1568       3.6075       0.0000    2598.4834    1528.0000
  657.4536      96.0000      98.3757       0.0342     116.7585       0.1624       3.4710       0.0000    2593.6433    1524.0000
  657.6060      96.0000      98.3518       0.0358     113.6814       0.1692       3.4239       0.0000    2591.0024    1523.0000
  657.7584      96.0000      98.5472       0.0360     116.2714       0.1717       3.3946       0.0000    2590.5259    1520.0000
  657.9108      96.0000      98.4901       0.0281     118.9462       0.1782       3.3776       0.0000    2603.7131    1542.0000
  658.0632      96.0000      98.6378       0.0199     129.3539       0.1813       3.4559       0.0000    2617.1108    1518.0000
  658.2156      96.0000      99.0453       0.0097     137.3325       0.1886       3.6974       0.0000    2634.0181    1516.0000
  658.3680      96.0000     100.0087       0.0033     145.0481       0.1957       3.8820       0.0000    2644.5588    1544.0000
  658.5204      96.0000     100.0537       0.0028     145.4105       0.2045       3.8611       0.0000    2645.3428    1539.0000
  658.6728      96.0000     103.3958      -0.0010     142.5566       0.2065       3.7730       0.0000    2651.5864    1516.0000
  658.8252      96.0000     100.8065      -0.0115     146.9995       0.2089       3.8206       0.0000    2668.9858    1496.0000
  658.9776      96.0000     100.2051      -0.0103     144.8840       0.2133       4.0007       0.0000    2667.0393    1533.0000
  659.1300      96.0000     101.4912      -0.0008     145.6315       0.2244       4.1414       0.0000    2651.3401    1526.0000
  659.2824      96.0000      99.6787      -0.0016     145.9989       0.2259       3.9574       0.0000    2652.6855    1498.0000
  659.4348      96.0000     102.0038       0.0021     156.4252       0.2276       3.7674       0.0000    2646.5854    1509.0000
  659.5872      96.0000     103.5145       0.0091     162.2197       0.2213       3.6724       0.0000    2634.9202    1559.0000
  659.7396      96.0000     102.2137       0.0057     160.0793       0.2186       3.4531       0.0000    2640.6597    1517.0000
  659.8920      96.0000      99.0953       0.0128     146.0186       0.2053       3.4066       0.0000    2628.9258    1478.0000
  660.0444      96.0000      99.1644       0.0254     139.4548       0.1889       3.2792       0.0000    2608.0588    1569.0000
  660.1968      96.0000      99.0951       0.0348     120.2964       0.1723       3.3664       0.0000    2592.6179    1589.0000
  660.3492      96.0000      99.0354       0.0295     114.6993       0.1637       3.5752       0.0000    2601.3655    1474.0000
  660.5016      96.0000      98.6498       0.0210     110.2954       0.1686       3.7453       0.0000    2615.3179    1561.0000
  660.6540      96.0000      98.7070       0.0123     115.6065       0.1751       3.7969       0.0000    2629.7087    1661.0000
  660.8064      96.0000      98.7401       0.0117     122.5694       0.1844       3.4748       0.0000    2630.6309    1547.0000
  660.9588      96.0000      98.9177       0.0110     116.9723       0.1891       3.3349       0.0000    2631.8059    1495.0000
  661.1112      96.0000      98.5473       0.0033     125.0711       0.1943       3.4006       0.0000    2644.5481    1619.0000
  661.2636      96.0000      98.5926      -0.0045     127.3398       0.1908       3.5036       0.0000    2657.3594    1587.0000
  661.4160      96.0000      99.1885      -0.0095     130.8016       0.1881       3.6590       0.0000    2665.7305    1482.0000
  661.5684      96.0000      99.1072      -0.0069     128.6783       0.1879       3.7528       0.0000    2661.3750    1549.0000
  661.7208      96.0000      99.3098       0.0039     123.1009       0.1900       3.6257       0.0000    2643.6240    1549.0000
  661.8732      96.0000      99.4501       0.0045     127.5451       0.1893       3.4814       0.0000    2642.5527    1527.0000
  662.0256      96.0000      99.5521       0.0021     134.2630       0.1958       3.3777       0.0000    2646.5708    1514.0000
  662.1780      96.0000      99.4501      -0.0009     142.9405       0.2035       3.5842       0.0000    2651.4954    1552.0000
  662.3304      96.0000      99.5645       0.0002     147.7279       0.2084       3.7316       0.0000    2649.7151    1537.0000
  662.4828      96.0000      99.5578       0.0068     148.3976       0.1979       3.5434       0.0000    2638.8623    1569.0000
  662.6352      96.0000      99.7603       0.0193     140.1047       0.1819       3.3408       0.0000    2618.1335    1528.0000
  662.7876      96.0000      99.7355       0.0294     125.5042       0.1644       3.2442       0.0000    2601.4976    1533.0000
  662.9400      96.0000      99.5972       0.0324     109.2563       0.1515       3.2931       0.0000    2596.5840    1565.0000
  663.0924      96.0000      99.7929       0.0316     102.1251       0.1433       3.3029       0.0000    2597.8684    1552.0000
  663.2448      96.0000     100.0407       0.0299     105.1861       0.1390       3.2995       0.0000    2600.6946    1525.0000
  663.3972      96.0000     100.1602       0.0230     113.0912       0.1425       3.3425       0.0000    2612.1067    1530.0000
  663.5496      96.0000     100.0663       0.0179     116.5613       0.1504       3.4306       0.0000    2620.3828    1531.0000
  663.7020      96.0000      99.9643       0.0120     119.6575       0.1586       3.4922       0.0000    2630.1353    1516.0000
  663.8544      96.0000      99.4950       0.0098     116.9452       0.1654       3.7770       0.0000    2633.8423    1532.0000
  664.0068      96.0000      99.4568       0.0058     120.9909       0.1700       3.9072       0.0000    2640.4734    1542.0000
  664.1592      96.0000      99.4502       0.0094     118.1047       0.1718       3.8142       0.0000    2634.5696    1494.0000
  664.3116      96.0000      99.8500       0.0110     114.7952       0.1745       3.5268       0.0000    2631.9194    1528.0000
  664.4640      96.0000      99.7806       0.0095     105.5636       0.1748       3.5997       0.0000    2634.2505    1552.0000
  664.6164      96.0000     100.2620       0.0025     112.4696       0.1736       3.8151       0.0000    2645.8865    1520.0000
  664.7688      96.0000     100.5528      -0.0027     118.6838       0.1714       4.0737       0.0000    2654.4312    1517.0000
  664.9212      96.0000     100.4904      -0.0025     127.5819       0.1745       4.0613       0.0000    2654.0842    1507.0000
  665.0736      96.0000     101.0928      -0.0084     117.0041       0.1763       4.1158       0.0000    2663.8589    1531.0000
  665.2260      96.0000     101.2513      -0.0101     106.2141       0.1731       3.9790       0.0000    2666.6731    1561.0000
  665.3784      96.0000     100.9914      -0.0024     100.4095       0.1720       4.1903       0.0000    2653.9255    1484.0000
  665.5308      96.0000     100.6342       0.0020     102.9097       0.1764       4.1866       0.0000    2646.7717    1519.0000
  665.6832      96.0000     101.2638      -0.0045     118.9773       0.1874       3.9338       0.0000    2657.3936    1555.0000
  665.8356      96.0000     101.5044      -0.0070     130.3081       0.1978       3.6719       0.0000    2661.5659    1511.0000
  665.9880      96.0000     102.6303      -0.0100     151.4908       0.2133       3.6215       0.0000    2666.5200    1525.0000
  666.1404      96.0000     102.0678      -0.0092     152.9273       0.2229       3.7420       0.0000    2665.1357    1547.0000
  666.2928      96.0000     103.3386      -0.0076     158.5047       0.2262       3.7230       0.0000    2662.5000    1558.0000
  666.4452      96.0000     105.0863      -0.0009     150.0153       0.2182       3.6083       0.0000    2651.4187    1521.0000
  666.5976      96.0000     102.9717       0.0132     145.6103       0.2066       3.5212       0.0000    2628.2034    1485.0000
  666.7500      96.0000     103.0677       0.0169     130.4167       0.1945       3.2351       0.0000    2622.1089    1567.0000
  666.9024      96.0000     102.9330       0.0191     120.0312       0.1933       3.1877       0.0000    2618.4751    1610.0000
  667.0548      96.0000     102.8968       0.0078     114.0663       0.1944       3.3738       0.0000    2637.1831    1456.0000
  667.2072      96.0000     103.3827      -0.0033     127.1855       0.2009       3.8731       0.0000    2655.4460    1503.0000
  667.3596      96.0000     104.7888      -0.0036     141.8022       0.2138       4.0558       0.0000    2655.9919    1609.0000
  667.5120      96.0000     106.1638      -0.0070     157.1700       0.2291       4.0231       0.0000    2661.4795    1518.0000
  667.6644      96.0000     104.2653      -0.0090     168.0461       0.2339       3.9141       0.0000    2664.8899    1514.0000
  667.8168      96.0000     104.8864      -0.0154     180.0009       0.2302       3.8957       0.0000    2675.4863    1552.0000
  667.9692      96.0000     106.1931      -0.0063     180.5778       0.2329       3.8435       0.0000    2660.3945    1555.0000
  668.1216      96.0000     104.6325      -0.0086     176.0335       0.2407       3.6970       0.0000    2664.2517    1568.0000
  668.2740      96.0000     104.8767      -0.0126     164.5558       0.2460       3.4385       0.0000    2670.8269    1559.0000
  668.4264      96.0000     104.8891      -0.0021     155.3456       0.2297       3.4516       0.0000    2653.5063    1512.0000
  668.5788      96.0000     104.8460       0.0032     156.2809       0.2298       3.5274       0.0000    2644.6816    1548.0000
  668.7312      96.0000     104.8594      -0.0015     159.6503       0.2356       3.7507       0.0000    2652.4644    1562.0000
  668.8836      96.0000     104.5757      -0.0076     162.5365       0.2531       3.7289       0.0000    2662.5000    1530.0000
  669.0360      96.0000     105.0726      -0.0096     159.2670       0.2512       3.7772       0.0000    2665.7612    1542.0000
  669.1884      96.0000     104.9676      -0.0044     164.3382       0.2388       3.7326       0.0000    2657.1941    1559.0000
  669.3408      96.0000     104.4755      -0.0035     169.1237       0.2304       3.6641       0.0000    2655.8110    1545.0000
  669.4932      96.0000     104.4053       0.0036     164.5309       0.2283       3.5385       0.0000    2644.0684    1527.0000
  669.6456      96.0000     104.4756       0.0065     149.1402       0.2278       3.4463       0.0000    2639.2197    1528.0000
  669.7980      96.0000     104.4321       0.0080     148.1785       0.2262       3.4287       0.0000    2636.8132    1530.0000
  669.9504      96.0000     104.2517       0.0037     146.6169       0.2246       3.4822       0.0000    2643.8743    1519.0000
  670.1028      96.0000     104.5624      -0.0029     152.3454       0.2253       3.7054       0.0000    2654.8037    1554.0000
  670.2552      96.0000     104.3487      -0.0115     149.8615       0.2271       3.7305       0.0000    2669.0503    1509.0000
  670.4076      96.0000     104.7027      -0.0150     152.5776       0.2212       3.7938       0.0000    2674.7305    1512.0000
  670.5600      96.0000     104.6497      -0.0099     141.3085       0.2221       3.5759       0.0000    2666.3386    1559.0000
  670.7124      96.0000     104.5890       0.0019     140.1915       0.2161       3.5179       0.0000    2646.7866    1499.0000
  670.8648      96.0000     104.5190       0.0111     136.7358       0.2171       3.4580       0.0000    2631.6799    1553.0000
  671.0172      96.0000     104.2351       0.0155     143.0022       0.2142       3.5234       0.0000    2624.4658    1530.0000
  671.1696      96.0000     104.4889       0.0103     139.4870       0.2232       3.7900       0.0000    2633.0740    1487.0000
  671.3220      96.0000     103.9812      -0.0039     144.0972       0.2285       3.9804       0.0000    2656.4856    1549.0000
  671.4744      96.0000     103.9790      -0.0124     151.1908       0.2333       4.1843       0.0000    2670.5378    1541.0000
  671.6268      96.0000     103.8373      -0.0098     155.9989       0.2329       4.1804       0.0000    2666.1216    1509.0000
  671.7792      96.0000     104.1783      -0.0117     153.6695       0.2400       4.2219       0.0000    2669.3452    1516.0000
  671.9316      96.0000     104.2351      -0.0230     143.6896       0.2336       4.1955       0.0000    2687.9895    1533.0000
  672.0840      96.0000     104.3185      -0.0249     145.0359       0.2265       4.1734       0.0000    2691.0476    1520.0000
  672.2364      96.0000     104.0941      -0.0167     148.7297       0.2144       3.8920       0.0000    2677.5857    1541.0000
  672.3888      96.0000     103.6841      -0.0089     151.0166       0.2154       3.6580       0.0000    2664.6985    1497.0000
  672.5412      96.0000     103.1815       0.0007     142.9389       0.2151       3.3813       0.0000    2648.7856    1525.0000
  672.6936      96.0000     102.9977       0.0187     131.3767       0.2134       3.2734       0.0000    2619.1052    1551.0000
  672.8460      96.0000     102.5793       0.0228     125.0736       0.2091       3.2420       0.0000    2612.3638    1523.0000
  672.9984      96.0000     101.8336       0.0178     123.7469       0.1994       3.4439       0.0000    2620.6365    1527.0000
  673.1508      96.0000     101.8904       0.0104     129.8820       0.2002       3.6309       0.0000    2632.8840    1535.0000
  673.3032      96.0000     101.7008       0.0034     129.6651       0.2096       3.7447       0.0000    2644.4072    1513.0000
  673.4556      96.0000     100.9913       0.0014     131.5687       0.2147       3.7750       0.0000    2647.7617    1523.0000
  673.6080      96.0000     100.4617       0.0045     130.8212       0.2076       3.6840       0.0000    2642.5061    1562.0000
  673.7604      96.0000     100.2695       0.0110     135.8027       0.1924       3.6202       0.0000    2631.7891    1506.0000
  673.9128      96.0000      99.9641       0.0179     133.1101       0.1750       3.2095       0.0000    2620.5000    1545.0000
  674.0652      96.0000      99.8500       0.0246     122.6628       0.1540       3.0802       0.0000    2609.3291    1492.0000
  674.2176      96.0000      99.5643       0.0372     112.4862       0.1348       2.8419       0.0000    2588.5916    1518.0000
  674.3700      96.0000      99.2544       0.0461     108.0302       0.1287       2.8605       0.0000    2573.9287    1567.0000
  674.5224      96.0000      99.3237       0.0552      99.8134       0.1327       2.8297       0.0000    2558.9705    1530.0000
  674.6748      96.0000      98.9236       0.0642      90.5652       0.1357       2.8867       0.0000    2544.0535    1494.0000
  674.8272      96.0000      98.7520       0.0672      81.3789       0.1373       2.9502       0.0000    2539.1641    1544.0000
  674.9796      96.0000      98.2311       0.0603      85.6807       0.1349       2.8752       0.0000    2550.4700    1544.0000
  675.1320      96.0000      98.0657       0.0509      90.5033       0.1278       2.9153       0.0000    2566.0635    1494.0000
  675.2844      96.0000      97.4243       0.0459      89.7212       0.1149       2.7638       0.0000    2574.3069    1548.0000
  675.4368      96.0000      97.8722       0.0523      79.4443       0.1083       2.8422       0.0000    2563.7068    1548.0000
  675.5892      96.0000      98.0777       0.0599      71.8595       0.1142       2.7169       0.0000    2551.1145    1518.0000
  675.7416      96.0000      98.4600       0.0638      68.0237       0.1267       2.8677       0.0000    2544.7476    1537.0000
  675.8940      96.0000      98.9807       0.0666      71.9876       0.1353       2.7411       0.0000    2540.0525    1552.0000
  676.0464      96.0000      98.6379       0.0756      73.2112       0.1423       2.8084       0.0000    2525.2000    1551.0000
  676.1988      96.0000      98.3876       0.0878      75.7471       0.1500       2.7069       0.0000    2505.1875    1549.0000
  676.3512      96.0000      98.4781       0.0957      75.4373       0.1534       2.7528       0.0000    2492.0305    1560.0000
  676.5036      96.0000      98.4239       0.0951      80.7805       0.1539       2.7158       0.0000    2493.0339    1554.0000
  676.6560      96.0000      97.4126       0.0951      80.9265       0.1515       2.6355       0.0000    2493.0925    1545.0000
  676.8084      96.0000      97.9058       0.0877      76.1281       0.1493       2.5297       0.0000    2505.2471    1535.0000
  676.9608      96.0000      98.1348       0.0918      71.5543       0.1439       2.4859       0.0000    2498.4639    1517.0000
  677.1132      96.0000      98.5803       0.0974      67.3041       0.1423       2.4385       0.0000    2489.2725    1538.0000
  677.2656      96.0000      98.9801       0.1024      72.1024       0.1424       2.5241       0.0000    2481.0452    1518.0000
  677.4180      96.0000      98.2946       0.1007      74.0385       0.1401       2.6110       0.0000    2483.7646    1496.0000
  677.5704      96.0000      98.4090       0.0898      78.6733       0.1302       2.8457       0.0000    2501.7959    1537.0000
  677.7228      96.0000      98.6045       0.0764      78.3350       0.1233       2.8554       0.0000    2523.8796    1521.0000
  677.8752      96.0000      99.1400       0.0653      81.0147       0.1165       2.8703       0.0000    2542.2239    1532.0000
  678.0276      96.0000      98.2219       0.0593      83.3358       0.1119       2.7942       0.0000    2552.1130    1507.0000
  678.1800      96.0000      97.2757       0.0544      86.3666       0.1121       2.7622       0.0000    2560.2197    1541.0000
  678.3324      96.0000      98.0088       0.0460      83.0971       0.1178       2.7706       0.0000    2574.1016    1546.0000
  678.4848      96.0000      98.1920       0.0460      84.0592       0.1283       2.8665       0.0000    2574.0364    1555.0000
  678.6372      96.0000      98.4210       0.0431      88.0055       0.1395       2.9055       0.0000    2578.9556    1567.0000
  678.7896      96.0000      98.0938       0.0447      93.7752       0.1536       2.9473       0.0000    2576.3135    1540.0000
  678.9420      96.0000      97.6649       0.0478      98.1851       0.1657       2.8968       0.0000    2571.1492    1504.0000
  679.0944      96.0000      97.7341       0.0586      95.2141       0.1664       2.9142       0.0000    2553.2446    1553.0000
  679.2468      96.0000      96.9776       0.0770      90.2094       0.1629       2.7471       0.0000    2522.8884    1563.0000
  679.3992      96.0000      97.5623       0.0873      85.0167       0.1568       2.6888       0.0000    2505.9329    1500.0000
  679.5516      96.0000      97.8916       0.0902      77.6946       0.1503       2.6847       0.0000    2501.2278    1567.0000
  679.7040      96.0000      98.9356       0.0886      75.4028       0.1433       2.6961       0.0000    2503.8274    1575.0000
  679.8564      96.0000      98.7972       0.0878      72.5772       0.1375       2.6974       0.0000    2505.1833    1513.0000
  680.0088      96.0000      98.4901       0.0870      74.3081       0.1383       2.7624       0.0000    2506.4253    1551.0000
  680.1612      96.0000      98.1663       0.0862      72.5654       0.1375       2.8920       0.0000    2507.7925    1587.0000
  680.3136      96.0000      98.7642       0.0877      72.9029       0.1368       2.9296       0.0000    2505.2563    1514.0000
  680.4660      96.0000      98.4662       0.0838      71.3643       0.1310       2.9377       0.0000    2511.6477    1523.0000
  680.6184      96.0000      99.1071       0.0781      67.3255       0.1270       2.8667       0.0000    2521.1943    1615.0000
  680.7708      96.0000      99.0378       0.0664      63.4994       0.1261       2.9687       0.0000    2540.3904    1513.0000
  680.9232      96.0000      98.6890       0.0504      68.7049       0.1300       3.0174       0.0000    2566.8901    1519.0000
  681.0756      96.0000      98.9808       0.0298      84.2832       0.1316       3.3453       0.0000    2600.7976    1584.0000
  681.2280      96.0000      98.7069       0.0081     101.9445       0.1433       3.8078       0.0000    2636.6387    1539.0000
  681.3804      96.0000      98.5807      -0.0016     112.7907       0.1583       4.1678       0.0000    2652.6545    1485.0000
  681.5328      96.0000      98.6046       0.0023     111.8451       0.1697       4.0384       0.0000    2646.1526    1527.0000
  681.6852      96.0000      99.0949       0.0153     106.4600       0.1680       3.6100       0.0000    2624.7244    1544.0000
  681.8376      96.0000      98.9444       0.0210     107.3328       0.1661       3.4254       0.0000    2615.2825    1518.0000
  681.9900      96.0000      99.6786       0.0250     107.7507       0.1644       3.4393       0.0000    2608.7234    1565.0000
  682.1424      96.0000      99.3115       0.0284     107.9592       0.1681       3.5076       0.0000    2603.2209    1570.0000
  682.2948      96.0000      99.3931       0.0311     104.6060       0.1699       3.4789       0.0000    2598.7598    1524.0000
  682.4472      96.0000      99.5024       0.0232      98.6081       0.1718       3.7310       0.0000    2611.7178    1552.0000
  682.5996      96.0000      99.4258       0.0164     101.0922       0.1673       3.8449       0.0000    2622.9902    1582.0000
  682.7520      96.0000      99.6337       0.0093     108.0995       0.1692       3.8117       0.0000    2634.6345    1523.0000
  682.9044      96.0000      99.9317       0.0097     118.4898       0.1773       3.4904       0.0000    2634.0723    1511.0000
  683.0568      96.0000      99.7684       0.0154     121.5670       0.1846       3.4245       0.0000    2624.5732    1562.0000
  683.2092      96.0000     100.0147       0.0197     118.8933       0.1855       3.4571       0.0000    2617.4187    1541.0000
  683.3616      96.0000      99.7683       0.0228     121.5676       0.1779       3.4203       0.0000    2612.3696    1544.0000
  683.5140      96.0000     100.0090       0.0271     124.2478       0.1705       3.3233       0.0000    2605.2292    1544.0000
  683.6664      96.0000     100.2373       0.0278     121.9212       0.1594       3.2378       0.0000    2604.1494    1507.0000
  683.8188      96.0000      99.1972       0.0313     112.1275       0.1484       3.2486       0.0000    2598.4353    1546.0000
  683.9712      96.0000      99.0138       0.0293     105.9854       0.1427       3.1976       0.0000    2601.6074    1549.0000
  684.1236      96.0000      98.9801       0.0350     107.3317       0.1404       3.1460       0.0000    2592.3152    1510.0000
  684.2760      96.0000      99.6543       0.0352     116.4201       0.1461       3.1634       0.0000    2591.8528    1549.0000
  684.4284      96.0000      99.7358       0.0423     112.9738       0.1521       3.1752       0.0000    2580.2632    1524.0000
  684.5808      96.0000      98.5233       0.0527     106.2424       0.1565       3.1773       0.0000    2562.9795    1489.0000
  684.7332      96.0000      98.0844       0.0704      88.8692       0.1582       2.9344       0.0000    2533.8315    1538.0000
  684.8856      96.0000      97.8939       0.0874      80.3991       0.1554       2.8094       0.0000    2505.8081    1548.0000
  685.0380      96.0000      97.6076       0.0974      75.0267       0.1538       2.6536       0.0000    2489.3423    1495.0000
  685.1904      96.0000      97.7225       0.1021      76.1806       0.1525       2.6857       0.0000    2481.4849    1520.0000
  685.3428      96.0000      97.7543       0.0990      74.0574       0.1524       2.6114       0.0000    2486.5713    1554.0000
  685.4952      96.0000      98.2494       0.0947      70.9787       0.1480       2.6192       0.0000    2493.7434    1545.0000
  685.6476      96.0000      98.6379       0.0882      68.8632       0.1441       2.5728       0.0000    2504.4978    1552.0000
  685.8000      96.0000      98.8786       0.0842      69.9604       0.1403       2.5877       0.0000    2511.0022    1575.0000
  685.9524      96.0000      98.1920       0.0813      68.4106       0.1356       2.6054       0.0000    2515.8669    1542.0000
  686.1048      96.0000      98.1230       0.0767      73.0391       0.1315       2.6413       0.0000    2523.4739    1548.0000
  686.2572      96.0000      98.3037       0.0697      77.3270       0.1285       2.7065       0.0000    2535.0322    1561.0000
  686.4096      96.0000      98.4901       0.0586      76.1730       0.1309       2.7963       0.0000    2553.3547    1538.0000
  686.5620      96.0000      98.5354       0.0502      77.7720       0.1329       2.9485       0.0000    2567.1777    1570.0000
  686.7144      96.0000      98.4542       0.0488      82.0182       0.1394       3.1321       0.0000    2569.5408    1532.0000
  686.8668      96.0000      98.1856       0.0522      94.7116       0.1450       3.1382       0.0000    2563.9392    1538.0000
  687.0192      96.0000      98.2256       0.0613      98.2001       0.1520       3.1351       0.0000    2548.8662    1549.0000
  687.1716      96.0000      99.2336       0.0666     102.0316       0.1489       3.0658       0.0000    2540.0686    1547.0000
  687.3240      96.0000      99.1072       0.0718      99.7385       0.1435       2.9922       0.0000    2531.5852    1528.0000
  687.4764      96.0000      99.1644       0.0681      99.0617       0.1318       2.8699       0.0000    2537.7131    1558.0000
  687.6288      96.0000      99.4275       0.0578      91.7534       0.1186       2.8533       0.0000    2554.6621    1559.0000
  687.7812      96.0000      98.3518       0.0479      87.9051       0.1055       2.8925       0.0000    2570.9441    1540.0000
  687.9336      96.0000      98.1921       0.0414      83.8663       0.1016       2.9030       0.0000    2581.6160    1547.0000
  688.0860      96.0000      98.1682       0.0363      80.4508       0.1039       2.8189       0.0000    2590.0920    1565.0000
  688.2384      96.0000      97.8250       0.0236      78.5146       0.1094       2.9304       0.0000    2611.0337    1542.0000
  688.3908      96.0000      98.2941       0.0116      93.5358       0.1152       3.1586       0.0000    2630.8145    1546.0000
  688.5432      96.0000      98.4544       0.0035     109.0677       0.1303       3.3806       0.0000    2644.1990    1560.0000
  688.6956      96.0000      99.0951       0.0102     123.4920       0.1503       3.2250       0.0000    2633.1057    1539.0000
  688.8480      96.0000      99.0051       0.0263     113.3916       0.1542       3.0774       0.0000    2606.6323    1548.0000
  689.0004      96.0000      99.2666       0.0441     107.6383       0.1414       3.0858       0.0000    2577.1956    1541.0000
  689.1528      96.0000      99.1464       0.0527      99.3683       0.1215       2.9978       0.0000    2563.0581    1546.0000
  689.3052      96.0000      98.7070       0.0569      93.0068       0.1102       2.8023       0.0000    2556.0366    1556.0000
  689.4576      96.0000      98.6617       0.0559      82.4126       0.1045       2.6415       0.0000    2557.7288    1541.0000
  689.6100      96.0000      98.3970       0.0524      74.1537       0.0970       2.7093       0.0000    2563.4595    1542.0000
  689.7624      96.0000      98.9116       0.0429      75.5945       0.0933       2.8714       0.0000    2579.2727    1562.0000
  689.9148      96.0000      98.4600       0.0310      77.7100       0.0929       3.0153       0.0000    2598.8350    1552.0000
  690.0672      96.0000      98.0541       0.0270      74.2466       0.0980       3.0489       0.0000    2605.3840    1541.0000
  690.2196      96.0000      98.4424       0.0222      76.0892       0.1034       3.1641       0.0000    2613.4338    1558.0000
  690.3720      96.0000      98.1013       0.0191      77.8201       0.1133       3.2558       0.0000    2618.4648    1520.0000
  690.5244      96.0000      97.9929       0.0210      92.0427       0.1304       3.4618       0.0000    2615.3569    1559.0000
  690.6768      96.0000      98.0203       0.0220      99.0640       0.1452       3.3984       0.0000    2613.7480    1553.0000
  690.8292      96.0000      98.9927       0.0259     110.1729       0.1512       3.2888       0.0000    2607.2324    1540.0000
  690.9816      96.0000      99.2789       0.0287     120.9643       0.1488       3.1840       0.0000    2602.6287    1526.0000
  691.1340      96.0000      98.9236       0.0409     122.4858       0.1457       3.0420       0.0000    2582.4351    1539.0000
  691.2864      96.0000      98.4696       0.0561     118.1246       0.1403       2.9147       0.0000    2557.4241    1547.0000
  691.4388      96.0000      98.7400       0.0655      93.4859       0.1325       2.7364       0.0000    2541.9272    1524.0000
  691.5912      96.0000      99.2093       0.0727      83.3014       0.1321       2.6768       0.0000    2529.9832    1554.0000
  691.7436      96.0000      98.9237       0.0776      76.1690       0.1400       2.6069       0.0000    2521.8865    1567.0000
  691.8960      96.0000      98.2039       0.0867      83.4989       0.1474       2.6713       0.0000    2506.9055    1561.0000
  692.0484      96.0000      97.9468       0.0914      84.0379       0.1600       2.7902       0.0000    2499.1606    1542.0000
  692.2008      96.0000      98.1230       0.0985      91.2418       0.1698       2.9729       0.0000    2487.5039    1542.0000
  692.3532      96.0000      98.7972       0.0968      90.6433       0.1696       2.9391       0.0000    2490.3425    1541.0000
  692.5056      96.0000      99.4501       0.0949      93.5720       0.1534       2.8541       0.0000    2493.4458    1561.0000
  692.6580      96.0000      99.4501       0.0859      88.0991       0.1345       2.6835       0.0000    2508.3364    1546.0000
  692.8104      96.0000      99.3653       0.0707      88.2914       0.1194       2.7667       0.0000    2533.3762    1513.0000
  692.9628      96.0000      98.9236       0.0510      83.5923       0.1119       2.7993       0.0000    2565.8923    1552.0000
  693.1152      96.0000      98.7069       0.0252      87.4388       0.1120       3.0753       0.0000    2608.4570    1560.0000
  693.2676      96.0000      98.4782       0.0093     102.4600       0.1244       3.4429       0.0000    2634.7161    1546.0000
  693.4200      96.0000      98.3637       0.0017     114.2605       0.1479       3.9283       0.0000    2647.1746    1554.0000
  693.5724      96.0000      98.1759      -0.0028     125.3266       0.1691       4.2413       0.0000    2654.6162    1535.0000
  693.7248      96.0000      97.7342       0.0012     122.2480       0.1811       3.9355       0.0000    2648.0125    1568.0000
  693.8772      96.0000      97.3331       0.0139     122.2480       0.1713       3.6330       0.0000    2627.0466    1546.0000
  694.0296      96.0000      97.4932       0.0273     115.2709       0.1557       3.4051       0.0000    2604.9614    1569.0000
  694.1820      96.0000      98.0938       0.0433     105.2515       0.1465       3.2763       0.0000    2578.4810    1534.0000
  694.3344      96.0000      98.2492       0.0588     102.1743       0.1435       3.2332       0.0000    2553.0210    1548.0000
  694.4868      96.0000      98.5473       0.0596      89.8272       0.1379       3.0024       0.0000    2551.6858    1554.0000
  694.6392      96.0000      98.5114       0.0498      88.8656       0.1327       2.9911       0.0000    2567.8096    1547.0000
  694.7916      96.0000      98.4423       0.0447      83.6869       0.1301       2.9959       0.0000    2576.2380    1519.0000
  694.9440      96.0000      98.9344       0.0431      86.3676       0.1330       3.2033       0.0000    2578.9033    1556.0000
  695.0964      96.0000      99.4951       0.0459      88.2908       0.1366       3.2882       0.0000    2574.2949    1546.0000
  695.2488      96.0000      99.2214       0.0465      83.5150       0.1449       3.2604       0.0000    2573.2952    1544.0000
  695.4012      96.0000      99.0381       0.0516      87.3764       0.1565       3.2856       0.0000    2564.8228    1540.0000
  695.5536      96.0000      99.5522       0.0557      93.7231       0.1616       3.2302       0.0000    2558.1157    1548.0000
  695.7060      96.0000      99.3002       0.0582     107.3317       0.1599       3.2444       0.0000    2553.8940    1544.0000
  695.8584      96.0000      99.4051       0.0637     110.2180       0.1536       3.0932       0.0000    2544.9011    1551.0000
  696.0108      96.0000      98.9686       0.0647     103.4447       0.1473       2.8709       0.0000    2543.3179    1535.0000
  696.1632      96.0000      98.6379       0.0638      92.2899       0.1374       2.8482       0.0000    2544.7183    1539.0000
  696.3156      96.0000      98.8622       0.0589      85.9742       0.1250       2.7615       0.0000    2552.8674    1540.0000
  696.4680      96.0000      98.9927       0.0622      89.0934       0.1172       2.8665       0.0000    2547.4148    1556.0000
  696.6204      96.0000      99.0049       0.0644      86.4125       0.1192       2.6552       0.0000    2543.7517    1558.0000
  696.7728      96.0000      98.5806       0.0731      85.5959       0.1238       2.6537       0.0000    2529.3057    1551.0000
  696.9252      96.0000      98.3637       0.0770      79.8262       0.1290       2.6024       0.0000    2522.9807    1551.0000
  697.0776      96.0000      98.4601       0.0716      86.3683       0.1276       2.8255       0.0000    2531.9104    1556.0000
  697.2300      96.0000      98.1802       0.0675      93.4843       0.1348       2.8693       0.0000    2538.6128    1547.0000
  697.3824      96.0000      98.4900       0.0680     100.2316       0.1425       2.8804       0.0000    2537.7188    1582.0000
  697.5348      96.0000      98.2254       0.0731      95.2164       0.1518       2.6806       0.0000    2529.3413    1554.0000
  697.6872      96.0000      98.1920       0.0742      94.4577       0.1534       2.5681       0.0000    2527.4963    1544.0000
  697.8396      96.0000      98.2121       0.0778      87.9027       0.1562       2.6593       0.0000    2521.6951    1581.0000
  697.9920      96.0000      98.4783       0.0823      89.4413       0.1653       2.8033       0.0000    2514.2505    1569.0000
  698.1444      96.0000      98.4662       0.0785      87.1840       0.1686       2.8317       0.0000    2520.5359    1547.0000
  698.2968      96.0000      98.3065       0.0726      95.6631       0.1669       2.8529       0.0000    2530.2490    1567.0000
  698.4492      96.0000      98.5783       0.0627     106.2409       0.1614       2.9993       0.0000    2546.4797    1548.0000
  698.6016      96.0000      98.4543       0.0689     111.5649       0.1629       3.1086       0.0000    2536.2854    1565.0000
  698.7540      96.0000      98.0775       0.0703     110.0255       0.1592       3.0424       0.0000    2533.9980    1574.0000
  698.9064      96.0000      98.0657       0.0838      93.4857       0.1548       2.8712       0.0000    2511.6748    1555.0000
  699.0588      96.0000      98.1922       0.0866      83.3050       0.1468       2.9280       0.0000    2507.1074    1583.0000
  699.2112      96.0000      98.1853       0.0908      78.4808       0.1462       2.8921       0.0000    2500.2231    1583.0000
  699.3636      96.0000      98.0085       0.0870      83.8817       0.1412       2.8421       0.0000    2506.4404    1582.0000
  699.5160      96.0000      98.4663       0.0801      84.2538       0.1391       2.7407       0.0000    2517.7688    1572.0000
  699.6684      96.0000      98.5807       0.0747      79.8422       0.1340       2.7760       0.0000    2526.8042    1568.0000
  699.8208      96.0000      98.8905       0.0674      86.3653       0.1309       2.7813       0.0000    2538.8271    1558.0000
  699.9732      96.0000      98.3322       0.0578      85.6084       0.1280       2.8329       0.0000    2554.6931    1577.0000
  700.1256      96.0000      97.9275       0.0458      88.0968       0.1299       2.7376       0.0000    2574.4558    1553.0000
  700.2780      96.0000      98.3399       0.0396      87.3275       0.1311       2.7425       0.0000    2584.6357    1546.0000
  700.4304      96.0000      98.8543       0.0413      90.8517       0.1358       2.8486       0.0000    2581.7866    1596.0000
  700.5828      96.0000      99.0501       0.0478      96.4291       0.1464       2.9272       0.0000    2571.1584    1548.0000
  700.7352      96.0000      99.3292       0.0591      93.1596       0.1585       2.9984       0.0000    2552.4897    1569.0000
  700.8876      96.0000      99.5400       0.0722      92.3292       0.1713       2.9022       0.0000    2530.8074    1566.0000
  701.0400      96.0000      99.3930       0.0770      93.0985       0.1792       2.9667       0.0000    2522.8743    1554.0000
  701.1924      96.0000      99.3807       0.0783      95.4064       0.1837       2.9744       0.0000    2520.7896    1559.0000
  701.3448      96.0000      99.5839       0.0770     100.0243       0.1817       3.0263       0.0000    2522.9158    1576.0000
  701.4972      96.0000      99.3359       0.0759      96.5625       0.1780       2.9923       0.0000    2524.8413    1537.0000
  701.6496      96.0000      99.7481       0.0734      99.0119       0.1821       2.9641       0.0000    2528.9255    1567.0000
  701.8020      96.0000      99.2671       0.0711      97.6650       0.1809       2.8618       0.0000    2532.6753    1591.0000
  701.9544      96.0000      97.8488       0.0650      99.5882       0.1806       2.8914       0.0000    2542.8276    1548.0000
  702.1068      96.0000      98.1301       0.0617      94.6526       0.1709       2.8469       0.0000    2548.1707    1568.0000
  702.2592      96.0000      98.2255       0.0647      89.2523       0.1678       2.9202       0.0000    2543.1633    1610.0000
  702.4116      96.0000      98.3185       0.0717      84.2519       0.1585       2.7463       0.0000    2531.7278    1524.0000
  702.5640      96.0000      98.8093       0.0693      81.5838       0.1463       2.6223       0.0000    2535.6714    1559.0000
  702.7164      96.0000      99.1193       0.0648      86.2144       0.1307       2.5332       0.0000    2543.0969    1608.0000
  702.8688      96.0000      98.4867       0.0654      83.9065       0.1169       2.5710       0.0000    2542.0176    1555.0000
  703.0212      96.0000      98.2158       0.0640      88.2515       0.1123       2.5882       0.0000    2544.4346    1554.0000
  703.1736      96.0000      98.6377       0.0604      86.7122       0.1128       2.6205       0.0000    2550.3560    1582.0000
  703.3260      96.0000      98.4662       0.0633      92.4819       0.1186       2.6786       0.0000    2545.5103    1545.0000
  703.4784      96.0000      98.4209       0.0570      91.5603       0.1278       2.9004       0.0000    2555.9724    1579.0000
  703.6308      96.0000      98.6888       0.0495      90.4058       0.1438       3.0697       0.0000    2568.3542    1587.0000
  703.7832      96.0000      98.1348       0.0515      94.4446       0.1564       3.1856       0.0000    2565.0471    1556.0000
  703.9356      96.0000      98.6045       0.0572     100.0733       0.1725       3.2594       0.0000    2555.6770    1586.0000
  704.0880      96.0000      98.4662       0.0652     104.1140       0.1813       3.3062       0.0000    2542.4734    1583.0000
  704.2404      96.0000      98.0777       0.0679     102.1908       0.1909       3.2038       0.0000    2538.0217    1559.0000
  704.3928      96.0000      98.2122       0.0715     101.1944       0.1854       3.0962       0.0000    2532.0986    1593.0000
  704.5452      96.0000      98.1466       0.0716     108.2950       0.1808       3.0740       0.0000    2531.8867    1594.0000
  704.6976      96.0000      98.3519       0.0667     108.4873       0.1738       3.0461       0.0000    2539.9509    1552.0000
  704.8500      96.0000      98.3518       0.0573     110.9887       0.1679       3.1249       0.0000    2555.4924    1523.0000
  705.0024      96.0000      98.2373       0.0532     107.1422       0.1636       3.1219       0.0000    2562.2808    1597.0000
  705.1548      96.0000      98.2672       0.0468     110.9835       0.1618       3.3048       0.0000    2572.7188    1549.0000
  705.3072      96.0000      98.3639       0.0422     115.0046       0.1625       3.4502       0.0000    2580.3091    1562.0000
  705.4596      96.0000      98.0086       0.0387     120.4092       0.1572       3.3844       0.0000    2586.1450    1573.0000
  705.6120      96.0000      98.3065       0.0424     121.2596       0.1515       3.2042       0.0000    2580.0491    1558.0000
  705.7644      96.0000      98.2311       0.0437     113.1989       0.1462       2.9225       0.0000    2577.8975    1563.0000
  705.9168      96.0000      98.3184       0.0356     101.8323       0.1412       2.8725       0.0000    2591.3367    1581.0000
  706.0692      96.0000      98.2040       0.0246      96.3865       0.1336       3.0426       0.0000    2609.4421    1574.0000
  706.2216      96.0000      98.3518       0.0146      94.2540       0.1310       3.2619       0.0000    2625.8364    1583.0000
  706.3740      96.0000      98.4448       0.0183      99.0000       0.1330       3.3684       0.0000    2619.7786    1566.0000
  706.5264      96.0000      98.2122       0.0230     106.8701       0.1360       3.2287       0.0000    2612.1221    1569.0000
  706.6788      96.0000      98.4091       0.0303     109.9635       0.1364       3.1200       0.0000    2599.9622    1595.0000
  706.8312      96.0000      98.3638       0.0343     104.2559       0.1363       3.1083       0.0000    2593.4099    1584.0000
  706.9836      96.0000      98.1920       0.0341      95.0389       0.1355       3.0934       0.0000    2593.7705    1551.0000
  707.1360      96.0000      98.3183       0.0353      91.7244       0.1371       3.0756       0.0000    2591.7158    1568.0000
  707.2884      96.0000      98.4047       0.0426      91.2062       0.1436       2.9999       0.0000    2579.6375    1556.0000
  707.4408      96.0000      98.3637       0.0507      89.8593       0.1523       3.0171       0.0000    2566.2710    1572.0000
  707.5932      96.0000      98.1349       0.0540      90.2727       0.1565       2.9736       0.0000    2560.8728    1586.0000
  707.7456      96.0000      98.4089       0.0569      97.2227       0.1555       2.9202       0.0000    2556.0737    1554.0000
  707.8980      96.0000      98.1759       0.0608      95.1061       0.1539       2.7814       0.0000    2549.6545    1555.0000
  708.0504      96.0000      97.9513       0.0706      93.5675       0.1537       2.7843       0.0000    2533.4788    1563.0000
  708.2028      96.0000      98.1348       0.0772      84.4432       0.1555       2.7945       0.0000    2522.6973    1594.0000
  708.3552      96.0000      98.2039       0.0747      95.6032       0.1544       2.9677       0.0000    2526.7444    1576.0000
  708.5076      96.0000      98.3184       0.0636     104.1511       0.1525       2.9901       0.0000    2545.0911    1565.0000
  708.6600      96.0000      98.3037       0.0533     112.4211       0.1407       3.0855       0.0000    2561.9956    1602.0000
  708.8124      96.0000      98.3517       0.0528     105.3017       0.1370       2.9076       0.0000    2562.8652    1573.0000
  708.9648      96.0000      98.2945       0.0588      90.7918       0.1346       2.8500       0.0000    2553.0334    1567.0000
  709.1172      96.0000      98.1920       0.0632      84.0605       0.1379       2.7265       0.0000    2545.6973    1596.0000
  709.2696      96.0000      98.2493       0.0665      83.8680       0.1342       2.8821       0.0000    2540.2888    1570.0000
  709.4220      96.0000      98.3303       0.0633      92.7150       0.1329       2.9555       0.0000    2545.5452    1552.0000
  709.5744      96.0000      98.1800       0.0648      91.9728       0.1335       2.9048       0.0000    2543.1309    1570.0000
  709.7268      96.0000      98.4211       0.0659      87.5473       0.1338       2.8068       0.0000    2541.3413    1579.0000
  709.8792      96.0000      98.7762       0.0605      88.5089       0.1303       2.7132       0.0000    2550.1890    1586.0000
  710.0316      96.0000      98.7521       0.0534      92.1504       0.1271       2.7770       0.0000    2561.8896    1576.0000
  710.1840      96.0000      98.6144       0.0556      97.9074       0.1291       2.7488       0.0000    2558.2253    1590.0000
  710.3364      96.0000      98.5234       0.0574      93.8686       0.1325       2.6856       0.0000    2555.2788    1560.0000
  710.4888      96.0000      98.5233       0.0596      91.3673       0.1364       2.6239       0.0000    2551.6907    1584.0000
  710.6412      96.0000      98.3064       0.0643      83.8666       0.1379       2.6891       0.0000    2543.9338    1577.0000
  710.7936      96.0000      98.4963       0.0684      79.3908       0.1344       2.7957       0.0000    2537.0642    1555.0000
  710.9460      96.0000      98.4211       0.0672      76.8894       0.1330       2.7802       0.0000    2539.1179    1560.0000
  711.0984      96.0000      98.2492       0.0651      77.6587       0.1300       2.7899       0.0000    2542.6011    1562.0000
  711.2508      96.0000      98.2708       0.0617      77.5187       0.1293       2.8285       0.0000    2548.2290    1563.0000
  711.4032      96.0000      98.2612       0.0562      78.8656       0.1301       3.0291       0.0000    2557.2832    1590.0000
  711.5556      96.0000      98.3399       0.0473      80.2119       0.1357       2.9447       0.0000    2571.9985    1551.0000
  711.7080      96.0000      98.6617       0.0440      85.6114       0.1490       3.0513       0.0000    2577.3926    1572.0000
  711.8604      96.0000      98.6378       0.0371      95.7641       0.1585       3.0976       0.0000    2588.7412    1570.0000
  712.0128      96.0000      98.6377       0.0292     111.1500       0.1679       3.3159       0.0000    2601.8364    1568.0000
  712.1652      96.0000      98.7250       0.0196     122.6750       0.1697       3.4409       0.0000    2617.6514    1586.0000
  712.3176      96.0000      98.9477       0.0201     127.9156       0.1629       3.4907       0.0000    2616.8293    1567.0000
  712.4700      96.0000      98.9116       0.0200     124.4537       0.1463       3.3669       0.0000    2617.0044    1572.0000
  712.6224      96.0000      98.8791       0.0185     113.1211       0.1204       3.1280       0.0000    2619.5110    1575.0000
  712.7748      96.0000      98.3401       0.0161      97.3305       0.1033       2.9268       0.0000    2623.3750    1558.0000
  712.9272      96.0000      98.4423       0.0094      87.7143       0.0927       2.9053       0.0000    2634.4939    1582.0000
  713.0796      96.0000      98.2216       0.0167      88.4177       0.0954       2.9820       0.0000    2622.4248    1594.0000
  713.2320      96.0000      98.4089       0.0237      93.6255       0.1033       3.0863       0.0000    2610.8394    1565.0000
  713.3844      96.0000      98.4210       0.0337      91.1253       0.1152       2.9982       0.0000    2594.3909    1570.0000
  713.5368      96.0000      98.1229       0.0366      90.0370       0.1247       2.9349       0.0000    2589.6426    1563.0000
  713.6892      96.0000      98.3228       0.0474      88.0987       0.1312       2.9112       0.0000    2571.7935    1577.0000
  713.8416      96.0000      98.1801       0.0385      89.9363       0.1286       2.9638       0.0000    2586.4463    1563.0000
  713.9940      96.0000      98.3756       0.0370      88.5757       0.1245       2.9136       0.0000    2588.9536    1574.0000
  714.1464      96.0000      98.1664       0.0310      84.1643       0.1139       2.9273       0.0000    2598.8889    1581.0000
  714.2988      96.0000      98.3756       0.0315      74.6338       0.1046       3.0435       0.0000    2598.0542    1555.0000
  714.4512      96.0000      98.4089       0.0252      68.6826       0.0949       3.1669       0.0000    2608.3801    1562.0000
  714.6036      96.0000      98.2675       0.0246      66.7473       0.0969       3.2333       0.0000    2609.4080    1559.0000
  714.7560      96.0000      98.2945       0.0272      73.8633       0.1038       3.2505       0.0000    2605.1230    1568.0000
  714.9084      96.0000      98.4781       0.0211      82.5220       0.1179       3.3881       0.0000    2615.2456    1567.0000
  715.0608      96.0000      98.2769       0.0144      97.3309       0.1301       3.6444       0.0000    2626.3022    1569.0000
  715.2132      96.0000      98.6257       0.0142     105.7198       0.1530       3.7128       0.0000    2626.5725    1568.0000
  715.3656      96.0000      98.4089       0.0199     110.3378       0.1677       3.6113       0.0000    2617.1799    1569.0000
  715.5180      96.0000      98.6380       0.0256     102.4525       0.1775       3.4004       0.0000    2607.6895    1560.0000
  715.6704      96.0000      98.7347       0.0299     102.6335       0.1744       3.3605       0.0000    2600.5847    1553.0000
  715.8228      96.0000      98.4092       0.0352     101.8639       0.1798       3.2756       0.0000    2591.9939    1566.0000
  715.9752      96.0000      98.5975       0.0407     107.0566       0.1823       3.2447       0.0000    2582.8477    1588.0000
  716.1276      96.0000      98.7642       0.0458     108.4875       0.1810       3.2008       0.0000    2574.4158    1554.0000
  716.2800      96.0000      98.2827       0.0458     113.2979       0.1701       3.2684       0.0000    2574.4133    1554.0000
  716.4324      96.0000      98.7522       0.0403     112.7209       0.1608       3.2592       0.0000    2583.5801    1591.0000
  716.5848      96.0000      98.5495       0.0389     103.1047       0.1566       3.2538       0.0000    2585.8699    1572.0000
  716.7372      96.0000      98.6498       0.0364      95.0233       0.1558       3.2508       0.0000    2590.0205    1549.0000
  716.8896      96.0000      98.6257       0.0345      94.2145       0.1528       3.1613       0.0000    2593.0281    1576.0000
  717.0420      96.0000      98.6792       0.0370     103.2537       0.1499       3.2000       0.0000    2588.8872    1573.0000
  717.1944      96.0000      98.3518       0.0363     103.4461       0.1426       3.1697       0.0000    2590.0654    1539.0000
  717.3468      96.0000      98.2492       0.0309      99.6334       0.1300       3.2124       0.0000    2599.0715    1589.0000
  717.4992      96.0000      98.3323       0.0295      89.5579       0.1146       3.0343       0.0000    2601.2732    1549.0000
  717.6516      96.0000      98.3638       0.0309      85.8884       0.1033       2.9326       0.0000    2599.0857    1552.0000
  717.8040      96.0000      98.0775       0.0300      79.5628       0.1003       2.8783       0.0000    2600.4919    1569.0000
  717.9564      96.0000      98.1801       0.0261      79.2528       0.0973       2.9386       0.0000    2606.9526    1540.0000
  718.1088      96.0000      98.2311       0.0256      77.1499       0.0968       2.8784       0.0000    2607.7976    1580.0000
  718.2612      96.0000      98.1350       0.0248      82.9043       0.0975       2.9580       0.0000    2609.0269    1596.0000
  718.4136      96.0000      98.2492       0.0227      83.4936       0.1043       2.8302       0.0000    2612.4905    1566.0000
  718.5660      96.0000      97.9832       0.0257      84.0579       0.1143       2.8660       0.0000    2607.5144    1558.0000
  718.7184      96.0000      97.9967       0.0367      84.8272       0.1284       2.7958       0.0000    2589.4541    1559.0000
  718.8708      96.0000      98.1350       0.0446      93.0605       0.1414       2.9750       0.0000    2576.4915    1589.0000
  719.0232      96.0000      98.0938       0.0441      97.4840       0.1481       3.1231       0.0000    2577.1580    1554.0000
  719.1756      96.0000      98.3183       0.0447      99.0226       0.1475       3.1088       0.0000    2576.2002    1554.0000
  719.3280      96.0000      98.7282       0.0455     101.3663       0.1444       3.0562       0.0000    2574.8787    1579.0000
  719.4804      96.0000      98.9081       0.0484     104.0193       0.1453       3.0179       0.0000    2570.1179    1553.0000
  719.6328      96.0000      98.8093       0.0399     106.9042       0.1493       3.0392       0.0000    2584.1040    1553.0000
  719.7852      96.0000      98.8424       0.0279     107.2948       0.1536       3.0290       0.0000    2603.9790    1581.0000
  719.9376      96.0000      99.1314       0.0251     116.3736       0.1588       3.0123       0.0000    2608.5916    1584.0000
  720.0900      96.0000      98.9899       0.0255     120.8149       0.1625       3.1727       0.0000    2607.8843    1565.0000
  720.2424      96.0000      99.3237       0.0297     119.6604       0.1653       3.1913       0.0000    2601.0212    1596.0000
  720.3948      96.0000      99.0499       0.0300     110.8135       0.1658       3.1364       0.0000    2600.4819    1572.0000
  720.5472      96.0000      98.6793       0.0326     104.2566       0.1545       2.9752       0.0000    2596.2239    1565.0000
  720.6996      96.0000      99.1400       0.0255      99.8311       0.1434       2.9454       0.0000    2607.8643    1608.0000
  720.8520      96.0000      99.1642       0.0186     100.3234       0.1301       3.0122       0.0000    2619.3433    1575.0000
  721.0044      96.0000      98.8261       0.0146     104.7468       0.1245       2.9967       0.0000    2625.9390    1561.0000
  721.1568      96.0000      98.4662       0.0144     103.3999       0.1160       2.9625       0.0000    2626.1802    1574.0000
  721.3092      96.0000      98.3518       0.0110     100.4074       0.1138       2.9966       0.0000    2631.8440    1580.0000
  721.4616      96.0000      98.4090       0.0111      97.9237       0.1177       3.0720       0.0000    2631.7595    1568.0000
  721.6140      96.0000      97.9470       0.0075     105.2178       0.1250       3.4260       0.0000    2637.5989    1561.0000
  721.7664      96.0000      98.0323       0.0141     106.7564       0.1285       3.3300       0.0000    2626.8066    1552.0000
  721.9188      96.0000      98.5684       0.0233     105.6019       0.1283       3.3129       0.0000    2611.5740    1584.0000
  722.0712      96.0000      99.1917       0.0347     105.2008       0.1285       3.2072       0.0000    2592.8225    1559.0000
  722.2236      96.0000      98.0539       0.0362     105.5854       0.1256       3.2260       0.0000    2590.2695    1541.0000
  722.3760      96.0000      97.8941       0.0367     104.2385       0.1267       3.2059       0.0000    2589.5105    1546.0000
  722.5284      96.0000      97.9469       0.0363      99.2545       0.1293       2.9597       0.0000    2590.0520    1588.0000
  722.6808      96.0000      98.2158       0.0301      96.3409       0.1318       3.0546       0.0000    2600.3833    1539.0000
  722.8332      96.0000      98.1565       0.0194      97.3030       0.1349       3.1826       0.0000    2617.9136    1555.0000
  722.9856      96.0000      97.9967       0.0079      98.4569       0.1395       3.4360       0.0000    2636.9009    1584.0000
  723.1380      96.0000      98.1207       0.0061     104.8324       0.1412       3.7090       0.0000    2639.8811    1552.0000
  723.2904      96.0000      98.1349       0.0086     110.7972       0.1415       3.7931       0.0000    2635.7856    1567.0000
  723.4428      96.0000      98.0895       0.0186     115.6053       0.1402       3.7149       0.0000    2619.3892    1590.0000
  723.5952      96.0000      98.0195       0.0252     109.7730       0.1441       3.4106       0.0000    2608.4644    1589.0000
  723.7476      96.0000      98.2826       0.0306      98.0357       0.1409       3.3234       0.0000    2599.4871    1575.0000
  723.9000      96.0000      98.2373       0.0242      89.1888       0.1321       3.3119       0.0000    2610.0671    1579.0000
  724.0524      96.0000      98.0843       0.0176      98.0983       0.1239       3.4473       0.0000    2620.9731    1565.0000
  724.2048      96.0000      97.9276       0.0197     112.3370       0.1246       3.4615       0.0000    2617.5317    1545.0000
  724.3572      96.0000      98.2493       0.0249     111.9524       0.1268       3.3623       0.0000    2608.9949    1551.0000
  724.5096      96.0000      98.3857       0.0285      97.1555       0.1258       3.2066       0.0000    2602.9585    1561.0000
  724.6620      96.0000      98.4210       0.0283      86.1558       0.1222       3.1428       0.0000    2603.2720    1546.0000
  724.8144      96.0000      98.1921       0.0226      87.5021       0.1195       3.0619       0.0000    2612.6460    1558.0000
  724.9668      96.0000      98.2374       0.0252      96.3369       0.1204       3.0440       0.0000    2608.3894    1565.0000
  725.1192      96.0000      98.2865       0.0252      94.8296       0.1223       3.1117       0.0000    2608.4224    1563.0000
  725.2716      96.0000      98.4209       0.0192      98.8684       0.1263       3.3232       0.0000    2618.2441    1558.0000
  725.4240      96.0000      98.3303       0.0167     101.1712       0.1292       3.5141       0.0000    2622.3706    1562.0000
  725.5764      96.0000      98.2502       0.0157     105.2119       0.1324       3.4816       0.0000    2624.0730    1582.0000
  725.7288      96.0000      98.2946       0.0181     103.0963       0.1360       3.3529       0.0000    2620.0632    1538.0000
  725.8812      96.0000      98.2158       0.0176      98.1010       0.1379       3.2412       0.0000    2620.9321    1572.0000
  726.0336      96.0000      98.4048       0.0235      97.5238       0.1403       3.2196       0.0000    2611.2209    1594.0000
  726.1860      96.0000      98.3637       0.0348     101.5626       0.1475       3.1574       0.0000    2592.6003    1576.0000
  726.3384      96.0000      98.5353       0.0379     103.5018       0.1586       3.0747       0.0000    2587.4629    1575.0000
  726.4908      96.0000      98.1665       0.0395     106.1788       0.1660       3.0110       0.0000    2584.8318    1587.0000
  726.6432      96.0000      98.2828       0.0367     103.1017       0.1656       3.1448       0.0000    2589.4514    1584.0000
  726.7956      96.0000      98.3637       0.0419      99.4726       0.1630       3.2223       0.0000    2580.8716    1566.0000
  726.9480      96.0000      98.1349       0.0454      96.0108       0.1547       3.1644       0.0000    2575.0132    1587.0000
  727.1004      96.0000      98.2026       0.0438      97.1365       0.1444       3.1241       0.0000    2577.7493    1581.0000
  727.2528      96.0000      98.3185       0.0357     100.1726       0.1292       3.0311       0.0000    2591.0496    1581.0000
  727.4052      96.0000      98.3637       0.0301      96.7967       0.1184       2.9851       0.0000    2600.3259    1575.0000
  727.5576      96.0000      98.4506       0.0229      94.6242       0.1087       2.9578       0.0000    2612.2881    1577.0000
  727.7100      96.0000      97.9512       0.0193      90.7916       0.1067       2.9956       0.0000    2618.1802    1573.0000
  727.8624      96.0000      97.6650       0.0187      95.1291       0.1063       3.0849       0.0000    2619.0752    1602.0000
  728.0148      96.0000      97.9643       0.0235     101.5610       0.1105       2.9492       0.0000    2611.1460    1576.0000
  728.1672      96.0000      97.6080       0.0206     105.0245       0.1100       3.0016       0.0000    2616.0369    1563.0000
  728.3196      96.0000      97.9514       0.0215     100.9000       0.1128       3.1090       0.0000    2614.4905    1570.0000
  728.4720      96.0000      98.5878       0.0254      94.9379       0.1177       3.1618       0.0000    2608.0166    1577.0000
  728.6244      96.0000      98.5354       0.0306      95.1147       0.1230       3.1297       0.0000    2599.5835    1559.0000
  728.7768      96.0000      98.2373       0.0363     101.7562       0.1299       3.0450       0.0000    2590.1211    1588.0000
  728.9292      96.0000      98.3761       0.0351     100.2176       0.1341       3.0774       0.0000    2592.0100    1572.0000
  729.0816      96.0000      98.3280       0.0386     103.1194       0.1380       3.0663       0.0000    2586.2866    1556.0000
  729.2340      96.0000      98.1466       0.0447     103.1765       0.1403       3.0443       0.0000    2576.1921    1566.0000
  729.3864      96.0000      98.2374       0.0446     105.0997       0.1455       3.1030       0.0000    2576.3293    1583.0000
  729.5388      96.0000      98.0385       0.0397     100.8666       0.1477       3.0021       0.0000    2584.5000    1583.0000
  729.6912      96.0000      98.0774       0.0423      97.9079       0.1459       3.0046       0.0000    2580.1240    1568.0000
  729.8436      96.0000      97.9967       0.0459     100.6743       0.1411       2.9435       0.0000    2574.2698    1544.0000
  729.9960      96.0000      98.3227       0.0480     107.3130       0.1347       3.0028       0.0000    2570.7834    1611.0000
  730.1484      96.0000      98.4210       0.0396     110.8147       0.1251       2.9029       0.0000    2584.6167    1567.0000
  730.3008      96.0000      98.4782       0.0353     109.0100       0.1127       2.9526       0.0000    2591.7244    1549.0000
  730.4532      96.0000      98.2947       0.0249      96.0216       0.1071       2.9004       0.0000    2608.8628    1582.0000
  730.6056      96.0000      98.4143       0.0250      85.7885       0.1056       3.0163       0.0000    2608.7148    1565.0000
  730.7580      96.0000      98.5924       0.0221      82.9036       0.1085       3.0159       0.0000    2613.4873    1566.0000
  730.9104      96.0000      98.5233       0.0253      89.4457       0.1156       3.1175       0.0000    2608.2629    1584.0000
  731.0628      96.0000      98.4313       0.0214      91.9459       0.1245       3.1106       0.0000    2614.7639    1569.0000
  731.2152      96.0000      98.5233       0.0192      96.4545       0.1326       3.2088       0.0000    2618.2656    1574.0000
  731.3676      96.0000      98.7973       0.0154      98.7635       0.1393       3.2292       0.0000    2624.6587    1573.0000
  731.5200      96.0000      98.7611       0.0139     102.8023       0.1477       3.3611       0.0000    2627.1057    1572.0000
  731.6724      96.0000      98.7522       0.0231     101.9479       0.1481       3.4227       0.0000    2611.8606    1554.0000
  731.8248      96.0000      98.6378       0.0316      99.2019       0.1438       3.3353       0.0000    2597.8281    1565.0000
  731.9772      96.0000      98.8262       0.0408      97.8556       0.1333       3.1617       0.0000    2582.6736    1553.0000
  732.1296      96.0000      98.9116       0.0387      88.6240       0.1227       2.9123       0.0000    2586.1733    1568.0000
  732.2820      96.0000      98.6045       0.0297      85.4052       0.1148       2.9897       0.0000    2600.9736    1568.0000
  732.4344      96.0000      98.4994       0.0199      80.9817       0.1178       3.0538       0.0000    2617.2375    1565.0000
  732.5868      96.0000      98.2675       0.0178      93.9644       0.1272       3.1334       0.0000    2620.6951    1583.0000
  732.7392      96.0000      98.4329       0.0198      96.8359       0.1378       3.0874       0.0000    2617.2617    1589.0000
  732.8916      96.0000      98.5926       0.0166     106.8541       0.1403       3.2293       0.0000    2622.5498    1566.0000
  733.0440      96.0000      98.4409       0.0150     105.6032       0.1437       3.5886       0.0000    2625.2107    1577.0000
  733.1964      96.0000      98.5117       0.0090     111.9676       0.1469       3.6409       0.0000    2635.2134    1581.0000
  733.3488      96.0000      98.4780       0.0131     109.0654       0.1457       3.5248       0.0000    2628.3513    1565.0000
  733.5012      96.0000      98.6527       0.0193     110.4298       0.1415       3.2680       0.0000    2618.1584    1584.0000
  733.6536      96.0000      98.6950       0.0291     103.8556       0.1357       3.1237       0.0000    2601.9495    1573.0000
  733.8060      96.0000      98.8663       0.0361     101.7401       0.1265       2.9824       0.0000    2590.3843    1569.0000
  733.9584      96.0000      98.6238       0.0539      87.3090       0.1182       2.8192       0.0000    2561.0342    1582.0000
  734.1108      96.0000      98.5234       0.0641      86.0285       0.1094       2.7607       0.0000    2544.2185    1565.0000
  734.2632      96.0000      98.5114       0.0646      80.0786       0.1073       2.6643       0.0000    2543.4365    1575.0000
  734.4156      96.0000      98.6498       0.0603      84.1061       0.1037       2.6526       0.0000    2550.5688    1589.0000
  734.5680      96.0000      98.4238       0.0549      80.8007       0.1015       2.6556       0.0000    2559.4568    1547.0000
  734.7204      96.0000      98.1920       0.0499      82.7118       0.1019       2.7531       0.0000    2567.6541    1569.0000
  734.8728      96.0000      98.2947       0.0475      83.6734       0.1079       2.8353       0.0000    2571.6697    1583.0000
  735.0252      96.0000      98.0749       0.0555      80.8366       0.1143       2.8631       0.0000    2558.4561    1577.0000
  735.1776      96.0000      98.1347       0.0698      81.4269       0.1208       2.8107       0.0000    2534.7654    1549.0000
  735.3300      96.0000      98.1229       0.0804      77.3881       0.1243       2.7285       0.0000    2517.4141    1575.0000
  735.4824      96.0000      98.4602       0.0875      80.2249       0.1241       2.7342       0.0000    2505.5686    1583.0000
  735.6348      96.0000      98.0776       0.0878      79.6346       0.1228       2.7511       0.0000    2505.0752    1554.0000
  735.7872      96.0000      97.9513       0.0859      76.1727       0.1197       2.7934       0.0000    2508.2471    1587.0000
  735.9396      96.0000      98.2865       0.0841      75.7010       0.1161       2.9206       0.0000    2511.2954    1587.0000
  736.0920      96.0000      98.1347       0.0817      76.8549       0.1194       3.0538       0.0000    2515.1282    1556.0000
  736.2444      96.0000      98.3066       0.0740      81.6630       0.1240       3.0133       0.0000    2527.8840    1598.0000
  736.3968      96.0000      98.2674       0.0771      85.0913       0.1326       2.8798       0.0000    2522.8630    1567.0000
  736.5492      96.0000      98.4208       0.0824      88.7608       0.1411       2.7582       0.0000    2513.9861    1580.0000
  736.7016      96.0000      98.1013       0.0889      87.6068       0.1515       2.7361       0.0000    2503.2856    1593.0000
  736.8540      96.0000      98.0203       0.0903      88.8834       0.1552       2.7262       0.0000    2501.0366    1562.0000
  737.0064      96.0000      98.0195       0.0875      88.0988       0.1527       2.7810       0.0000    2505.5767    1577.0000
  737.1588      96.0000      98.0539       0.0860      96.9288       0.1479       2.9219       0.0000    2508.1611    1582.0000
  737.3112      96.0000      97.8941       0.0813      94.6065       0.1421       2.9879       0.0000    2515.8572    1545.0000
  737.4636      96.0000      98.0574       0.0779      94.2366       0.1329       2.9632       0.0000    2521.3953    1593.0000
  737.6160      96.0000      98.3184       0.0692      92.3303       0.1235       2.9996       0.0000    2535.8726    1584.0000
  737.7684      96.0000      98.1349       0.0612      96.9616       0.1197       2.9520       0.0000    2549.0447    1567.0000
  737.9208      96.0000      97.8552       0.0473      95.2159       0.1245       2.9463       0.0000    2571.9038    1579.0000
  738.0732      96.0000      97.9631       0.0412      92.7157       0.1265       2.8119       0.0000    2582.0703    1577.0000
  738.2256      96.0000      98.0657       0.0292      99.1048       0.1347       3.0655       0.0000    2601.7485    1566.0000
  738.3780      96.0000      98.4408       0.0280     107.7594       0.1474       3.2307       0.0000    2603.7908    1607.0000
  738.5304      96.0000      98.6952       0.0279     113.1444       0.1574       3.5133       0.0000    2603.9465    1561.0000
  738.6828      96.0000      98.5354       0.0401     107.8768       0.1646       3.2039       0.0000    2583.7654    1591.0000
  738.8352      96.0000      98.9080       0.0496     104.8162       0.1564       3.0769       0.0000    2568.0908    1577.0000
  738.9876      96.0000      99.2787       0.0580     105.2009       0.1560       2.8023       0.0000    2554.2341    1581.0000
  739.1400      96.0000      98.9237       0.0620     102.7176       0.1473       2.7440       0.0000    2547.6582    1568.0000
  739.2924      96.0000      98.6829       0.0623      95.2135       0.1421       2.6079       0.0000    2547.2766    1594.0000
  739.4448      96.0000      98.4962       0.0653      86.1742       0.1381       2.6838       0.0000    2542.2498    1554.0000
  739.5972      96.0000      97.9059       0.0649      80.3410       0.1467       2.6833       0.0000    2542.8823    1574.0000
  739.7496      96.0000      97.8940       0.0692      82.6359       0.1534       2.8593       0.0000    2535.8149    1569.0000
  739.9020      96.0000      98.0386       0.0726      85.7130       0.1614       2.8689       0.0000    2530.2034    1589.0000
  740.0544      96.0000      98.2493       0.0769      86.7508       0.1602       2.8427       0.0000    2523.0669    1563.0000
  740.2068      96.0000      98.9357       0.0763      81.1734       0.1621       2.7260       0.0000    2524.1040    1569.0000
  740.3592      96.0000      98.4504       0.0692      79.9789       0.1570       2.6599       0.0000    2535.9026    1586.0000
  740.5116      96.0000      98.5353       0.0596      83.4281       0.1486       2.8065       0.0000    2551.7266    1584.0000
  740.6640      96.0000      98.4783       0.0499      95.1769       0.1454       2.9210       0.0000    2567.6992    1556.0000
  740.8164      96.0000      98.4046       0.0473      98.2946       0.1407       3.0365       0.0000    2571.9058    1566.0000
  740.9688      96.0000      98.6950       0.0531      95.4257       0.1427       3.0195       0.0000    2562.4551    1591.0000
  741.1212      96.0000      98.6258       0.0604      86.5746       0.1403       2.9899       0.0000    2550.4070    1595.0000
  741.2736      96.0000      98.4208       0.0624      84.4590       0.1416       2.9736       0.0000    2547.1040    1591.0000
  741.4260      96.0000      98.0842       0.0628      87.3280       0.1422       2.9315       0.0000    2546.3899    1573.0000
  741.5784      96.0000      98.2492       0.0584      94.0295       0.1442       2.9319       0.0000    2553.6909    1600.0000
  741.7308      96.0000      98.6378       0.0518     100.7778       0.1468       2.9765       0.0000    2564.5769    1594.0000
  741.8832      96.0000      98.6697       0.0463     105.2013       0.1533       3.0203       0.0000    2573.5259    1566.0000
  742.0356      96.0000      98.5474       0.0465     104.0798       0.1623       3.0249       0.0000    2573.2590    1561.0000
  742.1880      96.0000      98.5114       0.0479     103.2935       0.1686       3.0584       0.0000    2570.9312    1577.0000
  742.3404      96.0000      98.8165       0.0391     112.1404       0.1689       3.3208       0.0000    2585.4604    1586.0000
  742.4928      96.0000      98.8546       0.0417     124.0702       0.1694       3.4753       0.0000    2581.2297    1569.0000
  742.6452      96.0000      98.7162       0.0399     126.7011       0.1716       3.3826       0.0000    2584.1846    1593.0000
  742.7976      96.0000      98.7516       0.0517     116.5079       0.1713       3.0820       0.0000    2564.7739    1576.0000
  742.9500      96.0000      98.8213       0.0500     107.8493       0.1624       2.9608       0.0000    2567.4585    1566.0000
  743.1024      96.0000      98.5805       0.0522      99.7024       0.1559       3.0026       0.0000    2563.8889    1583.0000
  743.2548      96.0000      98.5685       0.0426      94.7020       0.1505       2.9508       0.0000    2579.7385    1591.0000
  743.4072      96.0000      98.5233       0.0387      92.9703       0.1499       2.9860       0.0000    2586.1553    1569.0000
  743.5596      96.0000      98.6258       0.0434      95.6013       0.1463       3.0357       0.0000    2578.3770    1582.0000
  743.7120      96.0000      98.6792       0.0495     102.9834       0.1476       3.1020       0.0000    2568.3608    1609.0000
  743.8644      96.0000      98.8334       0.0515      99.3130       0.1525       3.1519       0.0000    2565.1003    1572.0000
  744.0168      96.0000      98.6951       0.0446      96.4421       0.1567       3.1600       0.0000    2576.4375    1555.0000
  744.1692      96.0000      98.6497       0.0320      94.0604       0.1570       3.3794       0.0000    2597.2004    1595.0000
  744.3216      96.0000      98.5323       0.0177     100.2321       0.1598       3.4757       0.0000    2620.7476    1572.0000
  744.4740      96.0000      98.1112       0.0134     108.8728       0.1665       3.4268       0.0000    2627.9246    1579.0000
  744.6264      96.0000      98.3518       0.0206     113.4886       0.1690       3.3097       0.0000    2616.0225    1575.0000
  744.7788      96.0000      97.9375       0.0348     116.1992       0.1605       3.1695       0.0000    2592.5747    1582.0000
  744.9312      96.0000      98.2158       0.0495     110.8142       0.1540       3.0875       0.0000    2568.3914    1556.0000
  745.0836      96.0000      98.3399       0.0528     106.0061       0.1497       3.0485       0.0000    2562.8171    1577.0000
  745.2360      96.0000      98.3588       0.0442     105.4454       0.1461       3.0572       0.0000    2577.1470    1589.0000
  745.3884      96.0000      98.3399       0.0320     108.3470       0.1359       3.1656       0.0000    2597.2229    1574.0000
  745.5408      96.0000      97.9395       0.0240     112.3858       0.1278       3.1841       0.0000    2610.3293    1587.0000
  745.6932      96.0000      98.2674       0.0246     106.3876       0.1188       3.3379       0.0000    2609.3364    1601.0000
  745.8456      96.0000      98.3065       0.0267      99.8318       0.1078       3.3618       0.0000    2605.8672    1590.0000
  745.9980      96.0000      98.4542       0.0246      84.2458       0.0946       3.3386       0.0000    2609.3640    1589.0000
  746.1504      96.0000      98.5059       0.0183      72.4984       0.0841       3.1999       0.0000    2619.8706    1586.0000
  746.3028      96.0000      98.5353       0.0179      66.5473       0.0789       3.2114       0.0000    2620.4260    1573.0000
  746.4552      96.0000      98.6829       0.0146      64.6318       0.0817       3.2618       0.0000    2625.8694    1591.0000
  746.6076      96.0000      98.8213       0.0054      67.7090       0.0891       3.3717       0.0000    2641.1272    1566.0000
  746.7600      96.0000      98.7155       0.0070      74.0586       0.1036       3.5055       0.0000    2638.4297    1588.0000
  746.9124      96.0000      98.7521       0.0098      87.5608       0.1259       3.4952       0.0000    2633.8047    1568.0000
  747.0648      96.0000      98.8069       0.0184     104.6972       0.1465       3.6411       0.0000    2619.5859    1558.0000
  747.2172      96.0000      98.9811       0.0235     122.1848       0.1658       3.4558       0.0000    2611.2390    1597.0000
  747.3696      96.0000      98.8665       0.0274     131.3770       0.1716       3.4719       0.0000    2604.7144    1581.0000
  747.5220      96.0000      98.9809       0.0354     126.1933       0.1694       3.3706       0.0000    2591.5444    1580.0000
  747.6744      96.0000      98.9345       0.0446     118.9037       0.1615       3.3470       0.0000    2576.3860    1596.0000
  747.8268      96.0000      98.7521       0.0503     107.9412       0.1554       3.2501       0.0000    2567.0806    1597.0000
  747.9792      96.0000      99.3808       0.0446     102.5420       0.1458       3.1689       0.0000    2576.4250    1562.0000
  748.1316      96.0000      98.7514       0.0383      96.9139       0.1371       3.1370       0.0000    2586.8430    1602.0000
  748.2840      96.0000      98.7069       0.0350      97.5059       0.1305       3.0797       0.0000    2592.2456    1595.0000
  748.4364      96.0000      98.8213       0.0392      94.2218       0.1366       3.0622       0.0000    2585.3245    1574.0000
  748.5888      96.0000      98.7516       0.0459      89.6520       0.1441       3.0282       0.0000    2574.3345    1588.0000
  748.7412      96.0000      98.4544       0.0458      91.7525       0.1495       3.1492       0.0000    2574.4958    1604.0000
  748.8936      96.0000      99.3808       0.0485      96.2718       0.1489       3.1225       0.0000    2570.0562    1611.0000
  749.0460      96.0000      99.4469       0.0464     101.0822       0.1445       3.1505       0.0000    2573.4543    1588.0000
  749.1984      96.0000      99.5072       0.0455      96.4664       0.1401       3.0302       0.0000    2574.9727    1614.0000
  749.3508      96.0000      98.9237       0.0479      94.6396       0.1374       3.0775       0.0000    2571.0198    1591.0000
  749.5032      96.0000      98.3761       0.0499      94.0624       0.1368       3.1008       0.0000    2567.7002    1588.0000
  749.6556      96.0000      98.4328       0.0507      99.4474       0.1403       3.2393       0.0000    2566.3567    1597.0000
  749.8080      96.0000      98.5355       0.0457     102.9036       0.1486       3.2830       0.0000    2574.5588    1623.0000
  749.9604      96.0000      98.3590       0.0401      99.8250       0.1552       3.2869       0.0000    2583.8433    1580.0000
  750.1128      96.0000      98.2947       0.0448      95.0169       0.1538       3.3302       0.0000    2576.0588    1598.0000
  750.2652      96.0000      98.1684       0.0457      95.7410       0.1532       3.2824       0.0000    2574.6570    1615.0000
  750.4176      96.0000      98.1127       0.0506     101.4963       0.1551       3.4488       0.0000    2566.4854    1603.0000
  750.5700      96.0000      98.4661       0.0514     108.0526       0.1565       3.3355       0.0000    2565.1970    1598.0000
  750.7224      96.0000      98.8093       0.0542     106.5648       0.1520       3.3443       0.0000    2560.6145    1614.0000
  750.8748      96.0000      99.0501       0.0504     109.0833       0.1483       3.2524       0.0000    2566.7751    1601.0000
  751.0272      96.0000      98.7515       0.0461     106.7299       0.1462       3.2514       0.0000    2573.8936    1596.0000
  751.1796      96.0000      98.8665       0.0460     102.3065       0.1455       3.2369       0.0000    2574.1389    1590.0000
  751.3320      96.0000      98.5353       0.0373      93.4554       0.1402       3.2047       0.0000    2588.4595    1597.0000
  751.4844      96.0000      98.4411       0.0354      91.7527       0.1381       3.0275       0.0000    2591.5713    1622.0000
  751.6368      96.0000      98.4661       0.0308      90.5988       0.1332       3.0284       0.0000    2599.2175    1586.0000
  751.7892      96.0000      98.2312       0.0296      91.9457       0.1286       2.8791       0.0000    2601.2258    1597.0000
  751.9416      96.0000      98.2947       0.0213      90.3896       0.1267       2.9752       0.0000    2614.8335    1583.0000
  752.0940      96.0000      98.3065       0.0217      97.8903       0.1330       2.9858       0.0000    2614.2192    1574.0000
  752.2464      96.0000      97.7797       0.0256      98.8523       0.1427       3.0418       0.0000    2607.7375    1607.0000
  752.3988      96.0000      97.6908       0.0333      99.2144       0.1519       3.1586       0.0000    2594.9746    1591.0000
  752.5512      96.0000      98.2373       0.0410      96.7142       0.1604       3.1722       0.0000    2582.2949    1583.0000
  752.7036      96.0000      98.4090       0.0455      94.9681       0.1652       3.1971       0.0000    2574.9443    1584.0000
  752.8560      96.0000      98.4866       0.0437      95.0229       0.1617       3.1167       0.0000    2577.8218    1580.0000
  753.0084      96.0000      98.0084       0.0441      98.8980       0.1592       3.1778       0.0000    2577.3120    1614.0000
  753.1608      96.0000      97.7459       0.0412     100.6290       0.1597       3.2484       0.0000    2582.0378    1587.0000
  753.3132      96.0000      97.9105       0.0400     101.5910       0.1613       3.2261       0.0000    2584.0439    1587.0000
  753.4656      96.0000      98.0658       0.0419      99.8314       0.1587       3.3134       0.0000    2580.7920    1605.0000
  753.6180      96.0000      98.0894       0.0413     101.1936       0.1543       3.1861       0.0000    2581.8401    1605.0000
  753.7704      96.0000      97.9104       0.0456     102.9093       0.1494       3.2203       0.0000    2574.7905    1579.0000
  753.9228      96.0000      98.2610       0.0475      95.0240       0.1421       2.9232       0.0000    2571.6143    1605.0000
  754.0752      96.0000      98.3517       0.0487      90.6687       0.1299       2.9285       0.0000    2569.5972    1602.0000
  754.2276      96.0000      98.4962       0.0449      82.0261       0.1197       2.8429       0.0000    2575.8982    1595.0000
  754.3800      96.0000      98.5235       0.0386      81.8948       0.1146       2.9637       0.0000    2586.3147    1597.0000
  754.5324      96.0000      98.3637       0.0333      81.0414       0.1143       2.8921       0.0000    2595.0403    1582.0000
  754.6848      96.0000      98.3323       0.0312      82.3757       0.1190       2.9778       0.0000    2598.5464    1602.0000
  754.8372      96.0000      98.0895       0.0270      87.5224       0.1200       3.0031       0.0000    2605.4470    1597.0000
  754.9896      96.0000      97.7796       0.0300      86.2033       0.1257       3.1456       0.0000    2600.4587    1604.0000
  755.1420      96.0000      97.7920       0.0327      90.0594       0.1276       3.1168       0.0000    2596.1248    1594.0000
  755.2944      96.0000      98.0204       0.0382      87.4472       0.1274       3.0200       0.0000    2587.0271    1591.0000
  755.4468      96.0000      97.6886       0.0392      88.3817       0.1212       2.9460       0.0000    2585.2686    1588.0000
  755.5992      96.0000      97.6196       0.0421      87.9874       0.1187       2.9342       0.0000    2580.6130    1598.0000
  755.7516      96.0000      97.7826       0.0418      88.8679       0.1180       2.8179       0.0000    2581.0791    1596.0000
  755.9040      96.0000      98.6257       0.0358      88.2909       0.1161       2.8274       0.0000    2590.8967    1577.0000
  756.0564      96.0000      98.5568       0.0360      82.3403       0.1160       2.8179       0.0000    2590.6406    1607.0000
  756.2088      96.0000      98.6792       0.0360      84.5376       0.1181       2.8498       0.0000    2590.5662    1596.0000
  756.3612      96.0000      98.5925       0.0386      89.7303       0.1276       3.0198       0.0000    2586.2324    1607.0000
  756.5136      96.0000      99.2183       0.0375     108.5869       0.1450       3.2160       0.0000    2588.2039    1605.0000
  756.6660      96.0000      99.1194       0.0390     111.6646       0.1640       3.4487       0.0000    2585.6763    1591.0000
  756.8184      96.0000      98.5233       0.0420     118.0113       0.1712       3.2992       0.0000    2580.6255    1603.0000
  756.9708      96.0000      98.1445       0.0479     108.1825       0.1649       3.1541       0.0000    2570.9385    1591.0000
  757.1232      96.0000      98.5154       0.0504     103.8513       0.1505       2.9937       0.0000    2566.7834    1594.0000
  757.2756      96.0000      98.1348       0.0514      97.5046       0.1428       3.0061       0.0000    2565.1543    1608.0000
  757.4280      96.0000      98.1920       0.0439      96.5430       0.1384       3.0044       0.0000    2577.5647    1600.0000
  757.5804      96.0000      98.8531       0.0363     101.1793       0.1392       3.2469       0.0000    2590.1812    1600.0000
  757.7328      96.0000      98.2493       0.0367     106.9490       0.1470       3.2916       0.0000    2589.3789    1600.0000
  757.8852      96.0000      98.3637       0.0401     112.1027       0.1579       3.3654       0.0000    2583.7903    1588.0000
  758.0376      96.0000      98.5877       0.0490     120.1841       0.1692       3.5072       0.0000    2569.1301    1612.0000
  758.1900      96.0000      98.5113       0.0481     124.0306       0.1730       3.6263       0.0000    2570.5957    1607.0000
  758.3424      96.0000      98.2827       0.0507     125.0312       0.1730       3.5077       0.0000    2566.2654    1601.0000
  758.4948      96.0000      98.3036       0.0469     114.2560       0.1624       3.1698       0.0000    2572.5679    1616.0000
  758.6472      96.0000      98.0777       0.0534     100.2164       0.1560       3.0574       0.0000    2561.8643    1598.0000
  758.7996      96.0000      98.2825       0.0509      88.3532       0.1473       2.9712       0.0000    2565.9441    1595.0000
  758.9520      96.0000      98.4219       0.0426      89.7002       0.1436       3.1445       0.0000    2579.7310    1609.0000
  759.1044      96.0000      98.4542       0.0302     112.9714       0.1426       3.2738       0.0000    2600.1396    1589.0000
  759.2568      96.0000      98.2610       0.0267     129.4461       0.1402       3.4300       0.0000    2605.9451    1589.0000
  759.4092      96.0000      98.3493       0.0293     125.2130       0.1397       3.1874       0.0000    2601.7356    1603.0000
  759.5616      96.0000      98.0992       0.0352     108.2885       0.1337       2.9508       0.0000    2591.9773    1600.0000
  759.7140      96.0000      98.1230       0.0446      95.5992       0.1337       2.8883       0.0000    2576.3823    1608.0000
  759.8664      96.0000      98.3589       0.0438      95.4068       0.1327       2.7929       0.0000    2577.6675    1593.0000
  760.0188      96.0000      98.1229       0.0381      93.5456       0.1311       2.9684       0.0000    2587.1907    1581.0000
  760.1712      96.0000      98.7642       0.0296     100.2769       0.1295       3.1543       0.0000    2601.1689    1621.0000
  760.3236      96.0000      98.5236       0.0224      99.3149       0.1347       3.3866       0.0000    2612.9771    1596.0000
  760.4760      96.0000      98.4505       0.0195      95.4064       0.1442       3.1580       0.0000    2617.7683    1608.0000
  760.6284      96.0000      98.5114       0.0194      91.9445       0.1524       3.1455       0.0000    2618.0115    1615.0000
  760.7808      96.0000      98.2674       0.0135     107.5301       0.1566       3.3778       0.0000    2627.7537    1600.0000
  760.9332      96.0000      98.1683       0.0150     117.5940       0.1701       3.6663       0.0000    2625.2847    1611.0000
  761.0856      96.0000      98.4661       0.0245     115.4784       0.1777       3.4143       0.0000    2609.5696    1600.0000
  761.2380      96.0000      98.4091       0.0348      97.3915       0.1741       3.2176       0.0000    2592.5037    1591.0000
  761.3904      96.0000      98.2865       0.0444      94.6598       0.1624       3.0557       0.0000    2576.6692    1609.0000
  761.5428      96.0000      98.0776       0.0521      93.1354       0.1537       3.0012       0.0000    2563.9729    1605.0000
  761.6952      96.0000      98.1802       0.0569      96.3925       0.1526       2.9351       0.0000    2556.1238    1600.0000
  761.8476      96.0000      98.3592       0.0568      94.4614       0.1421       2.8905       0.0000    2556.2104    1589.0000
  762.0000      96.0000      98.5925       0.0517      93.4000       0.1301       2.9307       0.0000    2564.6763    1580.0000
  762.1524      96.0000      98.6379       0.0496      90.8998       0.1232       2.8981       0.0000    2568.2026    1622.0000
  762.3048      96.0000      98.7154       0.0532      80.7018       0.1185       2.9374       0.0000    2562.2273    1595.0000
  762.4572      96.0000      98.0775       0.0545      78.8642       0.1147       2.9130       0.0000    2560.0823    1596.0000
  762.6096      96.0000      97.9966       0.0571      81.2449       0.1103       2.8922       0.0000    2555.8042    1596.0000
  762.7620      96.0000      98.0843       0.0497      84.1311       0.1107       2.8383       0.0000    2568.0215    1596.0000
  762.9144      96.0000      98.2493       0.0410      84.7081       0.1142       2.8871       0.0000    2582.4019    1623.0000
  763.0668      96.0000      98.1920       0.0334      83.4814       0.1177       2.9261       0.0000    2594.9690    1600.0000
  763.2192      96.0000      97.7178       0.0302      84.2510       0.1169       3.0839       0.0000    2600.1426    1575.0000
  763.3716      96.0000      97.8369       0.0218      89.4438       0.1256       3.2696       0.0000    2613.9932    1586.0000
  763.5240      96.0000      97.8722       0.0254      93.9293       0.1401       3.2317       0.0000    2608.0542    1619.0000
  763.6764      96.0000      97.8648       0.0310      96.8155       0.1509       3.1859       0.0000    2598.7898    1583.0000
  763.8288      96.0000      97.9059       0.0409      96.4308       0.1551       3.1882       0.0000    2582.4346    1603.0000
  763.9812      96.0000      98.3065       0.0446      95.8877       0.1544       3.3449       0.0000    2576.3484    1626.0000
  764.1336      96.0000      98.3037       0.0478      97.6042       0.1623       3.3879       0.0000    2571.0745    1594.0000
  764.2860      96.0000      98.6046       0.0466      98.1968       0.1619       3.2504       0.0000    2573.1196    1611.0000
  764.4384      96.0000      98.3637       0.0468      97.7163       0.1570       3.1197       0.0000    2572.8176    1610.0000
  764.5908      96.0000      98.2947       0.0450      95.8094       0.1494       3.0415       0.0000    2575.8206    1591.0000
  764.7432      96.0000      98.2121       0.0457      90.9990       0.1445       2.9936       0.0000    2574.5874    1651.0000
  764.8956      96.0000      98.0204       0.0379      89.6527       0.1419       3.0913       0.0000    2587.4856    1575.0000
  765.0480      96.0000      98.2673       0.0270      96.3677       0.1407       3.1169       0.0000    2605.3687    1596.0000
  765.2004      96.0000      98.2377       0.0183     102.7174       0.1415       3.2621       0.0000    2619.7964    1637.0000
  765.3528      96.0000      98.0321       0.0147     105.4099       0.1374       3.0682       0.0000    2625.7744    1595.0000
  765.5052      96.0000      98.0842       0.0136     101.0485       0.1319       2.8663       0.0000    2627.6094    1618.0000
  765.6576      96.0000      98.3638       0.0181     102.5878       0.1238       2.7128       0.0000    2620.1997    1612.0000
  765.8100      96.0000      98.4662       0.0199     102.7801       0.1247       2.7345       0.0000    2617.1638    1583.0000
  765.9624      96.0000      98.3065       0.0185     104.7716       0.1273       2.8348       0.0000    2619.4724    1587.0000
  766.1148      96.0000      98.7516       0.0281     103.6171       0.1346       2.8812       0.0000    2603.7158    1625.0000
  766.2672      96.0000      98.1229       0.0371     103.0401       0.1414       2.8709       0.0000    2588.7397    1608.0000
  766.4196      96.0000      98.2120       0.0533      98.1520       0.1479       2.8490       0.0000    2562.0103    1586.0000
  766.5720      96.0000      98.0777       0.0609      90.8272       0.1514       2.7681       0.0000    2549.5432    1604.0000
  766.7244      96.0000      97.7796       0.0686      86.2247       0.1543       2.6857       0.0000    2536.8499    1609.0000
  766.8768      96.0000      97.7222       0.0680      82.7126       0.1564       2.5764       0.0000    2537.7427    1601.0000
  767.0292      96.0000      97.6626       0.0713      80.8016       0.1564       2.5610       0.0000    2532.3120    1598.0000
  767.1816      96.0000      97.7340       0.0709      76.0520       0.1544       2.6635       0.0000    2532.9800    1605.0000
  767.3340      96.0000      97.5167       0.0763      76.6290       0.1515       2.7939       0.0000    2524.1360    1608.0000
  767.4864      96.0000      97.9376       0.0736      79.6940       0.1483       3.0136       0.0000    2528.5237    1594.0000
  767.6388      96.0000      98.2256       0.0672      88.6767       0.1422       2.9936       0.0000    2539.1030    1621.0000
  767.7912      96.0000      98.4090       0.0633      89.0613       0.1361       2.9597       0.0000    2545.6189    1593.0000
  767.9436      96.0000      98.5516       0.0555      89.0749       0.1304       2.8193       0.0000    2558.4231    1615.0000
  768.0960      96.0000      98.4090       0.0470      87.8770       0.1327       2.8993       0.0000    2572.4131    1623.0000
  768.2484      96.0000      98.3757       0.0446      93.0698       0.1345       3.0353       0.0000    2576.4841    1615.0000
  768.4008      96.0000      98.1853       0.0430     100.0423       0.1429       3.0906       0.0000    2579.0310    1617.0000
  768.5532      96.0000      98.5113       0.0419     107.5900       0.1488       3.1384       0.0000    2580.9197    1595.0000
  768.7056      96.0000      98.3637       0.0435     102.2049       0.1533       3.0001       0.0000    2578.1819    1629.0000
  768.8580      96.0000      98.4504       0.0439      95.0264       0.1490       2.9432       0.0000    2577.5603    1593.0000
  769.0104      96.0000      98.5353       0.0507      87.1374       0.1420       2.9716       0.0000    2566.2717    1607.0000
  769.1628      96.0000      98.1585       0.0562      91.1474       0.1421       2.9116       0.0000    2557.2007    1601.0000
  769.3152      96.0000      98.3037       0.0607      89.9935       0.1460       2.9706       0.0000    2549.9065    1581.0000
  769.4676      96.0000      98.1801       0.0606      86.5300       0.1496       3.0170       0.0000    2550.0388    1580.0000
  769.6200      96.0000      98.1110       0.0617      87.5204       0.1547       3.1540       0.0000    2548.1472    1622.0000
  769.7724      96.0000      98.4867       0.0452     102.9063       0.1496       3.1969       0.0000    2575.4604    1601.0000
  769.9248      96.0000      98.7070       0.0182     131.7685       0.1439       3.4140       0.0000    2619.9761    1595.0000
  770.0772      96.0000      98.6047      -0.0055     145.2614       0.1339       3.3629       0.0000    2659.1365    1615.0000
  770.2296      96.0000      97.7543       0.0025     136.7991       0.1276       3.2735       0.0000    2645.8369    1633.0000
  770.3820      96.0000      97.9749       0.0187     110.2459       0.1248       2.9842       0.0000    2619.0640    1616.0000
  770.5344      96.0000      98.4660       0.0378      97.0299       0.1248       2.9628       0.0000    2587.6616    1609.0000
  770.6868      96.0000      98.1206       0.0494      95.2990       0.1325       2.9000       0.0000    2568.4255    1630.0000
  770.8392      96.0000      97.9749       0.0537      94.1311       0.1363       2.9021       0.0000    2561.4299    1626.0000
  770.9916      96.0000      98.3398       0.0511      91.9720       0.1420       2.9701       0.0000    2565.6772    1631.0000
  771.1440      96.0000      98.3495       0.0559      90.8181       0.1471       3.0397       0.0000    2557.8213    1605.0000
  771.2964      96.0000      98.2731       0.0559      93.8953       0.1551       2.9901       0.0000    2557.8455    1625.0000
  771.4488      96.0000      98.0776       0.0536      97.1395       0.1535       3.0489       0.0000    2561.5000    1630.0000
  771.6012      96.0000      98.2827       0.0473      92.7432       0.1523       3.0465       0.0000    2571.9719    1596.0000
  771.7536      96.0000      98.2121       0.0438      89.1234       0.1478       2.9986       0.0000    2577.7239    1603.0000
  771.9060      96.0000      98.1347       0.0396      84.5985       0.1457       2.9196       0.0000    2584.6982    1626.0000
  772.0584      96.0000      98.1759       0.0382      87.8409       0.1423       3.0354       0.0000    2586.9546    1607.0000
  772.2108      96.0000      98.1466       0.0362      92.4222       0.1440       3.2483       0.0000    2590.3394    1594.0000
  772.3632      96.0000      97.9058       0.0420      95.7927       0.1448       3.3318       0.0000    2580.6177    1609.0000
  772.5156      96.0000      98.2122       0.0491      96.5332       0.1436       3.2749       0.0000    2568.9741    1616.0000
  772.6680      96.0000      98.1349       0.0511      93.2637       0.1354       3.0108       0.0000    2565.7305    1607.0000
  772.8204      96.0000      98.0993       0.0486      92.2468       0.1235       2.9066       0.0000    2569.7576    1617.0000
  772.9728      96.0000      98.1757       0.0395      90.3661       0.1152       2.8122       0.0000    2584.8831    1601.0000
  773.1252      96.0000      98.7281       0.0262      92.0970       0.1121       2.9927       0.0000    2606.8516    1617.0000
  773.2776      96.0000      98.7761       0.0161      92.7140       0.1121       3.1423       0.0000    2623.4832    1629.0000
  773.4300      96.0000      98.4781       0.0118      91.1747       0.1122       3.3053       0.0000    2630.4692    1615.0000
  773.5824      96.0000      98.2846       0.0124      90.7901       0.1107       3.4154       0.0000    2629.5540    1602.0000
  773.7348      96.0000      98.2373       0.0141      87.6385       0.1074       3.4032       0.0000    2626.7134    1624.0000
  773.8872      96.0000      98.3636       0.0207      85.3295       0.1043       3.3117       0.0000    2615.7786    1595.0000
  774.0396      96.0000      98.2580       0.0245      82.4446       0.0996       3.1935       0.0000    2609.6045    1604.0000
  774.1920      96.0000      98.1467       0.0217      80.0911       0.0974       3.0890       0.0000    2614.1375    1624.0000
  774.3444      96.0000      98.2136       0.0204      81.0407       0.0954       3.0010       0.0000    2616.3838    1614.0000
  774.4968      96.0000      98.4504       0.0179      84.3249       0.0980       2.8808       0.0000    2620.5183    1631.0000
  774.6492      96.0000      98.6498       0.0175      92.9072       0.1057       2.9772       0.0000    2621.1853    1633.0000
  774.8016      96.0000      98.4143       0.0170     106.9196       0.1198       3.0406       0.0000    2621.9097    1603.0000
  774.9540      96.0000      98.3518       0.0183     115.3858       0.1373       3.2678       0.0000    2619.8259    1650.0000
  775.1064      96.0000      98.4090       0.0223     120.3863       0.1570       3.3036       0.0000    2613.2478    1632.0000
  775.2588      96.0000      98.8094       0.0267     115.4982       0.1637       3.4417       0.0000    2605.8936    1608.0000
  775.4112      96.0000      98.5517       0.0295     109.3409       0.1663       3.4061       0.0000    2601.3428    1629.0000
  775.5636      96.0000      98.6618       0.0267     109.1486       0.1630       3.3002       0.0000    2606.0081    1612.0000
  775.7160      96.0000      98.3971       0.0244     112.5253       0.1652       3.2560       0.0000    2609.8057    1612.0000
  775.8684      96.0000      98.4867       0.0230     118.1673       0.1640       3.3429       0.0000    2612.0210    1638.0000
  776.0208      96.0000      98.7761       0.0200     120.6675       0.1637       3.5432       0.0000    2616.9844    1617.0000
  776.1732      96.0000      98.7402       0.0181     117.5904       0.1610       3.6372       0.0000    2620.2036    1633.0000
  776.3256      96.0000      98.5973       0.0139     116.9511       0.1596       3.4565       0.0000    2627.0046    1651.0000
  776.4780      96.0000      98.6138       0.0132     109.9315       0.1496       3.2772       0.0000    2628.2664    1603.0000
  776.6304      96.0000      98.4663       0.0154     104.7484       0.1370       3.2048       0.0000    2624.6367    1632.0000
  776.7828      96.0000      98.3590       0.0242      94.6764       0.1309       3.1152       0.0000    2610.0398    1628.0000
  776.9352      96.0000      98.5475       0.0227      87.0924       0.1261       3.0051       0.0000    2612.6255    1619.0000
  777.0876      96.0000      98.4660       0.0226      91.3140       0.1272       2.9906       0.0000    2612.7432    1633.0000
  777.2400      96.0000      98.3589       0.0249      89.8782       0.1288       2.9799       0.0000    2608.8896    1611.0000
  777.3924      96.0000      98.5474       0.0356      89.8782       0.1391       3.0740       0.0000    2591.2568    1616.0000
  777.5448      96.0000      98.5806       0.0444      80.7640       0.1446       2.9892       0.0000    2576.7009    1650.0000
  777.6972      96.0000      98.5324       0.0479      91.0998       0.1455       3.0752       0.0000    2570.9973    1597.0000
  777.8496      96.0000      98.4091       0.0437      99.9509       0.1470       3.0756       0.0000    2577.8757    1612.0000
  778.0020      96.0000      98.3183       0.0421     107.5265       0.1484       3.0146       0.0000    2580.4954    1616.0000
  778.1544      96.0000      98.2579       0.0411      92.7175       0.1393       2.8691       0.0000    2582.1538    1604.0000
  778.3068      96.0000      97.9395       0.0462      82.7722       0.1259       2.7624       0.0000    2573.6885    1612.0000
  778.4592      96.0000      98.0540       0.0462      75.8485       0.1209       2.7247       0.0000    2573.8474    1619.0000
  778.6116      96.0000      98.0748       0.0521      80.6566       0.1227       2.7611       0.0000    2563.9724    1625.0000
  778.7640      96.0000      98.6951       0.0499      83.0977       0.1260       2.8619       0.0000    2567.6104    1642.0000
  778.9164      96.0000      98.5353       0.0514      90.2137       0.1286       2.8912       0.0000    2565.2188    1607.0000
  779.0688      96.0000      98.1301       0.0527      97.6636       0.1384       2.9036       0.0000    2562.9912    1616.0000
  779.2212      96.0000      98.5925       0.0583      99.3953       0.1499       2.9298       0.0000    2553.8511    1635.0000
  779.3736      96.0000      98.7641       0.0562      97.2797       0.1547       2.9928       0.0000    2557.2363    1617.0000
  779.5260      96.0000      98.6889       0.0581      94.2020       0.1562       3.1187       0.0000    2554.1926    1614.0000
  779.6784      96.0000      98.6950       0.0603      93.9952       0.1558       3.1057       0.0000    2550.4844    1635.0000
  779.8308      96.0000      98.5234       0.0590      90.1617       0.1587       3.1652       0.0000    2552.6333    1646.0000
  779.9832      96.0000      98.2216       0.0566      83.6442       0.1614       3.1969       0.0000    2556.6240    1610.0000
  780.1356      96.0000      98.3876       0.0558      84.7982       0.1620       3.2757       0.0000    2557.9753    1646.0000
  780.2880      96.0000      98.2373       0.0575      88.8389       0.1604       3.3348       0.0000    2555.1731    1650.0000
  780.4404      96.0000      98.3399       0.0510      97.1386       0.1537       3.3624       0.0000    2565.8208    1615.0000
  780.5928      96.0000      98.4661       0.0453      96.9463       0.1470       3.3170       0.0000    2575.3218    1652.0000
  780.7452      96.0000      98.5235       0.0385      97.9663       0.1380       3.1269       0.0000    2586.4424    1654.0000
  780.8976      96.0000      98.5235       0.0337      95.8655       0.1315       2.9242       0.0000    2594.3979    1631.0000
  781.0500      96.0000      98.4962       0.0285      89.7111       0.1270       2.8870       0.0000    2602.9055    1628.0000
  781.2024      96.0000      98.4662       0.0254      86.3821       0.1264       3.1364       0.0000    2608.1118    1624.0000
  781.3548      96.0000      98.7707       0.0208      87.0628       0.1286       3.4174       0.0000    2615.6699    1629.0000
  781.5072      96.0000      98.7642       0.0157      93.2172       0.1323       3.6077       0.0000    2624.1375    1629.0000
  781.6596      96.0000      98.5447       0.0138      93.0247       0.1391       3.5544       0.0000    2627.1829    1635.0000
  781.8120      96.0000      98.5134       0.0169      92.1370       0.1420       3.5134       0.0000    2622.1555    1639.0000
  781.9644      96.0000      98.5353       0.0227      94.2582       0.1436       3.2794       0.0000    2612.5068    1638.0000
  782.1168      96.0000      98.4448       0.0326      94.6291       0.1449       3.1198       0.0000    2596.2715    1636.0000
  782.2692      96.0000      98.4314       0.0432      97.3375       0.1491       2.9845       0.0000    2578.7410    1618.0000
  782.4216      96.0000      98.7401       0.0448      93.8977       0.1519       2.9601       0.0000    2576.1069    1640.0000
  782.5740      96.0000      98.3400       0.0410      94.2824       0.1513       3.0304       0.0000    2582.2915    1651.0000
  782.7264      96.0000      98.2941       0.0434      89.2796       0.1463       3.0327       0.0000    2578.3328    1611.0000
  782.8788      96.0000      98.5233       0.0509      90.5982       0.1441       3.0434       0.0000    2565.9329    1616.0000
  783.0312      96.0000      98.8213       0.0593      92.1368       0.1407       2.9189       0.0000    2552.2073    1650.0000
  783.1836      96.0000      98.9688       0.0573      95.3189       0.1401       2.8400       0.0000    2555.4097    1631.0000
  783.3360      96.0000      98.4142       0.0508      97.4504       0.1352       2.9685       0.0000    2566.2485    1649.0000
  783.4884      96.0000      98.3519       0.0402      97.4504       0.1333       3.0349       0.0000    2583.6121    1659.0000
  783.6408      96.0000      98.2216       0.0331      96.3848       0.1298       3.1398       0.0000    2595.3828    1609.0000
  783.7932      96.0000      97.6651       0.0293      94.4457       0.1267       3.0024       0.0000    2601.6379    1632.0000
  783.9456      96.0000      97.6651       0.0243      96.0350       0.1257       2.9429       0.0000    2609.9043    1630.0000
  784.0980      96.0000      98.2578       0.0248     101.4056       0.1273       2.9507       0.0000    2609.1289    1621.0000
  784.2504      96.0000      98.2375       0.0202     103.6965       0.1316       3.0929       0.0000    2616.6492    1638.0000
  784.4028      96.0000      98.1685       0.0237     102.1220       0.1360       3.2211       0.0000    2610.8347    1635.0000
  784.5552      96.0000      97.9011       0.0260      95.2824       0.1325       3.2092       0.0000    2607.0361    1644.0000
  784.7076      96.0000      97.9059       0.0338      89.9143       0.1292       3.0738       0.0000    2594.2803    1638.0000
  784.8600      96.0000      98.0992       0.0317      85.2963       0.1250       2.9237       0.0000    2597.7329    1623.0000
  785.0124      96.0000      98.4782       0.0317      81.5581       0.1283       2.8930       0.0000    2597.6897    1633.0000
  785.1648      96.0000      98.3131       0.0308      87.1355       0.1340       2.9273       0.0000    2599.1697    1601.0000
  785.3172      96.0000      98.1802       0.0354      91.7125       0.1406       3.0305       0.0000    2591.6362    1635.0000
  785.4696      96.0000      98.4781       0.0381     101.7134       0.1437       3.0827       0.0000    2587.2026    1644.0000
  785.6220      96.0000      98.4601       0.0417     101.9057       0.1432       3.0848       0.0000    2581.1331    1603.0000
  785.7744      96.0000      98.4663       0.0405     105.9873       0.1359       3.1373       0.0000    2583.0972    1654.0000
  785.9268      96.0000      98.1758       0.0388     101.9485       0.1297       3.1422       0.0000    2585.9651    1645.0000
  786.0792      96.0000      98.2374       0.0337      98.1165       0.1187       3.0991       0.0000    2594.4106    1608.0000
  786.2316      96.0000      98.5806       0.0301      91.6674       0.1138       3.0754       0.0000    2600.2913    1640.0000
  786.3840      96.0000      98.5952       0.0283      89.1672       0.1099       2.9431       0.0000    2603.3691    1640.0000
  786.5364      96.0000      98.5806       0.0357      83.1835       0.1129       2.8790       0.0000    2591.1704    1631.0000
  786.6888      96.0000      98.2945       0.0412      81.7436       0.1160       2.8289       0.0000    2581.9382    1637.0000
  786.8412      96.0000      98.3496       0.0494      79.6280       0.1217       2.8201       0.0000    2568.4080    1629.0000
  786.9936      96.0000      98.4542       0.0518      79.8090       0.1267       2.8964       0.0000    2564.5298    1640.0000
  787.1460      96.0000      98.4662       0.0493      85.7581       0.1256       2.9381       0.0000    2568.6587    1631.0000
  787.2984      96.0000      98.5058       0.0494      92.3129       0.1244       2.9798       0.0000    2568.4834    1638.0000
  787.4508      96.0000      98.6378       0.0403      99.6397       0.1177       3.0051       0.0000    2583.5820    1629.0000
  787.6032      96.0000      98.6376       0.0331      97.6652       0.1118       3.0159       0.0000    2595.4634    1628.0000
  787.7556      96.0000      98.4089       0.0240      97.8576       0.1037       2.9880       0.0000    2610.4226    1654.0000
  787.9080      96.0000      98.0384       0.0227      99.7808       0.1007       2.9217       0.0000    2612.6179    1619.0000
  788.0604      96.0000      98.1231       0.0239      98.1012       0.0992       2.8442       0.0000    2610.5732    1637.0000
  788.2128      96.0000      98.0748       0.0277      91.5591       0.1005       2.8556       0.0000    2604.3359    1619.0000
  788.3652      96.0000      98.0204       0.0281      87.9050       0.1018       2.9112       0.0000    2603.5972    1644.0000
  788.5176      96.0000      97.8487       0.0278      80.7136       0.1035       2.9989       0.0000    2604.1143    1644.0000
  788.6700      96.0000      97.6356       0.0268      78.4046       0.1008       3.1208       0.0000    2605.7549    1618.0000
  788.8224      96.0000      97.9968       0.0201      76.9726       0.0966       3.0126       0.0000    2616.8208    1631.0000
  788.9748      96.0000      98.1920       0.0171      84.9333       0.0947       2.9011       0.0000    2621.7495    1635.0000
  789.1272      96.0000      98.4047       0.0191      90.8775       0.0950       2.7851       0.0000    2618.5393    1639.0000
  789.2796      96.0000      98.3970       0.0261      91.1693       0.0968       2.9919       0.0000    2606.9990    1642.0000
  789.4320      96.0000      98.5473       0.0271      89.2460       0.1006       3.0651       0.0000    2605.3247    1629.0000
  789.5844      96.0000      98.2483       0.0288      90.0215       0.1064       3.1087       0.0000    2602.5579    1644.0000
  789.7368      96.0000      97.8941       0.0251      86.5581       0.1121       2.9898       0.0000    2608.5356    1649.0000
  789.8892      96.0000      98.2946       0.0257      88.6674       0.1162       2.9915       0.0000    2607.5452    1633.0000
  790.0416      96.0000      98.3036       0.0278      90.9753       0.1210       3.0901       0.0000    2604.0730    1630.0000
  790.1940      96.0000      98.0440       0.0249     100.9809       0.1240       3.0866       0.0000    2608.8337    1625.0000
  790.3464      96.0000      98.0086       0.0264     102.3334       0.1322       3.1194       0.0000    2606.5142    1642.0000
  790.4988      96.0000      97.8823       0.0285     104.8336       0.1367       3.0680       0.0000    2603.0347    1626.0000
  790.6512      96.0000      97.9630       0.0300     103.9740       0.1414       3.1204       0.0000    2600.4282    1626.0000
  790.8036      96.0000      97.9394       0.0273     104.3740       0.1347       3.0666       0.0000    2604.9099    1643.0000
  790.9560      96.0000      97.9927       0.0285      98.9714       0.1258       3.1347       0.0000    2602.9434    1616.0000
  791.1084      96.0000      98.1230       0.0308      95.3907       0.1186       3.0001       0.0000    2599.1753    1637.0000
  791.2608      96.0000      98.0894       0.0361      90.0031       0.1140       3.0093       0.0000    2590.4111    1645.0000
  791.4132      96.0000      98.2216       0.0349      89.8220       0.1067       2.8841       0.0000    2592.4924    1623.0000
  791.5656      96.0000      98.7069       0.0324      91.1683       0.0983       2.9160       0.0000    2596.5764    1646.0000
  791.7180      96.0000      98.3518       0.0237      99.0573       0.0952       2.9933       0.0000    2610.8987    1646.0000
  791.8704      96.0000      98.1300       0.0168     103.4869       0.0994       3.0764       0.0000    2622.3215    1612.0000
  792.0228      96.0000      98.1230       0.0134     100.2174       0.1059       2.9920       0.0000    2627.8992    1643.0000
  792.1752      96.0000      98.1922       0.0194      94.5153       0.1142       2.9333       0.0000    2618.0098    1643.0000
  792.3276      96.0000      98.1683       0.0247      88.5670       0.1205       2.8993       0.0000    2609.2168    1640.0000
  792.4800      96.0000      98.0385       0.0353      89.5286       0.1239       3.0569       0.0000    2591.7478    1647.0000
  792.6324      96.0000      98.1802       0.0399      88.6887       0.1316       2.9735       0.0000    2584.0969    1637.0000
  792.7848      96.0000      98.0575       0.0418      89.6365       0.1352       2.9096       0.0000    2581.0481    1644.0000
  792.9372      96.0000      97.9395       0.0359      92.1367       0.1371       3.0009       0.0000    2590.7515    1591.0000
  793.0896      96.0000      97.9513       0.0327      96.7785       0.1331       3.0759       0.0000    2596.0208    1668.0000
  793.2420      96.0000      98.1663       0.0356     105.4514       0.1385       3.2938       0.0000    2591.3267    1637.0000
  793.3944      96.0000      98.3065       0.0418     104.4159       0.1493       3.1016       0.0000    2580.9775    1589.0000
  793.5468      96.0000      98.4543       0.0479     104.9534       0.1567       3.1977       0.0000    2570.9290    1650.0000
  793.6992      96.0000      98.3037       0.0528      98.9886       0.1557       3.1044       0.0000    2562.9395    1625.0000
  793.8516      96.0000      98.2827       0.0494     106.2302       0.1486       3.0466       0.0000    2568.5435    1615.0000
  794.0040      96.0000      98.1468       0.0392     102.5761       0.1402       2.9451       0.0000    2585.3408    1651.0000
  794.1564      96.0000      98.0842       0.0333      99.6757       0.1327       2.9618       0.0000    2595.0056    1635.0000
  794.3088      96.0000      98.4091       0.0273      90.7913       0.1228       3.1169       0.0000    2605.0139    1643.0000
  794.4612      96.0000      98.0776       0.0239      83.6753       0.1110       3.1955       0.0000    2610.5066    1650.0000
  794.6136      96.0000      98.0844       0.0200      85.0363       0.1025       3.2041       0.0000    2616.9946    1646.0000
  794.7660      96.0000      98.4901       0.0136      80.8858       0.0989       3.2552       0.0000    2627.5186    1639.0000
  794.9184      96.0000      98.2256       0.0080      85.8862       0.0963       3.4262       0.0000    2636.7554    1632.0000
  795.0708      96.0000      98.4048      -0.0003      79.9214       0.0934       3.4554       0.0000    2650.4883    1630.0000
  795.2232      96.0000      98.3065       0.0011      83.4807       0.0895       3.4504       0.0000    2648.2034    1647.0000
  795.3756      96.0000      97.8486       0.0023      79.8265       0.0870       3.2405       0.0000    2646.1672    1651.0000
  795.5280      96.0000      98.0385       0.0051      81.2105       0.0848       3.3309       0.0000    2641.5601    1629.0000
  795.6804      96.0000      98.1348       0.0094      81.0321       0.0863       3.3551       0.0000    2634.4680    1659.0000
  795.8328      96.0000      98.0656       0.0041      85.2114       0.0887       3.4533       0.0000    2643.2996    1629.0000
  795.9852      96.0000      97.8822       0.0041      87.2772       0.0923       3.2736       0.0000    2643.2544    1643.0000
  796.1376      96.0000      98.0203       0.0038      86.3152       0.0968       3.2121       0.0000    2643.8074    1644.0000
  796.2900      96.0000      98.1230       0.0089      85.7720       0.1030       3.0589       0.0000    2635.3452    1624.0000
  796.4424      96.0000      98.3132       0.0099      85.0027       0.1053       3.2720       0.0000    2633.6694    1639.0000
  796.5948      96.0000      98.1111       0.0108      87.1049       0.1063       3.2316       0.0000    2632.1096    1629.0000
  796.7472      96.0000      97.9630       0.0110      83.6726       0.1037       3.2802       0.0000    2631.8286    1647.0000
  796.8996      96.0000      97.9280       0.0163      80.4031       0.1022       3.1582       0.0000    2623.1492    1649.0000
  797.0520      96.0000      98.2826       0.0205      77.8736       0.0990       3.1874       0.0000    2616.2205    1633.0000
  797.2044      96.0000      98.0321       0.0228      79.2205       0.0991       3.1857       0.0000    2612.4382    1638.0000
  797.3568      96.0000      98.4315       0.0176      78.2589       0.1016       3.1298       0.0000    2621.0215    1646.0000
  797.5092      96.0000      98.2827       0.0158      82.3421       0.1032       3.2638       0.0000    2623.8699    1621.0000
  797.6616      96.0000      98.0204       0.0126      84.0608       0.1059       3.2457       0.0000    2629.1309    1645.0000
  797.8140      96.0000      98.0844       0.0178      84.2798       0.1083       3.1418       0.0000    2620.5625    1621.0000
  797.9664      96.0000      97.9967       0.0277      85.6109       0.1100       2.9805       0.0000    2604.3730    1628.0000
  798.1188      96.0000      98.2374       0.0280      93.5813       0.1086       3.0933       0.0000    2603.8474    1654.0000
  798.2712      96.0000      98.1760       0.0186     105.1109       0.1085       3.2558       0.0000    2619.2783    1632.0000
  798.4236      96.0000      98.0204       0.0145     101.8414       0.1061       3.2343       0.0000    2625.9961    1633.0000
  798.5760      96.0000      98.4208       0.0174      93.6916       0.1053       3.1243       0.0000    2621.3284    1651.0000
  798.7284      96.0000      98.3035       0.0209      89.5847       0.1056       2.9691       0.0000    2615.4409    1622.0000
  798.8808      96.0000      98.1921       0.0256      86.6998       0.1073       2.9772       0.0000    2607.8196    1625.0000
  799.0332      96.0000      98.2371       0.0331      87.6485       0.1110       3.0198       0.0000    2595.3206    1677.0000
  799.1856      96.0000      98.1757       0.0375      82.3271       0.1138       3.0233       0.0000    2588.1191    1616.0000
  799.3380      96.0000      98.6830       0.0399      83.4292       0.1191       3.0218       0.0000    2584.1736    1628.0000
  799.4904      96.0000      98.5115       0.0406      86.1218       0.1258       3.0703       0.0000    2583.0364    1659.0000
  799.6428      96.0000      98.1396       0.0377      91.5094       0.1274       3.3097       0.0000    2587.7520    1622.0000
  799.7952      96.0000      97.9967       0.0389     100.6005       0.1320       3.4513       0.0000    2585.8125    1624.0000
  799.9476      96.0000      98.4867       0.0391     104.6558       0.1346       3.3878       0.0000    2585.5354    1632.0000
  800.1000      96.0000      98.5353       0.0384     100.7877       0.1359       3.3215       0.0000    2586.6885    1628.0000
  800.2524      96.0000      98.3517       0.0364      91.5561       0.1305       3.2716       0.0000    2590.0093    1639.0000
  800.4048      96.0000      98.1758       0.0327      81.5388       0.1204       3.3305       0.0000    2595.9873    1654.0000
  800.5572      96.0000      98.0202       0.0261      82.9871       0.1155       3.3549       0.0000    2606.8701    1642.0000
  800.7096      96.0000      98.0658       0.0232      87.2336       0.1163       3.1367       0.0000    2611.6382    1639.0000
  800.8620      96.0000      98.1664       0.0243      96.6574       0.1216       3.0077       0.0000    2609.9463    1654.0000
  801.0144      96.0000      98.3066       0.0232      97.9227       0.1290       2.9095       0.0000    2611.7239    1640.0000
  801.1668      96.0000      98.2946       0.0220      99.4290       0.1379       3.0888       0.0000    2613.6335    1633.0000
  801.3192      96.0000      98.4545       0.0254      95.7748       0.1461       3.1073       0.0000    2608.0527    1660.0000
  801.4716      96.0000      98.2026       0.0337      98.2607       0.1500       3.1430       0.0000    2594.4648    1649.0000
  801.6240      96.0000      98.1349       0.0486      93.8682       0.1562       3.0677       0.0000    2569.7424    1642.0000
  801.7764      96.0000      98.1802       0.0551      91.8706       0.1558       3.0717       0.0000    2559.0037    1647.0000
  801.9288      96.0000      98.2579       0.0558      92.4475       0.1543       3.0255       0.0000    2557.9316    1639.0000
  802.0812      96.0000      98.2374       0.0491      92.6400       0.1443       3.0802       0.0000    2569.0664    1624.0000
  802.2336      96.0000      98.2673       0.0421      94.2530       0.1367       3.0450       0.0000    2580.5303    1666.0000
  802.3860      96.0000      98.2947       0.0335      88.2955       0.1277       2.8940       0.0000    2594.7427    1633.0000
  802.5384      96.0000      98.5926       0.0259      87.5258       0.1187       2.8185       0.0000    2607.2554    1630.0000
  802.6908      96.0000      98.4867       0.0239      88.9905       0.1123       2.9284       0.0000    2610.6265    1645.0000
  802.8432      96.0000      98.0773       0.0302      92.2555       0.1134       3.1241       0.0000    2600.1968    1640.0000
  802.9956      96.0000      97.7223       0.0301      89.3569       0.1155       3.1421       0.0000    2600.3657    1629.0000
  803.1480      96.0000      98.5879       0.0320      86.8353       0.1173       3.0510       0.0000    2597.2695    1651.0000
  803.3004      96.0000      99.0379       0.0372      84.5274       0.1147       3.0139       0.0000    2588.5376    1608.0000
  803.4528      96.0000      99.0380       0.0363      87.7969       0.1141       3.0558       0.0000    2590.0510    1633.0000
  803.6052      96.0000      98.6950       0.0336      85.7895       0.1174       3.1243       0.0000    2594.5186    1658.0000
  803.7576      96.0000      98.2769       0.0339      86.6429       0.1186       3.0489       0.0000    2594.1047    1624.0000
  803.9100      96.0000      97.8487       0.0364      83.7580       0.1184       3.0367       0.0000    2589.8652    1644.0000
  804.0624      96.0000      98.1206       0.0352      87.2069       0.1164       2.9532       0.0000    2591.8579    1647.0000
  804.2148      96.0000      97.9967       0.0329      87.3291       0.1157       3.0737       0.0000    2595.6965    1637.0000
  804.3672      96.0000      98.0657       0.0292      91.3679       0.1158       3.0361       0.0000    2601.7590    1652.0000
  804.5196      96.0000      97.9831       0.0263      92.7293       0.1119       3.1832       0.0000    2606.6213    1633.0000
  804.6720      96.0000      98.3637       0.0229      91.3399       0.1115       3.1923       0.0000    2612.1396    1637.0000
  804.8244      96.0000      98.1800       0.0185      95.5710       0.1123       3.3537       0.0000    2619.4033    1651.0000
  804.9768      96.0000      98.1758       0.0212      93.2982       0.1148       3.3592       0.0000    2615.0813    1667.0000
  805.1292      96.0000      98.1801       0.0208      95.2507       0.1167       3.2743       0.0000    2615.6970    1637.0000
  805.2816      96.0000      98.3518       0.0170      91.6113       0.1201       3.3487       0.0000    2621.9663    1659.0000
  805.4340      96.0000      98.3494       0.0177      92.3303       0.1202       3.1786       0.0000    2620.8569    1636.0000
  805.5864      96.0000      98.3971       0.0213      91.9597       0.1220       3.2248       0.0000    2614.8730    1643.0000
  805.7388      96.0000      98.8094       0.0302      89.0195       0.1149       3.1133       0.0000    2600.1558    1633.0000
  805.8912      96.0000      98.8067       0.0270      91.3274       0.1129       3.2246       0.0000    2605.5103    1626.0000
  806.0436      96.0000      98.6378       0.0276      87.8640       0.1077       3.2022       0.0000    2604.4736    1645.0000
  806.1960      96.0000      98.4091       0.0325      92.3280       0.1133       3.0979       0.0000    2596.3064    1630.0000
  806.3484      96.0000      98.0654       0.0383      87.1352       0.1194       2.9806       0.0000    2586.7568    1646.0000
  806.5008      96.0000      97.5623       0.0330      89.1979       0.1222       3.0178       0.0000    2595.6199    1636.0000
  806.6532      96.0000      97.8822       0.0278      90.3678       0.1211       3.0095       0.0000    2604.0637    1617.0000
  806.8056      96.0000      97.8459       0.0291      93.2527       0.1170       3.2048       0.0000    2601.9431    1653.0000
  806.9580      96.0000      97.9512       0.0268      90.9976       0.1143       3.2082       0.0000    2605.7334    1636.0000
  807.1104      96.0000      97.7560       0.0255      83.0101       0.1100       3.3049       0.0000    2607.9597    1623.0000
  807.2628      96.0000      98.0385       0.0189      80.4807       0.1077       3.2948       0.0000    2618.7500    1653.0000
  807.4152      96.0000      97.7105       0.0214      84.3149       0.1094       3.3771       0.0000    2614.6379    1610.0000
  807.5676      96.0000      97.7798       0.0171      93.2644       0.1148       3.1730       0.0000    2621.7512    1666.0000
  807.7200      96.0000      98.3494       0.0079      93.1013       0.1174       2.8952       0.0000    2636.9604    1626.0000
  807.8724      96.0000      98.4995       0.0052      94.7809       0.1169       2.8221       0.0000    2641.4104    1636.0000
  808.0248      96.0000      98.3756       0.0087      87.6485       0.1134       3.0499       0.0000    2635.5972    1637.0000
  808.1772      96.0000      98.1854       0.0178      84.0058       0.1129       3.2209       0.0000    2620.6379    1640.0000
  808.3296      96.0000      98.1114       0.0177      80.7876       0.1119       3.1948       0.0000    2620.8191    1628.0000
  808.4820      96.0000      98.4090       0.0165      81.6861       0.1111       3.1876       0.0000    2622.8079    1630.0000
  808.6344      96.0000      98.4409       0.0115      92.6537       0.1096       3.4269       0.0000    2631.0952    1653.0000
  808.7868      96.0000      98.3638       0.0051      92.0768       0.1101       3.5081       0.0000    2641.5906    1628.0000
  808.9392      96.0000      98.1685       0.0000      92.3322       0.1120       3.4294       0.0000    2649.9561    1640.0000
  809.0916      96.0000      98.0748      -0.0004      88.6763       0.1127       3.2512       0.0000    2650.6733    1650.0000
  809.2440      96.0000      97.9849       0.0086      90.2990       0.1140       3.2845       0.0000    2635.8062    1626.0000
  809.3964      96.0000      97.5623       0.0109      90.1067       0.1199       3.2970       0.0000    2631.9873    1629.0000
  809.5488      96.0000      97.6263       0.0233      89.3163       0.1308       3.1270       0.0000    2611.5020    1646.0000
  809.7012      96.0000      97.7223       0.0324      91.5550       0.1400       3.0117       0.0000    2596.5742    1637.0000
  809.8536      96.0000      97.4816       0.0457      88.6702       0.1408       3.0360       0.0000    2574.6611    1621.0000
  810.0060      96.0000      98.3761       0.0393      89.4605       0.1344       3.1992       0.0000    2585.1575    1645.0000
  810.1584      96.0000      98.5114       0.0358      93.0151       0.1233       3.2411       0.0000    2590.8823    1643.0000
  810.3108      96.0000      98.4088       0.0231      97.4386       0.1132       3.2648       0.0000    2611.9126    1639.0000
  810.4632      96.0000      98.5783       0.0188      98.0007       0.1083       3.3333       0.0000    2618.9238    1649.0000
  810.6156      96.0000      98.2493       0.0217      91.1750       0.1124       3.4123       0.0000    2614.2166    1638.0000
  810.7680      96.0000      98.2827       0.0245      87.4008       0.1234       3.4464       0.0000    2609.5532    1645.0000
  810.9204      96.0000      97.9011       0.0208      88.1701       0.1366       3.6441       0.0000    2615.6082    1651.0000
  811.0728      96.0000      98.0895       0.0142     100.0998       0.1583       3.6182       0.0000    2626.4878    1645.0000
  811.2252      96.0000      98.2611       0.0162     114.6442       0.1731       3.6743       0.0000    2623.2100    1636.0000
  811.3776      96.0000      98.1206       0.0169     124.6450       0.1797       3.6455       0.0000    2622.0837    1646.0000
  811.5300      96.0000      98.0657       0.0263     122.0923       0.1729       3.6788       0.0000    2606.6843    1658.0000
  811.6824      96.0000      98.3637       0.0266     114.0147       0.1575       3.5434       0.0000    2606.0825    1639.0000
  811.8348      96.0000      98.3037       0.0263     106.7063       0.1414       3.2800       0.0000    2606.5613    1649.0000
  811.9872      96.0000      98.1348       0.0235     100.3532       0.1261       3.2133       0.0000    2611.2681    1653.0000
  812.1396      96.0000      98.1467       0.0196      98.4446       0.1169       3.2003       0.0000    2617.6287    1629.0000
  812.2920      96.0000      98.2216       0.0240      92.0009       0.1078       3.1691       0.0000    2610.4285    1666.0000
  812.4444      96.0000      98.0658       0.0250      84.3480       0.1001       3.1166       0.0000    2608.8113    1614.0000
  812.5968      96.0000      98.0776       0.0251      79.1528       0.0938       3.0655       0.0000    2608.5513    1664.0000
  812.7492      96.0000      98.0655       0.0216      77.7112       0.0914       3.2018       0.0000    2614.4333    1644.0000
  812.9016      96.0000      98.0895       0.0186      80.4760       0.0888       3.3440       0.0000    2619.2742    1628.0000
  813.0540      96.0000      98.0084       0.0163      79.1175       0.0905       3.4544       0.0000    2623.0408    1633.0000
  813.2064      96.0000      97.9279       0.0171      72.2037       0.0931       3.3050       0.0000    2621.7424    1642.0000
  813.3588      96.0000      98.1920       0.0187      73.8623       0.0955       3.2494       0.0000    2619.1626    1631.0000
  813.5112      96.0000      98.1920       0.0206      81.3780       0.0986       3.1824       0.0000    2616.0083    1660.0000
  813.6636      96.0000      98.6143       0.0236      92.1384       0.1002       3.0672       0.0000    2611.1116    1663.0000
  813.8160      96.0000      98.4210       0.0281      90.1176       0.0988       2.8549       0.0000    2603.6328    1650.0000
  813.9684      96.0000      97.8940       0.0303      84.3329       0.0934       2.6614       0.0000    2600.0825    1625.0000
  814.1208      96.0000      97.7920       0.0298      81.7598       0.0901       2.7135       0.0000    2600.8867    1664.0000
  814.2732      96.0000      97.8248       0.0287      84.3575       0.0904       2.7874       0.0000    2602.5745    1645.0000
  814.4256      96.0000      98.1920       0.0278      85.5115       0.0926       2.9391       0.0000    2604.1108    1658.0000
  814.5780      96.0000      97.8917       0.0263      83.6739       0.0928       3.0386       0.0000    2606.5393    1658.0000
  814.7304      96.0000      98.3398       0.0205      79.0847       0.0952       2.9762       0.0000    2616.1423    1638.0000
  814.8828      96.0000      98.8785       0.0198      81.3926       0.0986       2.9339       0.0000    2617.3721    1671.0000
  815.0352      96.0000      97.9737       0.0177      81.0078       0.1088       2.8319       0.0000    2620.7952    1673.0000
  815.1876      96.0000      98.1684       0.0160      90.4050       0.1166       2.9137       0.0000    2623.6667    1654.0000
  815.3400      96.0000      98.0657       0.0205      92.9052       0.1282       3.0468       0.0000    2616.1479    1656.0000
  815.4924      96.0000      98.4143       0.0312     102.5260       0.1374       3.1198       0.0000    2598.4697    1671.0000
  815.6448      96.0000      98.3637       0.0379     103.6291       0.1445       3.2677       0.0000    2587.4568    1654.0000
  815.7972      96.0000      98.1467       0.0368     105.7447       0.1432       3.2270       0.0000    2589.2715    1675.0000
  815.9496      96.0000      98.5228       0.0285      97.2784       0.1362       3.3044       0.0000    2603.0012    1657.0000
  816.1020      96.0000      98.4541       0.0265      92.7135       0.1335       3.4852       0.0000    2606.2964    1636.0000
  816.2544      96.0000      98.1663       0.0158      87.4350       0.1343       3.7610       0.0000    2623.8804    1675.0000
  816.4068      96.0000      98.6829       0.0140      90.3212       0.1421       3.8555       0.0000    2626.9495    1653.0000
  816.5592      96.0000      98.4090       0.0149      93.7999       0.1488       3.7722       0.0000    2625.3965    1632.0000
  816.7116      96.0000      98.2673       0.0198      94.0779       0.1525       3.5956       0.0000    2617.2556    1664.0000
  816.8640      96.0000      98.0776       0.0208     101.9487       0.1484       3.5492       0.0000    2615.6768    1645.0000
  817.0164      96.0000      98.1230       0.0250     106.3732       0.1387       3.3273       0.0000    2608.6951    1647.0000
  817.1688      96.0000      98.2865       0.0252     107.9056       0.1303       3.2377       0.0000    2608.3955    1661.0000
  817.3212      96.0000      98.3281       0.0160      96.1738       0.1183       3.0395       0.0000    2623.5823    1651.0000
  817.4736      96.0000      98.3183       0.0052      85.5910       0.1113       3.0551       0.0000    2641.4246    1632.0000
  817.6260      96.0000      98.1804       0.0014      82.5200       0.1065       3.2690       0.0000    2647.6648    1656.0000
  817.7784      96.0000      98.2407      -0.0017      83.8257       0.1137       3.6505       0.0000    2652.8501    1621.0000
  817.9308      96.0000      98.1111      -0.0009      89.1979       0.1241       3.8108       0.0000    2651.5022    1644.0000
  818.0832      96.0000      98.1758       0.0069     100.1786       0.1330       3.7143       0.0000    2638.6326    1667.0000
  818.2356      96.0000      98.2946       0.0185     110.0277       0.1389       3.5337       0.0000    2619.5264    1653.0000
  818.3880      96.0000      98.1014       0.0255     114.0838       0.1406       3.3590       0.0000    2607.8801    1639.0000
  818.5404      96.0000      98.5686       0.0296     107.0793       0.1362       3.2252       0.0000    2601.1162    1631.0000
  818.6928      96.0000      98.5353       0.0284     102.6558       0.1274       3.0809       0.0000    2603.2195    1657.0000
  818.8452      96.0000      98.5236       0.0284      98.4227       0.1195       3.0027       0.0000    2603.1711    1660.0000
  818.9976      96.0000      98.3638       0.0338      96.4313       0.1184       2.8364       0.0000    2594.2239    1640.0000
  819.1500      96.0000      98.1760       0.0362      93.3541       0.1203       2.8617       0.0000    2590.2424    1645.0000
  819.3024      96.0000      97.9277       0.0428      88.3383       0.1254       2.8562       0.0000    2579.3491    1649.0000
  819.4548      96.0000      97.9564       0.0512      87.3287       0.1307       2.9484       0.0000    2565.4431    1638.0000
  819.6072      96.0000      98.0657       0.0546      86.2476       0.1317       2.9136       0.0000    2559.9729    1638.0000
  819.7596      96.0000      97.9059       0.0517      85.2859       0.1292       2.9314       0.0000    2564.6875    1635.0000
  819.9120      96.0000      97.9833       0.0493      82.9770       0.1293       2.8483       0.0000    2568.6472    1632.0000
  820.0644      96.0000      97.8940       0.0529      78.0961       0.1305       2.7233       0.0000    2562.6550    1635.0000
  820.2168      96.0000      98.0087       0.0615      76.3467       0.1290       2.6651       0.0000    2548.5769    1642.0000
  820.3692      96.0000      97.9011       0.0624      75.7573       0.1252       2.7007       0.0000    2547.0066    1637.0000
  820.5216      96.0000      98.1682       0.0565      80.0020       0.1219       2.7562       0.0000    2556.7708    1654.0000
  820.6740      96.0000      98.5233       0.0490      78.2896       0.1197       2.7808       0.0000    2569.1252    1639.0000
  820.8264      96.0000      98.3495       0.0460      77.5321       0.1161       2.7062       0.0000    2574.0413    1661.0000
  820.9788      96.0000      98.2492       0.0407      79.0734       0.1138       2.8535       0.0000    2582.7627    1651.0000
  821.1312      96.0000      97.7107       0.0366      88.3050       0.1092       2.9026       0.0000    2589.6030    1636.0000
  821.2836      96.0000      97.8824       0.0312      87.5354       0.1050       2.9581       0.0000    2598.5728    1666.0000
  821.4360      96.0000      97.8486       0.0269      81.9121       0.0996       2.8948       0.0000    2605.6057    1666.0000
  821.5884      96.0000      98.1801       0.0229      73.6535       0.1007       2.8564       0.0000    2612.1426    1657.0000
  821.7408      96.0000      98.4503       0.0162      80.9504       0.1032       3.0232       0.0000    2623.2751    1653.0000
  821.8932      96.0000      98.6496       0.0129      88.6882       0.1156       3.2112       0.0000    2628.6807    1644.0000
  822.0456      96.0000      98.0538       0.0150      94.8312       0.1287       3.3970       0.0000    2625.2002    1646.0000
  822.1980      96.0000      98.4238       0.0146      99.4869       0.1336       3.4793       0.0000    2625.9851    1667.0000
  822.3504      96.0000      98.1229       0.0181     103.7200       0.1325       3.4717       0.0000    2620.1140    1654.0000
  822.5028      96.0000      98.1229       0.0154     104.8740       0.1249       3.3114       0.0000    2624.6653    1645.0000
  822.6552      96.0000      97.4703       0.0212     100.9875       0.1222       3.2575       0.0000    2615.0142    1668.0000
  822.8076      96.0000      97.7223       0.0244      96.1772       0.1195       3.1242       0.0000    2609.7483    1639.0000
  822.9600      96.0000      97.9177       0.0303      99.2544       0.1195       3.0950       0.0000    2600.0659    1679.0000
  823.1124      96.0000      97.8556       0.0386      95.7181       0.1229       2.9434       0.0000    2586.3308    1678.0000
  823.2648      96.0000      98.1684       0.0412      93.6016       0.1230       2.8570       0.0000    2581.9436    1646.0000
  823.4172      96.0000      97.8940       0.0462      83.6007       0.1210       2.8452       0.0000    2573.8130    1668.0000
  823.5696      96.0000      98.3952       0.0462      85.0490       0.1141       2.8404       0.0000    2573.7622    1660.0000
  823.7220      96.0000      98.2375       0.0484      83.1249       0.1071       2.8762       0.0000    2570.0901    1639.0000
  823.8744      96.0000      98.1920       0.0426      86.7790       0.1005       2.8677       0.0000    2579.6523    1674.0000
  824.0268      96.0000      98.2579       0.0381      86.5591       0.1006       2.8854       0.0000    2587.1067    1652.0000
  824.1792      96.0000      98.7522       0.0311      83.8653       0.1054       2.8396       0.0000    2598.6506    1678.0000
  824.3316      96.0000      98.6951       0.0200      81.1727       0.1141       2.9684       0.0000    2617.0344    1639.0000
  824.4840      96.0000      98.6961       0.0047      88.4810       0.1256       3.1031       0.0000    2642.2693    1663.0000
  824.6364      96.0000      98.8785      -0.0081     103.1045       0.1384       3.5119       0.0000    2663.4426    1663.0000
  824.7888      96.0000      98.5926      -0.0179     114.0957       0.1495       3.9106       0.0000    2679.5244    1657.0000
  824.9412      96.0000      98.4506      -0.0217     104.8641       0.1445       4.5472       0.0000    2685.8645    1647.0000
  825.0936      96.0000      98.4329      -0.0313      87.7393       0.1279       4.8887       0.0000    2701.6936    1650.0000
  825.2460      96.0000      98.6696      -0.0347      70.9784       0.1067       4.9456       0.0000    2707.1929    1650.0000
  825.3984      96.0000      98.5567      -0.0435      63.2854       0.0964       4.8285       0.0000    2721.8337    1666.0000
  825.5508      96.0000      98.3517      -0.0392      58.3190       0.0902       4.6707       0.0000    2714.6780    1664.0000
  825.7032      96.0000      98.1347      -0.0235      65.2427       0.0925       4.5566       0.0000    2688.7883    1649.0000
  825.8556      96.0000      97.8823      -0.0026      77.7438       0.0965       3.9982       0.0000    2654.2974    1668.0000
  826.0080      96.0000      97.7796       0.0178      93.8702       0.1046       3.4797       0.0000    2620.6421    1679.0000
  826.1604      96.0000      97.9737       0.0283      99.6399       0.1087       3.2179       0.0000    2603.2307    1643.0000
  826.3128      96.0000      98.0776       0.0364      98.2936       0.1066       3.1119       0.0000    2589.9629    1666.0000
  826.4652      96.0000      98.1802       0.0359      93.4833       0.1000       3.1169       0.0000    2590.7507    1693.0000
  826.6176      96.0000      97.9967       0.0292      91.9447       0.0914       3.0582       0.0000    2601.8186    1622.0000
  826.7700      96.0000      98.0937       0.0196      95.3331       0.0894       3.1383       0.0000    2617.7092    1684.0000
  826.9224      96.0000      98.0775       0.0113      96.1028       0.0910       3.3361       0.0000    2631.3137    1666.0000
  827.0748      96.0000      98.0992       0.0068      94.8940       0.0951       3.6189       0.0000    2638.8315    1657.0000
  827.2272      96.0000      98.1761       0.0003      94.3904       0.1024       3.7142       0.0000    2649.5527    1693.0000
  827.3796      96.0000      98.0657      -0.0032      95.7226       0.1082       3.7615       0.0000    2655.3027    1645.0000
  827.5320      96.0000      97.9374      -0.0131      93.8673       0.1091       3.8576       0.0000    2671.6907    1657.0000
  827.6844      96.0000      97.9867      -0.0103      93.1036       0.1053       3.7809       0.0000    2667.0403    1702.0000
  827.8368      96.0000      98.0993      -0.0076      93.8729       0.1021       3.4338       0.0000    2662.4651    1637.0000
  827.9892      96.0000      98.1111       0.0024      97.5288       0.1013       3.0401       0.0000    2645.9802    1706.0000
  828.1416      96.0000      97.8031       0.0152      95.2153       0.1028       2.9236       0.0000    2624.8408    1660.0000
  828.2940      96.0000      98.0085       0.0264      95.5999       0.1105       2.9318       0.0000    2606.4089    1653.0000
  828.4464      96.0000      97.9011       0.0423      96.3696       0.1175       3.0046       0.0000    2580.2842    1675.0000
  828.5988      96.0000      98.0203       0.0523      97.9082       0.1230       2.9335       0.0000    2563.7168    1631.0000
  828.7512      96.0000      98.2946       0.0627      97.9234       0.1254       2.9864       0.0000    2546.5676    1657.0000
  828.9036      96.0000      98.0658       0.0585      96.5620       0.1250       2.8289       0.0000    2553.4612    1663.0000
  829.0560      96.0000      98.0748       0.0428      91.7539       0.1184       2.8314       0.0000    2579.4224    1640.0000
  829.2084      96.0000      98.1229       0.0223      87.7132       0.1059       2.7962       0.0000    2613.1965    1658.0000
  829.3608      96.0000      98.1348       0.0152      88.6748       0.1008       2.9593       0.0000    2624.8550    1674.0000
  829.5132      96.0000      98.0290       0.0199      89.2653       0.1061       3.0284       0.0000    2617.1455    1652.0000
  829.6656      96.0000      98.2158       0.0342      85.4055       0.1132       2.8887       0.0000    2593.6455    1652.0000
  829.8180      96.0000      98.0385       0.0490      86.5594       0.1254       2.8368       0.0000    2569.1819    1649.0000
  829.9704      96.0000      97.8940       0.0591      96.3726       0.1336       2.8450       0.0000    2552.4370    1674.0000
  830.1228      96.0000      98.0086       0.0644     103.4885       0.1443       2.9179       0.0000    2543.7603    1665.0000
  830.2752      96.0000      97.8364       0.0669     102.1572       0.1436       2.8675       0.0000    2539.6106    1673.0000
  830.4276      96.0000      98.0085       0.0717      92.5228       0.1391       2.8985       0.0000    2531.6501    1670.0000
  830.5800      96.0000      97.8367       0.0686      96.3693       0.1317       2.9673       0.0000    2536.7703    1638.0000
  830.7324      96.0000      97.8369       0.0598     101.5645       0.1273       2.9401       0.0000    2551.2937    1681.0000
  830.8848      96.0000      98.2122       0.0427     106.7572       0.1204       3.0316       0.0000    2579.4927    1672.0000
  831.0372      96.0000      98.1921       0.0279     100.2318       0.1102       3.0606       0.0000    2603.9883    1658.0000
  831.1896      96.0000      98.0657       0.0185      96.7527       0.1011       3.1931       0.0000    2619.4587    1686.0000
  831.3420      96.0000      98.0292       0.0153      88.6751       0.0952       3.0463       0.0000    2624.7764    1642.0000
  831.4944      96.0000      97.9631       0.0179      93.4854       0.0912       2.9786       0.0000    2620.5427    1674.0000
  831.6468      96.0000      98.0748       0.0183      91.3699       0.0874       3.0219       0.0000    2619.7864    1696.0000
  831.7992      96.0000      97.9633       0.0128      98.6630       0.0856       3.1430       0.0000    2628.8140    1658.0000
  831.9516      96.0000      98.2255       0.0112     101.5320       0.0891       3.2872       0.0000    2631.5771    1685.0000
  832.1040      96.0000      98.3780       0.0085     102.1239       0.0959       3.3933       0.0000    2636.0435    1658.0000
  832.2564      96.0000      98.0874       0.0038      96.9464       0.1000       3.4739       0.0000    2643.7021    1661.0000
  832.4088      96.0000      98.3184      -0.0034      94.7913       0.1029       3.6026       0.0000    2655.5576    1665.0000
  832.5612      96.0000      98.1301      -0.0030      88.7069       0.1028       3.5905       0.0000    2654.8728    1661.0000
  832.7136      96.0000      98.1111      -0.0098      91.7841       0.1046       3.6591       0.0000    2666.2021    1636.0000
  832.8660      96.0000      97.7223       0.0027      85.8750       0.1038       3.7037       0.0000    2645.5503    1693.0000
  833.0184      96.0000      98.1301       0.0042      90.4058       0.1015       3.7629       0.0000    2643.0027    1618.0000
  833.1708      96.0000      98.0778       0.0088      94.2523       0.1003       3.6824       0.0000    2635.4304    1713.0000
  833.3232      96.0000      98.0657       0.0023      99.0626       0.0989       3.6107       0.0000    2646.1301    1652.0000
  833.4756      96.0000      98.1301       0.0036      96.3788       0.0955       3.6457       0.0000    2644.0359    1611.0000
  833.6280      96.0000      98.0777       0.0022      91.3783       0.0941       3.6033       0.0000    2646.4346    1717.0000
  833.7804      96.0000      98.2374       0.0026      84.2466       0.0928       3.6017       0.0000    2645.7175    1597.0000
  833.9328      96.0000      98.1759       0.0032      88.8689       0.0943       3.4993       0.0000    2644.6980    1652.0000
  834.0852      96.0000      98.2946      -0.0009      91.7538       0.0982       3.4294       0.0000    2651.5471    1738.0000
  834.2376      96.0000      98.0086       0.0033      98.8546       0.1004       3.2949       0.0000    2644.6147    1622.0000
  834.3900      96.0000      97.9012       0.0091      98.4548       0.1005       3.1760       0.0000    2634.9316    1695.0000
  834.5424      96.0000      98.0085       0.0198      94.0448       0.0944       2.9961       0.0000    2617.4126    1699.0000
  834.6948      96.0000      97.9511       0.0212      90.4058       0.0913       2.8653       0.0000    2614.9573    1650.0000
  834.8472      96.0000      98.2256       0.0241      85.8028       0.0906       2.8104       0.0000    2610.2434    1688.0000
  834.9996      96.0000      97.9011       0.0250      81.9429       0.0940       2.9537       0.0000    2608.7351    1658.0000
  835.1520      96.0000      97.8941       0.0189      79.2204       0.0962       3.1476       0.0000    2618.7810    1644.0000
  835.3044      96.0000      98.3685       0.0166      82.0924       0.1006       3.2944       0.0000    2622.6658    1657.0000
  835.4568      96.0000      98.0086       0.0178      89.4158       0.1022       3.2661       0.0000    2620.6228    1639.0000
  835.6092      96.0000      98.0540       0.0230      99.4525       0.1000       3.3405       0.0000    2612.0208    1679.0000
  835.7616      96.0000      98.1804       0.0238      99.0818       0.0940       3.2591       0.0000    2610.8037    1650.0000
  835.9140      96.0000      98.0293       0.0213      96.5666       0.0885       3.2320       0.0000    2614.8115    1637.0000
  836.0664      96.0000      97.9967       0.0135      91.2497       0.0894       3.1293       0.0000    2627.7764    1709.0000
  836.2188      96.0000      97.9630       0.0074      93.1589       0.0966       3.2471       0.0000    2637.7529    1603.0000
  836.3712      96.0000      98.0101      -0.0001     100.8694       0.1114       3.3964       0.0000    2650.0935    1667.0000
  836.5236      96.0000      98.2040      -0.0067     104.1528       0.1319       3.6509       0.0000    2661.0525    1660.0000
  836.6760      96.0000      98.1348      -0.0091     114.7306       0.1505       3.4248       0.0000    2665.0662    1631.0000
  836.8284      96.0000      98.4410      -0.0041     117.4057       0.1635       3.2982       0.0000    2656.7744    1685.0000
  836.9808      96.0000      98.4090       0.0078     125.8193       0.1691       3.0896       0.0000    2637.1313    1668.0000
  837.1332      96.0000      98.4542       0.0197     114.2798       0.1697       3.0932       0.0000    2617.4597    1637.0000
  837.2856      96.0000      98.4410       0.0334     111.0275       0.1665       3.0056       0.0000    2594.9187    1695.0000
  837.4380      96.0000      98.4661       0.0427      97.7179       0.1570       2.9168       0.0000    2579.5593    1679.0000
  837.5904      96.0000      98.5233       0.0454      97.7275       0.1473       2.9022       0.0000    2575.0447    1695.0000
  837.7428      96.0000      98.3304       0.0418      90.9790       0.1323       2.9945       0.0000    2581.0933    1679.0000
  837.8952      96.0000      98.0777       0.0369      90.3343       0.1238       2.9031       0.0000    2589.1348    1659.0000
  838.0476      96.0000      98.1920       0.0354      85.7212       0.1177       2.8176       0.0000    2591.5608    1674.0000
  838.2000      96.0000      98.2493       0.0452      85.0489       0.1170       2.6698       0.0000    2575.4707    1692.0000
  838.3524      96.0000      98.2217       0.0536      81.6671       0.1182       2.6733       0.0000    2561.5027    1642.0000
  838.5048      96.0000      97.9057       0.0536      85.4444       0.1147       2.8473       0.0000    2561.6040    1694.0000
  838.6572      96.0000      98.2827       0.0485      86.9003       0.1111       2.9034       0.0000    2569.9548    1666.0000
  838.8096      96.0000      97.9658       0.0443      90.6777       0.1068       2.8870       0.0000    2576.9607    1640.0000
  838.9620      96.0000      97.9848       0.0436      89.4017       0.1094       2.8616       0.0000    2578.1316    1651.0000
  839.1144      96.0000      98.2612       0.0412      87.3448       0.1130       2.9462       0.0000    2582.0796    1649.0000
  839.2668      96.0000      98.2120       0.0398      86.2478       0.1184       3.1819       0.0000    2584.3796    1661.0000
  839.4192      96.0000      97.8942       0.0416      87.7871       0.1240       3.0768       0.0000    2581.2786    1656.0000
  839.5716      96.0000      97.9277       0.0516      90.6442       0.1305       2.9601       0.0000    2564.9160    1658.0000
  839.7240      96.0000      97.8917       0.0592      94.2188       0.1380       2.8146       0.0000    2552.3701    1673.0000
  839.8764      96.0000      98.0420       0.0637      95.5509       0.1395       2.8461       0.0000    2544.9744    1674.0000
  840.0288      96.0000      98.0776       0.0650      99.6709       0.1402       2.9617       0.0000    2542.8071    1661.0000
  840.1812      96.0000      98.0538       0.0533      97.0580       0.1359       2.9994       0.0000    2562.1108    1661.0000
  840.3336      96.0000      97.8458       0.0472      90.9628       0.1335       2.9510       0.0000    2572.1658    1677.0000
  840.4860      96.0000      98.2708       0.0441      89.5061       0.1319       2.8620       0.0000    2577.2976    1663.0000
  840.6384      96.0000      98.0894       0.0483      90.4619       0.1326       2.7903       0.0000    2570.2507    1678.0000
  840.7908      96.0000      97.9176       0.0489      96.5718       0.1325       2.7506       0.0000    2569.2332    1685.0000
  840.9432      96.0000      97.9833       0.0500      97.3954       0.1343       2.7454       0.0000    2567.4441    1667.0000
  841.0956      96.0000      97.9394       0.0497      98.6421       0.1317       2.7703       0.0000    2568.0723    1675.0000
  841.2480      96.0000      98.2374       0.0485      99.0269       0.1344       2.9193       0.0000    2570.0217    1685.0000
  841.4004      96.0000      98.0290       0.0467      93.2839       0.1372       2.9375       0.0000    2572.9609    1656.0000
  841.5528      96.0000      98.0086       0.0430      91.6726       0.1434       3.0413       0.0000    2579.1113    1696.0000
  841.7052      96.0000      97.8940       0.0456      93.9656       0.1507       3.1120       0.0000    2574.7380    1646.0000
  841.8576      96.0000      98.0657       0.0506     102.1886       0.1581       3.3823       0.0000    2566.5059    1677.0000
  842.0100      96.0000      97.9375       0.0607     112.4187       0.1588       3.5013       0.0000    2549.8381    1666.0000
  842.1624      96.0000      98.0658       0.0642     111.6494       0.1522       3.3529       0.0000    2544.0928    1685.0000
  842.3148      96.0000      98.0322       0.0670     105.0827       0.1353       3.1659       0.0000    2539.4402    1696.0000
  842.4672      96.0000      98.0938       0.0747      95.2326       0.1248       2.9171       0.0000    2526.8179    1667.0000
  842.6196      96.0000      97.7105       0.0770      88.8859       0.1183       2.7736       0.0000    2522.9993    1671.0000
  842.7720      96.0000      97.6650       0.0749      85.6026       0.1168       2.6668       0.0000    2526.4158    1687.0000
  842.9244      96.0000      97.8487       0.0673      84.7667       0.1154       2.7367       0.0000    2538.8999    1668.0000
  843.0768      96.0000      97.8553       0.0604      87.6657       0.1165       2.8557       0.0000    2550.2944    1691.0000
  843.2292      96.0000      97.9631       0.0551      92.7959       0.1216       3.0081       0.0000    2559.0615    1652.0000
  843.3816      96.0000      97.7796       0.0559      90.5536       0.1265       2.9894       0.0000    2557.7927    1685.0000
  843.5340      96.0000      97.9513       0.0579      97.2512       0.1291       2.9809       0.0000    2554.4468    1684.0000
  843.6864      96.0000      97.9470       0.0588      97.7053       0.1305       2.8501       0.0000    2553.0134    1688.0000
  843.8388      96.0000      97.9514       0.0597      98.5119       0.1296       2.9081       0.0000    2551.4326    1668.0000
  843.9912      96.0000      98.1349       0.0608      92.3915       0.1326       2.8233       0.0000    2549.6272    1712.0000
  844.1436      96.0000      98.1112       0.0639      98.2989       0.1330       2.8815       0.0000    2544.5466    1674.0000
  844.2960      96.0000      98.2311       0.0663      98.0938       0.1401       2.9630       0.0000    2540.5913    1692.0000
  844.4484      96.0000      98.5806       0.0597     103.8663       0.1425       3.1170       0.0000    2551.4636    1706.0000
  844.6008      96.0000      98.1682       0.0507     100.5649       0.1430       3.1858       0.0000    2566.2927    1660.0000
  844.7532      96.0000      98.2947       0.0441     102.4260       0.1392       2.9504       0.0000    2577.2515    1738.0000
  844.9056      96.0000      98.2120       0.0403      96.8412       0.1328       2.8736       0.0000    2583.5076    1705.0000
  845.0580      96.0000      98.0776       0.0364      96.1427       0.1321       2.8010       0.0000    2589.9092    1698.0000
  845.2104      96.0000      98.1111       0.0401      94.5010       0.1370       2.9588       0.0000    2583.8083    1691.0000
  845.3628      96.0000      98.2946       0.0432      89.3708       0.1518       3.0399       0.0000    2578.6543    1681.0000
  845.5152      96.0000      98.3036       0.0420      85.1396       0.1604       3.2801       0.0000    2580.7444    1700.0000
  845.6676      96.0000      98.2255       0.0344      92.8872       0.1703       3.4108       0.0000    2593.2090    1715.0000
  845.8200      96.0000      98.7521       0.0172     109.1823       0.1729       3.7039       0.0000    2621.6160    1666.0000
  845.9724      96.0000      99.0381       0.0030     128.0592       0.1864       3.8352       0.0000    2645.0842    1700.0000
  846.1248      96.0000      98.9802      -0.0079     129.1357       0.1816       3.9614       0.0000    2663.0862    1693.0000
  846.2772      96.0000      97.7796      -0.0138     123.7481       0.1732       3.9812       0.0000    2672.7219    1668.0000
  846.4296      96.0000      98.0538      -0.0158     112.0569       0.1579       3.9162       0.0000    2676.0864    1708.0000
  846.5820      96.0000      98.0992      -0.0227     104.6694       0.1531       3.8861       0.0000    2687.5010    1686.0000
  846.7344      96.0000      98.1569      -0.0178      99.3026       0.1481       4.1176       0.0000    2679.4172    1710.0000
  846.8868      96.0000      97.9966      -0.0165      94.3966       0.1435       3.9537       0.0000    2677.2646    1684.0000
  847.0392      96.0000      98.0894      -0.0134      99.4390       0.1428       3.8472       0.0000    2672.0571    1680.0000
  847.1916      96.0000      98.1230      -0.0061     109.4942       0.1447       3.5172       0.0000    2660.1292    1719.0000
  847.3440      96.0000      98.2375      -0.0020     117.4768       0.1504       3.5081       0.0000    2653.2419    1699.0000
  847.4964      96.0000      99.3458       0.0027     129.6721       0.1572       3.3562       0.0000    2645.5112    1645.0000
  847.6488      96.0000     100.0090      -0.0015     127.4148       0.1663       3.3042       0.0000    2652.3977    1717.0000
  847.8012      96.0000      99.3117      -0.0098     129.8979       0.1669       3.3094       0.0000    2666.1882    1682.0000
  847.9536      96.0000      99.0380      -0.0138     118.8566       0.1610       3.6048       0.0000    2672.7048    1699.0000
  848.1060      96.0000      99.0813      -0.0121     116.3941       0.1504       3.8178       0.0000    2669.9358    1706.0000
  848.2584      96.0000      98.7519      -0.0081     109.2117       0.1508       3.9321       0.0000    2663.3464    1675.0000
  848.4108      96.0000      98.3518      -0.0090     108.3332       0.1513       3.9408       0.0000    2664.8677    1692.0000
  848.5632      96.0000      98.1803      -0.0107     103.7467       0.1568       3.7095       0.0000    2667.6741    1687.0000
  848.7156      96.0000      98.1467      -0.0055     107.8509       0.1614       3.4806       0.0000    2659.0127    1687.0000
  848.8680      96.0000      98.2375      -0.0035     115.6449       0.1701       3.2532       0.0000    2655.7756    1679.0000
  849.0204      96.0000      98.2578      -0.0012     121.8732       0.1761       3.1834       0.0000    2652.0471    1701.0000
  849.1728      96.0000      98.5685      -0.0062     126.3878       0.1783       3.3375       0.0000    2660.2566    1698.0000
  849.3252      96.0000      98.5472      -0.0081     121.6703       0.1813       3.4028       0.0000    2663.2898    1661.0000
  849.4776      96.0000      98.5113      -0.0045     122.6964       0.1804       3.4170       0.0000    2657.3906    1705.0000
  849.6300      96.0000      98.4542       0.0056     112.8463       0.1807       3.2598       0.0000    2640.7793    1691.0000
  849.7824      96.0000      98.2944       0.0102     105.6478       0.1773       3.1418       0.0000    2633.2278    1681.0000
  849.9348      96.0000      98.6336       0.0095     101.5436       0.1743       3.3971       0.0000    2634.3213    1699.0000
  850.0872      96.0000      98.8786       0.0072     101.1331       0.1737       3.5413       0.0000    2638.1064    1678.0000
  850.2396      96.0000      98.9566       0.0020     106.5040       0.1806       3.9162       0.0000    2646.6404    1728.0000
  850.3920      96.0000      98.8998       0.0042     108.9665       0.1936       3.8731       0.0000    2643.0574    1657.0000
  850.5444      96.0000      99.5402       0.0066     123.9219       0.2100       3.9017       0.0000    2639.1440    1741.0000
  850.6968      96.0000      99.3809       0.0076     136.8501       0.2243       4.0223       0.0000    2637.5061    1709.0000
  850.8492      96.0000      99.6297       0.0056     144.6481       0.2378       3.8126       0.0000    2640.7866    1664.0000
  851.0016      96.0000     100.0984       0.0022     142.3111       0.2365       3.7817       0.0000    2646.3369    1727.0000
  851.1540      96.0000      99.4828       0.0012     134.1027       0.2151       3.6278       0.0000    2648.0586    1681.0000
  851.3064      96.0000      98.2158      -0.0030     132.6662       0.1850       3.6131       0.0000    2654.9417    1702.0000
  851.4588      96.0000      98.0993      -0.0026     128.8500       0.1632       3.4987       0.0000    2654.3652    1698.0000
  851.6112      96.0000      98.0203       0.0083     125.1563       0.1432       3.0775       0.0000    2636.3110    1731.0000
  851.7636      96.0000      97.5617       0.0188     112.2280       0.1257       2.9698       0.0000    2618.9934    1685.0000
  851.9160      96.0000      97.9966       0.0231      99.5268       0.1050       2.9876       0.0000    2611.8967    1692.0000
  852.0684      96.0000      97.7340       0.0234      98.2774       0.1018       3.1810       0.0000    2611.4382    1737.0000
  852.2208      96.0000      97.7912       0.0221     105.0494       0.1047       3.2617       0.0000    2613.5483    1693.0000
  852.3732      96.0000      97.8371       0.0199     107.7171       0.1095       3.3067       0.0000    2617.2246    1702.0000
  852.5256      96.0000      97.8939       0.0242     104.6571       0.1088       3.2878       0.0000    2610.0493    1699.0000
  852.6780      96.0000      97.9058       0.0244     100.3310       0.1045       3.2231       0.0000    2609.7275    1713.0000
  852.8304      96.0000      97.8459       0.0243      98.2789       0.1017       3.1443       0.0000    2609.9390    1652.0000
  852.9828      96.0000      97.9058       0.0239      92.9434       0.0968       3.0799       0.0000    2610.5701    1712.0000
  853.1352      96.0000      97.6650       0.0251      91.1132       0.0949       3.0709       0.0000    2608.5071    1681.0000
  853.2876      96.0000      97.8367       0.0151      91.0975       0.0944       3.1087       0.0000    2625.0740    1692.0000
  853.4400      96.0000      97.7913       0.0026      92.9443       0.0997       3.4672       0.0000    2645.7749    1712.0000
  853.5924      96.0000      97.9512      -0.0091      94.7912       0.1111       3.6500       0.0000    2664.9414    1703.0000
  853.7448      96.0000      97.5623      -0.0143      95.4227       0.1210       3.8025       0.0000    2673.5229    1702.0000
  853.8972      96.0000      97.6651      -0.0147     107.5091       0.1298       3.5700       0.0000    2674.2717    1710.0000
  854.0496      96.0000      97.8942      -0.0083     108.7404       0.1359       3.6059       0.0000    2663.7224    1714.0000
  854.2020      96.0000      97.9469      -0.0023     109.9717       0.1385       3.3765       0.0000    2653.7305    1710.0000
  854.3544      96.0000      97.8705       0.0145     105.2727       0.1388       3.3128       0.0000    2626.0908    1721.0000
  854.5068      96.0000      98.1920       0.0331     103.4095       0.1361       3.1839       0.0000    2595.3384    1684.0000
  854.6592      96.0000      97.8940       0.0531     107.5136       0.1410       3.0850       0.0000    2562.3213    1712.0000
  854.8116      96.0000      97.9967       0.0602     100.3313       0.1440       2.9535       0.0000    2550.6025    1717.0000
  854.9640      96.0000      98.1921       0.0637      99.5269       0.1431       2.9853       0.0000    2544.9448    1716.0000
  855.1164      96.0000      97.9632       0.0595      97.8672       0.1420       2.9625       0.0000    2551.8433    1714.0000
  855.2688      96.0000      97.7678       0.0632      98.0724       0.1388       2.9282       0.0000    2545.7468    1680.0000
  855.4212      96.0000      97.8095       0.0712     100.5350       0.1384       2.8780       0.0000    2532.5562    1705.0000
  855.5736      96.0000      98.1348       0.0772      97.8852       0.1375       2.9268       0.0000    2522.6028    1707.0000
  855.7260      96.0000      97.7340       0.0826     106.8582       0.1393       2.9483       0.0000    2513.7380    1693.0000
  855.8784      96.0000      97.6194       0.0859     105.1158       0.1382       2.9540       0.0000    2508.3025    1679.0000
  856.0308      96.0000      97.9394       0.0881     101.2852       0.1341       3.0215       0.0000    2504.6917    1736.0000
  856.1832      96.0000      98.0085       0.0834      84.7006       0.1263       2.9884       0.0000    2512.4055    1692.0000
  856.3356      96.0000      97.7795       0.0814      84.6043       0.1177       2.8189       0.0000    2515.7366    1719.0000
  856.4880      96.0000      97.7915       0.0782      91.1026       0.1069       2.6108       0.0000    2521.0105    1721.0000
  856.6404      96.0000      97.9512       0.0781      93.8575       0.1053       2.5883       0.0000    2521.0601    1686.0000
  856.7928      96.0000      97.9058       0.0804      90.9764       0.1091       2.6962       0.0000    2517.3523    1729.0000
  856.9452      96.0000      97.8367       0.0866      89.5796       0.1141       2.8209       0.0000    2507.0410    1661.0000
  857.0976      96.0000      97.8096       0.0841      97.8900       0.1173       2.8762       0.0000    2511.2695    1748.0000
  857.2500      96.0000      98.0085       0.0835      98.1465       0.1208       2.7960       0.0000    2512.1499    1689.0000
  857.4024      96.0000      97.9059       0.0726      92.7275       0.1261       2.8109       0.0000    2530.1838    1707.0000
  857.5548      96.0000      97.7105       0.0582      89.1198       0.1270       2.8462       0.0000    2553.9456    1708.0000
  857.7072      96.0000      97.8032       0.0347     101.9124       0.1301       3.1529       0.0000    2592.7759    1689.0000
  857.8596      96.0000      97.7224       0.0167     108.6268       0.1393       3.4635       0.0000    2622.4199    1716.0000
  858.0120      96.0000      97.7222       0.0090     123.8750       0.1536       3.8028       0.0000    2635.1746    1689.0000
  858.1644      96.0000      97.8822       0.0089     125.8746       0.1598       3.6575       0.0000    2635.3354    1721.0000
  858.3168      96.0000      97.7341       0.0129     130.7643       0.1606       3.5322       0.0000    2628.6458    1710.0000
  858.4692      96.0000      97.6196       0.0187     133.0049       0.1552       3.3831       0.0000    2619.1191    1699.0000
  858.6216      96.0000      97.7913       0.0279     126.4509       0.1557       3.2922       0.0000    2603.9902    1727.0000
  858.7740      96.0000      97.8250       0.0333     126.8472       0.1522       3.1908       0.0000    2595.0576    1694.0000
  858.9264      96.0000      97.6313       0.0395     116.2900       0.1416       3.2049       0.0000    2584.8643    1721.0000
  859.0788      96.0000      97.6768       0.0504     110.8083       0.1369       3.2111       0.0000    2566.9116    1721.0000
  859.2312      96.0000      97.4815       0.0557     110.2652       0.1333       3.1455       0.0000    2558.0916    1712.0000
  859.3836      96.0000      97.6357       0.0601     110.0542       0.1387       2.9559       0.0000    2550.8914    1729.0000
  859.5360      96.0000      97.6533       0.0648     114.2120       0.1410       2.8509       0.0000    2543.1255    1700.0000
  859.6884      96.0000      97.9394       0.0684     114.6431       0.1396       2.7741       0.0000    2537.2119    1726.0000
  859.8408      96.0000      97.7224       0.0730     117.9140       0.1366       2.8342       0.0000    2529.4780    1713.0000
  859.9932      96.0000      97.6650       0.0763     119.2603       0.1282       2.8652       0.0000    2524.0664    1728.0000
  860.1456      96.0000      97.7222       0.0814     114.5981       0.1247       2.8637       0.0000    2515.7166    1706.0000
  860.2980      96.0000      97.9394       0.0877     112.4445       0.1239       2.8013       0.0000    2505.3428    1700.0000
  860.4504      96.0000      97.8368       0.0897     101.9448       0.1227       2.8200       0.0000    2502.0193    1714.0000
  860.6028      96.0000      97.7341       0.0832      93.3954       0.1192       2.9561       0.0000    2512.6843    1717.0000
  860.7552      96.0000      97.6650       0.0760      83.3183       0.1174       2.9676       0.0000    2524.6062    1720.0000
  860.9076      96.0000      97.8486       0.0663      83.3183       0.1165       2.8850       0.0000    2540.6304    1701.0000
  861.0600      96.0000      97.6531       0.0591      83.3183       0.1150       2.8287       0.0000    2552.4417    1730.0000
  861.2124      96.0000      97.6533       0.0564      83.3183       0.1182       2.8067       0.0000    2557.0010    1716.0000
  861.3648      96.0000      97.8940       0.0564      83.3183       0.1225       2.8638       0.0000    2556.9714    1721.0000
  861.5172      96.0000      97.9631       0.0543      83.3183       0.1292       2.9823       0.0000    2560.3748    1709.0000
  861.6696      96.0000      98.1230       0.0502      83.3183       0.1339       2.9907       0.0000    2567.1572    1710.0000
  861.8220      96.0000      97.9394       0.0532      83.3183       0.1372       3.0787       0.0000    2562.2507    1730.0000
  861.9744      96.0000      97.7637       0.0602      83.3183       0.1367       3.0033       0.0000    2550.6797    1710.0000
  862.1268      96.0000      97.7795       0.0671      83.3183       0.1379       2.9129       0.0000    2539.3005    1712.0000
  862.2792      96.0000      97.5959       0.0721      83.3183       0.1406       2.8898       0.0000    2531.0837    1701.0000
  862.4316      96.0000      97.8704       0.0727      83.3183       0.1409       2.7988       0.0000    2530.0364    1720.0000
  862.5840      96.0000      97.5504       0.0687      83.3183       0.1365       2.9794       0.0000    2536.6750    1722.0000
  862.7364      96.0000      97.8486       0.0718      83.3183       0.1330       2.8286       0.0000    2531.5222    1719.0000
  862.8888      96.0000      97.7106       0.0808      83.3183       0.1357       2.9131       0.0000    2516.5996    1737.0000
  863.0412      96.0000      97.5961       0.0813      83.3183       0.1347       2.8341       0.0000    2515.9153    1727.0000
  863.1936      96.0000      97.7677       0.0788      83.3183       0.1390       3.0249       0.0000    2519.9995    1710.0000
  863.3460      96.0000      97.5270       0.0750      83.3183       0.1384       3.0104       0.0000    2526.2991    1726.0000
  863.4984      96.0000      97.5505       0.0793      83.3183       0.1407       3.0759       0.0000    2519.1731    1726.0000
  863.6508      96.0000      97.6195       0.0764      83.3183       0.1389       2.9701       0.0000    2523.9238    1729.0000
  863.8032      96.0000      97.9059       0.0710      83.3183       0.1400       3.0590       0.0000    2532.8513    1729.0000
  863.9556      96.0000      97.7105       0.0568      83.3183       0.1444       3.0978       0.0000    2556.2368    1731.0000
  864.1080      96.0000      97.5506       0.0533      83.3183       0.1455       3.0941       0.0000    2562.0396    1724.0000
  864.2604      96.0000      97.6886       0.0490      83.3183       0.1461       3.0424       0.0000    2569.2087    1720.0000
  864.4128      96.0000      97.8371       0.0531      83.3183       0.1444       2.9674       0.0000    2562.3540    1733.0000
  864.5652      96.0000      97.7677       0.0557      83.3183       0.1462       3.1311       0.0000    2558.0435    1734.0000
  864.7176      96.0000      97.9630       0.0599      83.3183       0.1505       3.0359       0.0000    2551.1836    1734.0000
  864.8700      96.0000      97.7576       0.0602      83.3183       0.1518       3.0110       0.0000    2550.6091    1722.0000
  865.0224      96.0000      97.7224       0.0695      83.3183       0.1518       2.8621       0.0000    2535.3958    1728.0000
  865.1748      96.0000      97.9966       0.0781      83.3183       0.1499       2.7631       0.0000    2521.1208    1727.0000
  865.3272      96.0000      97.7342       0.0807      83.3183       0.1533       2.7855       0.0000    2516.7888    1703.0000
  865.4796      96.0000      97.8251       0.0770      83.3183       0.1552       2.7753       0.0000    2522.9348    1729.0000
  865.6320      96.0000      97.8368       0.0732      83.3183       0.1489       2.9570       0.0000    2529.2034    1716.0000
  865.7844      96.0000      97.7912       0.0679      83.3183       0.1392       2.9749       0.0000    2537.9578    1728.0000
  865.9368      96.0000      97.6650       0.0593      83.3183       0.1335       2.8805       0.0000    2552.0752    1743.0000
  866.0892      96.0000      97.5050       0.0548      83.3183       0.1326       2.8464       0.0000    2559.6130    1720.0000
  866.2416      96.0000      97.7223       0.0534      83.3183       0.1300       2.8140       0.0000    2561.8225    1740.0000
  866.3940      96.0000      97.6430       0.0564      83.3183       0.1273       2.9553       0.0000    2556.9768    1726.0000
  866.5464      96.0000      97.8133       0.0553      83.3183       0.1346       2.8782       0.0000    2558.7339    1719.0000
  866.6988      96.0000      97.3437       0.0539      83.3183       0.1401       2.8962       0.0000    2561.0972    1731.0000
  866.8512      96.0000      97.8371       0.0511      83.3183       0.1412       2.8449       0.0000    2565.6587    1731.0000
  867.0036      96.0000      97.5623       0.0560      83.3183       0.1392       2.9104       0.0000    2557.5222    1723.0000
  867.1560      96.0000      97.6078       0.0675      83.3183       0.1443       2.9263       0.0000    2538.5828    1741.0000
  867.3084      96.0000      97.5622       0.0733      83.3183       0.1485       2.9011       0.0000    2529.1333    1712.0000
  867.4608      96.0000      97.7913       0.0719      83.3183       0.1479       2.8679       0.0000    2531.4229    1721.0000
  867.6132      96.0000      97.9061       0.0747      83.3183       0.1432       3.0282       0.0000    2526.8022    1749.0000
  867.7656      96.0000      97.7121       0.0724      83.3183       0.1400       3.1091       0.0000    2530.4695    1701.0000
  867.9180      96.0000      97.8032       0.0769      83.3183       0.1385       3.1420       0.0000    2523.0457    1749.0000
  868.0704      96.0000      97.7341       0.0769      83.3183       0.1389       2.9363       0.0000    2523.1863    1717.0000
  868.2228      96.0000      97.7916       0.0723      83.3183       0.1384       3.0103       0.0000    2530.6353    1727.0000
  868.3752      96.0000      97.8487       0.0628      83.3183       0.1403       3.0502       0.0000    2546.3501    1733.0000
  868.5276      96.0000      97.8266       0.0546      83.3183       0.1398       3.0022       0.0000    2559.9558    1709.0000
  868.6800      96.0000      97.8368       0.0569      83.3183       0.1421       2.9541       0.0000    2556.0994    1742.0000
  868.8324      96.0000      97.5935       0.0555      83.3183       0.1422       2.8439       0.0000    2558.4768    1695.0000
  868.9848      96.0000      97.6847       0.0566      83.3183       0.1447       2.9171       0.0000    2556.5376    1727.0000
  869.1372      96.0000      97.6689       0.0583      83.3183       0.1463       2.9209       0.0000    2553.8704    1724.0000
  869.2896      96.0000      97.5623       0.0700      83.3183       0.1476       2.9753       0.0000    2534.5212    1727.0000
  869.4420      96.0000      97.6533       0.0700      83.3183       0.1476       3.0402       0.0000    2534.4988    1712.0000
  869.5944      96.0000      97.6297       0.0686      83.3183       0.1476       2.9127       0.0000    2536.7786    1726.0000
  869.7468      96.0000      97.7006       0.0665      83.3183       0.1476       2.9295       0.0000    2540.3396    1730.0000
  869.8992      96.0000      97.8217       0.0691      83.3183       0.1476       2.7084       0.0000    2536.0181    1720.0000
  870.0516      96.0000      97.7915       0.0700      83.3183       0.1476       2.7105       0.0000    2534.4443    1754.0000
  870.2040      96.0000      97.6408       0.0721      83.3183       0.1476       2.6614       0.0000    2530.9958    1698.0000
  870.3564      96.0000      97.7003       0.0734      83.3183       0.1476       2.7161       0.0000    2528.8210    1791.0000
  870.5088      96.0000      97.5319       0.0667      83.3183       0.1476       2.7618       0.0000    2539.9736    1722.0000
  870.6612      96.0000      97.6886       0.0593      83.3183       0.1476       2.8390       0.0000    2552.1365    1738.0000
  870.8136      96.0000      97.5474       0.0426      83.3183       0.1476       3.0089       0.0000    2579.6541    1737.0000
  870.9660      96.0000      97.5772       0.0300      83.3183       0.1476       3.1837       0.0000    2600.5801    1743.0000
  871.1184      96.0000      97.4243       0.0172      83.3183       0.1476       3.2784       0.0000    2621.6401    1751.0000
  871.2708      96.0000      97.3339       0.0151      83.3183       0.1476       3.2925       0.0000    2625.0247    1738.0000
  871.4232      96.0000      97.1271       0.0172      83.3183       0.1476       3.3571       0.0000    2621.6475    1728.0000
  871.5756      96.0000      93.1965       0.0206      83.3183       0.1476       3.4210       0.0000    2615.9302    1797.0000
  871.7280      96.0000      85.3838       0.0197      83.3183       0.1476       3.3865       0.0000    2617.5059    1735.0000
  871.8804      96.0000      75.0175       0.0148      83.3183       0.1476       3.2706       0.0000    2625.6394    1735.0000
  872.0328      96.0000      65.7620       0.0129      83.3183       0.1476       3.1930       0.0000    2628.6985    1742.0000
  872.1852      96.0000      64.5858       0.0124      83.3183       0.1476       3.2371       0.0000    2629.5356    1741.0000
  872.3376      96.0000      65.0174       0.0104      83.3183       0.1476       3.1759       0.0000    2632.8167    1717.0000
  872.4900      96.0000      64.8060       0.0178      83.3183       0.1476       3.1578       0.0000    2620.6860    1745.0000
  872.6424      96.0000      64.8874       0.0214      83.3183       0.1476       3.1465       0.0000    2614.6873    1716.0000
  872.7948      96.0000      64.7050       0.0267      83.3183       0.1476       3.1950       0.0000    2606.0095    1751.0000
  872.9472      96.0000      64.8314       0.0279      83.3183       0.1476       3.1954      -0.0032    2603.9038    1759.0000
  873.0996      96.0000      64.8061       0.0306      83.3183       0.1476       3.1953      -0.0052    2599.4797    1728.0000
  873.2520      96.0000      64.5858       0.0306      83.3183       0.1476       3.1946      -0.0052    2599.4685    1700.0000
  873.4044      96.0000      64.6107       0.0306      83.3183       0.1476       3.1947      -0.0052    2599.4700    1686.0000
  873.5568      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858    1635.0000
  873.7092      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858    1726.0000
  873.8616      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858    1464.0000
  874.0140      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858    1229.0000
  874.1664      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858    1029.0000
  874.3188      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858     959.0000
  874.4712      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858     933.0000
  874.6236      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858     903.0000
  874.7760      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858     865.0000
  874.9284      96.0000      64.9434       0.0306      83.3183       0.1476       3.1958      -0.0052    2599.4858     829.0000
